/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.map.streamAlignment.StreamNodeData;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import rma.swing.RmaJDialog;
import rma.util.RMAIO;

public class StreamNodeDialog
extends RmaJDialog
implements ItemListener,
ActionListener {
    JPanel NamePanel;
    JLabel NameLabel;
    JComboBox _systemChoice;
    JPanel ButtonPanel;
    JButton OKButton;
    JButton ApplyButton;
    JButton CancelButton;
    JPanel jPanel1;
    JLabel StreamLabel;
    JLabel coordinateLabel;
    JLabel stationLabel;
    JLabel junctionLabel;
    JTextField _streamTxt;
    JTextField _coordinateTxt;
    JTextField _stationTxt;
    JTextField _junction;
    StreamNodeData snd = new StreamNodeData();

    public StreamNodeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Stream Node Editor");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        this.setSize(400, 250);
        this.setLocation();
        this.NamePanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.NamePanel.setLayout(gridBagLayout);
        this.getContentPane().add("North", this.NamePanel);
        this.NameLabel = new JLabel();
        this.NameLabel.setText("Name");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(9, 5, 0, 0);
        ((GridBagLayout)this.NamePanel.getLayout()).setConstraints(this.NameLabel, gbc);
        this.NamePanel.add(this.NameLabel);
        this._systemChoice = new JComboBox();
        this._systemChoice.setRequestFocusEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.ipadx = 100;
        ((GridBagLayout)this.NamePanel.getLayout()).setConstraints(this._systemChoice, gbc);
        this.NamePanel.add(this._systemChoice);
        this.ButtonPanel = new JPanel();
        this.ButtonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add("South", this.ButtonPanel);
        this.OKButton = new JButton();
        this.OKButton.setText("OK");
        this.OKButton.setActionCommand("OK");
        this.ButtonPanel.add(this.OKButton);
        this.ApplyButton = new JButton();
        this.ApplyButton.setText("Apply");
        this.ApplyButton.setActionCommand("Apply");
        this.ButtonPanel.add(this.ApplyButton);
        this.CancelButton = new JButton();
        this.CancelButton.setText("Cancel");
        this.CancelButton.setActionCommand("Cancel");
        this.ButtonPanel.add(this.CancelButton);
        this.jPanel1 = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.jPanel1.setLayout(gridBagLayout);
        this.getContentPane().add("Center", this.jPanel1);
        this.StreamLabel = new JLabel();
        this.StreamLabel.setText("Stream");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.jPanel1.getLayout()).setConstraints(this.StreamLabel, gbc);
        this.jPanel1.add(this.StreamLabel);
        this.coordinateLabel = new JLabel();
        this.coordinateLabel.setText("Stream Coordinate");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.jPanel1.getLayout()).setConstraints(this.coordinateLabel, gbc);
        this.jPanel1.add(this.coordinateLabel);
        this.stationLabel = new JLabel();
        this.stationLabel.setText("Stream Station");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.jPanel1.getLayout()).setConstraints(this.stationLabel, gbc);
        this.jPanel1.add(this.stationLabel);
        this.junctionLabel = new JLabel();
        this.junctionLabel.setText("Stream Junction");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.jPanel1.getLayout()).setConstraints(this.junctionLabel, gbc);
        this.jPanel1.add(this.junctionLabel);
        this._streamTxt = new JTextField();
        this._streamTxt.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.jPanel1.getLayout()).setConstraints(this._streamTxt, gbc);
        this.jPanel1.add(this._streamTxt);
        this._coordinateTxt = new JTextField();
        this._coordinateTxt.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.jPanel1.getLayout()).setConstraints(this._coordinateTxt, gbc);
        this.jPanel1.add(this._coordinateTxt);
        this._stationTxt = new JTextField();
        this._stationTxt.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.jPanel1.getLayout()).setConstraints(this._stationTxt, gbc);
        this.jPanel1.add(this._stationTxt);
        this._junction = new JTextField();
        this._junction.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        ((GridBagLayout)this.jPanel1.getLayout()).setConstraints(this._junction, gbc);
        this.jPanel1.add(this._junction);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Object object = event.getSource();
                if (object == StreamNodeDialog.this) {
                    StreamNodeDialog.this.StreamNodeDialog_WindowClosing(event);
                }
            }
        });
        this._systemChoice.addItemListener(this);
        this.OKButton.addActionListener(this);
        this.ApplyButton.addActionListener(this);
        this.CancelButton.addActionListener(this);
        this.jPanel1.setBorder(new SoftBevelBorder(1));
    }

    public StreamNodeDialog(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    void StreamNodeDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.ApplyButton) {
            this.HandleApply_Action();
        } else if (object == this.OKButton) {
            this.HandleOK_Action();
        } else if (object == this.CancelButton) {
            this.HandleCancel_Action();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object object = event.getSource();
        if (object == this._systemChoice) {
            this.SystemChoice_StateChange();
        }
    }

    void HandleApply_Action() {
        this.setVisible(false);
    }

    void HandleOK_Action() {
        this.setVisible(false);
        this.dispose();
    }

    void HandleCancel_Action() {
        this.setVisible(false);
        this.dispose();
    }

    void SystemChoice_StateChange() {
        String selectedRes = (String)this._systemChoice.getSelectedItem();
        if (selectedRes == null) {
            return;
        }
        this.snd.name = selectedRes;
    }

    public void stateChanged(ChangeEvent event) {
        Object object = event.getSource();
    }

    public void initDlg() {
        this.fillForm();
    }

    public void storForm() {
        this.snd.name = (String)this._systemChoice.getSelectedItem();
        this.snd.stream = this._streamTxt.getText();
        this.snd.streamCoord = RMAIO.parseDouble(this._coordinateTxt.getText());
        this.snd.streamStation = RMAIO.parseDouble(this._stationTxt.getText());
        this.snd.junction = this._junction.getText();
    }

    public void fillForm() {
        this._systemChoice.setSelectedItem(this.snd.name);
        this._streamTxt.setText(this.snd.stream);
        this._coordinateTxt.setText("" + this.snd.streamCoord);
        this._stationTxt.setText("" + this.snd.streamStation);
        this._junction.setText(this.snd.junction);
    }

    public void clearDlg() {
        this._streamTxt.setText("");
        this._coordinateTxt.setText("");
        this._stationTxt.setText("");
        this._junction.setText("");
    }

    public StreamNodeData getStreamNodeData() {
        return this.snd;
    }

    public void setSteramNodeData(StreamNodeData data) {
        if (data == null) {
            return;
        }
        this.snd = data;
        this.fillForm();
        this.repaint();
    }
}

