/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.appInterface.AppDaddy;
import hec.map.MapPanel;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.StreamElement;
import hec.model.StreamNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.ClosableDialog;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;

public class StreamNodeEditorJDialog
extends RmaJDialog
implements ActionListener,
ClosableDialog {
    private RmaJTextField jTF_stream = new RmaJTextField();
    private RmaJDecimalField rDF_easting = new RmaJDecimalField();
    private RmaJDecimalField rDF_northing = new RmaJDecimalField();
    private RmaJDecimalField rDF_station = new RmaJDecimalField();
    private RmaJCheckBox jCkBox_default = new RmaJCheckBox("Use Default Stationing");
    private String _title;
    StreamNode _streamNode;
    String _stream = "";
    boolean _firstShow = true;
    WorldRect _extents = new WorldRect();
    Point _currLoc = null;
    private StreamAlignmentIfc _alignment;

    public StreamNodeEditorJDialog(Frame owner, boolean modal) {
        super(owner, modal);
        Insets anInset = new Insets(5, 5, 5, 5);
        JLabel jLBL_stream = new JLabel("Stream");
        JPanel jPNL_location = new JPanel(new GridBagLayout());
        JLabel jLBL_easting = new JLabel("Easting");
        JLabel jLBL_northing = new JLabel("Northing");
        JLabel jLBL_station = new JLabel("Station");
        ButtonCmdPanel jPNL_button = new ButtonCmdPanel(12);
        this.setSize(225, 280);
        this.setDefaultSize(235, 310);
        this._title = "Stream Node Editor";
        this.setTitle(this._title);
        this.getContentPane().setLayout(new GridBagLayout());
        jPNL_location.setBorder(new TitledBorder(" Location "));
        this.jCkBox_default.addActionListener(this);
        this.jTF_stream.setEditable(false);
        this.rDF_easting.setEditable(false);
        this.rDF_northing.setEditable(false);
        this.getContentPane().add((Component)jLBL_stream, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, anInset, 0, 0));
        this.getContentPane().add((Component)this.jTF_stream, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, anInset, 0, 0));
        this.getContentPane().add((Component)jPNL_location, new RmaGridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, anInset, 0, 0));
        this.getContentPane().add((Component)this.jCkBox_default, new RmaGridBagConstraints(1, 3, 2, 1, 0.0, 1.0, 18, 0, anInset, 0, 0));
        this.getContentPane().add((Component)jPNL_button, new RmaGridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, anInset, 0, 0));
        jPNL_location.add((Component)jLBL_easting, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, anInset, 0, 0));
        jPNL_location.add((Component)jLBL_northing, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, anInset, 0, 0));
        jPNL_location.add((Component)jLBL_station, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, anInset, 0, 0));
        jPNL_location.add((Component)this.rDF_easting, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, anInset, 0, 0));
        jPNL_location.add((Component)this.rDF_northing, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, anInset, 0, 0));
        jPNL_location.add((Component)this.rDF_station, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, anInset, 0, 0));
        jPNL_button.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        StreamNodeEditorJDialog.this.jB_Ok_actionPerformed();
                        break;
                    }
                    case 4: {
                        StreamNodeEditorJDialog.this.jB_Cancel_actionPerformed();
                    }
                }
            }
        });
        this.rDF_station.setChangeColor(Color.red);
        this.jCkBox_default.setModified(false);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.jCkBox_default) {
            this.jCkBox_default_actionPerformed();
        }
    }

    private void jB_Ok_actionPerformed() {
        this.saveForm();
        this.setVisible(false);
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        MapPanel map = frame.getMapPanel();
        StreamAlignmentGlyph glyph = (StreamAlignmentGlyph)map.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
        StreamElement stream = this._streamNode.getStream();
        glyph.resetStreamTics(stream);
        map.paintMap();
    }

    private void jB_Cancel_actionPerformed() {
        this.setModified(false);
        this.setVisible(false);
    }

    private void jCkBox_default_actionPerformed() {
        this.rDF_station.setEditable(!this.jCkBox_default.isSelected());
        this.rDF_station.setEditable(!this.jCkBox_default.isSelected());
    }

    @Override
    public boolean closeDialog() {
        if (this.isModified()) {
            int sel = this.saveEditsMessageBox();
            if (sel == 0) {
                this.jB_Ok_actionPerformed();
            } else if (sel == 1) {
                this.setModified(false);
            } else if (sel == 2 || sel == -1) {
                return false;
            }
        }
        this.jB_Cancel_actionPerformed();
        return true;
    }

    private void saveForm() {
        double station = this.rDF_station.getValue();
        boolean useDefault = this.jCkBox_default.isSelected();
        this._streamNode.setStation(station);
        this._streamNode.setDefaultStation(useDefault);
        if (this._alignment != null) {
            this._alignment.setModified(true);
        } else {
            this._streamNode.getStream().getAlignment().setModified(true);
        }
    }

    public void setData(StreamNode sn) {
        this._streamNode = sn;
        this._stream = this._streamNode.getStream().getName();
    }

    public void fillDialog() {
        if (this._streamNode == null) {
            return;
        }
        this.jTF_stream.setText(this._stream);
        WorldPt location = this._streamNode.getLocation();
        this.rDF_northing.setValue(location.n);
        this.rDF_easting.setValue(location.e);
        double station = this._streamNode.getStation();
        this.rDF_station.setValue(station);
        this.jCkBox_default.setSelected(this._streamNode.isDefaultStation());
        this.rDF_station.setEditable(!this._streamNode.isDefaultStation());
        this.rDF_station.setEditable(!this._streamNode.isDefaultStation());
        if (this._streamNode.isDefaultStation()) {
            this.jCkBox_default.requestFocus();
        } else {
            this.rDF_station.requestFocus();
        }
        this.setModified(false);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            if (this._firstShow) {
                Rectangle bounds = this.getParent().getBounds();
                Rectangle abounds = this.getBounds();
                Toolkit tk = Toolkit.getDefaultToolkit();
                Dimension d = tk.getScreenSize();
                int x = bounds.x + bounds.width - 250;
                int y = bounds.y + bounds.height - 400;
                if (x + abounds.width > d.width) {
                    x = d.width - abounds.width - 20;
                }
                this.setLocation(x, y);
                this._firstShow = false;
            } else if (this._currLoc != null && !this.isVisible()) {
                this.setLocation(this._currLoc.x, this._currLoc.y);
            }
            super.setVisible(true);
        } else {
            super.setVisible(b);
        }
    }

    @Override
    public void setModified(boolean b) {
        super.setModified(b);
        if (b) {
            this.setTitle(this._title + "*");
        } else {
            this.setTitle(this._title);
        }
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
        this.rDF_easting.setEditable(false);
        this.rDF_northing.setEditable(false);
        this.jTF_stream.setEditable(false);
    }

    private int saveEditsMessageBox() {
        int option = JOptionPane.showOptionDialog(this, "Do you want to save your changes?", "Edit in Progress", 1, 2, null, null, "Yes");
        return option;
    }

    public void setAlignment(StreamAlignmentIfc alignment) {
        this._alignment = alignment;
    }
}

