/*
 * Decompiled with CFR 0.152.
 */
package hec.map.streamAlignment;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.map.WorldPt;
import hec.model.StreamElement;
import hec.model.StreamNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;

public class StreamStationingPanel
extends AbstractEditorPanel {
    private StreamElement _elem;
    private RmaJTable stationingTable;
    private boolean _expertStreamMode = false;

    public StreamStationingPanel() {
        this.setLayout(new GridBagLayout());
        this._expertStreamMode = Boolean.getBoolean("expertStreamMode");
        Object[] headers = this._expertStreamMode ? new String[]{" ", "Index", "Coord", "Station", "Easting", "Northing"} : new String[]{" ", "Station", "Easting", "Northing"};
        this.stationingTable = new RmaJTable(this, headers){

            @Override
            public String getToolTipText(MouseEvent e) {
                int row = this.rowAtPoint(e.getPoint());
                int col = this.columnAtPoint(e.getPoint());
                if (row == -1 || col != 0) {
                    return super.getToolTipText(e);
                }
                NodeContainer nc = (NodeContainer)this.getValueAt(row, 0);
                StreamNode node = nc.node;
                String tip = "<html>Node: " + nc.name + "<br>Index:" + node.getIndex() + "<br>Coord:" + node.getStreamCoord();
                if (node.getJunction() != null) {
                    tip = tip + "<br>Junction:" + node.getJunction().getIndex();
                }
                tip = tip + "</html>";
                return tip;
            }
        };
        this.stationingTable.setCellSelectionEnabled(false);
        this.stationingTable.setColumnSelectionAllowed(false);
        this.stationingTable.setRowSelectionAllowed(true);
        this.stationingTable.setAddRemoveEnabled(false);
        this.stationingTable.removePopupMenuSumOptions();
        this.stationingTable.setPrecision(3);
        if (this._expertStreamMode) {
            this.stationingTable.setIntegerCellEditor(1);
            this.stationingTable.setDoubleCellEditor(2, true);
            this.stationingTable.setDoubleCellEditor(3, true);
            this.stationingTable.setDoubleCellEditor(4, true);
            this.stationingTable.setDoubleCellEditor(5, true);
        } else {
            this.stationingTable.setDoubleCellEditor(1, true);
            this.stationingTable.setDoubleCellEditor(2, true);
            this.stationingTable.setDoubleCellEditor(3, true);
        }
        this.stationingTable.setEditable(false);
        this.stationingTable.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.stationingTable.getScrollPane(), gbc);
    }

    @Override
    public void fillPanel(NamedType nt) {
        if (nt instanceof StreamElement) {
            this._elem = (StreamElement)nt;
            Vector<StreamNode> nodes = this._elem.getNodeVector();
            int size = nodes.size();
            this.stationingTable.deleteCells();
            for (int i = size - 1; i >= 0; --i) {
                StreamNode node = nodes.get(i);
                if (node == null) continue;
                Vector<Object> row = new Vector<Object>(4);
                if (i == size - 1) {
                    row.add(new NodeContainer(node, "Upstream Node"));
                } else if (i == 0) {
                    row.add(new NodeContainer(node, "DownStream Node"));
                } else {
                    row.add(new NodeContainer(node, ""));
                }
                if (this._expertStreamMode) {
                    row.add(new Integer(node.getIndex()));
                    row.add(new Double(node.getStreamCoord()));
                }
                row.add(new Double(node.getStation()));
                WorldPt wpt = this._elem.getLocationByStation(node.getStation());
                row.add(new Double(wpt.e));
                row.add(new Double(wpt.n));
                this.stationingTable.appendRow(row);
            }
        }
    }

    public void setStationText(String stationText) {
        TableColumnModel cm = this.stationingTable.getColumnModel();
        if (this._expertStreamMode) {
            TableColumn tc = cm.getColumn(3);
            tc.setHeaderValue(stationText);
        } else {
            TableColumn tc = cm.getColumn(1);
            tc.setHeaderValue(stationText);
        }
    }

    @Override
    public String getTabname() {
        return "Stream Stationing";
    }

    @Override
    public boolean savePanel(NamedType dobj) {
        return true;
    }

    private class NodeContainer {
        StreamNode node;
        String name;

        public NodeContainer(StreamNode streamNode, String nodeName) {
            this.node = streamNode;
            this.name = nodeName;
        }

        public String toString() {
            return this.name;
        }
    }
}

