/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tin;

import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.tin.TinGlyphDataRec;
import hec.map.tin.TinMap;
import hec.map.tin.TinTriangle;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import rma.util.RGBColorContour;

public class TinGlyph
extends MapGlyph {
    public static final int contourNONE = 0;
    public static final int contourELEV = 1;
    public static final int contourDEPTH = 2;
    public static final int contourINUNDATION = 3;
    TinMap _tinmap = null;
    RGBColorContour _cc = new RGBColorContour();

    public TinGlyph(MapPanel panel, TinMap map) {
        super(panel, map);
        this._tinmap = map;
        if (this._mapIdentifier.getGlyphDataRecord() == null) {
            this._mapIdentifier.setGlyphDataRecord(new TinGlyphDataRec());
        }
    }

    public double getDepthAt(int x, int y) {
        TinGlyphDataRec rec = (TinGlyphDataRec)this.getDataRecord();
        double depth = 0.0;
        MapScale scl = this._mapPanel.scale();
        WorldPt pt = new WorldPt();
        pt.e = scl.x2e(x);
        pt.n = scl.y2n(y);
        WorldRect bound = this.getBounds();
        if (!bound.contains(pt)) {
            return depth;
        }
        WorldRect rc = new WorldRect();
        Vector trivec = this._tinmap.triVector();
        Vector nodevec = this._tinmap.nodeVector();
        Vector convec = this._tinmap._constitVector;
        Vector elevVec = (Vector)convec.elementAt(rec.iconstit);
        Vector bedVec = (Vector)convec.elementAt(0);
        for (int i = 0; _paintOk && i < trivec.size(); ++i) {
            int j;
            TinTriangle tri = (TinTriangle)trivec.elementAt(i);
            if (tri == null) continue;
            WorldPt ndpt = (WorldPt)nodevec.elementAt(tri.node[0]);
            rc.init(ndpt);
            for (j = 1; j < 3; ++j) {
                ndpt = (WorldPt)nodevec.elementAt(tri.node[j]);
                rc.grow(ndpt);
            }
            if (!rc.contains(pt)) continue;
            for (j = 0; j < 3; ++j) {
                Double dd = (Double)elevVec.elementAt(tri.node[j]);
                Double bb = (Double)bedVec.elementAt(tri.node[j]);
                depth += (dd - bb) / 3.0;
            }
            if (!(depth < 0.0)) break;
            depth = 0.0;
            break;
        }
        return depth;
    }

    public void drawTin() {
        TinGlyphDataRec rec = (TinGlyphDataRec)this.getDataRecord();
        rec.drawTinEdges = !rec.drawTinEdges;
    }

    public void drawContour(boolean drw) {
        TinGlyphDataRec rec = (TinGlyphDataRec)this.getDataRecord();
        if (!drw) {
            rec.contourType = 0;
        }
    }

    public void drawTinElevation() {
        TinGlyphDataRec rec = (TinGlyphDataRec)this.getDataRecord();
        rec.contourType = 1;
        rec.iconstit = 0;
    }

    public void drawWaterSurface(int icon) {
        TinGlyphDataRec rec = (TinGlyphDataRec)this.getDataRecord();
        rec.contourType = 2;
        if (icon < 1) {
            icon = 1;
        }
        if (icon > 4) {
            icon = 4;
        }
        rec.iconstit = icon;
    }

    @Override
    public void draw(Graphics g, MapScale scl) {
        Vector trivec = this._tinmap.triVector();
        Vector nodevec = this._tinmap.nodeVector();
        Vector convec = this._tinmap._constitVector;
        int[] lx = new int[4];
        int[] ly = new int[4];
        TinGlyphDataRec rec = (TinGlyphDataRec)this.getDataRecord();
        int icon = rec.iconstit;
        if (icon >= convec.size()) {
            icon = convec.size() - 1;
        }
        if (icon >= 0) {
            if (rec.contourType == 1) {
                this.contourElevation(g, scl, (Vector)convec.elementAt(icon));
            } else if (rec.contourType == 2 && icon > 0) {
                this.contourDepth(g, scl, (Vector)this._tinmap._constitVector.elementAt(icon), (Vector)this._tinmap._constitVector.elementAt(0));
            } else if (rec.contourType == 3 && icon > 0) {
                this.contourInundation(g, scl, (Vector)this._tinmap._constitVector.elementAt(icon), (Vector)this._tinmap._constitVector.elementAt(0));
            }
        }
        if (!rec.drawTinEdges || !_paintOk) {
            return;
        }
        g.setColor(Color.black);
        for (int i = 0; _paintOk && i < trivec.size(); ++i) {
            TinTriangle tri = (TinTriangle)trivec.elementAt(i);
            if (tri == null) continue;
            for (int j = 0; j < 3; ++j) {
                WorldPt pt = (WorldPt)nodevec.elementAt(tri.node[j]);
                lx[j] = scl.e2x(pt.e);
                ly[j] = scl.n2y(pt.n);
            }
            lx[3] = lx[0];
            ly[3] = ly[0];
            if (!_paintOk) {
                return;
            }
            g.drawPolyline(lx, ly, 4);
        }
    }

    public void contourElevation(Graphics g, MapScale scl, Vector elevVec) {
        int i;
        double[] val = new double[3];
        Vector trivec = this._tinmap.triVector();
        Vector nodevec = this._tinmap.nodeVector();
        LocalPt[] lpt = new LocalPt[]{new LocalPt(), new LocalPt(), new LocalPt()};
        double max = 50.0;
        double min = -15.0;
        int ncontours = 20;
        double[] contourVal = new double[ncontours + 1];
        contourVal[0] = min;
        for (i = 1; i <= ncontours; ++i) {
            contourVal[i] = min + (double)i * (max - min) / (double)ncontours;
        }
        int nmax = elevVec.size();
        for (i = 0; _paintOk && i < trivec.size(); ++i) {
            TinTriangle tri = (TinTriangle)trivec.elementAt(i);
            if (tri == null) continue;
            for (int j = 0; j < 3; ++j) {
                Double dd = (Double)elevVec.elementAt(tri.node[j]);
                val[j] = dd;
                WorldPt pt = (WorldPt)nodevec.elementAt(tri.node[j]);
                scl.wp2lp(pt, lpt[j]);
            }
            this.contourTriangle(g, lpt, val, contourVal, ncontours, min, max);
        }
    }

    public void contourDepth(Graphics g, MapScale scl, Vector elevVec, Vector bedVec) {
        int i;
        double[] val = new double[3];
        Vector trivec = this._tinmap.triVector();
        Vector nodevec = this._tinmap.nodeVector();
        LocalPt[] lpt = new LocalPt[]{new LocalPt(), new LocalPt(), new LocalPt()};
        double max = 250.0;
        double min = 0.0;
        int ncontours = 100;
        double[] contourVal = new double[ncontours + 1];
        contourVal[0] = min;
        for (i = 1; i <= ncontours; ++i) {
            contourVal[i] = min + (double)i * (max - min) / (double)ncontours;
        }
        int nmax = elevVec.size();
        for (i = 0; _paintOk && i < trivec.size(); ++i) {
            TinTriangle tri = (TinTriangle)trivec.elementAt(i);
            if (tri == null) continue;
            for (int j = 0; j < 3; ++j) {
                Double dd = (Double)elevVec.elementAt(tri.node[j]);
                Double bb = (Double)bedVec.elementAt(tri.node[j]);
                val[j] = dd - bb;
                WorldPt pt = (WorldPt)nodevec.elementAt(tri.node[j]);
                scl.wp2lp(pt, lpt[j]);
            }
            this.contourTriangle(g, lpt, val, contourVal, ncontours, min, max);
        }
    }

    public void contourInundation(Graphics g, MapScale scl, Vector elevVec, Vector bedVec) {
    }

    public void contourTriangle(Graphics g, LocalPt[] lpt, double[] val, double[] conval, int ncon, double cmin, double cmax) {
        int i;
        this._cc.setMaxValue(cmax);
        this._cc.setMinValue(cmin);
        TinGlyphDataRec rec = (TinGlyphDataRec)this.getDataRecord();
        int[] lx = new int[10];
        int[] ly = new int[10];
        int[] idx = new int[]{0, 1, 2, 0};
        double min = val[0];
        int imin = 0;
        double max = val[0];
        int imax = 0;
        for (i = 1; i < 3; ++i) {
            if (min > val[i]) {
                min = val[i];
                imin = i;
            }
            if (!(max < val[i])) continue;
            max = val[i];
            imax = i;
        }
        if (max < cmin) {
            return;
        }
        if (min >= cmax) {
            for (i = 0; i < 3; ++i) {
                lx[i] = lpt[i].x;
                ly[i] = lpt[i].y;
            }
            if (!_paintOk) {
                return;
            }
            Color c2 = this._cc.getColor(cmax);
            g.setColor(c2);
            g.fillPolygon(lx, ly, 3);
            if (!rec.drawTinEdges) {
                g.drawPolygon(lx, ly, 3);
            }
            return;
        }
        if (imin == imax) {
            int j;
            for (i = 0; i < 3; ++i) {
                lx[i] = lpt[i].x;
                ly[i] = lpt[i].y;
            }
            for (j = 1; j <= ncon && max > conval[j]; ++j) {
            }
            if (!_paintOk) {
                return;
            }
            g.setColor(this._cc.getColor(conval[j - 1]));
            g.fillPolygon(lx, ly, 3);
            if (!rec.drawTinEdges) {
                g.drawPolygon(lx, ly, 3);
            }
            return;
        }
        int ic0 = 0;
        int ic1 = ncon;
        for (i = 0; _paintOk && i < ncon; ++i) {
            if (min > conval[i] && min < conval[i + 1]) {
                ic0 = i;
            }
            if (!(max > conval[i]) || !(max < conval[i + 1])) continue;
            ic1 = i;
        }
        for (i = ic0; _paintOk && i <= ic1; ++i) {
            int icnt = 0;
            for (int j = 0; j < 3; ++j) {
                if (val[j] >= conval[i]) {
                    lx[icnt] = lpt[j].x;
                    ly[icnt] = lpt[j].y;
                    ++icnt;
                }
                if (!(val[j] > conval[i] && val[idx[j + 1]] <= conval[i]) && (!(val[idx[j + 1]] > conval[i]) || !(val[j] <= conval[i]))) continue;
                double fac = (conval[i] - val[j]) / (val[idx[j + 1]] - val[j]);
                lx[icnt] = lpt[j].x + (int)(fac * (double)(lpt[idx[j + 1]].x - lpt[j].x));
                ly[icnt] = lpt[j].y + (int)(fac * (double)(lpt[idx[j + 1]].y - lpt[j].y));
                ++icnt;
            }
            if (icnt <= 2 || !_paintOk) continue;
            g.setColor(this._cc.getColor(conval[i]));
            g.fillPolygon(lx, ly, icnt);
            if (rec.drawTinEdges) continue;
            g.drawPolygon(lx, ly, icnt);
        }
    }
}

