/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tin;

import hec.io.HecFile;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectInterface;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.tin.TinTriangle;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import rma.util.RMAIO;

public class TinMap
extends MapObject
implements MapObjectInterface {
    Vector _nodeVector = new Vector();
    Vector _constitVector = new Vector();
    Vector _triVector = new Vector();
    WorldRect _rc = new WorldRect();

    public TinMap(String fileName) {
        super(fileName);
    }

    public TinMap(MapIdentifier id) {
        super(id);
    }

    public TinMap() {
    }

    public int getNodeCount() {
        return this._nodeVector.size();
    }

    public WorldPt getNode(int i) {
        return (WorldPt)this._nodeVector.elementAt(i);
    }

    public int getTriCount() {
        return this._triVector.size();
    }

    @Override
    public WorldRect getExtent() {
        return new WorldRect(this._rc.w, this._rc.n, this._rc.e, this._rc.s);
    }

    @Override
    public void unload() {
        this._nodeVector.removeAllElements();
        this._constitVector.removeAllElements();
        this._triVector.removeAllElements();
        this._rc = new WorldRect();
        this._loaded = false;
    }

    @Override
    public void load() throws IOException {
        if (!this._loaded) {
            BufferedReader in = null;
            int nmax = 0;
            Vector tmpnodeVec = new Vector();
            int[] nop = new int[4];
            try {
                int j;
                int i;
                String str;
                int len;
                long t1 = new Date().getTime();
                HecFile file = this._mapId.getFile();
                in = file.getBufferedReader();
                String line = in.readLine();
                line = in.readLine();
                line = in.readLine();
                line = in.readLine();
                while (line != null) {
                    TinTriangle tri;
                    len = line.length();
                    if (len < 5) {
                        line = in.readLine();
                        continue;
                    }
                    str = line.substring(0, 5);
                    i = RMAIO.parseInt(str);
                    if (i == 9999 || i == Integer.MIN_VALUE) break;
                    if (len < 50) continue;
                    for (i = 0; i < 4; ++i) {
                        nop[i] = Integer.MIN_VALUE;
                        int imax = (i + 1) * 10;
                        str = line.substring(imax - 5, imax);
                        nop[i] = RMAIO.parseInt(str);
                        if (nmax >= nop[i]) continue;
                        nmax = nop[i];
                    }
                    str = line.substring(45, 50);
                    j = RMAIO.parseInt(str);
                    if (j == Integer.MIN_VALUE || j < 1 || j > 900) continue;
                    if (nop[2] != Integer.MIN_VALUE && nop[2] > 0) {
                        tri = new TinTriangle();
                        tri.node[0] = nop[0];
                        tri.node[1] = nop[1];
                        tri.node[2] = nop[2];
                        this._triVector.addElement(tri);
                    }
                    if (nop[3] != Integer.MIN_VALUE && nop[3] > 0) {
                        tri = new TinTriangle();
                        tri.node[0] = nop[2];
                        tri.node[1] = nop[3];
                        tri.node[2] = nop[0];
                        this._triVector.addElement(tri);
                    }
                    line = in.readLine();
                }
                this._nodeVector.setSize(nmax + 1);
                Vector<Double> cvec = new Vector<Double>();
                Vector<Double> c1vec = new Vector<Double>();
                Vector<Double> c2vec = new Vector<Double>();
                Vector<Double> c3vec = new Vector<Double>();
                Vector<Double> c4vec = new Vector<Double>();
                cvec.setSize(nmax + 1);
                c1vec.setSize(nmax + 1);
                c2vec.setSize(nmax + 1);
                c3vec.setSize(nmax + 1);
                c4vec.setSize(nmax + 1);
                this._constitVector.addElement(cvec);
                this._constitVector.addElement(c1vec);
                this._constitVector.addElement(c2vec);
                this._constitVector.addElement(c3vec);
                this._constitVector.addElement(c4vec);
                line = in.readLine();
                j = 0;
                while (line != null) {
                    len = line.length();
                    if (len < 10) {
                        line = in.readLine();
                        continue;
                    }
                    str = line.substring(0, 10);
                    i = RMAIO.parseInt(str);
                    if (i == 9999 || i == Integer.MIN_VALUE) break;
                    if (len < 80) continue;
                    double x = RMAIO.parseDouble(line.substring(10, 20));
                    double y = RMAIO.parseDouble(line.substring(20, 30));
                    double z = RMAIO.parseDouble(line.substring(30, 40));
                    double z1 = RMAIO.parseDouble(line.substring(40, 50));
                    double z2 = RMAIO.parseDouble(line.substring(50, 60));
                    double z3 = RMAIO.parseDouble(line.substring(60, 70));
                    double z4 = RMAIO.parseDouble(line.substring(70, 80));
                    WorldPt pt = new WorldPt(x, y);
                    if (i >= this._nodeVector.size()) {
                        this._nodeVector.setSize(nmax + 100);
                        cvec.setSize(nmax + 100);
                        c1vec.setSize(nmax + 100);
                        c2vec.setSize(nmax + 100);
                        c3vec.setSize(nmax + 100);
                        c4vec.setSize(nmax + 100);
                    }
                    if (i >= nmax) {
                        nmax = i;
                    }
                    this._nodeVector.setElementAt(pt, i);
                    cvec.setElementAt(new Double(z), i);
                    c1vec.setElementAt(new Double(z1), i);
                    c2vec.setElementAt(new Double(z2), i);
                    c3vec.setElementAt(new Double(z3), i);
                    c4vec.setElementAt(new Double(z4), i);
                    if (j == 0) {
                        this._rc.initToPoint(pt);
                    } else {
                        this._rc.growToPoint(pt);
                    }
                    ++j;
                    line = in.readLine();
                }
                in.close();
                this._nodeVector.setSize(nmax + 1);
                this._nodeVector.trimToSize();
                cvec.setSize(nmax + 1);
                cvec.trimToSize();
                c1vec.setSize(nmax + 1);
                c1vec.trimToSize();
                c2vec.setSize(nmax + 1);
                c2vec.trimToSize();
                c3vec.setSize(nmax + 1);
                c3vec.trimToSize();
                c4vec.setSize(nmax + 1);
                c4vec.trimToSize();
                this.setExtent(new WorldRect(this._rc.w, this._rc.n, this._rc.e, this._rc.s));
            }
            catch (EOFException e) {
                in.close();
            }
            this._loaded = true;
        }
    }

    Vector nodeVector() {
        return this._nodeVector;
    }

    Vector triVector() {
        return this._triVector;
    }

    Vector dataVector(int i) {
        return (Vector)this._constitVector.elementAt(i);
    }

    public Vector getElements() {
        return null;
    }

    public void loadedStoreAsBin() {
    }
}

