/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms;

import hec.io.HecFile;
import hec.map.GridMap;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.tms.TmsGlyphDataRecord;
import hec.map.tms.datasource.Tile;
import hec.map.tms.datasource.TmsDataSource;
import hec.map.tms.datasource.TmsImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TmsMap
extends MapObject
implements GridMap {
    private TmsDataSource _dataSource;
    private double[] _e = new double[1];
    private double[] _n = new double[1];

    public TmsMap() {
    }

    public TmsMap(String filePath) {
        super(filePath);
    }

    public TmsMap(MapIdentifier mapId) {
        super(mapId);
    }

    @Override
    public void load() throws IOException {
        MapIdentifier mapId = this.getMapIdentifier();
        if (mapId == null) {
            return;
        }
        HecFile file = this.getMapIdentifier().getFile();
        File tmsFile = null;
        tmsFile = !(file instanceof File) ? (file == null ? new File(this.getMapIdentifier().getPath()) : new File(file.getPath())) : (File)((Object)file);
        this._dataSource = new TmsDataSource(tmsFile);
        this._dataSource.load();
        WorldRect wr = this._dataSource.getExtents();
        if (wr != null) {
            this.setExtent(this._dataSource.getExtents());
        }
        this._loaded = true;
    }

    @Override
    public void unload() {
        if (this._dataSource != null) {
            this._dataSource.unload();
            this._loaded = false;
        }
    }

    public List<Tile> getTilesFor(MapScale scale) {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        this._dataSource.getNumberOfLevels();
        return tiles;
    }

    public int getNumberOfLevels() {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this._dataSource.getNumberOfLevels();
    }

    @Override
    public float getElevation(WorldPt pt) {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this._e[0] = pt.e;
        this._n[0] = pt.n;
        return this._dataSource.getValue(this._e, this._n)[0];
    }

    @Override
    public float[] getElevation(double[] northing, double[] easting) {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this._dataSource.getValue(easting, northing);
    }

    @Override
    public double getMaximumElevation() {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this._dataSource.getMaxElevation();
    }

    @Override
    public double getMinimumElevation() {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this._dataSource.getMinElevation();
    }

    @Override
    public boolean supportsNoDataValue() {
        return true;
    }

    @Override
    public double getNoDataValue() {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this._dataSource.getNoDataValue();
    }

    @Override
    public WorldRect getGridCellSize() {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        int cellSize = this._dataSource.getCellSize();
        WorldRect r = new WorldRect();
        r.w = 0.0;
        r.s = 0.0;
        r.e = cellSize;
        r.n = cellSize;
        return r;
    }

    public int getAreaWidth() {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this._dataSource.getCellSize();
    }

    public int getAreaHeight() {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this._dataSource.getCellSize();
    }

    public TmsImage getImage(MapScale scale, TmsGlyphDataRecord gdr) {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this._dataSource.getImage(scale.getZoom(), scale.getWorldRect(), gdr);
    }

    public WorldRect getCurrentLevelExtent() {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this._dataSource.getCurrentLevelExtents();
    }

    public void clearImage() {
        if (this._dataSource == null || !this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(TmsMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this._dataSource.clearImage();
    }
}

