/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms;

import hec.event.ModifiableListener;
import hec.map.ElevationGlyph;
import hec.map.GlyphDataRecord;
import hec.map.LocalRect;
import hec.map.LocalRegion;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.tms.TmsGlyphDataRecord;
import hec.map.tms.TmsMap;
import hec.map.tms.datasource.TmsImage;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import java.util.Observable;
import java.util.Observer;
import rma.lang.Modifiable;

public class TmsMapGlyph
extends MapGlyph
implements ImageObserver,
ElevationGlyph,
ModifiableListener,
Observer {
    private Image _img;
    private int _areaWidth;
    private int _areaHeight;
    private int[] _pix;

    public TmsMapGlyph(MapPanel mapPanel, TmsMap tmsMap) {
        super(mapPanel, tmsMap);
    }

    @Override
    public void draw(Graphics g, MapScale scl) {
        WorldRect mwr;
        TmsImage tmsImage;
        if (this._map == null || this._mapPanel == null) {
            return;
        }
        TmsGlyphDataRecord data = (TmsGlyphDataRecord)this.getDataRecord();
        if (data == null) {
            data = new TmsGlyphDataRecord();
            this.setDataRecord(data);
        }
        if (data.isModified()) {
            this.clearImage();
            data.setModified(false);
        }
        if ((tmsImage = this.createImage()) == null || tmsImage.getImage() == null) {
            return;
        }
        WorldRect swr = scl.getWorldRect();
        WorldRect iwr = mwr = tmsImage.getExtents();
        Image img = tmsImage.getImage();
        if (_paintOk && iwr != null) {
            if (this._areaWidth == Integer.MIN_VALUE || this._areaHeight == Integer.MIN_VALUE) {
                return;
            }
            double xscl = (double)img.getWidth(this) / (mwr.e - mwr.w);
            double yscl = (double)img.getHeight(this) / (mwr.n - mwr.s);
            LocalRect ilr = scl.wr2lr(iwr);
            int dx1 = ilr.l;
            int dy1 = ilr.t;
            int dx2 = ilr.r;
            int dy2 = ilr.b;
            int sx1 = (int)((iwr.w - mwr.w) * xscl);
            int sy1 = (int)((mwr.n - iwr.n) * yscl);
            int sx2 = (int)((iwr.e - mwr.w) * xscl);
            int sy2 = (int)((mwr.n - iwr.s) * yscl);
            if (g instanceof Graphics2D) {
                float alpha = data.getAlpha();
                Graphics2D g2 = (Graphics2D)g;
                Composite oldac = g2.getComposite();
                AlphaComposite ac = AlphaComposite.getInstance(3, alpha);
                g2.setComposite(ac);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
                if (oldac != null) {
                    g2.setComposite(oldac);
                }
            }
        }
    }

    private void clearImage() {
        if (this._img == null) {
            return;
        }
        ((TmsMap)this.getMap()).clearImage();
        this._img = null;
    }

    private TmsImage createImage() {
        if (this._map == null || this._mapPanel == null) {
            return null;
        }
        TmsGlyphDataRecord data = (TmsGlyphDataRecord)this.getDataRecord();
        if (data == null) {
            data = new TmsGlyphDataRecord();
            this.setDataRecord(data);
        }
        if (!data.getSet()) {
            data.setGlyph(this);
        }
        TmsMap map = (TmsMap)this._map;
        this._areaWidth = map.getAreaWidth();
        this._areaHeight = map.getAreaHeight();
        MapScale scale = this._mapPanel.scale();
        return map.getImage(scale, (TmsGlyphDataRecord)this.getDataRecord());
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        System.out.println("imageUpdate TODO implement me");
        return false;
    }

    @Override
    public double getMaximumElevation() {
        return ((TmsMap)this.getMap()).getMaximumElevation();
    }

    @Override
    public double getMinimumElevation() {
        return ((TmsMap)this.getMap()).getMinimumElevation();
    }

    @Override
    public float getElevationAt(int ix, int iy) {
        if (this._mapPanel == null || this._map == null) {
            return Float.NEGATIVE_INFINITY;
        }
        WorldPt wpt = new WorldPt(this._mapPanel.scale().x2e(ix), this._mapPanel.scale().y2n(iy));
        return ((TmsMap)this.getMap()).getElevation(wpt);
    }

    @Override
    public double getNoDataValue() {
        return ((TmsMap)this.getMap()).getNoDataValue();
    }

    @Override
    public void drawElevationStats(Graphics g, LocalRegion region) {
    }

    @Override
    public void setDataRecord(GlyphDataRecord rec) {
        super.setDataRecord(rec);
        rec.addObserver(this);
    }

    @Override
    public void modifiedStateChanged(Modifiable obj, boolean modified) {
        if (modified) {
            this._img = null;
        }
    }

    @Override
    public GlyphDataRecord getDefaultDataRecord() {
        return new TmsGlyphDataRecord();
    }

    @Override
    public void update(Observable o, Object arg) {
        System.out.println("update:" + o + " arg=" + arg);
        this._img = null;
        this.clearImage();
    }
}

