/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms.datasource;

import hec.map.tms.datasource.FileSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import rma.services.GlobalServiceLoader;

public abstract class FileSystemFactory {
    private static FileSystemFactory factory = null;

    public static FileSystemFactory getDefault() {
        if (factory == null) {
            factory = new FileSysteFactoryProxy();
        }
        return factory;
    }

    public abstract FileSystem createFileSystem(File var1);

    public abstract boolean accept(File var1);

    private static class FileSysteFactoryProxy
    extends FileSystemFactory {
        List<FileSystemFactory> mFactories = null;

        private List<FileSystemFactory> loadFileSystemFactories() {
            if (this.mFactories == null) {
                this.mFactories = new ArrayList<FileSystemFactory>();
                ServiceLoader<FileSystemFactory> serviceLoader = GlobalServiceLoader.getInstance().getServiceLoader(FileSystemFactory.class);
                Iterator<FileSystemFactory> iterator = serviceLoader.iterator();
                while (iterator.hasNext()) {
                    this.mFactories.add(iterator.next());
                }
            }
            return this.mFactories;
        }

        @Override
        public FileSystem createFileSystem(File f) {
            List<FileSystemFactory> factories = this.loadFileSystemFactories();
            for (int i = 0; i < factories.size(); ++i) {
                FileSystemFactory fsf = factories.get(i);
                if (!fsf.accept(f)) continue;
                return fsf.createFileSystem(f);
            }
            return null;
        }

        @Override
        public boolean accept(File path) {
            List<FileSystemFactory> factories = this.loadFileSystemFactories();
            for (int i = 0; i < factories.size(); ++i) {
                FileSystemFactory fsf = factories.get(i);
                if (!fsf.accept(path)) continue;
                return true;
            }
            return false;
        }
    }
}

