/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms.datasource;

import hec.map.WorldRect;
import hec.map.tms.TmsGlyphDataRecord;
import hec.map.tms.datasource.FileSystem;
import hec.map.tms.datasource.FileSystemFactory;
import hec.map.tms.datasource.TmsImage;
import hec.map.tms.datasource.TmsLevel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import rma.util.RMAIO;

public class TmsDataSource {
    File dataSource;
    WorldRect mExtents;
    int mCellSize;
    double mPrecision;
    double mFractionData;
    List<TmsLevel> mLevels = new ArrayList<TmsLevel>();
    private double mMaxElev;
    private double mMinElev;
    private TmsLevel mCurrentLevel;

    public TmsDataSource(File f) {
        this.dataSource = f;
    }

    public float[] getValue(double[] xvalues, double[] yvalues) {
        TmsLevel level = this.getLevel(0);
        if (level == null) {
            float[] returnValues = new float[xvalues != null ? xvalues.length : 0];
            Arrays.fill(returnValues, this.getNoDataValue());
            return returnValues;
        }
        return level.getValue(xvalues, yvalues);
    }

    TmsLevel getLevel(int level) {
        if (this.mLevels.isEmpty() || level < 0 || level >= this.mLevels.size()) {
            return null;
        }
        return this.mLevels.get(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        if (this.dataSource == null) {
            String msg = "Unable to load TMS Map.  TMS file is NULL.";
            Logger.getLogger(TmsDataSource.class.getName()).log(Level.SEVERE, msg);
            throw new IOException(msg);
        }
        if (!this.dataSource.exists()) {
            String msg = "Unable to load TMS Map.  TMS file does not exist: " + this.dataSource.getAbsolutePath() + ".";
            Logger.getLogger(TmsDataSource.class.getName()).log(Level.SEVERE, msg);
            throw new IOException(msg);
        }
        InputStream zis = null;
        AbstractInterruptibleChannel fileChannel = null;
        FileSystem f = null;
        try {
            f = FileSystemFactory.getDefault().createFileSystem(this.dataSource);
            if (f == null) {
                Logger.getLogger(TmsDataSource.class.getName()).log(Level.WARNING, "load: failed to get TMS file system for {0}", this.dataSource);
                return;
            }
            fileChannel = f.getFileChannel("TMS.xml");
            zis = Channels.newInputStream((ReadableByteChannel)((Object)fileChannel));
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(zis);
            Element root = doc.getRootElement();
            Element child = root.getChild("CellSize");
            this.mCellSize = RMAIO.parseInt(child.getValue(), 0);
            child = root.getChild("Precision");
            this.mPrecision = RMAIO.parseDouble(child.getValue(), 0.0);
            child = root.getChild("FractionData");
            this.mFractionData = RMAIO.parseDouble(child.getValue(), 0.0);
            Element parent = root.getChild("Extent");
            child = root.getChild("SurfaceStatistics");
            Element maxChild = child.getChild("Maximum");
            this.mMaxElev = RMAIO.parseDouble(maxChild.getValue(), 0.0);
            Element minChild = child.getChild("Minimum");
            this.mMinElev = RMAIO.parseDouble(minChild.getValue(), 0.0);
            double maxx = 0.0;
            double minx = 0.0;
            double maxy = 0.0;
            double miny = 0.0;
            child = parent.getChild("MaxX");
            maxx = RMAIO.parseDouble(child.getValue(), -1.0);
            if (maxx == -1.0) {
                throw new IOException("Invalid MaxX Element in TmsDataSource");
            }
            child = parent.getChild("MinX");
            minx = RMAIO.parseDouble(child.getValue(), -1.0);
            if (minx == -1.0) {
                throw new IOException("Invalid MinX Element in Level");
            }
            child = parent.getChild("MaxY");
            maxy = RMAIO.parseDouble(child.getValue(), -1.0);
            if (maxy == -1.0) {
                throw new IOException("Invalid MaxY Element in Level");
            }
            child = parent.getChild("MinY");
            miny = RMAIO.parseDouble(child.getValue(), -1.0);
            if (miny == -1.0) {
                throw new IOException("Invalid MinY Element in Level");
            }
            this.mExtents = new WorldRect(minx, maxy, maxx, miny);
            List levels = root.getChild("Levels").getChildren();
            this.mLevels = new ArrayList<TmsLevel>();
            for (int i = 0; i < levels.size(); ++i) {
                Element level = (Element)levels.get(i);
                TmsLevel tmsLevel = new TmsLevel(this, this.dataSource, "level" + i);
                tmsLevel.parse(level);
                this.mLevels.add(tmsLevel);
            }
            System.out.println(levels.size());
        }
        catch (JDOMException ex) {
            String msg = "JDOMException occured when opening file: " + this.dataSource != null ? this.dataSource.getAbsolutePath() : "<Undefind TMS File>";
            Logger.getLogger(TmsDataSource.class.getName()).log(Level.SEVERE, msg, ex);
        }
        catch (ZipException ex) {
            String msg = "ZipException occured when opening file: " + this.dataSource != null ? this.dataSource.getAbsolutePath() : "<Undefind TMS File>";
            Logger.getLogger(TmsDataSource.class.getName()).log(Level.SEVERE, msg, ex);
        }
        catch (IOException ex) {
            String msg = "IOException occured when opening file: " + this.dataSource != null ? this.dataSource.getAbsolutePath() : "<Undefind TMS File>";
            Logger.getLogger(TmsDataSource.class.getName()).log(Level.SEVERE, msg, ex);
        }
        catch (Exception ex) {
            String msg = "Exception occured when opening file: " + this.dataSource != null ? this.dataSource.getAbsolutePath() : "<Undefind TMS File>";
            Logger.getLogger(TmsDataSource.class.getName()).log(Level.SEVERE, msg, ex);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(TmsDataSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(TmsDataSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(TmsDataSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void unload() {
        try {
            for (int i = 0; i < this.mLevels.size(); ++i) {
                this.mLevels.get(i).close();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TmsDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int getNumberOfLevels() {
        return this.mLevels.size();
    }

    public WorldRect getExtents() {
        return this.mExtents;
    }

    public int getCellSize() {
        return this.mCellSize;
    }

    public float getNoDataValue() {
        return -9999.0f;
    }

    public TmsImage getImage(double zoom, WorldRect worldRect, TmsGlyphDataRecord gdr) {
        int y = (int)(-Math.floor(Math.log(zoom) / Math.log(2.0)));
        this.mCurrentLevel = null;
        if (y <= 0) {
            this.mCurrentLevel = this.mLevels.get(this.mLevels.size() - 1);
            return this.mCurrentLevel.getImage(worldRect, gdr);
        }
        if (y >= this.mLevels.size() - 1) {
            this.mCurrentLevel = this.mLevels.get(0);
            return this.mCurrentLevel.getImage(worldRect, gdr);
        }
        int level = this.mLevels.size() - 1 - y;
        this.mCurrentLevel = this.mLevels.get(level);
        return this.mCurrentLevel.getImage(worldRect, gdr);
    }

    public WorldRect getCurrentLevelExtents() {
        if (this.mCurrentLevel != null) {
            return this.mCurrentLevel.getExtents();
        }
        return this.getExtents();
    }

    public double getMinElevation() {
        return this.mMinElev;
    }

    public double getMaxElevation() {
        return this.mMaxElev;
    }

    public void clearImage() {
        for (int i = 0; i < this.mLevels.size(); ++i) {
            this.mLevels.get(i).clearImage();
        }
    }
}

