/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms.datasource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import rma.util.RMAIO;

public class TmsHeader {
    ByteOrder byteOrder = ByteOrder.nativeOrder();
    int numRows = 0;
    int numCols = 0;
    int nbits = 0;
    String pixeltype = "unsignedint";
    int totalRowBytes = 0;
    double upperLeftX = 0.0;
    double upperLeftY = 0.0;
    double xdim;
    double ydim;
    float noDataValue;
    float maxValue;
    float minValue;

    public double getXDimension() {
        return this.xdim;
    }

    public double getYDimension() {
        return this.ydim;
    }

    public double getUpperLeftX() {
        return this.upperLeftX;
    }

    public double getUpperLeftY() {
        return this.upperLeftY;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float getNotDataValue() {
        return this.noDataValue;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getNumBits() {
        return this.nbits;
    }

    public void read(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] split = line.split(" ", 2);
            if (split == null || split.length < 2) continue;
            split[0] = split[0].trim();
            split[1] = split[1].trim();
            if ("byteorder".equalsIgnoreCase(split[0])) {
                String order = split[1];
                if ("I".equalsIgnoreCase(order) || "lsbfirst".equalsIgnoreCase(order)) {
                    this.byteOrder = ByteOrder.LITTLE_ENDIAN;
                    continue;
                }
                if (!"M".equalsIgnoreCase(order) && !"msbfirst".equalsIgnoreCase(order)) continue;
                this.byteOrder = ByteOrder.BIG_ENDIAN;
                continue;
            }
            if ("nrows".equalsIgnoreCase(split[0])) {
                this.numRows = RMAIO.parseInt(split[1]);
                continue;
            }
            if ("ncols".equalsIgnoreCase(split[0])) {
                this.numCols = RMAIO.parseInt(split[1]);
                continue;
            }
            if ("nbits".equalsIgnoreCase(split[0])) {
                this.nbits = RMAIO.parseInt(split[1]);
                continue;
            }
            if ("pixeltype".equalsIgnoreCase(split[0])) {
                this.pixeltype = split[1];
                continue;
            }
            if ("totalrowbytes".equalsIgnoreCase(split[0])) {
                this.totalRowBytes = RMAIO.parseInt(split[1]);
                continue;
            }
            if ("ulxmap".equalsIgnoreCase(split[0])) {
                this.upperLeftX = RMAIO.parseDouble(split[1]);
                continue;
            }
            if ("ulymap".equalsIgnoreCase(split[0])) {
                this.upperLeftY = RMAIO.parseDouble(split[1]);
                continue;
            }
            if ("xdim".equalsIgnoreCase(split[0])) {
                this.xdim = RMAIO.parseInt(split[1]);
                continue;
            }
            if ("ydim".equalsIgnoreCase(split[0])) {
                this.ydim = RMAIO.parseInt(split[1]);
                continue;
            }
            if ("nodata".equalsIgnoreCase(split[0])) {
                this.noDataValue = RMAIO.parseInt(split[1]);
                continue;
            }
            if ("maxvalueF32".equalsIgnoreCase(split[0])) {
                this.maxValue = RMAIO.parseFloat(split[1]);
                continue;
            }
            if (!"minvalueF32".equalsIgnoreCase(split[0])) continue;
            this.minValue = RMAIO.parseFloat(split[1]);
        }
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumColumns() {
        return this.numCols;
    }

    public int getTotalRowBytes() {
        return this.totalRowBytes;
    }
}

