/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms.datasource;

import hec.map.WorldRect;
import hec.map.tms.TmsGlyphDataRecord;
import hec.map.tms.datasource.FileSystem;
import hec.map.tms.datasource.FileSystemFactory;
import hec.map.tms.datasource.Tile;
import hec.map.tms.datasource.TmsDataSource;
import hec.map.tms.datasource.TmsImage;
import hec.map.tms.datasource.TmsTileFactory;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;
import rma.util.RMAIO;

public class TmsLevel
implements ImageObserver {
    public static final float NO_DATA_VALUE = -9999.0f;
    private String name;
    private FileSystem fileSystem;
    private int rows = 0;
    private int cols = 0;
    private double tileCellSize;
    private double maxx = 0.0;
    private double minx = 0.0;
    private double maxy = 0.0;
    private double miny = 0.0;
    private Map<RowColIndex, Tile> mTileCache = new HashMap<RowColIndex, Tile>();
    private Map<RowColIndex, Long> mTileLastAccessed = new HashMap<RowColIndex, Long>();
    private SoftReference<TmsImage> _imgRef;
    private TmsDataSource _dataSource;
    private WorldRect mExtents;
    private static final Tile EMPTY_TILE = new EmptyTile();

    public TmsLevel(TmsDataSource tmsDataSource, File f, String name) {
        this._dataSource = tmsDataSource;
        this._imgRef = new SoftReference<Object>(null);
        this.fileSystem = FileSystemFactory.getDefault().createFileSystem(f);
        this.name = name;
    }

    protected double colToX(int col) {
        return (double)col / (double)this.getNumberColumns() * (this.maxx - this.minx) + this.minx;
    }

    protected double rowToY(int row) {
        return this.maxy - (double)row / (double)this.getNumberRows() * (this.maxy - this.miny);
    }

    protected int yToRow(double y) {
        return this.rows - 1 - (int)((y - this.miny) / (this.maxy - this.miny) * (double)this.rows);
    }

    protected int xToCol(double x) {
        return (int)((x - this.minx) / (this.maxx - this.minx) * (double)this.cols);
    }

    public TmsImage getImage(WorldRect visibleRect, TmsGlyphDataRecord gdr) {
        return this.createImage(visibleRect, gdr);
    }

    protected TmsImage createImage(WorldRect visibleRect, TmsGlyphDataRecord gdr) {
        WorldRect levelExtents = this.getExtents();
        WorldRect drawingRect = visibleRect.getIntersection(levelExtents);
        if (drawingRect == null) {
            return null;
        }
        if (gdr != null) {
            gdr.getColorContour().setMinValue(this._dataSource.getMinElevation());
            gdr.getColorContour().setMaxValue(this._dataSource.getMaxElevation());
        }
        BufferedImage img = null;
        Graphics g = null;
        int x = 0;
        int y = 0;
        Image image = null;
        int i1 = this.xToCol(drawingRect.w);
        int i2 = this.xToCol(drawingRect.e) + 1;
        int startCol = i1 < 0 ? 0 : i1;
        int endCol = i2 > this.getNumberColumns() ? this.getNumberColumns() : i2;
        i1 = this.yToRow(drawingRect.n);
        i2 = this.yToRow(drawingRect.s);
        int startRow = Math.min(i1, i2);
        int endRow = Math.max(i1, i2) + 1;
        startRow = startRow < 0 ? 0 : startRow;
        endRow = endRow > this.getNumberRows() ? this.getNumberRows() : endRow;
        drawingRect.w = this.colToX(startCol);
        drawingRect.e = this.colToX(endCol);
        drawingRect.n = Math.max(this.rowToY(startRow), this.rowToY(endRow));
        drawingRect.s = Math.min(this.rowToY(startRow), this.rowToY(endRow));
        int numRows = endRow - startRow;
        int numCols = endCol - startCol;
        double xscale = 0.0;
        double yscale = 0.0;
        for (int r = startRow; r < endRow; ++r) {
            for (int c2 = startCol; c2 < endCol; ++c2) {
                Tile tile = this.getTile(r, c2);
                if (tile == null) continue;
                image = tile.getImage(gdr);
                if (img == null && image != null) {
                    int width = image.getWidth(this);
                    int height = image.getHeight(this);
                    img = new BufferedImage(numCols * width, numRows * height, 2);
                    for (int r1 = 0; r1 < numCols * width; ++r1) {
                        for (int c1 = 0; c1 < numRows * height; ++c1) {
                            img.setRGB(r1, c1, 0);
                        }
                    }
                    g = img.getGraphics();
                    xscale = (double)img.getWidth() / drawingRect.width();
                    yscale = (double)img.getHeight() / drawingRect.height();
                }
                if (image == null) continue;
                x = (int)((tile.getUpperLeftX() - drawingRect.w) * xscale);
                y = (int)((drawingRect.n - tile.getUpperLeftY()) * yscale);
                g.drawImage(image, x, y, image.getWidth(this), image.getHeight(this), this);
            }
        }
        if (g != null) {
            g.dispose();
        }
        return new TmsImageImpl(img, drawingRect);
    }

    void parse(Element parent) throws IOException {
        Element child = parent.getChild("Rows");
        this.rows = RMAIO.parseInt(child.getValue(), -1);
        if (this.rows == -1) {
            throw new IOException("Invalid Row Element in Level - " + this.name);
        }
        child = parent.getChild("Cols");
        this.cols = RMAIO.parseInt(child.getValue(), -1);
        if (this.cols == -1) {
            throw new IOException("Invalid Col Element in Level - " + this.name);
        }
        child = parent.getChild("TileCellSize");
        this.tileCellSize = RMAIO.parseDouble(child.getValue(), -1.0);
        if (this.tileCellSize == -1.0) {
            throw new IOException("Invalid tileCellSize Element in Level - " + this.name);
        }
        child = parent.getChild("MaxX");
        this.maxx = RMAIO.parseDouble(child.getValue(), -1.0);
        if (this.maxx == -1.0) {
            throw new IOException("Invalid MaxX Element in Level - " + this.name);
        }
        child = parent.getChild("MinX");
        this.minx = RMAIO.parseDouble(child.getValue(), -1.0);
        if (this.minx == -1.0) {
            throw new IOException("Invalid MinX Element in Level - " + this.name);
        }
        child = parent.getChild("MaxY");
        this.maxy = RMAIO.parseDouble(child.getValue(), -1.0);
        if (this.maxy == -1.0) {
            throw new IOException("Invalid MaxY Element in Level - " + this.name);
        }
        child = parent.getChild("MinY");
        this.miny = RMAIO.parseDouble(child.getValue(), -1.0);
        if (this.miny == -1.0) {
            throw new IOException("Invalid MinY Element in Level - " + this.name);
        }
        this.mExtents = new WorldRect(this.minx, this.maxy, this.maxx, this.miny);
    }

    public WorldRect getExtents() {
        return this.mExtents;
    }

    public int getNumberRows() {
        return this.rows;
    }

    public int getNumberColumns() {
        return this.cols;
    }

    public double getMinX() {
        return this.minx;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public double getMinY() {
        return this.miny;
    }

    public double getMaxY() {
        return this.maxy;
    }

    public float getNoDataValue() {
        return -9999.0f;
    }

    public Tile getTile(int row, int column) {
        Tile tile = null;
        if (column >= 0 && column < this.getNumberColumns() && row >= 0 && row < this.getNumberRows()) {
            RowColIndex rci = new RowColIndex(row, column);
            tile = this.mTileCache.get(rci);
            if (tile == EMPTY_TILE) {
                return null;
            }
            if (tile == null) {
                String[] extensions = TmsTileFactory.getDefault().getTileExtensions();
                for (int zz = 0; zz < extensions.length; ++zz) {
                    String tileEntryPath = this.name + "/" + column + "/" + row + extensions[zz];
                    if (!this.fileSystem.exists(tileEntryPath)) continue;
                    tile = TmsTileFactory.getDefault().createTile(tileEntryPath, this.fileSystem);
                }
                if (tile == null) {
                    tile = new EmptyTile();
                }
                this.mTileCache.put(rci, tile);
                this.mTileLastAccessed.put(rci, System.currentTimeMillis());
            }
        }
        return tile;
    }

    public float[] getValue(double[] easting, double[] northing) {
        int numReturnValue = northing != null ? northing.length : 0;
        int numMaps = this.getNumberColumns() * this.getNumberRows();
        float[] values = new float[numReturnValue];
        Arrays.fill(values, this.getNoDataValue());
        if (numMaps == 0) {
            return values;
        }
        HashMap<RowColIndex, TileBucket> bucketMap = new HashMap<RowColIndex, TileBucket>();
        RowColIndex key = new RowColIndex(0, 0);
        int i = 0;
        while (i < numReturnValue) {
            int row;
            int column = this.xToCol(easting[i]);
            key.row = row = this.yToRow(northing[i]);
            key.col = column;
            TileBucket bucket = (TileBucket)bucketMap.get(key);
            if (bucket == null) {
                bucket = new TileBucket();
                bucket.tile = this.getTile(row, column);
                bucketMap.put(new RowColIndex(row, column), bucket);
            }
            while (bucket.ptIdx >= bucket.xpts.length) {
                int newSize = bucket.xpts.length * 2;
                double[] tempX = bucket.xpts;
                double[] tempY = bucket.ypts;
                int[] tempOrigIdx = bucket.origPtIdx;
                bucket.xpts = new double[newSize];
                bucket.ypts = new double[newSize];
                bucket.origPtIdx = new int[newSize];
                System.arraycopy(tempX, 0, bucket.xpts, 0, tempX.length);
                System.arraycopy(tempY, 0, bucket.ypts, 0, tempY.length);
                System.arraycopy(tempOrigIdx, 0, bucket.origPtIdx, 0, tempOrigIdx.length);
            }
            int ptIdx = bucket.ptIdx++;
            bucket.xpts[ptIdx] = easting[i];
            bucket.ypts[ptIdx] = northing[i];
            bucket.origPtIdx[ptIdx] = i++;
        }
        Set keySet = bucketMap.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            float[] value;
            TileBucket bucket = (TileBucket)bucketMap.get(iterator.next());
            if (bucket.tile != null) {
                value = bucket.tile.getValues(bucket.xpts, bucket.ypts, bucket.ptIdx);
                for (int i2 = 0; i2 < value.length; ++i2) {
                    float rvalue = value[i2];
                    if (rvalue == bucket.tile.getNoDataValue()) {
                        rvalue = this.getNoDataValue();
                    }
                    values[bucket.origPtIdx[i2]] = rvalue;
                }
                continue;
            }
            value = new float[bucket.ptIdx];
            Arrays.fill(value, this.getNoDataValue());
        }
        return values;
    }

    public void close() {
        Collection<Tile> values = this.mTileCache.values();
        Iterator<Tile> iterator = values.iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
        }
        this.mTileCache.clear();
        try {
            this.fileSystem.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TmsLevel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    public void clearImage() {
        this._imgRef = new SoftReference<Object>(null);
    }

    private class TmsImageImpl
    implements TmsImage {
        Image img = null;
        WorldRect ext = null;

        public TmsImageImpl(Image i, WorldRect wr) {
            this.img = i;
            this.ext = wr;
        }

        @Override
        public Image getImage() {
            return this.img;
        }

        @Override
        public WorldRect getExtents() {
            return this.ext;
        }
    }

    private class RowColIndex {
        public int row;
        public int col;

        public RowColIndex(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RowColIndex other = (RowColIndex)obj;
            if (this.row != other.row) {
                return false;
            }
            return this.col == other.col;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + this.row;
            hash = 59 * hash + this.col;
            return hash;
        }
    }

    public static class EmptyTile
    implements Tile {
        @Override
        public float getNoDataValue() {
            return -9999.0f;
        }

        @Override
        public float[] getValues(double[] xvalues, double[] yvalues, int numPoints) {
            float[] values = new float[numPoints];
            Arrays.fill(values, this.getNoDataValue());
            return values;
        }

        @Override
        public float[] getValues() {
            return null;
        }

        @Override
        public Image getImage(TmsGlyphDataRecord gdr) {
            return null;
        }

        @Override
        public float getMinValue() {
            return -9999.0f;
        }

        @Override
        public float getMaxValue() {
            return -9999.0f;
        }

        @Override
        public double getUpperLeftX() {
            return 0.0;
        }

        @Override
        public double getUpperLeftY() {
            return 0.0;
        }

        @Override
        public WorldRect getExtents() {
            return null;
        }

        @Override
        public void close() {
        }
    }

    private class TileBucket {
        public Tile tile = null;
        double[] xpts = new double[100];
        double[] ypts = new double[100];
        int[] origPtIdx = new int[100];
        int ptIdx = 0;

        private TileBucket() {
        }
    }
}

