/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms.datasource;

import hec.map.tms.datasource.FileSystem;
import hec.map.tms.datasource.Tile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import rma.services.GlobalServiceLoader;

public abstract class TmsTileFactory {
    static TmsTileFactory tileFactory = null;

    public static TmsTileFactory getDefault() {
        if (tileFactory == null) {
            tileFactory = new TmsTileFactoryProxy();
        }
        return tileFactory;
    }

    public abstract String[] getTileExtensions();

    public abstract Tile createTile(String var1, FileSystem var2);

    public abstract boolean accept(String var1);

    private static class TmsTileFactoryProxy
    extends TmsTileFactory {
        private List<TmsTileFactory> mFactories;

        private List<TmsTileFactory> loadTileFactoryServices() {
            if (this.mFactories == null) {
                this.mFactories = new ArrayList<TmsTileFactory>();
                ServiceLoader<TmsTileFactory> serviceLoader = GlobalServiceLoader.getInstance().getServiceLoader(TmsTileFactory.class);
                Iterator<TmsTileFactory> iterator = serviceLoader.iterator();
                while (iterator.hasNext()) {
                    this.mFactories.add(iterator.next());
                }
            }
            return this.mFactories;
        }

        @Override
        public String[] getTileExtensions() {
            ArrayList<String> extensions = new ArrayList<String>();
            List<TmsTileFactory> factories = this.loadTileFactoryServices();
            for (int i = 0; i < factories.size(); ++i) {
                String[] tileExtensions = factories.get(i).getTileExtensions();
                extensions.addAll(Arrays.asList(tileExtensions));
            }
            return extensions.toArray(new String[0]);
        }

        @Override
        public Tile createTile(String path, FileSystem dataProvider) {
            List<TmsTileFactory> factories = this.loadTileFactoryServices();
            for (int i = 0; i < factories.size(); ++i) {
                TmsTileFactory factory = factories.get(i);
                if (!factory.accept(path)) continue;
                return factory.createTile(path, dataProvider);
            }
            return null;
        }

        @Override
        public boolean accept(String path) {
            List<TmsTileFactory> factories = this.loadTileFactoryServices();
            for (int i = 0; i < factories.size(); ++i) {
                TmsTileFactory factory = factories.get(i);
                if (!factory.accept(path)) continue;
                return true;
            }
            return false;
        }
    }
}

