/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms.datasource.filesystem.directory;

import hec.map.tms.datasource.FileSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAIO;

public class DirectoryFileSystem
implements FileSystem {
    private File rootDir = null;

    public DirectoryFileSystem(File f) {
        this.rootDir = f;
    }

    @Override
    public FileChannel getFileChannel(String path) {
        File f = this.createFile(path);
        if (f == null || !f.exists()) {
            return null;
        }
        try {
            RandomAccessFile file = new RandomAccessFile(f, "r");
            return file.getChannel();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DirectoryFileSystem.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private File createFile(String path) {
        if (RMAIO.isFullPath(path)) {
            if (path.toLowerCase().startsWith(this.rootDir.getAbsolutePath().toLowerCase())) {
                return new File(path);
            }
            return null;
        }
        return new File(this.rootDir.getAbsolutePath() + File.separator + path);
    }

    @Override
    public boolean exists(String path) {
        File f = this.createFile(path);
        return f != null && f.exists();
    }

    @Override
    public boolean close() throws IOException {
        return true;
    }
}

