/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms.datasource.filesystem.zipfile;

import hec.map.tms.datasource.FileSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import rma.util.RMAIO;

public class ZipFileFileSystem
implements FileSystem {
    ZipFile mZipFile = null;
    private static final Map<File, File> cleanUpMap;

    public ZipFileFileSystem(File f) {
        try {
            this.mZipFile = new ZipFile(f);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipFileFileSystem.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ZipFileFileSystem.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public FileChannel getFileChannel(String path) {
        if (this.mZipFile == null) {
            return null;
        }
        String tempDirectory = System.getProperty("java.io.tmpdir");
        String TMS_TEMP_ROOT = tempDirectory + "TMS";
        String TMS_MAP_ROOT = TMS_TEMP_ROOT + "/" + RMAIO.getFileNameNoExtension(this.mZipFile.getName());
        File TMS_MAP_ROOT_FILE = new File(TMS_MAP_ROOT);
        cleanUpMap.put(TMS_MAP_ROOT_FILE, TMS_MAP_ROOT_FILE);
        String DEST_FILE = TMS_MAP_ROOT + "/" + path;
        try {
            ZipEntry entry = this.mZipFile.getEntry(path);
            InputStream inputStream = this.mZipFile.getInputStream(entry);
            int numBytesRead = 0;
            BufferedInputStream bufIn = new BufferedInputStream(inputStream);
            File f = new File(DEST_FILE);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            FileOutputStream fStream = new FileOutputStream(DEST_FILE);
            BufferedOutputStream bufOut = new BufferedOutputStream(fStream);
            byte[] byteArray = new byte[1000];
            numBytesRead = bufIn.read(byteArray);
            while (numBytesRead != -1) {
                bufOut.write(byteArray, 0, numBytesRead);
                numBytesRead = bufIn.read(byteArray);
            }
            bufOut.flush();
            bufOut.close();
            bufIn.close();
            File file = new File(DEST_FILE);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            FileChannel channel = randomAccessFile.getChannel();
            return channel;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public boolean exists(String path) {
        return this.mZipFile.getEntry(path) != null;
    }

    @Override
    public boolean close() throws IOException {
        this.mZipFile.close();
        return true;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new CleanUpThread());
        cleanUpMap = new HashMap<File, File>();
    }

    private static class CleanUpThread
    extends Thread {
        @Override
        public void run() {
            Collection<File> files = cleanUpMap.values();
            for (File f : files) {
                if (!f.isDirectory()) continue;
                this.removeDirectory(f);
            }
        }

        public boolean removeDirectory(File directory) {
            if (directory == null) {
                return false;
            }
            if (!directory.exists()) {
                return true;
            }
            if (!directory.isDirectory()) {
                return false;
            }
            String[] list = directory.list();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    File entry = new File(directory, list[i]);
                    if (!(entry.isDirectory() ? !this.removeDirectory(entry) : !entry.delete())) continue;
                    return false;
                }
            }
            return directory.delete();
        }
    }
}

