/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms.datasource.tile.bil;

import hec.map.WorldRect;
import hec.map.tms.TmsGlyphDataRecord;
import hec.map.tms.datasource.FileSystem;
import hec.map.tms.datasource.Tile;
import hec.map.tms.datasource.tile.bil.BilTileHeader;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import rma.util.ColorContour;

public class BilTile
implements Tile {
    private FileChannel mFileChannel = null;
    private FileSystem mDataProvider = null;
    private BilTileHeader mTmsHeader = null;
    private String dataFilePath = null;
    private String headerFilePath = null;
    static JLabel COMP = new JLabel();
    private SoftReference<Image> weakIamgeRef = null;
    private MediaTracker _tracker;
    boolean initialzied = false;
    TmsGlyphDataRecord mPrevGdr = null;

    public BilTile(String path, FileSystem dataProvider) {
        this.mDataProvider = dataProvider;
        String name = this.dataFilePath = path;
        String name2 = name.toLowerCase();
        int idx = name2.indexOf(".bil");
        this.headerFilePath = idx >= 0 ? name.substring(0, idx) + ".hdr" : this.dataFilePath + ".hdr";
    }

    public void closeDataStream() {
        if (this.mFileChannel != null) {
            try {
                this.mFileChannel.close();
            }
            catch (IOException ex) {
                Logger.getLogger(BilTile.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.mTmsHeader = null;
            this.initialzied = false;
            this.mFileChannel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.initialzied) {
            return;
        }
        FileChannel headerFileChannel = this.mDataProvider.getFileChannel(this.headerFilePath);
        InputStream newInputStream = Channels.newInputStream(headerFileChannel);
        this.mTmsHeader = new BilTileHeader();
        try {
            this.mTmsHeader.read(newInputStream);
        }
        catch (IOException ex) {
            Logger.getLogger(BilTile.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            try {
                newInputStream.close();
                headerFileChannel.close();
            }
            catch (IOException ex) {
                Logger.getLogger(BilTile.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
        this.mFileChannel = this.mDataProvider.getFileChannel(this.dataFilePath);
        this.initialzied = true;
    }

    @Override
    public float[] getValues(double[] x, double[] y, int numPoints) {
        if (numPoints > x.length) {
            throw new IllegalArgumentException("Invalid Number of Points.  Number of points must be less than or equal to the size of the original point array");
        }
        this.initialize();
        float[] values = new float[numPoints];
        Arrays.fill(values, this.getNoDataValue());
        float tileMin = this.mTmsHeader.getMinValue();
        float tileMax = this.mTmsHeader.getMaxValue();
        int numBits = this.mTmsHeader.getNumBits();
        int NUM_BYTES = numBits / 8;
        ByteBuffer buffer = ByteBuffer.allocate(NUM_BYTES);
        buffer.order(this.mTmsHeader.getByteOrder().equals(ByteOrder.BIG_ENDIAN) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        Rectangle2D.Double bounds = new Rectangle2D.Double(this.mTmsHeader.getUpperLeftX(), this.mTmsHeader.getUpperLeftY() - this.mTmsHeader.getXDimension() * (double)this.mTmsHeader.getNumColumns(), this.mTmsHeader.getXDimension() * (double)this.mTmsHeader.getNumColumns(), this.mTmsHeader.getYDimension() * (double)this.mTmsHeader.getNumRows());
        float NUM_BITS_VALUE = (float)(Math.pow(2.0, numBits) - 2.0);
        for (int i = 0; i < values.length; ++i) {
            float dvalue;
            int zz;
            if (!bounds.contains(x[i], y[i])) {
                values[i] = this.getNoDataValue();
                continue;
            }
            double boundsLX = bounds.getX();
            int icol = (int)((x[i] - boundsLX) / this.mTmsHeader.getXDimension());
            double boundsUY = bounds.getY() + bounds.getHeight();
            int irow = (int)((boundsUY - y[i]) / this.mTmsHeader.getYDimension());
            int idx = irow * this.mTmsHeader.getTotalRowBytes() + icol * (this.mTmsHeader.getNumBits() / 8);
            idx = idx < 0 ? 0 : idx;
            int numBytesRead = -1;
            try {
                this.mFileChannel.position(0L);
                this.mFileChannel.position(idx);
                numBytesRead = this.mFileChannel.read(buffer);
            }
            catch (IOException ex) {
                Logger.getLogger(BilTile.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                values[i] = this.getNoDataValue();
                continue;
            }
            if (numBytesRead < 0) {
                values[i] = this.getNoDataValue();
                continue;
            }
            int value = 0;
            buffer.position(0);
            if (this.mTmsHeader.getByteOrder().equals(ByteOrder.BIG_ENDIAN)) {
                for (zz = 0; zz < NUM_BYTES; ++zz) {
                    value <<= 8;
                    value |= buffer.get() & 0xFF;
                }
            } else {
                for (zz = NUM_BYTES - 1; zz >= 0; --zz) {
                    value <<= 8;
                    value |= buffer.get(zz) & 0xFF;
                }
            }
            values[i] = (float)value == this.getNoDataValue() ? this.getNoDataValue() : (dvalue = tileMin + (tileMax - tileMin) * (float)value / NUM_BITS_VALUE);
        }
        return values;
    }

    @Override
    public float getNoDataValue() {
        return this.mTmsHeader.getNotDataValue();
    }

    @Override
    public void close() {
        this.closeDataStream();
    }

    @Override
    public float[] getValues() {
        try {
            this.initialize();
            this.mFileChannel.position(0L);
            float tMin = this.mTmsHeader.getMinValue();
            float tMax = this.mTmsHeader.getMaxValue();
            int numBits = this.mTmsHeader.getNumBits();
            int NUM_BYTES = numBits / 8;
            float NUM_BITS_VALUE = (float)(Math.pow(2.0, numBits) - 2.0);
            int numCols = this.mTmsHeader.getNumColumns();
            int numRows = this.mTmsHeader.getNumRows();
            int totRowBytes = this.mTmsHeader.getTotalRowBytes();
            int numEntries = numCols * numRows;
            float[] farray = new float[numEntries];
            ByteBuffer buffer = ByteBuffer.allocate(NUM_BYTES * numEntries);
            buffer.order(this.mTmsHeader.getByteOrder().equals(ByteOrder.BIG_ENDIAN) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            int numRead = this.mFileChannel.read(buffer);
            if (numRead < 0) {
                return null;
            }
            buffer.flip();
            for (int irow = 0; irow < numRows; ++irow) {
                for (int icol = 0; icol < numCols; ++icol) {
                    float dvalue;
                    int zz;
                    int idx = irow * numCols + icol;
                    int value = 0;
                    if (this.mTmsHeader.getByteOrder().equals(ByteOrder.BIG_ENDIAN)) {
                        for (zz = 0; zz < NUM_BYTES; ++zz) {
                            value <<= 8;
                            value |= buffer.get() & 0xFF;
                        }
                    } else {
                        for (zz = 0; zz < NUM_BYTES; ++zz) {
                            byte v = buffer.get();
                            value |= (v & 0xFF) << 8 * zz;
                        }
                    }
                    farray[idx] = (float)value == this.getNoDataValue() ? this.getNoDataValue() : (dvalue = tMin + (tMax - tMin) * (float)value / NUM_BITS_VALUE);
                }
            }
            return farray;
        }
        catch (IOException e) {
            System.out.println("getValues:error reading " + this.dataFilePath + " Error: " + e);
            return null;
        }
    }

    @Override
    public Image getImage(TmsGlyphDataRecord gdr) {
        if (this.weakIamgeRef == null || this.weakIamgeRef.get() == null || this.mPrevGdr != gdr) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Creating Image for WeakRef");
            this.initialize();
            int numRows = this.mTmsHeader.getNumRows();
            int numColumns = this.mTmsHeader.getNumColumns();
            float[] values = this.getValues();
            int[] pix = new int[values.length];
            double[] rgb3 = new double[3];
            double lafc = 1.0;
            double[] vec0 = new double[3];
            double[] vec1 = new double[3];
            double[] cross = new double[3];
            double mapResX = this.mTmsHeader.getXDimension();
            double mapResY = this.mTmsHeader.getYDimension();
            double aa = gdr.getAspectAngle();
            double theta = -Math.PI / 180 * (aa - 90.0);
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            double sinPhi = 0.5;
            double aaMag = Math.sqrt(cosTheta * cosTheta + sinTheta * sinTheta + sinPhi * sinPhi);
            cosTheta /= aaMag;
            sinTheta /= aaMag;
            sinPhi /= aaMag;
            ColorContour cc = gdr.getColorContour();
            boolean aspectShadingOn = gdr.getAspectEnabled();
            for (int i = 0; i < values.length; ++i) {
                float val = values[i];
                if (val == this.getNoDataValue() || Float.isNaN(val)) {
                    pix[i] = 0;
                    continue;
                }
                if (aspectShadingOn) {
                    int is;
                    float eleS;
                    int ie;
                    float eleE;
                    int in = i - numColumns;
                    float eleN = in < 0 ? val : values[in];
                    if (eleN == this.getNoDataValue() || Float.isNaN(eleN)) {
                        eleN = val;
                    }
                    if ((eleE = (ie = i + 1) % numColumns == 0 ? val : values[ie]) == this.getNoDataValue() || Float.isNaN(eleE)) {
                        eleE = val;
                    }
                    if ((eleS = (is = i + numColumns) >= values.length ? val : values[is]) == this.getNoDataValue() || Float.isNaN(eleS)) {
                        eleS = val;
                    }
                    int iw = i - 1;
                    float eleW = i % numColumns == 0 ? val : values[iw];
                    if (eleW == this.getNoDataValue() || Float.isNaN(eleW)) {
                        eleW = val;
                    }
                    vec0[0] = 2.0 * mapResX;
                    vec0[1] = 0.0;
                    vec0[2] = (eleE - eleW) * 10.0f;
                    vec1[0] = 0.0;
                    vec1[1] = 2.0 * mapResY;
                    vec1[2] = (eleN - eleS) * 10.0f;
                    cross[0] = vec0[1] * vec1[2] - vec0[2] * vec1[1];
                    cross[1] = vec0[2] * vec1[0] - vec0[0] * vec1[2];
                    cross[2] = vec0[0] * vec1[1] - vec0[1] * vec1[0];
                    double nMag = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
                    double dot = 1.0;
                    if (nMag != 0.0) {
                        dot = (cosTheta * cross[0] + sinTheta * cross[1] + sinPhi * cross[2]) / nMag;
                    }
                    if (cross[2] < 0.0) {
                        dot *= -1.0;
                    }
                    lafc = (dot + 1.25) / 2.25;
                }
                pix[i] = cc.getRGB(rgb3, val, lafc);
            }
            if (this._tracker == null) {
                this._tracker = new MediaTracker(COMP);
            }
            Image img = null;
            MemoryImageSource mis = new MemoryImageSource(numColumns, numRows, pix, 0, numColumns);
            try {
                this._tracker.removeImage(img);
            }
            catch (Exception e) {
                System.out.println("Error removing image from tracker.  " + e);
            }
            img = Toolkit.getDefaultToolkit().createImage(mis);
            this.weakIamgeRef = new SoftReference<Image>(img);
            this._tracker.addImage(img, 0);
            try {
                this._tracker.waitForAll();
            }
            catch (InterruptedException e) {
                System.out.println("Error waiting for image from tracker.  " + e);
            }
            this._tracker.removeImage(img);
            this.mPrevGdr = gdr;
        }
        return this.weakIamgeRef.get();
    }

    @Override
    public float getMinValue() {
        return this.mTmsHeader.getMinValue();
    }

    @Override
    public float getMaxValue() {
        return this.mTmsHeader.getMaxValue();
    }

    @Override
    public double getUpperLeftX() {
        return this.mTmsHeader.getUpperLeftX();
    }

    @Override
    public double getUpperLeftY() {
        return this.mTmsHeader.getUpperLeftY();
    }

    @Override
    public WorldRect getExtents() {
        this.initialize();
        if (this.mTmsHeader != null) {
            return this.mTmsHeader.getExtents();
        }
        return null;
    }

    public static interface TmsTileDataProvider {
        public InputStream getInputStream();
    }
}

