/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms.datasource.tile.flt;

import hec.map.WorldRect;
import hec.map.tms.TmsGlyphDataRecord;
import hec.map.tms.datasource.FileSystem;
import hec.map.tms.datasource.Tile;
import hec.map.tms.datasource.tile.flt.FltTileHeader;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import rma.util.ColorContour;

public class FltTile
implements Tile {
    static JLabel COMP = new JLabel();
    FileSystem mDataProvider = null;
    private FileChannel mFileChannel = null;
    private SoftReference<Image> weakIamgeRef = null;
    private FltTileHeader mTmsHeader = null;
    private String dataFilePath = null;
    private String headerFilePath = null;
    private boolean initialzied = false;
    private MediaTracker _tracker;
    TmsGlyphDataRecord mPrevGdr = null;

    FltTile(String path, FileSystem dataProvider) {
        this.mDataProvider = dataProvider;
        String name = this.dataFilePath = path;
        String name2 = name.toLowerCase();
        int idx = name2.indexOf(".flt");
        this.headerFilePath = idx >= 0 ? name.substring(0, idx) + ".hdr" : this.dataFilePath + ".hdr";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.initialzied) {
            return;
        }
        if (!this.mDataProvider.exists(this.headerFilePath)) {
            throw new RuntimeException("Missing HDR file: " + this.headerFilePath);
        }
        FileChannel headerFileChannel = this.mDataProvider.getFileChannel(this.headerFilePath);
        InputStream newInputStream = Channels.newInputStream(headerFileChannel);
        this.mTmsHeader = new FltTileHeader();
        try {
            this.mTmsHeader.read(newInputStream);
        }
        catch (IOException ex) {
            Logger.getLogger(FltTile.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            try {
                newInputStream.close();
                headerFileChannel.close();
            }
            catch (IOException ex) {
                Logger.getLogger(FltTile.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
        this.mFileChannel = this.mDataProvider.getFileChannel(this.dataFilePath);
        this.initialzied = true;
    }

    public void closeDataStream() {
        if (this.mFileChannel != null) {
            try {
                this.mFileChannel.close();
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            this.mTmsHeader = null;
            this.initialzied = false;
            this.mFileChannel = null;
        }
    }

    @Override
    public float[] getValues() {
        Object in = null;
        try {
            this.initialize();
            this.mFileChannel.position(0L);
            int numRows = this.mTmsHeader.getNumberRows();
            int numColumns = this.mTmsHeader.getNumberColumns();
            ByteBuffer buffer = ByteBuffer.allocate(32 * numColumns * numRows);
            buffer.order(this.mTmsHeader.getByteOrder().equals(ByteOrder.BIG_ENDIAN) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            int numRead = this.mFileChannel.read(buffer);
            buffer.flip();
            FloatBuffer fbuf = buffer.asFloatBuffer();
            float[] farray = new float[numColumns * numRows];
            fbuf.get(farray);
            return farray;
        }
        catch (Exception e) {
            System.out.println("getValues:error reading " + this.dataFilePath + " Error: " + e);
            return null;
        }
    }

    @Override
    public Image getImage(TmsGlyphDataRecord gdr) {
        if (this.weakIamgeRef == null || this.weakIamgeRef.get() == null || this.mPrevGdr != gdr) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Creating Image for WeakRef");
            this.initialize();
            int numRows = this.mTmsHeader.getNumberRows();
            int numColumns = this.mTmsHeader.getNumberColumns();
            float[] values = this.getValues();
            int[] pix = new int[values.length];
            double[] rgb3 = new double[3];
            double lafc = 1.0;
            double[] vec0 = new double[3];
            double[] vec1 = new double[3];
            double[] cross = new double[3];
            double mapResX = this.mTmsHeader.getCellSize();
            double mapResY = this.mTmsHeader.getCellSize();
            double aa = gdr.getAspectAngle();
            double theta = -Math.PI / 180 * (aa - 90.0);
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            double sinPhi = 0.5;
            double aaMag = Math.sqrt(cosTheta * cosTheta + sinTheta * sinTheta + sinPhi * sinPhi);
            cosTheta /= aaMag;
            sinTheta /= aaMag;
            sinPhi /= aaMag;
            ColorContour cc = gdr.getColorContour();
            boolean aspectShadingOn = gdr.getAspectEnabled();
            for (int i = 0; i < values.length; ++i) {
                float val = values[i];
                if (val == this.getNoDataValue() || Float.isNaN(val)) {
                    pix[i] = 0;
                    continue;
                }
                if (aspectShadingOn) {
                    int is;
                    float eleS;
                    int ie;
                    float eleE;
                    int in = i - this.mTmsHeader._numcol;
                    float eleN = in < 0 ? val : values[in];
                    if (eleN == this.getNoDataValue() || Float.isNaN(eleN)) {
                        eleN = val;
                    }
                    if ((eleE = (ie = i + 1) % this.mTmsHeader._numcol == 0 ? val : values[ie]) == this.getNoDataValue() || Float.isNaN(eleE)) {
                        eleE = val;
                    }
                    if ((eleS = (is = i + this.mTmsHeader._numcol) >= values.length ? val : values[is]) == this.getNoDataValue() || Float.isNaN(eleS)) {
                        eleS = val;
                    }
                    int iw = i - 1;
                    float eleW = i % this.mTmsHeader._numcol == 0 ? val : values[iw];
                    if (eleW == this.getNoDataValue() || Float.isNaN(eleW)) {
                        eleW = val;
                    }
                    vec0[0] = 2.0 * mapResX;
                    vec0[1] = 0.0;
                    vec0[2] = (eleE - eleW) * 10.0f;
                    vec1[0] = 0.0;
                    vec1[1] = 2.0 * mapResY;
                    vec1[2] = (eleN - eleS) * 10.0f;
                    cross[0] = vec0[1] * vec1[2] - vec0[2] * vec1[1];
                    cross[1] = vec0[2] * vec1[0] - vec0[0] * vec1[2];
                    cross[2] = vec0[0] * vec1[1] - vec0[1] * vec1[0];
                    double nMag = Math.sqrt(cross[0] * cross[0] + cross[1] * cross[1] + cross[2] * cross[2]);
                    double dot = 1.0;
                    if (nMag != 0.0) {
                        dot = (cosTheta * cross[0] + sinTheta * cross[1] + sinPhi * cross[2]) / nMag;
                    }
                    if (cross[2] < 0.0) {
                        dot *= -1.0;
                    }
                    lafc = (dot + 1.25) / 2.25;
                }
                pix[i] = cc.getRGB(rgb3, val, lafc);
            }
            if (this._tracker == null) {
                this._tracker = new MediaTracker(COMP);
            }
            Image img = null;
            MemoryImageSource mis = new MemoryImageSource(numColumns, numRows, pix, 0, numColumns);
            try {
                this._tracker.removeImage(img);
            }
            catch (Exception e) {
                System.out.println("Error removing image from tracker.  " + e);
            }
            img = Toolkit.getDefaultToolkit().createImage(mis);
            this.weakIamgeRef = new SoftReference<Image>(img);
            this._tracker.addImage(img, 0);
            try {
                this._tracker.waitForAll();
            }
            catch (Exception e) {
                System.out.println("Error waiting for image from tracker.  " + e);
            }
            this._tracker.removeImage(img);
            this.mPrevGdr = gdr;
        }
        return this.weakIamgeRef.get();
    }

    @Override
    public float[] getValues(double[] x, double[] y, int numPoints) {
        if (numPoints > x.length) {
            throw new IllegalArgumentException("Invalid Number of Points.  Number of points must be less than or equal to the size of the original point array");
        }
        this.initialize();
        Point2D.Double llcorner = new Point2D.Double(this.mTmsHeader.getLowerLeftX(), this.mTmsHeader.getLowerLeftY());
        int numRows = this.mTmsHeader.getNumberRows();
        int numColumns = this.mTmsHeader.getNumberColumns();
        double cellSize = this.mTmsHeader.getCellSize();
        int maxSize = (int)((double)(numColumns * numRows) * cellSize);
        Rectangle2D.Double extent = new Rectangle2D.Double(((Point2D)llcorner).getX(), ((Point2D)llcorner).getY(), cellSize * (double)numColumns, cellSize * (double)numRows);
        ByteBuffer buffer = ByteBuffer.allocate(maxSize * 32 / 8);
        float[] returnValues = new float[numPoints];
        Arrays.fill(returnValues, this.getNoDataValue());
        try {
            this.mFileChannel.position(0L);
            this.mFileChannel.read(buffer);
        }
        catch (IOException ex) {
            Logger.getLogger(FltTile.class.getName()).log(Level.SEVERE, null, ex);
            return returnValues;
        }
        buffer.order(this.mTmsHeader.getByteOrder().equals(ByteOrder.BIG_ENDIAN) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < returnValues.length; ++i) {
            if (!extent.contains(x[i], y[i])) {
                returnValues[i] = this.getNoDataValue();
                continue;
            }
            int icol = (int)((x[i] - ((Point2D)llcorner).getX()) / cellSize);
            int irow = (int)((double)numRows - (y[i] - ((Point2D)llcorner).getY()) / cellSize);
            int idx = irow * numColumns + icol;
            buffer.position(0);
            float value = buffer.getFloat(idx * 4);
            returnValues[i] = value != this.getNoDataValue() && !Float.isNaN(value) ? value : this.getNoDataValue();
        }
        return returnValues;
    }

    @Override
    public float getNoDataValue() {
        return this.mTmsHeader.getNoDataValue();
    }

    @Override
    public float getMinValue() {
        return this.mTmsHeader.getMinValue();
    }

    @Override
    public float getMaxValue() {
        return this.mTmsHeader.getMaxValue();
    }

    @Override
    public double getUpperLeftX() {
        return this.mTmsHeader.getLowerLeftX();
    }

    @Override
    public double getUpperLeftY() {
        return this.mTmsHeader.getLowerLeftY() + (double)this.mTmsHeader.getNumberRows() * this.mTmsHeader.getCellSize();
    }

    @Override
    public WorldRect getExtents() {
        this.initialize();
        if (this.mTmsHeader != null) {
            return this.mTmsHeader.getExtents();
        }
        return null;
    }

    @Override
    public void close() {
        this.closeDataStream();
    }
}

