/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms.datasource.tile.flt;

import hec.map.WorldRect;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import rma.util.RMAIO;

public class FltTileHeader {
    ByteOrder _byteOrder = ByteOrder.nativeOrder();
    protected double _cellsize = 1.0;
    protected float[] _data;
    protected float _maxElev = Float.MIN_VALUE;
    protected float _minElev = Float.MAX_VALUE;
    protected float _nodata = -9999.0f;
    protected int _numcol = 0;
    protected int _numrow = 0;
    private WorldRect _extent;
    protected Point2D _lowerLeftCorner;

    public double getLowerLeftX() {
        return this._lowerLeftCorner.getX();
    }

    public double getLowerLeftY() {
        return this._lowerLeftCorner.getY();
    }

    public float getMaxValue() {
        return this._maxElev;
    }

    public float getMinValue() {
        return this._minElev;
    }

    public void read(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        double x = 0.0;
        double y = 0.0;
        while ((line = reader.readLine()) != null) {
            String[] split;
            if (line.isEmpty() || (split = line.split(" ", 2)) == null || split.length < 2) continue;
            split[0] = split[0].trim();
            split[1] = split[1].trim();
            if ("ncols".equalsIgnoreCase(split[0])) {
                this._numcol = RMAIO.parseInt(split[1]);
                continue;
            }
            if ("nrows".equalsIgnoreCase(split[0])) {
                this._numrow = RMAIO.parseInt(split[1]);
                continue;
            }
            if ("cellsize".equalsIgnoreCase(split[0])) {
                this._cellsize = RMAIO.parseDouble(split[1]);
                continue;
            }
            if ("xllcorner".equalsIgnoreCase(split[0])) {
                x = RMAIO.parseDouble(split[1]);
                continue;
            }
            if ("yllcorner".equalsIgnoreCase(split[0])) {
                y = RMAIO.parseDouble(split[1]);
                continue;
            }
            if ("NODATA_value".equalsIgnoreCase(split[0])) {
                this._nodata = RMAIO.parseFloat(split[1]);
                continue;
            }
            if (!"byteorder".equalsIgnoreCase(split[0])) continue;
            if ("LSBFIRST".equalsIgnoreCase(split[1])) {
                this._byteOrder = ByteOrder.LITTLE_ENDIAN;
                continue;
            }
            this._byteOrder = ByteOrder.BIG_ENDIAN;
        }
        this._extent = new WorldRect(x, y, x + this._cellsize * (double)this._numcol, y + this._cellsize * (double)this._numrow);
        this._lowerLeftCorner = new Point2D.Double(x, y);
    }

    public WorldRect getExtents() {
        return this._extent;
    }

    public float getNoDataValue() {
        return this._nodata;
    }

    public int getNumberColumns() {
        return this._numcol;
    }

    public int getNumberRows() {
        return this._numrow;
    }

    public double getCellSize() {
        return this._cellsize;
    }

    public ByteOrder getByteOrder() {
        return this._byteOrder;
    }
}

