/*
 * Decompiled with CFR 0.152.
 */
package hec.map.tms.io.spi;

import hec.map.tms.io.TmsConversion;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.services.annotations.ServiceProvider;
import rma.util.RMAIO;

@ServiceProvider(service=TmsConversion.class, position=100)
public class TmsConversionSpi
extends TmsConversion {
    String convertTmsFltExePath = null;
    public static final Logger LOGGER = Logger.getLogger(TmsConversionSpi.class.getName());

    private void installConversionFiles() {
        Object h5assistPath;
        Object rasMapperPath;
        Object iconZipDllPath;
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        tempDir = (String)tempDir + "tms" + File.separator;
        new File((String)tempDir).deleteOnExit();
        this.convertTmsFltExePath = (String)tempDir + "ConvertTMSFLT.exe";
        if (!new File(this.convertTmsFltExePath).exists()) {
            String convertTmsFltExeRsrc = "hec/map/tms/io/spi/ConvertTMSFLT.exe";
            this.convertTmsFltExePath = RMAIO.copyFileFromResourcesToDirectory(convertTmsFltExeRsrc, (String)tempDir);
            File f = new File(this.convertTmsFltExePath);
            f.deleteOnExit();
        }
        if (!new File((String)(iconZipDllPath = (String)tempDir + "Ionic.Zip.dll")).exists()) {
            String iconZipDllRsrc = "hec/map/tms/io/spi/Ionic.Zip.dll";
            iconZipDllPath = RMAIO.copyFileFromResourcesToDirectory(iconZipDllRsrc, (String)tempDir);
            File f = new File((String)iconZipDllPath);
            f.deleteOnExit();
        }
        if (!new File((String)(rasMapperPath = (String)tempDir + "RasMapperLib.dll")).exists()) {
            String rasMapperRsrc = "hec/map/tms/io/spi/RasMapperLib.dll";
            rasMapperPath = RMAIO.copyFileFromResourcesToDirectory(rasMapperRsrc, (String)tempDir);
            File f = new File((String)rasMapperPath);
            f.deleteOnExit();
        }
        if (!new File((String)(h5assistPath = (String)tempDir + "H5Assist.dll")).exists()) {
            String h5assistPathRsrc = "hec/map/tms/io/spi/H5Assist.dll";
            h5assistPath = RMAIO.copyFileFromResourcesToDirectory(h5assistPathRsrc, (String)tempDir);
            File f = new File((String)h5assistPath);
            f.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File convertFile(String filePath) {
        this.installConversionFiles();
        try {
            Runtime rt = Runtime.getRuntime();
            MessageFormat mf = new MessageFormat("{0} /var \"{1}\" /units \"{2}\" /tol {3} /file \"{4}\" ");
            String cmdPath = mf.format(new String[]{this.convertTmsFltExePath, "variable", "units", ".01", filePath});
            File file = new File(filePath);
            LOGGER.log(Level.FINE, cmdPath);
            LOGGER.log(Level.FINE, "Working Dir = {0}", file.getParent());
            Process pr = rt.exec(cmdPath, null, file.getParentFile());
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = null;
            while ((line = input.readLine()) != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, line);
            }
            File file2 = new File(filePath);
            return file2;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    @Override
    public File convertToTms(File pathToFltFile) {
        String path = pathToFltFile.getAbsolutePath();
        File f = this.convertFile(path);
        f = new File(RMAIO.getPathNoExtension(f.getAbsolutePath()) + ".tms");
        return f;
    }

    @Override
    public File convertToFlt(File pathToTmsFile) {
        Object path = pathToTmsFile.getAbsolutePath();
        File f = this.convertFile((String)path);
        if (((String)(path = f.getAbsolutePath())).toUpperCase().endsWith(".TMS")) {
            path = ((String)path).substring(0, ((String)path).length() - 3) + "flt";
        }
        return new File((String)path);
    }
}

