/*
 * Decompiled with CFR 0.152.
 */
package hec.map.transform;

import hec.io.AsciiSerializable;
import hec.map.transform.AlbersLambertCoordinateInfo;
import hec.util.XMLUtilities;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jdom.Element;
import rma.util.RMAIO;

public class AlbersCoordinateInfo
extends AlbersLambertCoordinateInfo
implements Serializable,
AsciiSerializable {
    static final long serialVersionUID = -2188689126331589320L;
    private boolean _isShg = false;

    public AlbersCoordinateInfo() {
        this._type = "Albers Equal-Area Conic";
    }

    public AlbersCoordinateInfo(String units, String spheroid) {
        super(units, spheroid);
        this._type = "Albers Equal-Area Conic";
    }

    public AlbersCoordinateInfo(String units, String spheroid, double sMajorAxis, double sMinorAxis, double latStdPar1, double latStdPar2, double longCentMer, double originLat, double fe, double fn) {
        this(units, spheroid);
        this._sMajorAxis = sMajorAxis;
        this._sMinorAxis = sMinorAxis;
        this._latStdPar1 = latStdPar1;
        this._latStdPar2 = latStdPar2;
        this._longCentMer = longCentMer;
        this._originLat = originLat;
        this._fe = fe;
        this._fn = fn;
    }

    @Override
    public String getWKT() {
        return "PROJCS[\"" + this.getType() + "\", GEOGCS[\"" + this.getSpheroid() + "\",DATUM[\"" + this.getSpheroid() + "\",SPHEROID[\"" + this.getSpheroid() + "\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\"," + this.getFalseEasting() + "],PARAMETER[\"False_Northing\"," + this.getFalseNorthing() + "],PARAMETER[\"Central_Meridian\"," + this.getLongCentMer() + "],PARAMETER[\"Standard_Parallel_1\"," + this.getLatStdPar1() + "],PARAMETER[\"Standard_Parallel_2\"," + this.getLatStdPar2() + "],PARAMETER[\"Latitude_Of_Origin\"," + this.getOriginLat() + "],UNIT[\"" + this.getUnits() + "\"," + (this.getUnits().toLowerCase().equals("Meters") ? "1" : Double.toString(0.3048006096012192)) + "]]";
    }

    @Override
    public String getType() {
        return "Albers Equal-Area Conic";
    }

    public static AlbersCoordinateInfo getSHGCoordinateInfo() {
        AlbersCoordinateInfo aci = new AlbersCoordinateInfo("Meters", "GRS 1980(NAD83)", 0.0, 0.0, 2.903E7, 4.503E7, -9.6E7, 2.3E7, 0.0, 0.0);
        aci._isShg = true;
        return aci;
    }

    public boolean isShg() {
        return this._isShg;
    }

    @Override
    protected void writeObject2(BufferedWriter writer) throws IOException {
        if (writer == null) {
            return;
        }
        super.writeObject2(writer);
        RMAIO.fout(writer, "isShg=" + this._isShg);
    }

    @Override
    protected void parseType(String type, String param) {
        if ("isShg".equals(type)) {
            this._isShg = "true".equalsIgnoreCase(param);
        } else {
            super.parseType(type, param);
        }
    }

    @Override
    public boolean loadData(Element cinfoElem) {
        boolean retval = super.loadData(cinfoElem);
        this._isShg = XMLUtilities.getAttributeValueAsBoolean(cinfoElem, "isShg", false);
        return true;
    }

    @Override
    public boolean saveData(Element cinfoElem) {
        boolean retval = super.saveData(cinfoElem);
        cinfoElem.setAttribute("isShg", String.valueOf(this._isShg));
        return true;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

