/*
 * Decompiled with CFR 0.152.
 */
package hec.map.transform;

import hec.io.AsciiSerializable;
import hec.map.transform.CoordinateInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jdom.Element;
import rma.util.RMAIO;

public abstract class AlbersLambertCoordinateInfo
extends CoordinateInfo
implements Serializable,
AsciiSerializable {
    static final long serialVersionUID = 9099405708256007277L;
    protected double _sMajorAxis;
    protected double _sMinorAxis;
    protected double _latStdPar1;
    protected double _latStdPar2;
    protected double _longCentMer;
    protected double _originLat;
    protected double _fe;
    protected double _fn;

    public AlbersLambertCoordinateInfo() {
    }

    public AlbersLambertCoordinateInfo(String units, String spheroid) {
        super(units, spheroid);
    }

    public AlbersLambertCoordinateInfo(String units, String spheroid, double sMajorAxis, double sMinorAxis, double latStdPar1, double latStdPar2, double longCentMer, double originLat, double fe, double fn) {
        this(units, spheroid);
        this._sMajorAxis = sMajorAxis;
        this._sMinorAxis = sMinorAxis;
        this._latStdPar1 = latStdPar1;
        this._latStdPar2 = latStdPar2;
        this._longCentMer = longCentMer;
        this._originLat = originLat;
        this._fe = fe;
        this._fn = fn;
    }

    public void setMajorAxis(double sMajorAxis) {
        this._sMajorAxis = sMajorAxis;
    }

    public void setMinorAxis(double sMinorAxis) {
        this._sMinorAxis = sMinorAxis;
    }

    public void setLatStdPar1(double latStdPar1) {
        this._latStdPar1 = latStdPar1;
    }

    public void setLatStdPar2(double latStdPar2) {
        this._latStdPar2 = latStdPar2;
    }

    public void setLongCentMer(double longCentMer) {
        this._longCentMer = longCentMer;
    }

    public void setOriginLat(double originLat) {
        this._originLat = originLat;
    }

    public void setFalseNorthing(double fn) {
        this._fn = fn;
    }

    public void setFalseEasting(double fe) {
        this._fe = fe;
    }

    public double getMajorAxis() {
        return this._sMajorAxis;
    }

    public double getMinorAxis() {
        return this._sMinorAxis;
    }

    public double getLatStdPar1() {
        return this._latStdPar1;
    }

    public double getLatStdPar2() {
        return this._latStdPar2;
    }

    public double getLongCentMer() {
        return this._longCentMer;
    }

    public double getOriginLat() {
        return this._originLat;
    }

    public double getFalseNorthing() {
        return this._fn;
    }

    public double getFalseEasting() {
        return this._fe;
    }

    @Override
    protected void writeObject2(BufferedWriter writer) throws IOException {
        if (writer == null) {
            return;
        }
        RMAIO.fout(writer, "minorAxis=" + this._sMinorAxis);
        RMAIO.fout(writer, "majorAxis=" + this._sMajorAxis);
        RMAIO.fout(writer, "latStdPar1=" + this._latStdPar1);
        RMAIO.fout(writer, "latStdPar2=" + this._latStdPar2);
        RMAIO.fout(writer, "longCentMer=" + this._longCentMer);
        RMAIO.fout(writer, "originLat=" + this._originLat);
        RMAIO.fout(writer, "falseEasting=" + this._fe);
        RMAIO.fout(writer, "falseNorthing=" + this._fn);
    }

    @Override
    protected void readObject2(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return;
        }
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("CoordinateInfoEnd") > -1) {
                return;
            }
            String type = RMAIO.getType(line, "=");
            String param = RMAIO.getParam(line, "=");
            this.parseType(type, param);
        }
    }

    protected void parseType(String type, String param) {
        if (type.equals("minorAxis")) {
            this._sMinorAxis = RMAIO.parseDouble(param, 0.0);
        } else if (type.equals("minorAxis")) {
            this._sMajorAxis = RMAIO.parseDouble(param, 0.0);
        } else if (type.equals("majorAxis")) {
            this._sMajorAxis = RMAIO.parseDouble(param, 0.0);
        } else if (type.equals("latStdPar1")) {
            this._latStdPar1 = RMAIO.parseDouble(param, 0.0);
        } else if (type.equals("latStdPar2")) {
            this._latStdPar2 = RMAIO.parseDouble(param, 0.0);
        } else if (type.equals("longCentMer")) {
            this._longCentMer = RMAIO.parseDouble(param, 0.0);
        } else if (type.equals("originLat")) {
            this._originLat = RMAIO.parseDouble(param, 0.0);
        } else if (type.equals("falseEasting")) {
            this._fe = RMAIO.parseDouble(param, 0.0);
        } else if (type.equals("falseNorthing")) {
            this._fn = RMAIO.parseDouble(param, 0.0);
        }
    }

    @Override
    public boolean saveData(Element cinfoElem) {
        boolean retval = super.saveData(cinfoElem);
        cinfoElem.setAttribute("minorAxis", String.valueOf(this._sMinorAxis));
        cinfoElem.setAttribute("majorAxis", String.valueOf(this._sMajorAxis));
        cinfoElem.setAttribute("latStdPar1", String.valueOf(this._latStdPar1));
        cinfoElem.setAttribute("latStdPar2", String.valueOf(this._latStdPar2));
        cinfoElem.setAttribute("longCentMer", String.valueOf(this._longCentMer));
        cinfoElem.setAttribute("originLat", String.valueOf(this._originLat));
        cinfoElem.setAttribute("falseEasting", String.valueOf(this._fe));
        cinfoElem.setAttribute("falseNorthing", String.valueOf(this._fn));
        return true;
    }

    @Override
    public boolean loadData(Element cinfoElem) {
        boolean retval = super.loadData(cinfoElem);
        this._sMinorAxis = RMAIO.parseDouble(cinfoElem.getAttributeValue("minorAxis"));
        this._sMajorAxis = RMAIO.parseDouble(cinfoElem.getAttributeValue("majorAxis"));
        this._latStdPar1 = RMAIO.parseDouble(cinfoElem.getAttributeValue("latStdPar1"));
        this._latStdPar2 = RMAIO.parseDouble(cinfoElem.getAttributeValue("latStdPar2"));
        this._originLat = RMAIO.parseDouble(cinfoElem.getAttributeValue("originLat"));
        this._longCentMer = RMAIO.parseDouble(cinfoElem.getAttributeValue("longCentMer"));
        this._fe = RMAIO.parseDouble(cinfoElem.getAttributeValue("falseEasting"));
        this._fn = RMAIO.parseDouble(cinfoElem.getAttributeValue("falseNorthing"));
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AlbersLambertCoordinateInfo)) {
            return false;
        }
        if (super.equals(obj)) {
            AlbersLambertCoordinateInfo alci = (AlbersLambertCoordinateInfo)obj;
            if (!alci.getType().equals(this.getType())) {
                return false;
            }
            if (this._sMajorAxis == alci._sMajorAxis && this._sMinorAxis == alci._sMinorAxis && this._latStdPar1 == alci._latStdPar1 && this._latStdPar2 == alci._latStdPar2 && this._longCentMer == alci._longCentMer && this._originLat == alci._originLat && this._fe == alci._fe && this._fn == alci._fn) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

