/*
 * Decompiled with CFR 0.152.
 */
package hec.map.transform;

import hec.io.AsciiSerializable;
import hec.map.transform.CoordinateTransformConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Hashtable;
import org.jdom.Element;
import rma.util.RMAIO;

public abstract class CoordinateInfo
implements Serializable,
AsciiSerializable,
CoordinateTransformConstants {
    static final long serialVersionUID = -3120331063847981541L;
    protected String _type;
    protected String _units;
    protected double _unitMultiplier = 1.0;
    protected String _spheroid;
    public static final String COORDINATEINFO_BEGIN = "CoordinateInfoBegin";
    public static final String COORDINATEINFO_END = "CoordinateInfoEnd";
    protected static final Class[] INT_CLASS_ARGS = new Class[0];
    protected static Hashtable _mapCoordinateInfo = new Hashtable();

    public CoordinateInfo() {
    }

    public CoordinateInfo(String units, String spheroid) {
        this._units = units;
        this._spheroid = spheroid;
    }

    public void setUnits(String units) {
        this._units = units;
    }

    public void setUnitMultiplier(double m) {
        if (m > 0.0) {
            this._unitMultiplier = m;
        }
    }

    public void setSpheroid(String spheroid) {
        this._spheroid = spheroid;
    }

    public abstract String getType();

    public String getUnits() {
        return this._units;
    }

    public double getUnitMultiplier() {
        if (this._unitMultiplier <= 0.0) {
            this._unitMultiplier = 1.0;
        }
        return this._unitMultiplier;
    }

    public String getWKT() {
        return "";
    }

    public double getLengthConvFactor(int unitSystemId) {
        double fac = this.getUnitMultiplier();
        String lu = this._units.toLowerCase();
        if (lu.indexOf("feet") >= 0 && unitSystemId != 1) {
            fac *= 0.3048;
        } else if (lu.indexOf("meter") >= 0 && unitSystemId == 1) {
            fac /= 0.3048;
        }
        return fac;
    }

    public String getSpheroid() {
        return this._spheroid;
    }

    public void set(String units, String spheroid) {
        this._units = units;
        this._spheroid = spheroid;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CoordinateInfo)) {
            return false;
        }
        CoordinateInfo ci = (CoordinateInfo)obj;
        return !(this.getType() != ci.getType() && !this.getType().equals(ci.getType()) || this._units != ci._units && !this._units.equals(ci._units) || this._spheroid != ci._spheroid && !this._spheroid.equals(ci._spheroid));
    }

    public void writeObject(BufferedWriter writer) throws IOException {
        if (writer == null) {
            return;
        }
        writer.newLine();
        RMAIO.fout(writer, COORDINATEINFO_BEGIN);
        RMAIO.fout(writer, "type=" + this.getType());
        RMAIO.fout(writer, "units=" + this._units);
        RMAIO.fout(writer, "unitMult=" + this._unitMultiplier);
        RMAIO.fout(writer, "spheroid=" + this._spheroid);
        this.writeObject2(writer);
        RMAIO.fout(writer, COORDINATEINFO_END);
        writer.newLine();
    }

    protected abstract void writeObject2(BufferedWriter var1) throws IOException;

    public static CoordinateInfo readObject(BufferedReader reader) throws IOException {
        String line;
        CoordinateInfo ci = null;
        if (reader == null) {
            return null;
        }
        int baseInfo = 0;
        while (baseInfo < 6 && (line = reader.readLine()) != null) {
            if (line.indexOf(COORDINATEINFO_END) > -1) {
                return ci;
            }
            String type = RMAIO.getType(line, "=");
            String param = RMAIO.getParam(line, "=");
            if (type.equals("type")) {
                String infoClassName = (String)_mapCoordinateInfo.get(param);
                if (infoClassName == null) {
                    System.err.println("CoordinateInfo.readObject: unknown coordinateType " + param);
                    return null;
                }
                Class<?> infoClass = null;
                try {
                    infoClass = Class.forName(infoClassName);
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Coordinate Info Class " + infoClassName + " was not found");
                    return null;
                }
                try {
                    ci = (CoordinateInfo)infoClass.newInstance();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    System.err.println("Coordinate Info Class " + infoClassName + " was not instantiated");
                    return null;
                }
                baseInfo |= 1;
                continue;
            }
            if (type.equals("units")) {
                if (ci != null) {
                    ci.setUnits(param);
                }
                baseInfo |= 2;
                continue;
            }
            if (type.equals("unitMult")) {
                if (ci == null) continue;
                ci.setUnitMultiplier(Double.parseDouble(param));
                continue;
            }
            if (!type.equals("spheroid")) continue;
            if (ci != null) {
                ci.setSpheroid(param);
            }
            baseInfo |= 4;
        }
        ci.readObject2(reader);
        return ci;
    }

    public void setType(String type) {
        this._type = type;
    }

    protected abstract void readObject2(BufferedReader var1) throws IOException;

    public boolean saveData(Element cinfoElem) {
        cinfoElem.setAttribute("type", this.getType());
        if (this._units != null) {
            cinfoElem.setAttribute("units", this._units);
        }
        cinfoElem.setAttribute("unitMult", String.valueOf(this._unitMultiplier));
        if (this._spheroid != null) {
            cinfoElem.setAttribute("spheroid", this._spheroid);
        }
        return true;
    }

    public boolean loadData(Element cinfoElem) {
        if (cinfoElem == null) {
            return false;
        }
        String typ = cinfoElem.getAttributeValue("type");
        if (!typ.equals(this.getType())) {
            // empty if block
        }
        this._units = cinfoElem.getAttributeValue("units");
        this._unitMultiplier = RMAIO.parseDouble(cinfoElem.getAttributeValue("unitMult"), 1.0);
        this._spheroid = cinfoElem.getAttributeValue("spheroid");
        return true;
    }

    public String toString() {
        return this.getType();
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static {
        _mapCoordinateInfo.put("Universal Transverse Mercator", "hec.map.transform.UTMCoordinateInfo");
        _mapCoordinateInfo.put("Geographic", "hec.map.transform.GeographicCoordinateInfo");
        _mapCoordinateInfo.put("State Plane Coordinates", "hec.map.transform.StatePlaneCoordinateInfo");
        _mapCoordinateInfo.put("Albers Equal-Area Conic", "hec.map.transform.AlbersCoordinateInfo");
        _mapCoordinateInfo.put("Lambert Conformal Conic", "hec.map.transform.LambertCoordinateInfo");
        _mapCoordinateInfo.put("Transverse Mercator", "hec.map.transform.TransverseMercatorCoordinateInfo");
        _mapCoordinateInfo.put("X-Y", "hec.map.transform.XYCoordinateInfo");
        _mapCoordinateInfo.put("Polar Stereographic (HRAP)", "hec.map.transform.PolarStereographicCoordinateInfo");
        _mapCoordinateInfo.put("Albers Equal-Area Conic (SHG)", "hec.map.transform.AlbersCoordinateInfo");
    }
}

