/*
 * Decompiled with CFR 0.152.
 */
package hec.map.transform;

import hec.map.transform.AlbersCoordinateInfo;
import hec.map.transform.AlbersLambertCoordinateInfo;
import hec.map.transform.CoordinateInfo;
import hec.map.transform.CoordinateTransformConstants;
import hec.map.transform.GeographicCoordinateInfo;
import hec.map.transform.LambertCoordinateInfo;
import hec.map.transform.StatePlaneCoordinateInfo;
import hec.map.transform.TransverseMercatorCoordinateInfo;
import hec.map.transform.UTMCoordinateInfo;
import hec.map.transform.XYCoordinateInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ServiceLoader;
import java.util.StringTokenizer;

public abstract class CoordinateInfoFactory {
    private CoordinateInfoFactory() {
    }

    public static CoordinateInfoFactory getDefault() {
        CoordinateInfoFactory cif2 = null;
        ServiceLoader<CoordinateInfoFactory> sl = ServiceLoader.load(CoordinateInfoFactory.class);
        for (CoordinateInfoFactory cif2 : sl) {
            if (cif2 != null) break;
        }
        if (cif2 == null) {
            cif2 = new CoordinateInfoFactoryImpl();
        }
        return cif2;
    }

    public abstract CoordinateInfo createCoordinateInfo(Reader var1) throws IOException;

    public static void main(String[] args) {
        CoordinateInfoFactory.test(-75.75);
        CoordinateInfoFactory.test(75.75);
        CoordinateInfoFactory.test(-75.5);
        CoordinateInfoFactory.test(75.5);
        CoordinateInfoFactory.test(75.8);
    }

    public static void test(double startingValue) {
        System.out.println("SV :" + startingValue);
        double dms = new CoordinateInfoFactoryImpl().toInternalDecimalDegrees(startingValue);
        System.out.println("DMS: " + dms);
        System.out.println("DEG: " + CoordinateInfoFactory.dmsToDegrees(dms));
        System.out.println("");
    }

    private static double dmsToDegrees(double dfPacked) {
        double dfSign = dfPacked < 0.0 ? -1.0 : 1.0;
        double dfSeconds = Math.abs(dfPacked);
        double dfDegrees = Math.floor(dfSeconds / 1000000.0);
        double dfMinutes = Math.floor((dfSeconds -= dfDegrees * 1000000.0) / 1000.0);
        dfSeconds -= dfMinutes * 1000.0;
        dfSeconds = dfSign * (dfDegrees * 3600.0 + dfMinutes * 60.0 + dfSeconds);
        dfDegrees = dfSeconds / 3600.0;
        return dfDegrees;
    }

    private static class CoordinateInfoFactoryImpl
    extends CoordinateInfoFactory {
        private double degrees = 0.0;
        CoordinateInfo _coordInfo;

        @Override
        public CoordinateInfo createCoordinateInfo(Reader reader) throws IOException {
            StringBuilder builder = new StringBuilder();
            try {
                String line;
                BufferedReader buffReader = new BufferedReader(reader);
                while ((line = buffReader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    line = line.replace("\n", "").trim();
                    builder.append(line);
                }
                reader.close();
                line = builder.toString().toUpperCase();
                StringTokenizer otherLine = new StringTokenizer(line, "]]");
                String word = otherLine.nextToken();
                if (!line.contains("PROJECTION")) {
                    this._coordInfo = new GeographicCoordinateInfo();
                    this._coordInfo.setType("Geographic");
                    this.setSpheroidData(line);
                    this.setUnitsForSpheroidData(line);
                }
                if (line.startsWith("PROJCS[")) {
                    StringTokenizer projectsLine = new StringTokenizer(word, "\"");
                    String nextWord = projectsLine.nextToken();
                    nextWord = projectsLine.nextToken();
                    if (nextWord.contains("STATEPLANE") && nextWord.contains("_")) {
                        String zone;
                        this._coordInfo = new StatePlaneCoordinateInfo();
                        this._coordInfo.setType("State Plane Coordinates");
                        if (nextWord.endsWith("INT")) {
                            zone = nextWord.substring(nextWord.length() - 13, nextWord.length() - 9);
                            this._coordInfo.setUnits(CoordinateInfo.UNITS[5]);
                        } else if (nextWord.endsWith("FEET")) {
                            zone = nextWord.substring(nextWord.length() - 9, nextWord.length() - 5);
                            this._coordInfo.setUnits(CoordinateInfo.UNITS[1]);
                        } else {
                            zone = nextWord.substring(nextWord.length() - 4, nextWord.length());
                            this.setUnits(line);
                        }
                        ((StatePlaneCoordinateInfo)this._coordInfo).setStatePlaneZone(Long.parseLong(zone));
                        this.setSpheroidData(word);
                    } else if (nextWord.contains("UTM")) {
                        this._coordInfo = new UTMCoordinateInfo();
                        this._coordInfo.setType("Universal Transverse Mercator");
                        if (nextWord.lastIndexOf("_") != -1) {
                            String zone = nextWord.substring(nextWord.lastIndexOf("_"), nextWord.length() - 1);
                            zone = zone.replace("_", "0");
                            ((UTMCoordinateInfo)this._coordInfo).setUTMZone(Long.parseLong(zone));
                        } else {
                            this.setProjectionData(line);
                        }
                        this.setUnits(line);
                        this.setSpheroidData(word);
                    } else {
                        this.setProjectionData(line);
                        this.setSpheroidData(line);
                        this.setUnits(line);
                    }
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            return this._coordInfo;
        }

        private void setSpheroidData(String line) {
            if (line.contains("SPHEROID[")) {
                String speriodType = line.substring(line.indexOf("SPHEROID["));
                if (speriodType.contains("CLARKE_1866") || speriodType.contains("CLARKE 1866")) {
                    this._coordInfo.setSpheroid("Clarke 1866(NAD27)");
                } else if (speriodType.contains("WGS_1984") || speriodType.contains("WGS 1984") || speriodType.contains("WGS 84")) {
                    this._coordInfo.setSpheroid(CoordinateTransformConstants.SPHERIODS[3]);
                } else if (speriodType.contains("GRS_1980") || speriodType.contains("GRS 1980")) {
                    this._coordInfo.setSpheroid(CoordinateTransformConstants.SPHERIODS[2]);
                } else if (speriodType.contains("WGS_1972") || speriodType.contains("WGS 1972")) {
                    this._coordInfo.setSpheroid(CoordinateTransformConstants.SPHERIODS[1]);
                } else if (speriodType.contains("SPHERE")) {
                    this._coordInfo.setSpheroid(CoordinateTransformConstants.SPHERIODS[4]);
                }
            }
        }

        private void setUnits(String word) {
            String UNIT_KEY = "UNIT[";
            if (word.contains(UNIT_KEY)) {
                String word1 = word.substring(word.lastIndexOf("UNIT[") + UNIT_KEY.length(), word.length() - 1);
                if (word1.startsWith("\"FOOT")) {
                    this._coordInfo.setUnits(CoordinateInfo.UNITS[1]);
                } else if (word1.startsWith("\"METER") || word1.startsWith("\"METRE")) {
                    this._coordInfo.setUnits(CoordinateInfo.UNITS[2]);
                } else if (word1.startsWith("\"INTER")) {
                    this._coordInfo.setUnits(CoordinateInfo.UNITS[5]);
                }
            }
        }

        private void setUnitsForSpheroidData(String line) {
            if (line.contains("PRIMEM[") && line.contains("UNIT[")) {
                String word1 = line.substring(line.indexOf("UNIT["), line.length() - 1);
                if (word1.contains("RADIANS")) {
                    this._coordInfo.setUnits(CoordinateTransformConstants.UNITS[0]);
                } else if (word1.contains("SECONDS")) {
                    this._coordInfo.setUnits(CoordinateTransformConstants.UNITS[3]);
                } else if (word1.contains("DEGREE")) {
                    this._coordInfo.setUnits(CoordinateTransformConstants.UNITS[4]);
                }
            }
        }

        private void setProjectionData(String line) {
            String word;
            if (line.contains("PROJECTION[") && (word = line.substring(line.indexOf("PROJECTION["), line.length() - 1)).startsWith("PROJECTION[")) {
                if (word.contains("X-Y")) {
                    this._coordInfo = new XYCoordinateInfo();
                    this._coordInfo.setType("X-Y");
                } else if (word.contains("ALBERS")) {
                    this._coordInfo = new AlbersCoordinateInfo();
                    this._coordInfo = (AlbersLambertCoordinateInfo)this._coordInfo;
                    this._coordInfo.setType("Albers Equal-Area Conic");
                    this.setAlbersLambertData(word);
                } else if (word.contains("LAMBERT_CONFORMAL CONIC")) {
                    this._coordInfo = new LambertCoordinateInfo();
                    this._coordInfo.setType("Lambert Conformal Conic");
                    this.setLambertData(word);
                } else if (word.contains("TRANSVERSE_MERCATOR")) {
                    this._coordInfo = new TransverseMercatorCoordinateInfo();
                    this._coordInfo.setType("Transverse Mercator");
                    this.setTMData(word);
                }
            }
        }

        private void setTMData(String line) {
            StringTokenizer otherLine = new StringTokenizer(line, "[");
            while (otherLine.hasMoreTokens()) {
                String word = otherLine.nextToken();
                if (word.startsWith("\"FALSE_EASTING") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    ((TransverseMercatorCoordinateInfo)this._coordInfo).setFalseEasting(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"FALSE_NORTHING") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    ((TransverseMercatorCoordinateInfo)this._coordInfo).setFalseNorthing(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"CENTRAL_MERIDIAN") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    this.degrees = this.toInternalDecimalDegrees(Double.parseDouble(word));
                    ((TransverseMercatorCoordinateInfo)this._coordInfo).setLongCentMer(this.degrees);
                    continue;
                }
                if (word.startsWith("\"SCALE_FACTOR") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    ((TransverseMercatorCoordinateInfo)this._coordInfo).setFactor(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"LATITUDE_OF_ORIGIN") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    this.degrees = this.toInternalDecimalDegrees(Double.parseDouble(word));
                    ((TransverseMercatorCoordinateInfo)this._coordInfo).setOriginLat(this.degrees);
                    continue;
                }
                if (word.startsWith("\"METER") && word.contains(",") && word.contains("]")) {
                    ((TransverseMercatorCoordinateInfo)this._coordInfo).setUnits(CoordinateInfo.UNITS[2]);
                    word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                    ((TransverseMercatorCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"FEET") && word.contains(",") && word.contains("]")) {
                    ((TransverseMercatorCoordinateInfo)this._coordInfo).setUnits(CoordinateInfo.UNITS[1]);
                    word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                    ((TransverseMercatorCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"FOOT") && word.contains(",") && word.contains("]")) {
                    ((TransverseMercatorCoordinateInfo)this._coordInfo).setUnits(CoordinateInfo.UNITS[1]);
                    word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                    ((TransverseMercatorCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
                    continue;
                }
                if (!word.startsWith("\"INTER") || !word.contains(",") || !word.contains("]")) continue;
                ((TransverseMercatorCoordinateInfo)this._coordInfo).setUnits(CoordinateInfo.UNITS[5]);
                word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                ((TransverseMercatorCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
            }
        }

        private void setLambertData(String line) {
            StringTokenizer otherLine = new StringTokenizer(line, "[");
            while (otherLine.hasMoreTokens()) {
                String word = otherLine.nextToken();
                if (word.startsWith("\"FALSE_EASTING") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    ((LambertCoordinateInfo)this._coordInfo).setFalseEasting(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"FALSE_NORTHING") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    ((LambertCoordinateInfo)this._coordInfo).setFalseNorthing(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"CENTRAL_MERIDIAN") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    this.degrees = this.toInternalDecimalDegrees(Double.parseDouble(word));
                    ((LambertCoordinateInfo)this._coordInfo).setLongCentMer(this.degrees);
                    continue;
                }
                if (word.startsWith("\"STANDARD_PARALLEL_1") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    this.degrees = this.toInternalDecimalDegrees(Double.parseDouble(word));
                    ((LambertCoordinateInfo)this._coordInfo).setLatStdPar1(this.degrees);
                    continue;
                }
                if (word.startsWith("\"STANDARD_PARALLEL_2") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    this.degrees = this.toInternalDecimalDegrees(Double.parseDouble(word));
                    ((LambertCoordinateInfo)this._coordInfo).setLatStdPar2(this.degrees);
                    continue;
                }
                if (word.startsWith("\"LATITUDE_OF_ORIGIN") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    this.degrees = this.toInternalDecimalDegrees(Double.parseDouble(word));
                    ((LambertCoordinateInfo)this._coordInfo).setOriginLat(this.degrees);
                    continue;
                }
                if (word.startsWith("\"METER") && word.contains(",") && word.contains("]")) {
                    ((LambertCoordinateInfo)this._coordInfo).setUnits("Meters");
                    word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                    ((LambertCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"FEET") && word.contains(",") && word.contains("]")) {
                    ((LambertCoordinateInfo)this._coordInfo).setUnits("U.S. Feet");
                    word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                    ((LambertCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"FOOT") && word.contains(",") && word.contains("]")) {
                    ((LambertCoordinateInfo)this._coordInfo).setUnits("U.S. Feet");
                    word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                    ((LambertCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
                    continue;
                }
                if (!word.startsWith("\"INTER") || !word.contains(",") || !word.contains("]")) continue;
                ((LambertCoordinateInfo)this._coordInfo).setUnits(CoordinateInfo.UNITS[5]);
                word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                ((LambertCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
            }
        }

        private void setAlbersLambertData(String line) {
            StringTokenizer otherLine = new StringTokenizer(line, "[");
            while (otherLine.hasMoreTokens()) {
                String word = otherLine.nextToken();
                if (word.startsWith("\"FALSE_EASTING") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setFalseEasting(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"FALSE_NORTHING") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setFalseNorthing(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"CENTRAL_MERIDIAN") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    this.degrees = this.toInternalDecimalDegrees(Double.parseDouble(word));
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setLongCentMer(this.degrees);
                    continue;
                }
                if (word.startsWith("\"STANDARD_PARALLEL_1") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    this.degrees = this.toInternalDecimalDegrees(Double.parseDouble(word));
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setLatStdPar1(this.degrees);
                    continue;
                }
                if (word.startsWith("\"STANDARD_PARALLEL_2") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    this.degrees = this.toInternalDecimalDegrees(Double.parseDouble(word));
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setLatStdPar2(this.degrees);
                    continue;
                }
                if (word.startsWith("\"LATITUDE_OF_ORIGIN") && word.contains(",") && word.contains("]")) {
                    word = word.substring(word.indexOf(44) + 1, word.indexOf(93));
                    this.degrees = this.toInternalDecimalDegrees(Double.parseDouble(word));
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setOriginLat(this.degrees);
                    continue;
                }
                if (word.startsWith("\"METER") && word.contains(",") && word.contains("]")) {
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setUnits("Meters");
                    word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"FEET") && word.contains(",") && word.contains("]")) {
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setUnits("U.S. Feet");
                    word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
                    continue;
                }
                if (word.startsWith("\"FOOT") && word.contains(",") && word.contains("]")) {
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setUnits("U.S. Feet");
                    word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                    ((AlbersLambertCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
                    continue;
                }
                if (!word.startsWith("\"INTER") || !word.contains(",") || !word.contains("]")) continue;
                ((AlbersLambertCoordinateInfo)this._coordInfo).setUnits(CoordinateInfo.UNITS[5]);
                word = word.substring(word.indexOf(",") + 1, word.indexOf("]"));
                ((AlbersLambertCoordinateInfo)this._coordInfo).setUnitMultiplier(Double.parseDouble(word));
            }
        }

        private double toInternalDecimalDegrees(Double dfDec) {
            double dfSign = dfDec < 0.0 ? -1.0 : 1.0;
            dfDec = Math.abs(dfDec);
            double dfDegrees = Math.floor(dfDec);
            double dfMinutes = Math.floor((dfDec - dfDegrees) * 60.0);
            double dfSeconds = (dfDec - dfDegrees) * 3600.0 - dfMinutes * 60.0;
            return dfSign * (dfDegrees * 1000000.0 + dfMinutes * 1000.0 + dfSeconds);
        }
    }
}

