/*
 * Decompiled with CFR 0.152.
 */
package hec.map.transform;

import hec.lang.LongContainer;
import hec.map.transform.AlbersLambertCoordinateInfo;
import hec.map.transform.CoordinateInfo;
import hec.map.transform.CoordinateTransformConstants;
import hec.map.transform.CoordinateTransformUtil;
import hec.map.transform.PolarStereographicCoordinateInfo;
import hec.map.transform.StatePlaneCoordinateInfo;
import hec.map.transform.TransverseMercatorCoordinateInfo;
import hec.map.transform.UTMCoordinateInfo;
import hec.map.transform.XYCoordinateInfo;
import java.io.File;
import rma.util.RMAIO;

@Deprecated(forRemoval=true, since="5.2.0")
public class CoordinateTransform
implements CoordinateTransformConstants {
    private static String NAD1927FILE = null;
    private static String NAD1983FILE = null;
    private static boolean _debug = false;

    @Deprecated(forRemoval=true, since="5.2.0")
    private static native long gctp(double[] var0, double[] var1, long var2, long var4, double[] var6, long var7, long var9, long var11, String var13, long var14, String var16, double[] var17, double[] var18, long var19, long var21, double[] var23, long var24, long var26, String var28, String var29);

    @Deprecated(forRemoval=true, since="5.2.0")
    public static synchronized long transform(double[] inCoorX, double[] inCoorY, CoordinateInfo inCoorInfo, double[] outCoorX, double[] outCoorY, CoordinateInfo outCoorInfo) {
        if (inCoorInfo == null || inCoorInfo instanceof XYCoordinateInfo) {
            if (_debug) {
                System.out.println("transform: can't transform inCoorInfo");
            }
            return -1L;
        }
        if (outCoorInfo == null || outCoorInfo instanceof XYCoordinateInfo) {
            if (_debug) {
                System.out.println("transform: can't transform outCoorInfo");
            }
            return -1L;
        }
        if (!CoordinateTransform.datFileExist()) {
            return -1L;
        }
        if (inCoorX.length != inCoorY.length && outCoorX.length != outCoorY.length && inCoorX.length != outCoorX.length) {
            System.out.println("transform: array lengths are not the same");
            return -1L;
        }
        if (inCoorInfo.equals(outCoorInfo)) {
            for (int i = 0; i < inCoorX.length; ++i) {
                outCoorX[i] = inCoorX[i];
                outCoorY[i] = inCoorY[i];
            }
            return 0L;
        }
        if (_debug) {
            System.out.println("transform:inCoord=" + inCoorInfo + " outCoord=" + outCoorInfo);
        }
        LongContainer errorFlag = new LongContainer();
        long iprFlag = _debug ? 0 : 3;
        long jprFlag = _debug ? 0 : 3;
        String errorFile = "efile.txt";
        String paramFile = "";
        long inSys = CoordinateTransform.getSystem(inCoorInfo.getType());
        long inUnit = CoordinateTransform.getUnit(inCoorInfo.getUnits());
        long outSys = CoordinateTransform.getSystem(outCoorInfo.getType());
        long outUnit = CoordinateTransform.getUnit(outCoorInfo.getUnits());
        long inSpheroid = CoordinateTransformUtil.getSpheroid(inCoorInfo.getSpheroid());
        long outSpheroid = CoordinateTransformUtil.getSpheroid(outCoorInfo.getSpheroid());
        double[] inParam = CoordinateTransform.getParam(inCoorInfo);
        double[] outParam = CoordinateTransform.getParam(outCoorInfo);
        long inZone = CoordinateTransform.getZone(inCoorInfo);
        long outZone = CoordinateTransform.getZone(outCoorInfo);
        try {
            return CoordinateTransform.gctp(inCoorX, inCoorY, inSys, inZone, inParam, inUnit, inSpheroid, iprFlag, errorFile, jprFlag, paramFile, outCoorX, outCoorY, outSys, outZone, outParam, outUnit, outSpheroid, NAD1927FILE, NAD1983FILE);
        }
        catch (Exception e) {
            System.out.println("transform: exception on transformation " + e);
            return -1L;
        }
    }

    private static long getSystem(String system) {
        if (system == null || system.length() < 1) {
            System.out.println("transform: undefined system");
            return -1L;
        }
        for (int i = 0; i < SYSTEMS.length; ++i) {
            if (!system.equalsIgnoreCase(SYSTEMS[i])) continue;
            if (_debug) {
                System.out.println("getSystem:returning " + SYSTEM_IDS[i] + " for " + system);
            }
            return SYSTEM_IDS[i];
        }
        System.out.println("transform: unknown system " + system);
        return -1L;
    }

    private static long getUnit(String unit) {
        if (unit == null || unit.length() < 1) {
            System.out.println("transform: undefined unit");
            return -1L;
        }
        for (int i = 0; i < UNITS.length; ++i) {
            if (!unit.equalsIgnoreCase(UNITS[i])) continue;
            return UNIT_IDS[i];
        }
        System.out.println("transform: unknown unit " + unit);
        return -1L;
    }

    private static double[] getParam(CoordinateInfo coorInfo) {
        double[] params = new double[15];
        if (coorInfo instanceof UTMCoordinateInfo) {
            UTMCoordinateInfo utmci = (UTMCoordinateInfo)coorInfo;
            params[0] = utmci.getLongZone();
            params[1] = utmci.getLatZone();
        } else if (!(coorInfo instanceof StatePlaneCoordinateInfo)) {
            if (coorInfo instanceof AlbersLambertCoordinateInfo) {
                AlbersLambertCoordinateInfo alci = (AlbersLambertCoordinateInfo)coorInfo;
                params[0] = alci.getMajorAxis();
                params[1] = alci.getMinorAxis();
                params[2] = alci.getLatStdPar1();
                params[3] = alci.getLatStdPar2();
                params[4] = alci.getLongCentMer();
                params[5] = alci.getOriginLat();
                params[6] = alci.getFalseEasting();
                params[7] = alci.getFalseNorthing();
            } else if (coorInfo instanceof TransverseMercatorCoordinateInfo) {
                TransverseMercatorCoordinateInfo tmci = (TransverseMercatorCoordinateInfo)coorInfo;
                params[0] = tmci.getMajorAxis();
                params[1] = tmci.getMinorAxis();
                params[2] = tmci.getFactor();
                params[4] = tmci.getLongCentMer();
                params[5] = tmci.getOriginLat();
                params[6] = tmci.getFalseEasting();
                params[7] = tmci.getFalseNorthing();
            } else if (coorInfo instanceof PolarStereographicCoordinateInfo) {
                PolarStereographicCoordinateInfo psci = (PolarStereographicCoordinateInfo)coorInfo;
                params[0] = psci.getMajorAxis();
                params[1] = psci.getMinorAxis();
                params[4] = psci.getLongPol();
                params[5] = psci.getTrueScale();
                params[6] = psci.getFalseEasting();
                params[7] = psci.getFalseNorthing();
            }
        }
        return params;
    }

    private static long getZone(CoordinateInfo coorInfo) {
        if (coorInfo instanceof UTMCoordinateInfo) {
            return ((UTMCoordinateInfo)coorInfo).getUTMZone();
        }
        if (coorInfo instanceof StatePlaneCoordinateInfo) {
            return ((StatePlaneCoordinateInfo)coorInfo).getStatePlaneZone();
        }
        return 0L;
    }

    private static boolean datFileExist() {
        File f = new File(NAD1927FILE);
        if (!f.exists() || !f.canRead()) {
            System.out.println("datFileExists: ERROR can't locate or read " + NAD1927FILE);
            return false;
        }
        File f2 = new File(NAD1983FILE);
        if (!f2.exists() || !f2.canRead()) {
            System.out.println("datFileExists: ERROR can't locate or read " + NAD1983FILE);
            return false;
        }
        return true;
    }

    static {
        try {
            System.loadLibrary("rmaUtil");
        }
        catch (Throwable t) {
            System.out.println("CoordinateTransform: failed to load library " + t);
        }
        _debug = Boolean.getBoolean("map.transform.debug");
        Object transformFilesHome = System.getProperty("statePlane.directory");
        if (transformFilesHome == null) {
            transformFilesHome = System.getProperty("user.dir");
            System.out.println("WARNING: 'statePlane.directory' property not set, using " + (String)transformFilesHome);
        }
        if (!((String)transformFilesHome).endsWith("/")) {
            transformFilesHome = (String)transformFilesHome + "/";
        }
        NAD1927FILE = (String)transformFilesHome + "nad27sp";
        NAD1983FILE = (String)transformFilesHome + "nad83sp";
        if (!new File(NAD1927FILE).exists() || !new File(NAD1983FILE).exists()) {
            String tempDir = System.getProperty("java.io.tmpdir") + "statePlaneDir";
            NAD1927FILE = RMAIO.copyFileFromResourcesToDirectory("hec/map/transform/datum/nad27sp", tempDir);
            NAD1983FILE = RMAIO.copyFileFromResourcesToDirectory("hec/map/transform/datum/nad83sp", tempDir);
        }
        if (_debug) {
            System.out.println("nad27 file=" + NAD1927FILE);
            System.out.println("nad83 file=" + NAD1983FILE);
        }
    }
}

