/*
 * Decompiled with CFR 0.152.
 */
package hec.map.transform;

import hec.map.transform.CoordinateInfo;
import hec.map.transform.CoordinateTransformPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJDialog;

public class CoordinateTransformDialog
extends RmaJDialog {
    protected CoordinateTransformPanel ctPanel;
    protected ButtonCmdPanel controlPanel;
    protected boolean _canceled = false;

    public CoordinateTransformDialog(Frame parent, boolean modal, int type) {
        super(parent, modal);
        this.buildControls(type, false);
    }

    public CoordinateTransformDialog(Frame parent, boolean modal, int type, boolean showUnitMultiplier) {
        super(parent, modal);
        this.buildControls(type, showUnitMultiplier);
    }

    public CoordinateTransformDialog(Dialog parent, boolean modal, int type) {
        super(parent, modal);
        this.buildControls(type, false);
    }

    public CoordinateTransformDialog(Dialog parent, boolean modal, int type, boolean showUnitMultiplier) {
        super(parent, modal);
        this.buildControls(type, showUnitMultiplier);
    }

    protected void buildControls(int type, boolean showUnitMultiplier) {
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(420, 420);
        if (type == 0) {
            this.setTitle("Map Coordinate Information");
        } else if (type == 1) {
            this.setTitle("GridSet Coordinate Information");
        }
        this.ctPanel = this.getCoordinateTransformPanel(type, showUnitMultiplier);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 2.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 1;
        this.getContentPane().add((Component)this.ctPanel, gbc);
        this.controlPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.anchor = 16;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.controlPanel, gbc);
        this.controlPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            @Override
            public void buttonCmdActionPerformed(ActionEvent event) {
                int id = event.getID();
                if (id == 8) {
                    CoordinateTransformDialog.this._canceled = false;
                    CoordinateTransformDialog.this.setVisible(false);
                } else if (id == 4) {
                    CoordinateTransformDialog.this._canceled = true;
                    CoordinateTransformDialog.this.setVisible(false);
                }
            }
        });
        this.setLocation();
    }

    public boolean wasCanceled() {
        return this._canceled;
    }

    public CoordinateInfo getCoordinateInfo() {
        return this.ctPanel.getCoordinateInfo();
    }

    public void setCoordinateInfo(CoordinateInfo cInfo) {
        this.ctPanel.setCoordinateInfo(cInfo);
    }

    protected CoordinateTransformPanel getCoordinateTransformPanel(int type, boolean showUnitMultiplier) {
        return new CoordinateTransformPanel(type, showUnitMultiplier);
    }

    public static void main(String[] args) {
        CoordinateTransformDialog ctd = new CoordinateTransformDialog(new Frame(), true, 0);
        ctd.setVisible(true);
    }
}

