/*
 * Decompiled with CFR 0.152.
 */
package hec.map.transform;

import hec.map.transform.AlbersCoordinateInfo;
import hec.map.transform.AlbersLambertCoordinateInfo;
import hec.map.transform.CoordinateInfo;
import hec.map.transform.CoordinateTransformConstants;
import hec.map.transform.CoordinateTransformUtil;
import hec.map.transform.GeographicCoordinateInfo;
import hec.map.transform.LambertCoordinateInfo;
import hec.map.transform.PolarStereographicCoordinateInfo;
import hec.map.transform.StatePlaneCoordinateInfo;
import hec.map.transform.TransverseMercatorCoordinateInfo;
import hec.map.transform.UTMCoordinateInfo;
import hec.map.transform.XYCoordinateInfo;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import rma.lang.Modifiable;
import rma.swing.LatLongJPanel;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;

public class CoordinateTransformPanel
extends JPanel
implements Modifiable,
CoordinateTransformConstants {
    protected boolean _modified = false;
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final String INPUT_TITLE = "Map Coordinate Information";
    public static final String OUTPUT_TITLE = "GridSet Coordinate Information";
    protected static final int HRAP_AXIS_VALUE = 6371200;
    protected RmaJComboBox systemCombo;
    protected RmaJComboBox unitsCombo;
    protected RmaJComboBox spheroidsCombo;
    protected JLabel spheroidLabel;
    protected JPanel cardPanel;
    protected UTMPanel utmPanel;
    protected StatePanel statePanel;
    protected Albers_LambertPanel albersPanel;
    protected Albers_LambertPanel albersPanelSHG;
    protected Albers_LambertPanel lambertPanel;
    protected PolarStereographicPanel polarPanel;
    protected TMPanel tmPanel;
    protected XYPanel xyPanel;
    protected GeographicPanel geographicPanel;
    protected Insets insets = new Insets(5, 5, 0, 0);
    protected Insets insets2 = new Insets(5, 20, 0, 0);
    protected boolean _showUnitMultiplier = false;
    String[] stateSpheroidList = new String[]{"Clarke 1866(NAD27)", "GRS 1980(NAD83)"};
    ItemListener _systemIL;
    private static Object[] _geoUnits = new Object[]{UNITS[0], UNITS[3], UNITS[4]};
    private static Object[] _normalUnits = new Object[]{UNITS[1], UNITS[2], UNITS[5]};
    private static DefaultComboBoxModel _normalUnitsModel = new DefaultComboBoxModel<Object>(_normalUnits);
    private static DefaultComboBoxModel _geoUnitsModel = new DefaultComboBoxModel<Object>(_geoUnits);

    public CoordinateTransformPanel(int inputOutput) {
        this.buildControls(inputOutput, false);
    }

    public CoordinateTransformPanel(int inputOutput, boolean showUnitMultiplier) {
        this.buildControls(inputOutput, showUnitMultiplier);
    }

    protected void buildControls(int inputOutput, boolean showUnitMultiplier) {
        this._showUnitMultiplier = showUnitMultiplier;
        if (inputOutput == 0) {
            this.setBorder(new TitledBorder(INPUT_TITLE));
        } else if (inputOutput == 1) {
            this.setBorder(new TitledBorder(OUTPUT_TITLE));
        } else {
            this.setBorder(new LineBorder(Color.black));
        }
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel("System:");
        label.setDisplayedMnemonic('s');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)label, gbc);
        this.systemCombo = this.createCoordComboChoices();
        label.setLabelFor(this.systemCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.add((Component)this.systemCombo, gbc);
        label = new JLabel("Units:");
        label.setDisplayedMnemonic('u');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = this.insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)label, gbc);
        this.unitsCombo = new RmaJComboBox(_normalUnitsModel);
        label.setLabelFor(this.unitsCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.add((Component)this.unitsCombo, gbc);
        this.spheroidLabel = new JLabel("Spheroid:");
        this.spheroidLabel.setDisplayedMnemonic('p');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = this.insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)this.spheroidLabel, gbc);
        this.spheroidsCombo = this.createSpheroidComboChoices();
        this.spheroidLabel.setLabelFor(this.spheroidsCombo);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.insets = this.insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.add((Component)this.spheroidsCombo, gbc);
        this.cardPanel = new JPanel(new CardLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.insets;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        this.add((Component)this.cardPanel, gbc);
        this.xyPanel = new XYPanel();
        this.cardPanel.add((Component)this.xyPanel, "X-Y");
        this.geographicPanel = new GeographicPanel();
        this.cardPanel.add((Component)this.geographicPanel, "Geographic");
        this.utmPanel = new UTMPanel();
        this.cardPanel.add((Component)this.utmPanel, "Universal Transverse Mercator");
        this.statePanel = new StatePanel();
        this.cardPanel.add((Component)this.statePanel, "State Plane Coordinates");
        this.albersPanel = new Albers_LambertPanel("Albers Equal-Area Conic");
        this.cardPanel.add((Component)this.albersPanel, "Albers Equal-Area Conic");
        this.albersPanelSHG = new Albers_LambertPanel("Albers Equal-Area Conic (SHG)");
        this.cardPanel.add((Component)this.albersPanelSHG, "Albers Equal-Area Conic (SHG)");
        this.lambertPanel = new Albers_LambertPanel("Lambert Conformal Conic");
        this.cardPanel.add((Component)this.lambertPanel, "Lambert Conformal Conic");
        this.tmPanel = new TMPanel();
        this.cardPanel.add((Component)this.tmPanel, "Transverse Mercator");
        String s = (String)this.systemCombo.getSelectedItem();
        this.polarPanel = new PolarStereographicPanel();
        this.cardPanel.add((Component)this.polarPanel, "Polar Stereographic (HRAP)");
        this._systemIL = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean state = false;
                boolean shg = false;
                boolean hrap = false;
                boolean xyType = false;
                if (e.getStateChange() == 2) {
                    return;
                }
                String s = (String)CoordinateTransformPanel.this.systemCombo.getSelectedItem();
                if (s == null) {
                    return;
                }
                DefaultComboBoxModel model = _normalUnitsModel;
                if (s.equals("X-Y")) {
                    xyType = true;
                } else if (s.equals("Albers Equal-Area Conic (SHG)")) {
                    shg = true;
                    CoordinateTransformPanel.this.unitsCombo.setSelectedItem("Meters");
                    CoordinateTransformPanel.this.albersPanelSHG.fe.setValue(0);
                    CoordinateTransformPanel.this.albersPanelSHG.fn.setValue(0);
                    CoordinateTransformPanel.this.albersPanelSHG.longCentMer.setValue(-9.6E7);
                    CoordinateTransformPanel.this.albersPanelSHG.latStdPar1.setValue(2.903E7);
                    CoordinateTransformPanel.this.albersPanelSHG.latStdPar2.setValue(4.503E7);
                    CoordinateTransformPanel.this.albersPanelSHG.originLat.setValue(2.3E7);
                    s = "Albers Equal-Area Conic (SHG)";
                    CoordinateTransformPanel.this.albersPanelSHG.latStdPar2.enableEdit();
                    CoordinateTransformPanel.this.albersPanelSHG.latStdPar1.enableEdit();
                    CoordinateTransformPanel.this.albersPanelSHG.originLat.enableEdit();
                    CoordinateTransformPanel.this.albersPanelSHG.longCentMer.enableEdit();
                    CoordinateTransformPanel.this.albersPanelSHG.fe.setEditable(false);
                    CoordinateTransformPanel.this.albersPanelSHG.fn.setEditable(false);
                } else if (s.equals("Geographic")) {
                    model = _geoUnitsModel;
                } else if (s.equals("Polar Stereographic (HRAP)")) {
                    hrap = true;
                    CoordinateTransformPanel.this.unitsCombo.setSelectedItem("Meters");
                    CoordinateTransformPanel.this.polarPanel.fe.setValue(1905000);
                    CoordinateTransformPanel.this.polarPanel.fn.setValue(7620000);
                    CoordinateTransformPanel.this.polarPanel.longPol.setValue(-1.05E8);
                    CoordinateTransformPanel.this.polarPanel.trueScale.setValue(6.0E7);
                    CoordinateTransformPanel.this.polarPanel.sMajorAxis.setValue(6371200);
                    CoordinateTransformPanel.this.polarPanel.sMinorAxis.setValue(6371200);
                    CoordinateTransformPanel.this.polarPanel.fe.setEnabled(false);
                    CoordinateTransformPanel.this.polarPanel.fn.setEnabled(false);
                    CoordinateTransformPanel.this.polarPanel.longPol.enableEdit();
                    CoordinateTransformPanel.this.polarPanel.trueScale.enableEdit();
                } else if (!s.equals("Universal Transverse Mercator")) {
                    if (s.equals("State Plane Coordinates")) {
                        state = true;
                    } else if (s.equals("Albers Equal-Area Conic") || s.equals("Lambert Conformal Conic") || s.equals("Transverse Mercator")) {
                        // empty if block
                    }
                }
                CoordinateTransformPanel.this.spheroidsCombo.setVisible(!xyType);
                CoordinateTransformPanel.this.spheroidLabel.setVisible(!xyType);
                if (state) {
                    CoordinateTransformPanel.this.fillSpheroidsCombo(CoordinateTransformPanel.this.stateSpheroidList);
                } else {
                    CoordinateTransformPanel.this.fillSpheroidsCombo(CoordinateTransformConstants.SPHERIODS);
                }
                if (shg) {
                    CoordinateTransformPanel.this.spheroidsCombo.setSelectedItem("GRS 1980(NAD83)");
                }
                if (hrap) {
                    CoordinateTransformPanel.this.spheroidsCombo.setSelectedItem("Sphere of Radius 6371200 Meters");
                }
                ((CardLayout)CoordinateTransformPanel.this.cardPanel.getLayout()).show(CoordinateTransformPanel.this.cardPanel, s);
                CoordinateTransformPanel.this.unitsCombo.setModel(model);
            }
        };
        this.spheroidsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                String spheroid = (String)CoordinateTransformPanel.this.spheroidsCombo.getSelectedItem();
                boolean hrapSpheroid = spheroid.equals("Sphere of Radius 6371200 Meters");
                long spheroidId = CoordinateTransformUtil.getSpheroid(spheroid);
                Component[] comps = CoordinateTransformPanel.this.cardPanel.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    if (!comps[i].isVisible() || !(comps[i] instanceof AxisPanel)) continue;
                    AxisPanel ap = (AxisPanel)((Object)comps[i]);
                    ap.setAxisFieldsEnabled(spheroidId < 0L && !hrapSpheroid);
                    double d = 0.0;
                    if (hrapSpheroid) {
                        d = 6371200.0;
                    }
                    ap.setMinorAxis(d);
                    ap.setMajorAxis(d);
                    break;
                }
            }
        });
        this.systemCombo.addItemListener(this._systemIL);
        Dimension dim = this.getPreferredSize();
        this.setMinimumSize(dim);
    }

    public CoordinateInfo getCoordinateInfo() {
        Component[] comps = this.cardPanel.getComponents();
        CoordinateInfo cInfo = null;
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof CoordinatePanel) || !comps[i].isVisible()) continue;
            cInfo = ((CoordinatePanel)comps[i]).getCoordinateInfo();
            break;
        }
        if (cInfo != null) {
            cInfo.set((String)this.unitsCombo.getSelectedItem(), (String)this.spheroidsCombo.getSelectedItem());
        }
        return cInfo;
    }

    public void setCoordinateInfo(CoordinateInfo cInfo) {
        this.clearPanel();
        if (cInfo == null) {
            return;
        }
        this.systemCombo.setSelectedIndex(-1);
        this.systemCombo.setSelectedItem(cInfo.getType());
        this.unitsCombo.setSelectedItem(cInfo.getUnits());
        this.spheroidsCombo.setSelectedItem(cInfo.getSpheroid());
        Component[] comps = this.cardPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof CoordinatePanel) || !comps[i].isVisible()) continue;
            ((CoordinatePanel)comps[i]).setCoordinateInfo(cInfo);
        }
    }

    public void clearPanel() {
        this.systemCombo.setSelectedIndex(0);
        this.unitsCombo.setSelectedIndex(0);
        this.spheroidsCombo.setSelectedIndex(0);
        this.utmPanel.clearPanel();
        this.statePanel.clearPanel();
        this.albersPanel.clearPanel();
        this.lambertPanel.clearPanel();
        this.tmPanel.clearPanel();
    }

    @Override
    public void setModified(boolean b) {
        this._modified = b;
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    protected RmaJComboBox createCoordComboChoices() {
        return new RmaJComboBox<String>(SYSTEMS);
    }

    protected RmaJComboBox createSpheroidComboChoices() {
        return new RmaJComboBox<String>(SPHERIODS);
    }

    private void fillSpheroidsCombo(String[] items) {
        this.spheroidsCombo.removeAllItems();
        for (int i = 0; i < items.length; ++i) {
            this.spheroidsCombo.addItem(items[i]);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new CoordinateTransformPanel(0));
        frame.setSize(325, 375);
        frame.setVisible(true);
    }

    public class XYPanel
    extends CoordinatePanel {
        RmaJDecimalField unitsMultField;

        public XYPanel() {
            this.setLayout(new GridBagLayout());
            if (CoordinateTransformPanel.this._showUnitMultiplier) {
                JLabel label = new JLabel("Units Multiplier:");
                label.setDisplayedMnemonic('M');
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.insets = new Insets(0, 0, 5, 5);
                gbc.anchor = 18;
                gbc.fill = 0;
                this.add((Component)label, gbc);
                this.unitsMultField = new RmaJDecimalField();
                label.setLabelFor(this.unitsMultField);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.insets = new Insets(0, 0, 5, 5);
                gbc.anchor = 18;
                gbc.ipadx = 50;
                this.add((Component)this.unitsMultField, gbc);
            }
        }

        @Override
        public CoordinateInfo getCoordinateInfo() {
            XYCoordinateInfo info = CoordinateTransformPanel.this._showUnitMultiplier ? new XYCoordinateInfo(null, this.unitsMultField.getValue()) : new XYCoordinateInfo(null, 1.0);
            return info;
        }

        @Override
        public void setCoordinateInfo(CoordinateInfo cInfo) {
            if (cInfo instanceof XYCoordinateInfo) {
                XYCoordinateInfo xyInfo = (XYCoordinateInfo)cInfo;
                if (CoordinateTransformPanel.this._showUnitMultiplier) {
                    this.unitsMultField.setValue(xyInfo.getUnitMultiplier());
                }
            }
        }
    }

    public class GeographicPanel
    extends CoordinatePanel {
        @Override
        public CoordinateInfo getCoordinateInfo() {
            GeographicCoordinateInfo info = new GeographicCoordinateInfo(null);
            return info;
        }

        @Override
        public void setCoordinateInfo(CoordinateInfo cInfo) {
            if (cInfo instanceof GeographicCoordinateInfo) {
                GeographicCoordinateInfo geographicCoordinateInfo = (GeographicCoordinateInfo)cInfo;
            }
        }
    }

    public class UTMPanel
    extends CoordinatePanel {
        RmaJIntegerField utmZoneNumber;

        public UTMPanel() {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel("UTM Zone:");
            label.setDisplayedMnemonic('u');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 0, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.utmZoneNumber = new RmaJIntegerField();
            label.setLabelFor(this.utmZoneNumber);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(0, 0, 5, 5);
            gbc.anchor = 18;
            gbc.ipadx = 25;
            this.add((Component)this.utmZoneNumber, gbc);
        }

        @Override
        public CoordinateInfo getCoordinateInfo() {
            UTMCoordinateInfo info = new UTMCoordinateInfo(null, null, this.utmZoneNumber.getValue(), 0.0, 0.0);
            return info;
        }

        @Override
        public void setCoordinateInfo(CoordinateInfo cInfo) {
            if (cInfo instanceof UTMCoordinateInfo) {
                UTMCoordinateInfo utmInfo = (UTMCoordinateInfo)cInfo;
                this.utmZoneNumber.setValue(utmInfo.getUTMZone());
            }
        }
    }

    public class StatePanel
    extends CoordinatePanel {
        RmaJIntegerField stateZoneNumber;

        public StatePanel() {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel("Zone:");
            label.setDisplayedMnemonic('z');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.stateZoneNumber = new RmaJIntegerField();
            label.setLabelFor(this.stateZoneNumber);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets2;
            gbc.anchor = 18;
            gbc.ipadx = 25;
            this.add((Component)this.stateZoneNumber, gbc);
        }

        @Override
        public CoordinateInfo getCoordinateInfo() {
            StatePlaneCoordinateInfo info = new StatePlaneCoordinateInfo(null, null, this.stateZoneNumber.getValue());
            return info;
        }

        @Override
        public void setCoordinateInfo(CoordinateInfo cInfo) {
            if (cInfo instanceof StatePlaneCoordinateInfo) {
                StatePlaneCoordinateInfo sInfo = (StatePlaneCoordinateInfo)cInfo;
                this.stateZoneNumber.setValue(sInfo.getStatePlaneZone());
            }
        }
    }

    public class Albers_LambertPanel
    extends CoordinatePanel {
        LatLongJPanel latStdPar1;
        LatLongJPanel latStdPar2;
        LatLongJPanel longCentMer;
        LatLongJPanel originLat;
        RmaJDecimalField fe;
        RmaJDecimalField fn;
        String _type;
        JPanel axisPanel;

        public Albers_LambertPanel(String type) {
            this.setLayout(new GridBagLayout());
            this._type = type;
            JLabel label = new JLabel("Latitude of the first standard parallel:");
            label.setDisplayedMnemonic('t');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.latStdPar1 = new LatLongJPanel(0);
            label.setLabelFor(this.latStdPar1);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.ipadx = 110;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.latStdPar1, gbc);
            label = new JLabel("Latitude of the second standard parallel:");
            label.setDisplayedMnemonic('u');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.latStdPar2 = new LatLongJPanel(0);
            label.setLabelFor(this.latStdPar2);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.latStdPar2, gbc);
            label = new JLabel("Longitude of the central meridian:");
            label.setDisplayedMnemonic('m');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.longCentMer = new LatLongJPanel(1);
            label.setLabelFor(this.longCentMer);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.longCentMer, gbc);
            label = new JLabel("Latitude of the projection origin:");
            label.setDisplayedMnemonic('o');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.originLat = new LatLongJPanel(0);
            label.setLabelFor(this.originLat);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.originLat, gbc);
            label = new JLabel("False easting:");
            label.setDisplayedMnemonic('f');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.fe = new RmaJDecimalField();
            label.setLabelFor(this.fe);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.fe, gbc);
            label = new JLabel("False northing:");
            label.setDisplayedMnemonic('n');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.fn = new RmaJDecimalField();
            label.setLabelFor(this.fn);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 6;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.fn, gbc);
        }

        @Override
        public CoordinateInfo getCoordinateInfo() {
            AlbersLambertCoordinateInfo info = null;
            if (this._type.startsWith("Albers Equal-Area Conic")) {
                info = new AlbersCoordinateInfo(null, null, 0.0, 0.0, this.latStdPar1.getValue(), this.latStdPar2.getValue(), this.longCentMer.getValue(), this.originLat.getValue(), this.fe.getValue(), this.fn.getValue());
            } else if (this._type.equals("Lambert Conformal Conic")) {
                info = new LambertCoordinateInfo(null, null, 0.0, 0.0, this.latStdPar1.getValue(), this.latStdPar2.getValue(), this.longCentMer.getValue(), this.originLat.getValue(), this.fe.getValue(), this.fn.getValue());
            }
            return info;
        }

        @Override
        public void setCoordinateInfo(CoordinateInfo cInfo) {
            if (cInfo instanceof AlbersLambertCoordinateInfo) {
                AlbersLambertCoordinateInfo alInfo = (AlbersLambertCoordinateInfo)cInfo;
                this.latStdPar1.setValue(alInfo.getLatStdPar1());
                this.latStdPar2.setValue(alInfo.getLatStdPar2());
                this.longCentMer.setValue(alInfo.getLongCentMer());
                this.originLat.setValue(alInfo.getOriginLat());
                this.fe.setValue(alInfo.getFalseEasting());
                this.fn.setValue(alInfo.getFalseNorthing());
            }
        }
    }

    public class TMPanel
    extends CoordinatePanel {
        RmaJDecimalField factor;
        LatLongJPanel longCentMer;
        LatLongJPanel originLat;
        RmaJDecimalField fe;
        RmaJDecimalField fn;
        JPanel axisPanel;

        public TMPanel() {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel("Scale factor at central meridian:");
            label.setDisplayedMnemonic('c');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.factor = new RmaJDecimalField();
            label.setLabelFor(this.factor);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.ipadx = 50;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.factor, gbc);
            label = new JLabel("Longitude of the central meridian:");
            label.setDisplayedMnemonic('l');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.longCentMer = new LatLongJPanel(1);
            label.setLabelFor(this.longCentMer);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.longCentMer, gbc);
            label = new JLabel("Latitude of the projection origin:");
            label.setDisplayedMnemonic('a');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.originLat = new LatLongJPanel(0);
            label.setLabelFor(this.originLat);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.originLat, gbc);
            label = new JLabel("False easting:");
            label.setDisplayedMnemonic('f');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.fe = new RmaJDecimalField();
            label.setLabelFor(this.fe);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.fe, gbc);
            label = new JLabel("False northing:");
            label.setDisplayedMnemonic('n');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.fn = new RmaJDecimalField();
            label.setLabelFor(this.fn);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 6;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.fn, gbc);
        }

        @Override
        public CoordinateInfo getCoordinateInfo() {
            TransverseMercatorCoordinateInfo info = new TransverseMercatorCoordinateInfo(null, null, 0.0, 0.0, this.factor.getValue(), this.longCentMer.getValue(), this.originLat.getValue(), this.fe.getValue(), this.fn.getValue());
            return info;
        }

        @Override
        public void setCoordinateInfo(CoordinateInfo cInfo) {
            if (cInfo instanceof TransverseMercatorCoordinateInfo) {
                TransverseMercatorCoordinateInfo tmInfo = (TransverseMercatorCoordinateInfo)cInfo;
                this.factor.setValue(tmInfo.getFactor());
                this.longCentMer.setValue(tmInfo.getLongCentMer());
                this.originLat.setValue(tmInfo.getOriginLat());
                this.fe.setValue(tmInfo.getFalseEasting());
                this.fn.setValue(tmInfo.getFalseNorthing());
            }
        }
    }

    public class PolarStereographicPanel
    extends CoordinatePanel
    implements AxisPanel {
        RmaJDecimalField sMajorAxis;
        RmaJDecimalField sMinorAxis;
        LatLongJPanel longPol;
        LatLongJPanel trueScale;
        RmaJDecimalField fe;
        RmaJDecimalField fn;
        JPanel axisPanel;

        public PolarStereographicPanel() {
            this.setLayout(new GridBagLayout());
            this.axisPanel = new JPanel(new GridBagLayout());
            this.axisPanel.setBorder(new TitledBorder("Axis"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.gridwidth = 2;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)this.axisPanel, gbc);
            JLabel label = new JLabel("Semi-major:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.axisPanel.add((Component)label, gbc);
            this.sMajorAxis = new RmaJDecimalField(0);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.ipadx = 50;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.axisPanel.add((Component)this.sMajorAxis, gbc);
            label = new JLabel("Semi-minor:");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.axisPanel.add((Component)label, gbc);
            this.sMinorAxis = new RmaJDecimalField(0);
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.ipadx = 50;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.axisPanel.add((Component)this.sMinorAxis, gbc);
            label = new JLabel("Central Meridian:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.longPol = new LatLongJPanel(1);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 3;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.longPol, gbc);
            label = new JLabel("Latitude of true scale:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.trueScale = new LatLongJPanel(0);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.trueScale, gbc);
            label = new JLabel("False easting:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.fe = new RmaJDecimalField();
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.fe, gbc);
            label = new JLabel("False northing:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.weightx = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 0;
            this.add((Component)label, gbc);
            this.fn = new RmaJDecimalField();
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 6;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = CoordinateTransformPanel.this.insets;
            gbc.anchor = 18;
            gbc.fill = 2;
            this.add((Component)this.fn, gbc);
        }

        @Override
        public void setAxisFieldsEnabled(boolean b) {
            this.sMajorAxis.setEditable(b);
            this.sMinorAxis.setEditable(b);
        }

        @Override
        public void setMinorAxis(double d) {
            this.sMinorAxis.setValue(d);
        }

        @Override
        public void setMajorAxis(double d) {
            this.sMajorAxis.setValue(d);
        }

        @Override
        public CoordinateInfo getCoordinateInfo() {
            PolarStereographicCoordinateInfo info = null;
            info = new PolarStereographicCoordinateInfo(null, null, this.sMajorAxis.getValue(), this.sMinorAxis.getValue(), this.longPol.getValue(), this.trueScale.getValue(), this.fe.getValue(), this.fn.getValue());
            return info;
        }

        @Override
        public void setCoordinateInfo(CoordinateInfo cInfo) {
            if (cInfo instanceof PolarStereographicCoordinateInfo) {
                PolarStereographicCoordinateInfo alInfo = (PolarStereographicCoordinateInfo)cInfo;
                this.sMajorAxis.setValue(alInfo.getMajorAxis());
                this.sMinorAxis.setValue(alInfo.getMinorAxis());
                this.longPol.setValue(alInfo.getLongPol());
                this.trueScale.setValue(alInfo.getTrueScale());
                this.fe.setValue(alInfo.getFalseEasting());
                this.fn.setValue(alInfo.getFalseNorthing());
            }
        }
    }

    public abstract class CoordinatePanel
    extends JPanel {
        public abstract CoordinateInfo getCoordinateInfo();

        public abstract void setCoordinateInfo(CoordinateInfo var1);

        public void clearPanel() {
            Component[] c2 = this.getComponents();
            for (int i = 0; i < c2.length; ++i) {
                if (!(c2[i] instanceof JTextField)) continue;
                ((JTextField)c2[i]).setText("");
            }
        }
    }

    public static interface AxisPanel {
        public void setAxisFieldsEnabled(boolean var1);

        public void setMinorAxis(double var1);

        public void setMajorAxis(double var1);
    }
}

