/*
 * Decompiled with CFR 0.152.
 */
package hec.map.transform;

import hec.io.AsciiSerializable;
import hec.map.transform.CoordinateInfo;
import hec.util.XMLUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jdom.Element;
import rma.util.RMAIO;

public class PolarStereographicCoordinateInfo
extends CoordinateInfo
implements Serializable,
AsciiSerializable {
    static final long serialVersionUID = 7052380589970108400L;
    private double _sMajorAxis;
    private double _sMinorAxis;
    private double _longPol;
    private double _trueScale;
    private double _fe;
    private double _fn;
    private boolean _isHRAP = false;

    public PolarStereographicCoordinateInfo() {
    }

    public PolarStereographicCoordinateInfo(String units, String spheroid) {
        super(units, spheroid);
    }

    public PolarStereographicCoordinateInfo(String units, String spheroid, double sMajorAxis, double sMinorAxis, double longPol, double trueScale, double fe, double fn) {
        this(units, spheroid);
        this._sMajorAxis = sMajorAxis;
        this._sMinorAxis = sMinorAxis;
        this._longPol = longPol;
        this._trueScale = trueScale;
        this._fe = fe;
        this._fn = fn;
    }

    public void setMajorAxis(double sMajorAxis) {
        this._sMajorAxis = sMajorAxis;
    }

    public void setMinorAxis(double sMinorAxis) {
        this._sMinorAxis = sMinorAxis;
    }

    public void setLongPol(double longPol) {
        this._longPol = longPol;
    }

    public void setTrueScale(double trueScale) {
        this._trueScale = trueScale;
    }

    public void setFalseNorthing(double fn) {
        this._fn = fn;
    }

    public void setFalseEasting(double fe) {
        this._fe = fe;
    }

    @Override
    public String getType() {
        return "Polar Stereographic (HRAP)";
    }

    public double getMajorAxis() {
        return this._sMajorAxis;
    }

    public double getMinorAxis() {
        return this._sMinorAxis;
    }

    public double getLongPol() {
        return this._longPol;
    }

    public double getTrueScale() {
        return this._trueScale;
    }

    public double getFalseNorthing() {
        return this._fn;
    }

    public double getFalseEasting() {
        return this._fe;
    }

    @Override
    protected void writeObject2(BufferedWriter writer) throws IOException {
        if (writer == null) {
            return;
        }
        RMAIO.fout(writer, "minorAxis=" + this._sMinorAxis);
        RMAIO.fout(writer, "majorAxis=" + this._sMajorAxis);
        RMAIO.fout(writer, "longPol=" + this._longPol);
        RMAIO.fout(writer, "trueScale=" + this._trueScale);
        RMAIO.fout(writer, "falseEasting=" + this._fe);
        RMAIO.fout(writer, "falseNorthing=" + this._fn);
        RMAIO.fout(writer, "isHrap=" + this._isHRAP);
    }

    @Override
    protected void readObject2(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return;
        }
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("CoordinateInfoEnd") > -1) {
                return;
            }
            String type = RMAIO.getType(line, "=");
            String param = RMAIO.getParam(line, "=");
            if (type.equals("minorAxis")) {
                this._sMinorAxis = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("minorAxis")) {
                this._sMajorAxis = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("majorAxis")) {
                this._sMajorAxis = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("longPol")) {
                this._longPol = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("trueScale")) {
                this._trueScale = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("falseEasting")) {
                this._fe = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("falseNorthing")) {
                this._fn = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (!type.equals("isHrap")) continue;
            this._isHRAP = "true".equalsIgnoreCase(param);
        }
    }

    @Override
    public boolean saveData(Element cinfoElem) {
        boolean retval = super.saveData(cinfoElem);
        cinfoElem.setAttribute("minorAxis", String.valueOf(this._sMinorAxis));
        cinfoElem.setAttribute("majorAxis", String.valueOf(this._sMajorAxis));
        cinfoElem.setAttribute("longPol", String.valueOf(this._longPol));
        cinfoElem.setAttribute("trueScale", String.valueOf(this._trueScale));
        cinfoElem.setAttribute("falseEasting", String.valueOf(this._fe));
        cinfoElem.setAttribute("falseNorthing", String.valueOf(this._fn));
        cinfoElem.setAttribute("isHrap", String.valueOf(this._isHRAP));
        return true;
    }

    @Override
    public boolean loadData(Element cinfoElem) {
        boolean retval = super.loadData(cinfoElem);
        this._sMinorAxis = RMAIO.parseDouble(cinfoElem.getAttributeValue("minorAxis"));
        this._sMajorAxis = RMAIO.parseDouble(cinfoElem.getAttributeValue("majorAxis"));
        this._longPol = RMAIO.parseDouble(cinfoElem.getAttributeValue("longPol"));
        this._trueScale = RMAIO.parseDouble(cinfoElem.getAttributeValue("trueScale"));
        this._fe = RMAIO.parseDouble(cinfoElem.getAttributeValue("falseEasting"));
        this._fn = RMAIO.parseDouble(cinfoElem.getAttributeValue("falseNorthing"));
        this._isHRAP = XMLUtilities.getAttributeValueAsBoolean(cinfoElem, "isHrap", true);
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PolarStereographicCoordinateInfo)) {
            return false;
        }
        if (super.equals(obj)) {
            PolarStereographicCoordinateInfo psci = (PolarStereographicCoordinateInfo)obj;
            if (this._sMajorAxis == psci._sMajorAxis && this._sMinorAxis == psci._sMinorAxis && this._longPol == psci._longPol && this._trueScale == psci._trueScale && this._fe == psci._fe && this._fn == psci._fn) {
                return true;
            }
        }
        return false;
    }

    public static PolarStereographicCoordinateInfo getHRAPCoordinateInfo() {
        PolarStereographicCoordinateInfo info = new PolarStereographicCoordinateInfo("Meters", "Sphere of Radius 6371200 Meters", 6371200.0, 6371200.0, -1.05E8, 6.0E7, 1905000.0, 7620000.0);
        info._isHRAP = true;
        return info;
    }

    public boolean isHrap() {
        return this._isHRAP;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

