/*
 * Decompiled with CFR 0.152.
 */
package hec.map.transform;

import hec.io.AsciiSerializable;
import hec.map.transform.CoordinateInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jdom.Element;
import rma.util.RMAIO;

public class StatePlaneCoordinateInfo
extends CoordinateInfo
implements Serializable,
AsciiSerializable {
    static final long serialVersionUID = -4287149345518601227L;
    protected long _stateZone;

    public StatePlaneCoordinateInfo() {
    }

    public StatePlaneCoordinateInfo(String units, String spheroid) {
        super(units, spheroid);
    }

    public StatePlaneCoordinateInfo(String units, String spheroid, long stateZone) {
        this(units, spheroid);
        this._stateZone = stateZone;
    }

    @Override
    public String getType() {
        return "State Plane Coordinates";
    }

    public void setStatePlaneZone(long stateZone) {
        this._stateZone = stateZone;
    }

    public long getStatePlaneZone() {
        return this._stateZone;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof StatePlaneCoordinateInfo)) {
            return false;
        }
        if (super.equals(obj)) {
            StatePlaneCoordinateInfo spci = (StatePlaneCoordinateInfo)obj;
            if (this._stateZone == spci._stateZone && this._units.equals(spci._units) && this._unitMultiplier == spci._unitMultiplier && this._spheroid.equals(spci._spheroid)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void writeObject2(BufferedWriter writer) throws IOException {
        if (writer == null) {
            return;
        }
        RMAIO.fout(writer, "StateZone=" + this._stateZone);
    }

    @Override
    protected void readObject2(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return;
        }
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("CoordinateInfoEnd") > -1) {
                return;
            }
            String type = RMAIO.getType(line, "=");
            String param = RMAIO.getParam(line, "=");
            if (!type.equals("StateZone")) continue;
            this._stateZone = RMAIO.parseLong(param, 0L);
        }
    }

    @Override
    public boolean saveData(Element cinfoElem) {
        boolean retval = super.saveData(cinfoElem);
        cinfoElem.setAttribute("StateZone", String.valueOf(this._stateZone));
        return true;
    }

    @Override
    public boolean loadData(Element cinfoElem) {
        boolean retval = super.loadData(cinfoElem);
        this._stateZone = RMAIO.parseLong(cinfoElem.getAttributeValue("StateZone"), 0L);
        return true;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

