/*
 * Decompiled with CFR 0.152.
 */
package hec.map.transform;

import hec.io.AsciiSerializable;
import hec.map.transform.CoordinateInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jdom.Element;
import rma.util.RMAIO;

public class TransverseMercatorCoordinateInfo
extends CoordinateInfo
implements Serializable,
AsciiSerializable {
    static final long serialVersionUID = 9193277812628055693L;
    protected double _sMajorAxis;
    protected double _sMinorAxis;
    protected double _factor;
    protected double _longCentMer;
    protected double _originLat;
    protected double _fe;
    protected double _fn;

    public TransverseMercatorCoordinateInfo() {
    }

    public TransverseMercatorCoordinateInfo(String units, String spheroid) {
        super(units, spheroid);
    }

    public TransverseMercatorCoordinateInfo(String units, String spheroid, double sMajorAxis, double sMinorAxis, double factor, double longCentMer, double originLat, double fe, double fn) {
        this(units, spheroid);
        this._sMajorAxis = sMajorAxis;
        this._sMinorAxis = sMinorAxis;
        this._factor = factor;
        this._longCentMer = longCentMer;
        this._originLat = originLat;
        this._fe = fe;
        this._fn = fn;
    }

    @Override
    public String getType() {
        return "Transverse Mercator";
    }

    public void setMajorAxis(double sMajorAxis) {
        this._sMajorAxis = sMajorAxis;
    }

    public void setMinorAxis(double sMinorAxis) {
        this._sMinorAxis = sMinorAxis;
    }

    public void setFactor(double factor) {
        this._factor = factor;
    }

    public void setLongCentMer(double longCentMer) {
        this._longCentMer = longCentMer;
    }

    public void setOriginLat(double originLat) {
        this._originLat = originLat;
    }

    public void setFalseNorthing(double fn) {
        this._fn = fn;
    }

    public void setFalseEasting(double fe) {
        this._fe = fe;
    }

    public double getMajorAxis() {
        return this._sMajorAxis;
    }

    public double getMinorAxis() {
        return this._sMinorAxis;
    }

    public double getFactor() {
        return this._factor;
    }

    public double getLongCentMer() {
        return this._longCentMer;
    }

    public double getOriginLat() {
        return this._originLat;
    }

    public double getFalseNorthing() {
        return this._fn;
    }

    public double getFalseEasting() {
        return this._fe;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TransverseMercatorCoordinateInfo)) {
            return false;
        }
        if (super.equals(obj)) {
            TransverseMercatorCoordinateInfo tmci = (TransverseMercatorCoordinateInfo)obj;
            if (this._sMajorAxis == tmci._sMajorAxis && this._sMinorAxis == tmci._sMinorAxis && this._factor == tmci._factor && this._longCentMer == tmci._longCentMer && this._originLat == tmci._originLat && this._fe == tmci._fe && this._fn == tmci._fn) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void writeObject2(BufferedWriter writer) throws IOException {
        if (writer == null) {
            return;
        }
        RMAIO.fout(writer, "minorAxis=" + this._sMajorAxis);
        RMAIO.fout(writer, "majorAxis=" + this._sMinorAxis);
        RMAIO.fout(writer, "factor=" + this._factor);
        RMAIO.fout(writer, "longCentMer=" + this._longCentMer);
        RMAIO.fout(writer, "originLat=" + this._originLat);
        RMAIO.fout(writer, "falseEasting=" + this._fe);
        RMAIO.fout(writer, "falseNorthing=" + this._fn);
    }

    @Override
    protected void readObject2(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return;
        }
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("CoordinateInfoEnd") > -1) {
                return;
            }
            String type = RMAIO.getType(line, "=");
            String param = RMAIO.getParam(line, "=");
            if (type.equals("minorAxis")) {
                this._sMinorAxis = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("minorAxis")) {
                this._sMajorAxis = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("majorAxis")) {
                this._sMajorAxis = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("factor")) {
                this._factor = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("longCentMer")) {
                this._longCentMer = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("originLat")) {
                this._originLat = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (type.equals("falseEasting")) {
                this._fe = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (!type.equals("falseNorthing")) continue;
            this._fn = RMAIO.parseDouble(param, 0.0);
        }
    }

    @Override
    public boolean saveData(Element cinfoElem) {
        boolean retval = super.saveData(cinfoElem);
        cinfoElem.setAttribute("minorAxis", String.valueOf(this._sMinorAxis));
        cinfoElem.setAttribute("majorAxis", String.valueOf(this._sMajorAxis));
        cinfoElem.setAttribute("factor", String.valueOf(this._factor));
        cinfoElem.setAttribute("longCentMer", String.valueOf(this._longCentMer));
        cinfoElem.setAttribute("originLat", String.valueOf(this._originLat));
        cinfoElem.setAttribute("falseEasting", String.valueOf(this._fe));
        cinfoElem.setAttribute("falseNorthing", String.valueOf(this._fn));
        return true;
    }

    @Override
    public boolean loadData(Element cinfoElem) {
        boolean retval = super.loadData(cinfoElem);
        this._sMinorAxis = RMAIO.parseDouble(cinfoElem.getAttributeValue("minorAxis"));
        this._sMajorAxis = RMAIO.parseDouble(cinfoElem.getAttributeValue("majorAxis"));
        this._factor = RMAIO.parseDouble(cinfoElem.getAttributeValue("factor"));
        this._originLat = RMAIO.parseDouble(cinfoElem.getAttributeValue("originLat"));
        this._longCentMer = RMAIO.parseDouble(cinfoElem.getAttributeValue("longCentMer"));
        this._fe = RMAIO.parseDouble(cinfoElem.getAttributeValue("falseEasting"));
        this._fn = RMAIO.parseDouble(cinfoElem.getAttributeValue("falseNorthing"));
        return true;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

