/*
 * Decompiled with CFR 0.152.
 */
package hec.map.transform;

import hec.io.AsciiSerializable;
import hec.map.transform.CoordinateInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jdom.Element;
import rma.util.RMAIO;

public class UTMCoordinateInfo
extends CoordinateInfo
implements Serializable,
AsciiSerializable {
    static final long serialVersionUID = -8952428272664877500L;
    protected long _utmZone;
    protected double _latZone;
    protected double _longZone;

    public UTMCoordinateInfo() {
    }

    public UTMCoordinateInfo(String units, String spheroid) {
        super(units, spheroid);
    }

    public UTMCoordinateInfo(String units, String spheroid, long utmZone, double latZone, double longZone) {
        this(units, spheroid);
        this._utmZone = utmZone;
        this._latZone = latZone;
        this._longZone = longZone;
    }

    @Override
    public String getType() {
        return "Universal Transverse Mercator";
    }

    public void setUTMZone(long utmZone) {
        this._utmZone = utmZone;
    }

    public void setLatZone(double latZone) {
        this._latZone = latZone;
    }

    public void setLongZone(double longZone) {
        this._longZone = longZone;
    }

    public long getUTMZone() {
        return this._utmZone;
    }

    public double getLatZone() {
        return this._latZone;
    }

    public double getLongZone() {
        return this._longZone;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UTMCoordinateInfo)) {
            return false;
        }
        if (super.equals(obj)) {
            UTMCoordinateInfo uci = (UTMCoordinateInfo)obj;
            if (this._utmZone == uci._utmZone && this._latZone == uci._latZone && this._longZone == uci._longZone) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void writeObject2(BufferedWriter writer) throws IOException {
        if (writer == null) {
            return;
        }
        RMAIO.fout(writer, "UTMZone=" + this._utmZone);
        RMAIO.fout(writer, "latZone=" + this._latZone);
        RMAIO.fout(writer, "longZone=" + this._longZone);
    }

    @Override
    protected void readObject2(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return;
        }
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("CoordinateInfoEnd") > -1) {
                return;
            }
            String type = RMAIO.getType(line, "=");
            String param = RMAIO.getParam(line, "=");
            if (type.equals("UTMZone")) {
                this._utmZone = RMAIO.parseLong(param, 0L);
                continue;
            }
            if (type.equals("latZone")) {
                this._latZone = RMAIO.parseDouble(param, 0.0);
                continue;
            }
            if (!type.equals("longZone")) continue;
            this._longZone = RMAIO.parseDouble(param, 0.0);
        }
    }

    @Override
    public boolean saveData(Element cinfoElem) {
        boolean retval = super.saveData(cinfoElem);
        cinfoElem.setAttribute("UTMZone", String.valueOf(this._utmZone));
        cinfoElem.setAttribute("latZone", String.valueOf(this._latZone));
        cinfoElem.setAttribute("longZone", String.valueOf(this._longZone));
        return true;
    }

    @Override
    public boolean loadData(Element cinfoElem) {
        boolean retval = super.loadData(cinfoElem);
        this._utmZone = RMAIO.parseLong(cinfoElem.getAttributeValue("UTMZone"), 0L);
        this._latZone = RMAIO.parseDouble(cinfoElem.getAttributeValue("latZone"));
        this._longZone = RMAIO.parseDouble(cinfoElem.getAttributeValue("longZone"));
        return true;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

