/*
 * Decompiled with CFR 0.152.
 */
package hec.map.vrt;

import hec.appInterface.FileOpener;
import hec.io.FileLock;
import hec.io.Identifier;
import hec.io.SimpleHecFileImpl;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimpleFileOpeners
implements FileOpener {
    @Override
    public Identifier openFile(Identifier fileToOpenId, boolean useCache) {
        String path = fileToOpenId.getPath();
        return new Identifier(path, new SimpleHecFileImpl(path));
    }

    @Override
    public Identifier createFile(Identifier fileToCreateId) {
        String path = fileToCreateId.getPath();
        File f = new File(path);
        if (!f.getParentFile().exists()) {
            f.mkdirs();
        }
        return new Identifier(path, new SimpleHecFileImpl(path));
    }

    @Override
    public boolean lockFile(Identifier id, FileLock flock) {
        return true;
    }

    @Override
    public boolean unlockFile(Identifier id, FileLock flock) {
        return true;
    }

    @Override
    public List getFileList(String path, final String filter) {
        String[] files = new File(path).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(filter);
            }
        });
        ArrayList<File> list = new ArrayList<File>();
        for (String string : files) {
            list.add(new File(string));
        }
        return list;
    }

    @Override
    public List getDriveList() {
        File[] roots = File.listRoots();
        return Arrays.asList(roots);
    }
}

