/*
 * Decompiled with CFR 0.152.
 */
package hec.map.vrt;

import hec.map.ElevationGlyph;
import hec.map.ElevationGlyphDataRecord;
import hec.map.GlyphDataRecord;
import hec.map.LocalPt;
import hec.map.LocalRegion;
import hec.map.MapGlyph;
import hec.map.MapGlyphFactory;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldRect;
import hec.map.vrt.VrtMapObject;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import rma.util.ColorContour;
import rma.util.WaterDepthColorContour;

public class VrtMapGlyph
extends MapGlyph
implements ElevationGlyph {
    BufferedImage mBufferedImage = null;
    WorldRect mPreviousWorldRect = null;
    boolean shown = true;
    boolean isDirty = false;

    public VrtMapGlyph(MapPanel mapPanel, VrtMapObject vrtMapObject) {
        super(mapPanel, vrtMapObject);
    }

    @Override
    public boolean isShown() {
        return this.shown;
    }

    @Override
    public void setShown(boolean shown) {
        this.shown = shown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics graphics, MapScale scl) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        Graphics buffGraphics = null;
        try {
            Dimension d = this.getMapPanel().viewport().getSize();
            if (this.mBufferedImage == null || (double)this.mBufferedImage.getWidth() != d.getWidth() || (double)this.mBufferedImage.getHeight() != d.getHeight()) {
                this.isDirty = true;
                this.mBufferedImage = new BufferedImage((int)d.getWidth(), (int)d.getHeight(), 2);
            }
            if (this.mPreviousWorldRect == null || !scl.getWorldRect().equals(this.mPreviousWorldRect)) {
                this.isDirty = true;
            }
            if (this.isDirty) {
                this.mPreviousWorldRect = scl.getWorldRect();
                buffGraphics = (Graphics2D)this.mBufferedImage.getGraphics();
                buffGraphics.setColor(new Color(0, 0, 1, 0));
                ((Graphics2D)buffGraphics).setComposite(AlphaComposite.Clear);
                buffGraphics.fillRect(0, 0, this.mBufferedImage.getWidth(), this.mBufferedImage.getHeight());
                ((Graphics2D)buffGraphics).setComposite(AlphaComposite.SrcOver);
                VrtMapObject vrtMap = (VrtMapObject)this.getMap();
                List<MapObject> mapObjects = vrtMap.getMapObjects();
                for (int i = mapObjects.size() - 1; i >= 0; --i) {
                    MapObject mapObject = mapObjects.get(i);
                    MapIdentifier thisMapIdentifier = vrtMap.getMapIdentifier();
                    MapIdentifier mapIdentifier = mapObject.getMapIdentifier();
                    if (mapIdentifier != null && thisMapIdentifier != null) {
                        mapIdentifier.setGlyphDataRecord(this.getDataRecord());
                    }
                    MapGlyph newMapGlyph = MapGlyphFactory.newMapGlyph(this._mapPanel, mapObject);
                    newMapGlyph.draw(buffGraphics, scl);
                }
            }
            g2d.setComposite(AlphaComposite.SrcOver);
            GlyphDataRecord dataRecord = this.getDataRecord();
            AlphaComposite ac = AlphaComposite.getInstance(3, ((ElevationGlyphDataRecord)dataRecord).getAlpha());
            g2d.setComposite(ac);
            g2d.drawImage((Image)this.mBufferedImage, 0, 0, null);
            this.isDirty = false;
        }
        finally {
            g2d.dispose();
            if (buffGraphics != null) {
                buffGraphics.dispose();
            }
        }
    }

    @Override
    public double getMaximumElevation() {
        return ((VrtMapObject)this.getMap()).getMaximumElevation();
    }

    @Override
    public double getMinimumElevation() {
        return ((VrtMapObject)this.getMap()).getMinimumElevation();
    }

    @Override
    public float getElevationAt(int ix, int iy) {
        return ((VrtMapObject)this.getMap()).getElevation(this._mapPanel.scale(this).lp2wp(new LocalPt(ix, iy)));
    }

    @Override
    public double getNoDataValue() {
        return ((VrtMapObject)this.getMap()).getNoDataValue();
    }

    @Override
    public void drawElevationStats(Graphics g, LocalRegion region) {
    }

    @Override
    public GlyphDataRecord getDefaultDataRecord() {
        ElevationGlyphDataRecord record = new ElevationGlyphDataRecord();
        record.setColorContour(new WaterDepthColorContour());
        ColorContour colorContour = record.getColorContour();
        colorContour.setMinValue(this.getMinimumElevation());
        colorContour.setMaxValue(this.getMaximumElevation());
        return record;
    }
}

