/*
 * Decompiled with CFR 0.152.
 */
package hec.map.vrt;

import hec.appInterface.FileOpener;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.SimpleHecFileImpl;
import hec.map.ElevationMap;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectFactory;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.crs.CRS;
import hec.map.crs.CRSException;
import hec.map.vrt.SimpleFileOpeners;
import hec.vrt.ComplexSource;
import hec.vrt.VRTDataSet;
import hec.vrt.VRTRasterBand;
import hec.vrt.VRTReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAIO;

public class VrtMapObject
extends MapObject
implements ElevationMap {
    VRTDataSet mDataSet = null;
    List<MapObject> mSubMaps = new ArrayList<MapObject>();

    public VrtMapObject() {
    }

    public VrtMapObject(String vrtMapPath) {
        this(new MapIdentifier(vrtMapPath, new SimpleHecFileImpl(vrtMapPath)));
    }

    public VrtMapObject(MapIdentifier mapId) {
        super(mapId);
    }

    @Override
    public List getFilenames() {
        if (!this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(VrtMapObject.class.getName()).log(Level.SEVERE, null, ex);
                return Collections.EMPTY_LIST;
            }
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add(this.getMapIdentifier().getPath());
        for (MapObject subMap : this.mSubMaps) {
            List filenames = subMap.getFilenames();
            fileNames.addAll(filenames);
        }
        return fileNames;
    }

    @Override
    public void load() throws IOException {
        this.mSubMaps.clear();
        if (this.getMapIdentifier() == null || this.getMapIdentifier().getFile() == null && (this.getMapIdentifier().getPath() == null || this.getMapIdentifier().getPath().isEmpty())) {
            throw new IOException("Undefined VRT File");
        }
        if (this.getMapIdentifier().getFile() == null) {
            this.getMapIdentifier().setFile(new SimpleHecFileImpl(this.getMapIdentifier().getPath()));
        }
        VRTReader reader = new VRTReader();
        HecFile file = this.getMapIdentifier().getFile();
        try (DataInputStream dataInputStream = file.getDataInputStream();){
            this.mDataSet = reader.read((InputStream)dataInputStream, new File(file.getPath()).getParentFile());
        }
        try {
            String wkt = this.mDataSet.getCrsWKT();
            if (wkt != null && !wkt.isEmpty()) {
                this.mCoordinateReferencySystem = CRS.getDefault().parseWkt(this.mDataSet.getCrsWKT());
            }
        }
        catch (CRSException ex) {
            Logger.getLogger(VrtMapObject.class.getName()).log(Level.SEVERE, null, ex);
        }
        int numberOfBands = this.mDataSet.getNumberOfBands();
        WorldRect myExtents = null;
        for (int i = 1; i < numberOfBands + 1; ++i) {
            VRTRasterBand rasterBand = this.mDataSet.getRasterBand(1);
            List sources = rasterBand.getSources();
            for (ComplexSource complexSource : sources) {
                String sourceFilePath = complexSource.getSourceFilePath();
                MapObject mo = MapObjectFactory.newMapObject(this.getFileOpener(), new Identifier(sourceFilePath));
                if (mo == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Undefined Map Object for the following map: " + sourceFilePath);
                    continue;
                }
                mo.load();
                WorldRect extent = mo.getExtent();
                if (myExtents == null) {
                    myExtents = new WorldRect(extent);
                } else {
                    myExtents.grow(extent);
                }
                this.mSubMaps.add(mo);
            }
        }
        if (myExtents != null) {
            this.setExtent(myExtents);
        }
        this._loaded = true;
    }

    public List<MapObject> getMapObjects() {
        return this.mSubMaps;
    }

    @Override
    public FileOpener getFileOpener() {
        FileOpener fo = super.getFileOpener();
        if (fo == null) {
            fo = new SimpleFileOpeners();
        }
        return fo;
    }

    @Override
    public void unload() {
        for (MapObject mapObject : this.mSubMaps) {
            mapObject.unload();
        }
        this.mSubMaps.clear();
        this._loaded = false;
    }

    @Override
    public float getElevation(WorldPt pt) {
        double[] easting = new double[]{pt.e};
        double[] northing = new double[]{pt.n};
        return this.getElevation(northing, easting)[0];
    }

    @Override
    public float[] getElevation(double[] northing, double[] easting) {
        int i;
        int numReturnValue = northing != null ? northing.length : 0;
        int numMaps = 0;
        ArrayList<ElevationMap> gridMaps = new ArrayList<ElevationMap>();
        for (MapObject mapObject : this.mSubMaps) {
            if (!(mapObject instanceof ElevationMap)) continue;
            gridMaps.add((ElevationMap)((Object)mapObject));
        }
        numMaps = gridMaps.size();
        float[] values = new float[numReturnValue];
        Arrays.fill(values, new Double(this.getNoDataValue()).floatValue());
        if (numMaps == 0) {
            return values;
        }
        double[][] tempValuesNorthing = new double[numMaps][100];
        double[][] tempValuesEasting = new double[numMaps][100];
        int[] lengthOfArray = new int[numMaps];
        int[][] valueIndex = new int[numMaps][100];
        Arrays.fill(lengthOfArray, 0);
        for (i = 0; i < numMaps; ++i) {
            Arrays.fill(valueIndex[i], -1);
            Arrays.fill(tempValuesEasting[i], this.getNoDataValue());
            Arrays.fill(tempValuesNorthing[i], this.getNoDataValue());
        }
        for (i = 0; i < numReturnValue; ++i) {
            boolean contains = false;
            for (int j = 0; j < numMaps; ++j) {
                WorldRect extent;
                ElevationMap map = (ElevationMap)gridMaps.get(j);
                if (map == null || (extent = map.getExtent()) == null || !(contains = extent.contains(easting[i], northing[i]))) continue;
                if (lengthOfArray[j] >= tempValuesEasting[j].length) {
                    double[] temp = tempValuesEasting[j];
                    tempValuesEasting[j] = new double[tempValuesEasting[j].length * 2];
                    Arrays.fill(tempValuesEasting[j], this.getNoDataValue());
                    System.arraycopy(temp, 0, tempValuesEasting[j], 0, temp.length);
                    temp = tempValuesNorthing[j];
                    tempValuesNorthing[j] = new double[tempValuesNorthing[j].length * 2];
                    Arrays.fill(tempValuesNorthing[j], this.getNoDataValue());
                    System.arraycopy(temp, 0, tempValuesNorthing[j], 0, temp.length);
                    int[] tempI = valueIndex[j];
                    valueIndex[j] = new int[valueIndex[j].length * 2];
                    Arrays.fill(valueIndex[j], -1);
                    System.arraycopy(tempI, 0, valueIndex[j], 0, tempI.length);
                }
                tempValuesNorthing[j][lengthOfArray[j]] = northing[i];
                tempValuesEasting[j][lengthOfArray[j]] = easting[i];
                valueIndex[j][lengthOfArray[j]] = i;
                int n = j;
                lengthOfArray[n] = lengthOfArray[n] + 1;
            }
        }
        float[][] tempReturnValues = new float[numMaps][0];
        for (int j = 0; j < numMaps; ++j) {
            tempReturnValues[j] = ((ElevationMap)gridMaps.get(j)).getElevation(tempValuesNorthing[j], tempValuesEasting[j]);
            for (int i2 = 0; i2 < lengthOfArray[j]; ++i2) {
                if (valueIndex[j][i2] == -1 || valueIndex[j][i2] >= values.length || (double)tempReturnValues[j][i2] == ((ElevationMap)gridMaps.get(j)).getNoDataValue()) continue;
                double value = tempReturnValues[j][i2];
                if (values[valueIndex[j][i2]] != (float)this.getNoDataValue()) continue;
                values[valueIndex[j][i2]] = (float)value;
            }
        }
        return values;
    }

    @Override
    public double getMaximumElevation() {
        if (!this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(VrtMapObject.class.getName()).log(Level.SEVERE, null, ex);
                return 0.0;
            }
        }
        double minValue = Double.MIN_VALUE;
        for (int i = 0; i < this.mDataSet.getNumberOfBands(); ++i) {
            String minValueObj = this.mDataSet.getRasterBand(i + 1).getMetaDataItem("STATISTICS_MAXIMUM");
            double minValueItem = RMAIO.parseDouble((Object)minValueObj, 0.0);
            if (!(minValueItem > minValue)) continue;
            minValue = minValueItem;
        }
        return minValue != Double.MIN_VALUE ? minValue : 0.0;
    }

    @Override
    public double getMinimumElevation() {
        if (!this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(VrtMapObject.class.getName()).log(Level.SEVERE, null, ex);
                return 0.0;
            }
        }
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < this.mDataSet.getNumberOfBands(); ++i) {
            String minValueObj = this.mDataSet.getRasterBand(i + 1).getMetaDataItem("STATISTICS_MINIMUM");
            double minValueItem = RMAIO.parseDouble((Object)minValueObj, 0.0);
            if (!(minValueItem < minValue)) continue;
            minValue = minValueItem;
        }
        return minValue != Double.MAX_VALUE ? minValue : 0.0;
    }

    @Override
    public double getNoDataValue() {
        if (!this._loaded) {
            try {
                this.load();
            }
            catch (IOException ex) {
                Logger.getLogger(VrtMapObject.class.getName()).log(Level.SEVERE, null, ex);
                return 0.0;
            }
        }
        return this.mDataSet.getRasterBand(1).getNoDataValue();
    }
}

