/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.event.DataChangeEvent;
import hec.event.LockEvent;
import hec.io.DBFMappingClass;
import hec.io.DBFSerializable;
import hec.model.AbstractDataObject;
import hec.model.CommonDataList;
import java.lang.reflect.Field;

public abstract class AbstractDBFObject
extends AbstractDataObject
implements DBFSerializable {
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static String ID_TAG = "ID_TAG";
    protected static String NAME_TAG = "TAG_NAME";
    protected String FD_ID = "FD_ID";
    protected String FD_NAME = "FD_NAME";
    public int NAME_SIZE = 64;
    public int DESC_SIZE = 64;
    protected DBFMappingClass _dbfMap = null;

    public AbstractDBFObject() {
        this.createMappingInfo();
    }

    public AbstractDBFObject(long id, CommonDataList datalist) {
        this();
        this._id = id;
        this._dataList = datalist;
    }

    protected void createMappingInfo() {
        if (this._dbfMap == null) {
            this._dbfMap = new DBFMappingClass();
        }
        this._dbfMap.addDbfMap("_id", this.FD_ID, 'N', 8, 0, false, ID_TAG, this.FD_ID, ".NOT. DELETED()", (byte)20, false);
        this._dbfMap.addDbfMap("_name", this.FD_NAME, "Name", 'C', this.NAME_SIZE, 0, true, NAME_TAG, "UPPER(FD_NAME)", ".NOT. DELETED()", (byte)20, false);
        this._dbfMap.addDbfMap("_description", "FD_DESC", "Description", 'M', this.DESC_SIZE, 0, true, null, null, null, (byte)0, false);
        this._dbfMap.add(DBFMappingClass.createMappingClass(this.getClass()));
    }

    @Override
    public DBFMappingClass getMappingInformation() {
        return this._dbfMap;
    }

    @Override
    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Object obj = this._dataList.loadObject(this);
            if (obj instanceof AbstractDBFObject) {
                this.copyInto((AbstractDBFObject)obj);
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this.setModified(false);
        }
        return this._loaded;
    }

    @Override
    public String getIDTag() {
        return ID_TAG;
    }

    @Override
    public long getId() {
        return super.getId();
    }

    @Override
    public String getNameTag() {
        return NAME_TAG;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void locked(LockEvent le) {
    }

    @Override
    public void DataChanged(DataChangeEvent e) {
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

