/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.model.CommonDataList;
import hec.model.DataList;
import hec.model.DataObject;
import hec.model.DataStruct;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import rma.swing.table.AbstractRmaTableModel;
import rma.util.Contains;
import rma.util.RMAIO;

public abstract class AbstractDataListTableModel
extends AbstractRmaTableModel {
    protected boolean _committingTable;
    protected CommonDataList m_dataList = null;
    protected List m_objects;
    protected List m_tempObjects;
    protected boolean m_commitImmediatly = false;
    protected Component m_parentComponent = null;
    protected int m_currentEditRow = -1;

    public AbstractDataListTableModel() {
    }

    public AbstractDataListTableModel(CommonDataList dl) {
        this.m_dataList = dl;
        this.m_objects = new Vector<DataStruct>(Arrays.asList(this.m_dataList.getObjectArray()));
        this.m_tempObjects = new Vector(this.m_objects.size());
        this.m_columnNames = new String[0];
        for (int i = 0; i < this.m_objects.size(); ++i) {
            this.m_tempObjects.add(null);
        }
        this.addRow();
    }

    public AbstractDataListTableModel(DataList dl) {
        this((CommonDataList)dl);
    }

    @Override
    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.m_tempObjects == null) {
            return 0;
        }
        return this.m_tempObjects.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public int firstIndexOf(String match, int index, boolean wrap, boolean wholeWord, boolean caseSensitive) {
        int ii;
        if (index < 0 || index >= this.m_tempObjects.size()) {
            return -1;
        }
        Contains contains = new Contains(wholeWord);
        if (!caseSensitive) {
            match = match.toUpperCase();
        }
        for (ii = index; ii < this.m_tempObjects.size(); ++ii) {
            if (!this.matchDelegateIndex(ii, match, caseSensitive, contains)) continue;
            return ii;
        }
        if (!wrap) {
            return -1;
        }
        for (ii = 0; ii < index; ++ii) {
            if (!this.matchDelegateIndex(ii, match, caseSensitive, contains)) continue;
            return ii;
        }
        return -1;
    }

    public int lastIndexOf(String match, int index, boolean wholeWord, boolean caseSensitive) {
        if (index < 0 || index >= this.m_tempObjects.size()) {
            return -1;
        }
        Contains contains = new Contains(wholeWord);
        if (!caseSensitive) {
            match = match.toUpperCase();
        }
        for (int ii = index; ii >= 0; --ii) {
            if (!this.matchDelegateIndex(ii, match, caseSensitive, contains)) continue;
            return ii;
        }
        return -1;
    }

    private boolean matchDelegateIndex(int delegateIndex, String match, boolean caseSensitive, Contains contains) {
        String delegateString;
        DataObject dobj = (DataObject)this.m_tempObjects.get(delegateIndex);
        if (dobj == null) {
            if (delegateIndex >= this.m_objects.size()) {
                return false;
            }
            dobj = (DataObject)this.m_objects.get(delegateIndex);
            if (dobj == null) {
                return false;
            }
        }
        if ((delegateString = dobj.getName()) == null) {
            return false;
        }
        if (!caseSensitive) {
            delegateString = delegateString.toUpperCase();
        }
        return contains.contains(delegateString, match);
    }

    @Override
    public String getColumnName(int column) {
        if (column < 0 || column > this.m_columnNames.length - 1) {
            return "";
        }
        return this.m_columnNames[column];
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void addColumn(String str) {
    }

    @Override
    public void addColumn(String colName, Vector data) {
    }

    public void addRow() {
        this.addRow(this.m_tempObjects);
    }

    protected void addRow(List tempList) {
        DataObject dobjLast = null;
        DataObject dobjNextToLast = null;
        if (tempList == null) {
            return;
        }
        if (tempList.size() > 0) {
            dobjLast = (DataObject)tempList.get(tempList.size() - 1);
        }
        if (tempList.size() > 1) {
            dobjNextToLast = (DataObject)tempList.get(tempList.size() - 2);
        }
        if (dobjLast != null && dobjLast.getName().trim().length() == 0 && dobjNextToLast != null && dobjNextToLast.getName().trim().length() == 0) {
            return;
        }
        DataObject dobj = this.m_dataList.newDataObject("", "");
        tempList.add(dobj);
        this.fireTableDataChanged();
    }

    @Override
    public void addRow(Vector data) {
        this.addRow();
    }

    @Override
    public void setColumnNames(Vector colNames) {
        if (colNames == null) {
            return;
        }
        this.m_columnNames = new String[colNames.size()];
        colNames.copyInto(this.m_columnNames);
    }

    @Override
    public void setColumnNames(String[] colNames) {
        if (colNames == null) {
            return;
        }
        this.m_columnNames = colNames;
    }

    @Override
    public void setColumnParameters(int[] params) {
    }

    @Override
    public int getColumnParameter(int col) {
        return -1;
    }

    @Override
    public int getUnitSystem() {
        return this.m_dataList.getUnitSystem();
    }

    @Override
    public void deleteRow(int row) {
        if (row < 0 || row >= this.m_tempObjects.size()) {
            return;
        }
        DataObject dobj = (DataObject)this.m_tempObjects.get(row);
        if (!this.isValidRecord(dobj)) {
            this.m_tempObjects.remove(row);
            this.fireTableRowsDeleted(row, row);
            return;
        }
        int result = RMAIO.postYesNoWarning(this.m_parentComponent, "Are you sure you want to delete record - " + dobj.getName());
        if (result == 1) {
            return;
        }
        if (dobj.getId() != Long.MIN_VALUE && !this.m_dataList.removeObject(dobj.getId())) {
            RMAIO.postError(this.m_parentComponent, "An Error Occurred while trying to delete the record - " + dobj.getName());
            return;
        }
        this.m_tempObjects.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public void setRowEnabled(boolean enabled, int row) {
    }

    @Override
    public void setColEnabled(boolean enabled, int col) {
    }

    @Override
    public void setColumnClass(int col, Class cls) {
    }

    @Override
    public void clearAll() {
    }

    @Override
    public Vector getRow(int row) {
        return new Vector();
    }

    @Override
    public void insertRow(int row, Vector data) {
        if (row < 0 || row >= this.m_tempObjects.size()) {
            return;
        }
        DataObject dobj = this.m_dataList.newDataObject("", "");
        this.m_tempObjects.add(row, dobj);
        this.fireTableRowsInserted(row, row);
    }

    @Override
    public Vector getDataVector() {
        return new Vector();
    }

    public void commitImmediatly(boolean ci) {
        this.m_commitImmediatly = ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTable() {
        try {
            this._committingTable = true;
            DataObject[] dobjs = new DataObject[this.m_tempObjects.size()];
            this.m_tempObjects.toArray(dobjs);
            for (int i = 0; i < dobjs.length; ++i) {
                if (dobjs[i] == null) continue;
                boolean committed = this.commitDataObject(dobjs[i]);
                if (!committed) {
                    this.m_tempObjects.remove(dobjs[i]);
                    this.fireTableRowsDeleted(i, i);
                    continue;
                }
                if (i < this.m_objects.size()) {
                    this.m_objects.set(i, dobjs[i]);
                    continue;
                }
                this.m_objects.add(dobjs[i]);
            }
            this.addRow();
        }
        finally {
            this._committingTable = false;
        }
        return true;
    }

    public boolean commitDataObject(DataObject dobj) {
        if (dobj == null) {
            throw new IllegalArgumentException("NULL Object in AbstractDataListTableModel commitDataObject()!");
        }
        boolean valid = this.isValidRecord(dobj);
        if (!valid) {
            return false;
        }
        if (dobj.getId() != Long.MIN_VALUE && dobj.getName().trim().length() == 0) {
            return this.m_dataList.removeObject(dobj.getId());
        }
        if (dobj.getId() != Long.MIN_VALUE) {
            return this.m_dataList.saveObject(dobj);
        }
        if (dobj.getId() == Long.MIN_VALUE && this.m_dataList.doesExist(dobj.getName())) {
            RMAIO.postError(this.m_parentComponent, "The name " + dobj.getName() + " already exists. \nPlease choose another name.");
            return false;
        }
        this.m_dataList.addNewObject(dobj);
        return true;
    }

    public void setParentComponent(Component c2) {
        this.m_parentComponent = c2;
    }

    public boolean uniqueNameInEditBuffer(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < this.m_tempObjects.size(); ++i) {
            DataObject dobj = (DataObject)this.m_tempObjects.get(i);
            if (dobj == null || !dobj.getName().equalsIgnoreCase(name) || dobj.getName().equals("")) continue;
            return true;
        }
        return false;
    }

    public boolean isValidRecord(DataObject dobj) {
        if (dobj == null) {
            return false;
        }
        return dobj.getId() != Long.MIN_VALUE || !dobj.getName().equals("");
    }

    public void clearEdits() {
        if (this._committingTable) {
            return;
        }
        this.clearList(this.m_tempObjects, this.m_objects);
        this.fireTableDataChanged();
    }

    protected void clearList(List tempList, List objectsList) {
        if (tempList == null || objectsList == null) {
            return;
        }
        tempList.clear();
        for (int i = 0; i < objectsList.size(); ++i) {
            tempList.add(null);
        }
        this.addRow(tempList);
    }
}

