/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.event.AbstractDataListener;
import hec.event.DataChangeEvent;
import hec.event.DataChangeListener;
import hec.event.LockEvent;
import hec.event.LockListener;
import hec.io.AsciiSerializable;
import hec.lang.DataObjectReference;
import hec.lang.NamedType;
import hec.model.CommonDataList;
import hec.model.CommonDataListContainer;
import hec.model.DataObject;
import hec.model.DataStruct;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.util.Vector;

public abstract class AbstractDataObject
extends NamedType
implements DataObject,
AsciiSerializable {
    static final long serialVersionUID = -2323954421457016036L;
    protected long _id = Long.MIN_VALUE;
    protected transient CommonDataList _dataList = null;
    protected Vector _objRefs = null;
    protected transient boolean _loaded = false;
    protected transient Vector _observerList = null;
    protected transient boolean _outOfDateData = false;
    protected transient boolean _isLocked = false;
    protected transient DataObject _parent = null;
    transient int _refCnt = 0;
    protected transient PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);

    public AbstractDataObject() {
    }

    public AbstractDataObject(long id, CommonDataList datalist) {
        this();
        this._id = id;
        this._dataList = datalist;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this._propertyChangeSupport.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeSupport(PropertyChangeListener listener) {
        this._propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeSupport(String property, PropertyChangeListener listener) {
        this._propertyChangeSupport.removePropertyChangeListener(property, listener);
    }

    @Override
    public boolean setId(long id) {
        this._id = id;
        return true;
    }

    @Override
    public long getId() {
        return this._id;
    }

    public CommonDataListContainer getCommonDataListContainer() {
        return this._dataList.getCommonDataListContainer();
    }

    @Override
    public boolean setDataList(CommonDataList datalist) {
        this._dataList = datalist;
        return true;
    }

    public int getGmtOffset() {
        return this._dataList.getGmtOffset();
    }

    public int getUnitSystem() {
        return this._dataList.getUnitSystem();
    }

    @Override
    public CommonDataList getDataList() {
        return this._dataList;
    }

    @Override
    public boolean loadId() {
        return true;
    }

    @Override
    public boolean loadData() {
        if (this._loaded) {
            return true;
        }
        if (this._objRefs != null) {
            for (int i = 0; i < this._objRefs.size(); ++i) {
                DataObjectReference ref = (DataObjectReference)this._objRefs.elementAt(i);
                if (ref == null || !ref.isLoadable() || ref.loadObjectRef(this)) continue;
                ref.setLoadable(false);
            }
        }
        this._outOfDateData = false;
        return true;
    }

    @Override
    public DataObjectReference[] getObjectReferences() {
        if (this._objRefs == null) {
            return null;
        }
        Object[] refs = new DataObjectReference[this._objRefs.size()];
        this._objRefs.copyInto(refs);
        return refs;
    }

    @Override
    public boolean addObjectReference(DataObjectReference ref) {
        if (this._objRefs == null) {
            this._objRefs = new Vector();
        }
        if (ref == null || this._objRefs.contains(ref)) {
            return false;
        }
        this._objRefs.addElement(ref);
        return true;
    }

    @Override
    public void removeObjectReference(int pos) {
        if (this._objRefs == null || this._objRefs.size() < pos) {
            return;
        }
        try {
            DataObjectReference dor = (DataObjectReference)this._objRefs.elementAt(pos);
            if (dor != null) {
                dor.loadObjectRef(this);
                DataObject obj = (DataObject)dor.getObject();
                if (obj != null) {
                    obj.decrementRefCnt();
                }
                this._objRefs.removeElement(dor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeObjectReference(DataObjectReference ref) {
        if (this._objRefs == null || ref == null) {
            return;
        }
        try {
            if (!this._objRefs.contains(ref)) {
                return;
            }
            ref.loadObjectRef(this);
            DataObject obj = (DataObject)ref.getObject();
            if (obj != null) {
                obj.decrementRefCnt();
            }
            this._objRefs.removeElement(ref);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean save() {
        this._dataList.saveObject(this);
        if (this._objRefs != null) {
            for (int i = 0; i < this._objRefs.size(); ++i) {
                DataObjectReference ref = (DataObjectReference)this._objRefs.elementAt(i);
                DataObject dObj = (DataObject)ref.getObject();
                if (dObj == null) continue;
                dObj.save();
            }
        }
        return true;
    }

    @Override
    public void addObserver(AbstractDataListener doo) {
        if (this._observerList == null) {
            this._observerList = new Vector();
        }
        if (this._observerList.contains(doo)) {
            return;
        }
        this._observerList.addElement(doo);
    }

    @Override
    public void removeObserver(AbstractDataListener doo) {
        if (this._observerList != null) {
            this._observerList.removeElement(doo);
        }
    }

    @Override
    public void reload() {
        DataChangeEvent event = new DataChangeEvent(2, this.getId(), "", this.getClass().getName());
        this.fireDataChangeEvent(event);
        this._outOfDateData = true;
    }

    @Override
    public void delete() {
        DataChangeEvent event = new DataChangeEvent(3, this.getId(), "", this.getClass().getName());
        this.fireDataChangeEvent(event);
    }

    public void fireDataChangeEvent(DataChangeEvent dce) {
        if (dce == null) {
            return;
        }
        for (int i = 0; this._observerList != null && i < this._observerList.size(); ++i) {
            AbstractDataListener adl = (AbstractDataListener)this._observerList.elementAt(i);
            if (!(adl instanceof DataChangeListener)) continue;
            DataChangeListener dcl = (DataChangeListener)adl;
            dcl.DataChanged(dce);
        }
    }

    @Override
    public void DataChanged(DataChangeEvent event) {
    }

    @Override
    public void locked(boolean lock, String user) {
        if (this._observerList == null || this._observerList.size() == 0) {
            return;
        }
        LockEvent event = new LockEvent(this.getId(), user, this.getClass().getName(), lock);
        this.setLocked(lock);
        for (int i = 0; i < this._observerList.size(); ++i) {
            AbstractDataListener adl = (AbstractDataListener)this._observerList.elementAt(i);
            if (!(adl instanceof LockListener)) continue;
            LockListener ll = (LockListener)adl;
            ll.locked(event);
        }
    }

    public void setLocked(boolean locked) {
        this._isLocked = locked;
    }

    public boolean getLocked() {
        return this._isLocked;
    }

    @Override
    public DataStruct getData() {
        return null;
    }

    @Override
    public boolean isLoaded() {
        return this._loaded;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this._objRefs == null) {
            return;
        }
        for (int i = 0; i < this._objRefs.size(); ++i) {
            DataObjectReference ref = (DataObjectReference)this._objRefs.elementAt(i);
            ref.loadObjectRef(this);
            DataObject obj = (DataObject)ref.getObject();
            obj.setName(name);
        }
    }

    @Override
    public void setDescription(String desc) {
        super.setDescription(desc);
        if (this._objRefs == null) {
            return;
        }
        for (int i = 0; i < this._objRefs.size(); ++i) {
            DataObjectReference ref = (DataObjectReference)this._objRefs.elementAt(i);
            ref.loadObjectRef(this);
            DataObject obj = (DataObject)ref.getObject();
            obj.setDescription(desc);
        }
    }

    @Override
    public void setParent(DataObject parent) {
        this._parent = parent;
    }

    @Override
    public DataObject getParent() {
        return this._parent;
    }

    @Override
    public void incrementRefCnt() {
        ++this._refCnt;
    }

    @Override
    public void decrementRefCnt() {
        --this._refCnt;
    }

    @Override
    public int getRefCnt() {
        return this._refCnt;
    }

    @Override
    public void copyInto(DataObject dobj) {
        if (dobj == null) {
            return;
        }
        this.setName(dobj.getName());
        this.setDescription(dobj.getDescription());
        this.setId(dobj.getId());
    }

    @Override
    public void setModified(boolean b) {
        super.setModified(b);
        if (b && this._dataList != null && !this.getIgnoreModifiedEvents()) {
            this._dataList.setModified(b);
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

