/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.intArrayContainer;
import hec.hecmath.computation.ComputationException;
import hec.hecmath.functions.TimeSeriesFunctions;
import hec.io.DSSArrayContainer;
import hec.io.DSSIdentifier;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerVertDatum;
import hec.lang.Const;
import hec.lang.DSSPathString;
import hec.lang.NamedType;
import hec.lang.annotation.Scriptable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumContainer;
import mil.army.usace.hec.metadata.VerticalDatumException;
import rma.util.RMAConst;
import rma.util.RMAIO;

public abstract class AbstractTSRecord
extends NamedType
implements TSRecord,
VerticalDatum {
    private static final Logger logger = Logger.getLogger(AbstractTSRecord.class.getName());
    public static final boolean INPUT = true;
    public static final boolean OUTPUT = false;
    protected int _varId = Integer.MIN_VALUE;
    protected String _paramName = null;
    protected String _dssFilename = null;
    protected String _dssPathname = null;
    protected String _units = null;
    protected int _inputDataPos = 0;
    protected transient boolean _isObservedData = false;
    protected transient String _unitsType = null;
    protected transient String _interpUnitsType = null;
    protected transient int _beginDate;
    protected transient int _beginTime;
    protected transient int _timeStepMin;
    protected transient int _numSteps;
    protected transient String _timeWindow;
    protected transient String _timeIncrString;
    protected transient HecTime _startTime;
    protected transient HecTime _endTime;
    protected transient int _size;
    protected transient DSSArrayContainer _dssArray = null;
    protected transient intArrayContainer _timeArray = new intArrayContainer();
    protected transient doubleArrayContainer _dataArray = new doubleArrayContainer();
    protected transient VerticalDatumContainer _vdc = null;
    protected boolean _compressData = false;
    private TimeSeriesContainer _tsContainer;

    public AbstractTSRecord() {
    }

    public AbstractTSRecord(int idx) {
        this._index = idx;
    }

    public AbstractTSRecord(AbstractTSRecord rec) {
        this._paramName = rec.getParamName();
        this._dssFilename = rec.getDSSFilename();
        this._dssPathname = rec.getDSSPathname();
        this._units = rec.getUnits();
        this._unitsType = rec.getUnitsType();
        this.initialize(rec.getBeginDate(), rec.getBeginTime(), rec.getTimeStepMinutes(), rec.getNumSteps(), rec.getTimeWindowString());
    }

    public boolean copyInto(AbstractTSRecord newTsRec) {
        if (newTsRec == null) {
            return false;
        }
        boolean rtn = true;
        newTsRec._varId = this._varId;
        newTsRec._paramName = this._paramName;
        newTsRec._dssFilename = this._dssFilename;
        newTsRec._dssPathname = this._dssPathname;
        newTsRec._units = this._units;
        newTsRec._inputDataPos = this._inputDataPos;
        newTsRec._isObservedData = this._isObservedData;
        newTsRec._unitsType = this._unitsType;
        newTsRec._interpUnitsType = this._interpUnitsType;
        newTsRec._beginDate = this._beginDate;
        newTsRec._beginTime = this._beginTime;
        newTsRec._timeStepMin = this._timeStepMin;
        newTsRec._numSteps = this._numSteps;
        newTsRec._timeWindow = this._timeWindow;
        newTsRec._timeIncrString = this._timeIncrString;
        newTsRec._startTime = this._startTime != null ? new HecTime(this._startTime) : null;
        newTsRec._endTime = this._endTime != null ? new HecTime(this._endTime) : null;
        newTsRec._size = this._size;
        if (this._dssArray != null) {
            (newTsRec._dssArray = new DSSArrayContainer((DSSIdentifier)this._dssArray)).dataArray = this._dssArray.dataArray != null ? Arrays.copyOf(this._dssArray.dataArray, this._dssArray.dataArray.length) : null;
            newTsRec._dssArray.timeArray = this._dssArray.timeArray != null ? Arrays.copyOf(this._dssArray.timeArray, this._dssArray.timeArray.length) : null;
            newTsRec._dssArray.granularity = this._dssArray.granularity;
            newTsRec._dssArray.numberRead = this._dssArray.numberRead;
            newTsRec._dssArray.numberValues = this._dssArray.numberValues;
        }
        newTsRec._timeArray = this._timeArray != null ? new intArrayContainer(Arrays.copyOf(this._timeArray.array, this._timeArray.array.length)) : null;
        newTsRec._dataArray = this._dataArray != null ? new doubleArrayContainer(Arrays.copyOf(this._dataArray.array, this._dataArray.array.length)) : null;
        newTsRec._vdc = this._vdc;
        newTsRec._compressData = this._compressData;
        if (this._dataArray != null && this._tsContainer != null) {
            newTsRec.getTimeSeriesContainerFor(0, this._dataArray.array.length);
        }
        return rtn;
    }

    @Override
    public void setInterpUnitsType(String type) {
        this._interpUnitsType = type;
    }

    @Override
    public String getInterpUnitsType() {
        return this._interpUnitsType;
    }

    @Override
    public void shiftLeft(RunTimeWindow rtw) {
        if (rtw == null) {
            return;
        }
        if (this._timeArray == null || this._timeArray.length == 0) {
            return;
        }
        HecTime time = null;
        if (this._startTime == null) {
            time = new HecTime();
            time.setJulian(this._beginDate + 1, this._beginTime);
        } else {
            time = new HecTime(this._startTime.value(), 1);
        }
        int[] tempTimeArray = new int[this._timeArray.length];
        for (int i = 0; i < tempTimeArray.length; ++i) {
            tempTimeArray[i] = time.value();
            time.add(this._timeStepMin);
        }
        this._numSteps = rtw.getNumSteps();
        this._timeWindow = rtw.getTimeWindowString();
        this._timeIncrString = rtw.getTimeStepString(0);
        this._timeStepMin = rtw.getTimeStepMinutes();
        this._size = this._numSteps + 1;
        int minutes = rtw.getLookbackTime().value();
        int diff = minutes - tempTimeArray[0];
        int oldEndTimeValue = tempTimeArray[tempTimeArray.length - 1];
        int numval = tempTimeArray.length;
        int m0 = tempTimeArray[0];
        int m1 = tempTimeArray[numval - 1];
        long x1 = minutes - m0;
        long x2 = numval - 1;
        long numerator = x1 * x2;
        int value = 0;
        value = m1 - m0 == 0 ? numval - 1 : (int)(numerator / (long)(m1 - m0));
        if (value < 0) {
            return;
        }
        this._timeArray.shiftLeft(value);
        this._dataArray.shiftLeft(value);
        this._timeArray.resize(this._size);
        this._dataArray.resize(this._size);
        if (this._startTime == null) {
            this._startTime = new HecTime();
        }
        if (this._endTime == null) {
            this._endTime = new HecTime();
        }
        this._startTime.set(minutes);
        this._endTime.set(oldEndTimeValue + diff);
        this._beginDate = this._startTime.julian();
        this._beginTime = this._startTime.minute();
        this._timeWindow = this._startTime.dateAndTime(4) + " " + this._endTime.dateAndTime(4);
    }

    @Override
    public void shiftLeft(HecTime startTime) {
        if (startTime == null) {
            return;
        }
        int minutes = startTime.value();
        if (this._timeArray == null || this._timeArray.length == 0) {
            return;
        }
        int diff = minutes - this._timeArray.array[0];
        int oldEndTimeValue = this._timeArray.array[this._timeArray.array.length - 1];
        int numval = this._timeArray.length;
        int m0 = this._timeArray.array[0];
        int m1 = this._timeArray.array[numval - 1];
        long x1 = minutes - m0;
        long x2 = numval - 1;
        long numerator = x1 * x2;
        int value = 0;
        value = m1 - m0 == 0 ? numval - 1 : (int)(numerator / (long)(m1 - m0));
        if (value < 0) {
            return;
        }
        this._timeArray.shiftLeft(value);
        this._dataArray.shiftLeft(value);
        if (this._startTime == null) {
            this._startTime = new HecTime();
        }
        if (this._endTime == null) {
            this._endTime = new HecTime();
        }
        this._startTime.set(minutes);
        this._endTime.set(oldEndTimeValue + diff);
        RunTimeWindow rtw = new RunTimeWindow(this._startTime, this._endTime, this._startTime);
        this._timeWindow = this._startTime.dateAndTime(4) + " " + this._endTime.dateAndTime(4);
    }

    @Override
    public void setVariableId(int varid) {
        this._varId = varid;
    }

    @Override
    public int getVariableId() {
        return this._varId;
    }

    @Override
    public synchronized Object clone() {
        try {
            AbstractTSRecord oc = (AbstractTSRecord)super.clone();
            return oc;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public double[] getSummaryArray() {
        int i;
        if (this._dataArray == null || this._dataArray.length <= 0) {
            return null;
        }
        double[] array = new double[4];
        for (i = 0; i < 4; ++i) {
            array[i] = -3.4028234663852886E38;
        }
        double[] data = this._dataArray.array;
        array[3] = 0.0;
        for (i = 0; i < data.length; ++i) {
            if (data[i] == -3.4028234663852886E38) continue;
            array[0] = array[0] == -3.4028234663852886E38 ? data[i] : array[0] + data[i];
            if (array[1] == -3.4028234663852886E38 || array[1] > data[i]) {
                array[1] = data[i];
            }
            if (array[2] == -3.4028234663852886E38 || array[2] < data[i]) {
                array[2] = data[i];
            }
            array[3] = array[3] + 1.0;
        }
        if (array[3] < 1.0) {
            return null;
        }
        array[0] = array[0] / array[3];
        return array;
    }

    @Override
    public int getNumSteps() {
        return this._numSteps;
    }

    @Override
    public void setTimeWindowString(String timestr) {
        this._timeWindow = timestr;
    }

    @Override
    public String getTimeWindowString() {
        return this._timeWindow;
    }

    @Override
    public void setTimeWindow(HecTime start, HecTime end) {
        this._startTime = start;
        this._endTime = end;
    }

    @Override
    public void setUnits(String units) {
        this._units = units;
    }

    @Override
    public String getUnits() {
        if (this._units == null) {
            return "";
        }
        return this._units;
    }

    @Override
    public void setUnitsType(String dataType) {
        this._unitsType = dataType;
    }

    @Override
    public int getBeginDate() {
        return this._beginDate;
    }

    @Override
    public int getBeginTime() {
        return this._beginTime;
    }

    @Override
    public int getTimeStepMinutes() {
        return this._timeStepMin;
    }

    @Override
    public String getUnitsType() {
        if (this._unitsType == null) {
            return "";
        }
        return this._unitsType;
    }

    @Override
    public int[] getTimeArray() {
        return this._timeArray.array;
    }

    @Override
    @Scriptable
    public double[] getDataArrayFor(int step, int period) {
        if (!this.fillTSContainer(step, period)) {
            return null;
        }
        return this._tsContainer.values;
    }

    @Override
    @Scriptable
    public double[] getTSArray() {
        return this._dataArray.array;
    }

    @Override
    public doubleArrayContainer getTSContainer() {
        return this._dataArray;
    }

    @Override
    public void reset() {
        this._beginDate = 0;
        this._beginTime = 0;
        this._startTime = null;
        this._endTime = null;
        this._numSteps = 0;
        this._timeWindow = null;
        this._timeIncrString = null;
        this._timeStepMin = 0;
        this._size = 0;
        this._timeArray = new intArrayContainer();
        this._dataArray = new doubleArrayContainer();
    }

    @Override
    public boolean initialize(RunTimeWindow rtw) {
        this._beginDate = rtw.getLookbackTime().julian();
        this._beginTime = rtw.getLookbackTime().minute();
        this._startTime = (HecTime)rtw.getLookbackTime().clone();
        this._endTime = (HecTime)rtw.getEndTime().clone();
        this._numSteps = rtw.getNumSteps();
        this._timeWindow = rtw.getTimeWindowString();
        this._timeIncrString = rtw.getTimeStepString(0);
        this._timeStepMin = rtw.getTimeStepMinutes();
        this._size = this._numSteps + 1;
        this._timeArray.setSize(this._size);
        this._dataArray.setSize(this._size);
        for (int i = 0; i <= this._numSteps; ++i) {
            this._dataArray.array[i] = -3.4028234663852886E38;
        }
        return true;
    }

    @Override
    public boolean reinitialize(RunTimeWindow rtw) {
        this._beginDate = rtw.getLookbackTime().julian();
        this._beginTime = rtw.getLookbackTime().minute();
        this._numSteps = rtw.getNumSteps();
        this._timeWindow = rtw.getTimeWindowString();
        this._startTime = rtw.getLookbackTime();
        this._endTime = rtw.getEndTime();
        this._size = this._numSteps + 1;
        this._timeArray.setSize(this._size);
        this._dataArray.setSize(this._size);
        for (int i = 0; i <= this._numSteps; ++i) {
            this._dataArray.array[i] = -3.4028234663852886E38;
        }
        return true;
    }

    @Override
    public boolean initialize(int beginDate, int beginTime, int timeStepMin, int numSteps, String timeWindow) {
        this._beginDate = beginDate;
        this._beginTime = beginTime;
        this._timeStepMin = timeStepMin;
        this._numSteps = numSteps;
        this._timeWindow = timeWindow;
        this._startTime = null;
        this._endTime = null;
        this._timeIncrString = HecTimeSeriesBase.getEPartFromInterval(timeStepMin);
        this._size = this._numSteps + 1;
        this._timeArray.setSize(this._size);
        this._dataArray.setSize(this._size);
        for (int i = 0; i < this._size; ++i) {
            this._dataArray.array[i] = -3.4028234663852886E38;
        }
        return true;
    }

    @Override
    public String getParamName() {
        if (this._paramName == null) {
            return "";
        }
        return this._paramName;
    }

    @Override
    public void setParamName(String name) {
        this._paramName = name;
    }

    @Override
    public String getDSSPathname() {
        if (this._dssPathname == null) {
            return "";
        }
        return this._dssPathname;
    }

    @Override
    public void setDSSPathname(String name) {
        this._dssPathname = name;
    }

    @Override
    public void setDSSPathname(String[] parts) {
        if (parts.length < 6) {
            return;
        }
        Object name = "/";
        for (int i = 0; i < 6; ++i) {
            name = (String)name + parts[i] + "/";
        }
        this._dssPathname = name;
    }

    @Override
    public String getDSSFilename() {
        if (this._dssFilename == null) {
            return "";
        }
        return this._dssFilename;
    }

    @Override
    public void setDSSFilename(String name) {
        this._dssFilename = name;
    }

    @Override
    public void setInputDataPos(int inputPos) {
        this._inputDataPos = inputPos;
    }

    @Override
    public int getInputDataPos() {
        return this._inputDataPos;
    }

    @Override
    public boolean isObservedData() {
        return this._inputDataPos == -1;
    }

    @Override
    public boolean isDefaultData() {
        return this._inputDataPos == 0;
    }

    @Override
    public boolean readData(BufferedReader input) {
        try {
            String line = input.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = input.readLine();
                    continue;
                }
                if (line.indexOf("TSRecord") < 0) break;
                String type = RMAIO.getType(line, "=");
                String param = RMAIO.getParam(line, "=").trim();
                if (type.compareTo("TSRecord Name") == 0) {
                    this.setName(param);
                } else if (type.compareTo("TSRecord VariableId") == 0) {
                    this._varId = RMAIO.parseInt(param);
                } else if (type.compareTo("TSRecord ParamName") == 0) {
                    this._paramName = param;
                } else if (type.compareTo("TSRecord DssFilename") == 0) {
                    this._dssFilename = param;
                } else if (type.compareTo("TSRecord DssPathname") == 0) {
                    this._dssPathname = param;
                } else if (type.compareTo("TSRecord InputPosition") == 0) {
                    this._inputDataPos = RMAIO.parseInt(param, 0);
                } else if (type.compareTo("TSRecord ObservedData") == 0) {
                    this._inputDataPos = "true".equals(param) ? -1 : 0;
                } else if (type.compareTo("TSRecord End") == 0) break;
                line = input.readLine();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public abstract String getRelativePath(String var1);

    @Override
    public boolean writeData(BufferedWriter out) {
        try {
            out.write("TSRecord Name=" + this.getName());
            out.newLine();
            out.write("TSRecord VariableId=" + Integer.toString(this.getVariableId()));
            out.newLine();
            out.write("TSRecord ParamName=" + this.getParamName());
            out.newLine();
            out.write("TSRecord DssFilename=" + this.getRelativePath(this.getDSSFilename()));
            out.newLine();
            out.write("TSRecord DssPathname=" + this.getDSSPathname());
            out.newLine();
            out.write("TSRecord InputPosition=" + this._inputDataPos);
            out.newLine();
            out.write("TSRecord End=");
            out.newLine();
        }
        catch (IOException e) {
            System.out.println("Failed write tsrecord");
            return false;
        }
        return true;
    }

    @Override
    public boolean readDataFromRas(BufferedReader input) {
        try {
            String line = input.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = input.readLine();
                    continue;
                }
                if (line.indexOf("TSRecord") < 0) break;
                String type = RMAIO.getType(line, "=");
                String param = RMAIO.getParam(line, "=").trim();
                if (type.compareTo("TSRecord Loc") == 0) {
                    this.setName(param);
                }
                if (type.compareTo("TSRecord Name") == 0) {
                    this.setName(param);
                } else if (type.compareTo("TSRecord DssFilename") == 0) {
                    this._dssFilename = param;
                } else if (type.compareTo("TSRecord DssPathname") == 0) {
                    this._dssPathname = param;
                } else if (type.compareTo("TSRecord InputPosition") == 0) {
                    this._inputDataPos = RMAIO.parseInt(param, 0);
                } else if (type.compareTo("TSRecord End") == 0) break;
                line = input.readLine();
            }
            String dssPathname = this.getDSSPathname();
            DSSPathString dssPathString = new DSSPathString(dssPathname);
            String cPart = dssPathString.getCPart();
            this.setParamName(cPart);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean writeDataToRas(BufferedWriter out) {
        try {
            out.write("TSRecord Loc=" + this.getName());
            out.newLine();
            String dssfil = this.getRelativePath(this.getDSSFilename());
            if (dssfil.equalsIgnoreCase("forecast.dss")) {
                dssfil = "..\\forecast.dss";
            }
            out.write("TSRecord DssFilename=" + dssfil);
            out.newLine();
            out.write("TSRecord DssPathname=" + this.getDSSPathname());
            out.newLine();
            out.write("TSRecord InputPosition=" + this.getInputDataPos());
            out.newLine();
            out.write("TSRecord End");
            out.newLine();
        }
        catch (IOException e) {
            System.out.println("Failed write tsrecord");
            return false;
        }
        return true;
    }

    @Override
    @Scriptable
    public double getValue(HecTime time) {
        if (time == null || this._dataArray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        int minutes = time.julian() * 1440 + time.minutesSinceMidnight();
        int numval = this._timeArray.array.length;
        int m0 = this._timeArray.array[0];
        int m1 = this._timeArray.array[numval - 1];
        if (Const.isUndefined(m0) && Const.isUndefined(m1) && this._startTime != null && this._endTime != null && this._startTime.isDefined() && this._endTime.isDefined() && Const.isDefined(this._timeStepMin)) {
            int tStep;
            long findTime = time.getMinutes();
            long sTimeMinutes = this._startTime.getMinutes();
            long eTimeMinutes = this._endTime.getMinutes();
            if (sTimeMinutes <= findTime && eTimeMinutes >= findTime && (tStep = (int)(findTime - sTimeMinutes) / this._timeStepMin) > 0 && tStep < this._dataArray.array.length) {
                return this._dataArray.array[tStep];
            }
        }
        if (minutes < m0 || minutes > m1) {
            return Double.NEGATIVE_INFINITY;
        }
        long x1 = minutes - m0;
        long x2 = numval - 1;
        long numerator = x1 * x2;
        int i = (int)(numerator / (long)(m1 - m0));
        if (i >= numval) {
            return -3.4028234663852886E38;
        }
        int mi = this._timeArray.array[i];
        if (minutes - mi == 0) {
            double val = this._dataArray.array[i];
            return val;
        }
        if (i + 1 >= numval) {
            return -3.4028234663852886E38;
        }
        int mi1 = this._timeArray.array[i + 1];
        double val = this._dataArray.array[i] + (this._dataArray.array[i + 1] - this._dataArray.array[i]) * (double)(minutes - mi) / (double)(mi1 - mi);
        return val;
    }

    @Override
    @Deprecated
    public double getTSValueAt(HecTime time) {
        return this.getValue(time);
    }

    @Override
    public double[] getInterpolatedTSArray(HecTime startTime, HecTime endTime, int intervalTime) {
        int i;
        int numval = this._timeArray.array.length;
        if (numval < 1) {
            return null;
        }
        HecTime tstart = new HecTime(this._timeArray.array[0], 1);
        HecTime tend = new HecTime(this._timeArray.array[numval - 1], 1);
        long ltstart = (long)tstart.julian() * 86400L + (long)tstart.secondsSinceMidnight();
        long ltend = (long)tend.julian() * 86400L + (long)tend.secondsSinceMidnight();
        long lstartTime = (long)startTime.julian() * 86400L + (long)startTime.secondsSinceMidnight();
        long lendTime = (long)endTime.julian() * 86400L + (long)endTime.secondsSinceMidnight();
        if (ltstart < lstartTime) {
            tstart = startTime;
        }
        if (ltend > lendTime) {
            tend = endTime;
        }
        int numSteps = 0;
        HecTime curtime = new HecTime(tstart);
        while (curtime.lessThanEqualTo(tend)) {
            ++numSteps;
            curtime.add(intervalTime);
        }
        double[] array = new double[numSteps];
        for (i = 0; i < numSteps; ++i) {
            array[i] = -3.4028234663852886E38;
        }
        curtime = new HecTime(tstart);
        for (i = 0; i < numSteps; ++i) {
            array[i] = this.getTSValueAt(curtime);
            curtime.add(intervalTime);
        }
        return array;
    }

    public static String[] parseDssPath(String dsspath) {
        DSSPathname pathname = new DSSPathname(dsspath);
        String[] parts = pathname.getParts();
        return parts;
    }

    @Override
    @Scriptable
    public double getCurrentValue(RunTimeStep rts) {
        if (rts == null) {
            return -3.4028234663852886E38;
        }
        return this.getValue(rts.step);
    }

    @Override
    @Scriptable
    public double getValue(int step) {
        if (this._dataArray == null || this._dataArray.array == null) {
            System.out.println("getValue: no data");
            return -3.4028234663852886E38;
        }
        if (step >= this._dataArray.array.length) {
            step = this._dataArray.array.length - 1;
        }
        if (step < 0) {
            step = 0;
        }
        return this._dataArray.array[step];
    }

    @Override
    @Scriptable
    public void setCurrentValue(RunTimeStep rts, double value) {
        if (rts == null) {
            return;
        }
        this.setCurrentValue(rts.step, value);
    }

    @Override
    @Scriptable
    public void setCurrentValue(int step, double value) {
        if (this._dataArray == null || this._dataArray.array == null) {
            logger.warning("setCurrentValue: no data");
            return;
        }
        if (step >= this._dataArray.array.length || step < 0) {
            logger.warning("setCurrentValue: invalid step");
            return;
        }
        this._dataArray.array[step] = value;
    }

    @Override
    @Scriptable
    public double getLaggedValue(RunTimeStep rts, int lagAmount) {
        if (rts == null) {
            return -3.4028234663852886E38;
        }
        lagAmount = Math.abs(lagAmount);
        return this.getValue(rts.step - lagAmount);
    }

    @Override
    @Scriptable
    public double getPreviousValue(RunTimeStep rts) {
        if (rts == null) {
            return -3.4028234663852886E38;
        }
        return this.getValue(rts.step - 1);
    }

    @Scriptable
    public double getPeriodAverage(RunTimeStep rts, int period, int lag) {
        if (rts == null) {
            return -3.4028234663852886E38;
        }
        return this.getPeriodAverage(rts.step - lag, period);
    }

    @Scriptable
    public double getPeriodAverage(int step, int period, int lag) {
        return this.getPeriodAverage(step - lag, period);
    }

    @Override
    @Scriptable
    public double getPeriodAverage(RunTimeStep rts, int period) {
        if (rts == null) {
            return -3.4028234663852886E38;
        }
        return this.getPeriodAverage(rts.step, period);
    }

    @Override
    @Scriptable
    public double getPeriodAverage(int step, int period) {
        if (this._dataArray == null || this._dataArray.array == null) {
            return -3.4028234663852886E38;
        }
        if ((period = Math.abs(period)) == 0) {
            period = 1;
        }
        double sum = 0.0;
        int imax = this._dataArray.array.length - 1;
        for (int j = 0; j < period; ++j) {
            int i = step - j;
            if (i > imax) {
                i = imax;
            }
            if (i < 0) {
                i = 0;
            }
            sum += this._dataArray.array[i];
        }
        return sum / (double)period;
    }

    @Override
    @Scriptable
    public double getCumulativeTotal(RunTimeStep rts, int period) {
        if (rts == null) {
            return -3.4028234663852886E38;
        }
        return this.getCumulativeTotal(rts.step, period);
    }

    @Override
    @Scriptable
    public double getCumulativeTotal(int step, int period) {
        if (this._dataArray == null || this._dataArray.array == null) {
            return -3.4028234663852886E38;
        }
        if ((period = Math.abs(period)) == 0) {
            period = 1;
        }
        double sum = 0.0;
        int imax = this._dataArray.array.length - 1;
        for (int j = 0; j < period; ++j) {
            int i = step - j;
            if (i > imax) {
                i = imax;
            }
            if (i < 0) {
                i = 0;
            }
            sum += this._dataArray.array[i];
        }
        return sum;
    }

    @Override
    @Scriptable
    public TimeSeriesContainer getTimeSeriesContainer() {
        int timeInterval;
        if (this._dataArray == null) {
            return null;
        }
        TimeSeriesContainer tsc = null;
        tsc = this.hasVerticalDatum() ? new TimeSeriesContainerVertDatum() : new TimeSeriesContainer();
        tsc.values = this._dataArray.array;
        tsc.times = this._timeArray.array;
        String ePart = null;
        if (tsc.times != null && tsc.times.length > 0 && RMAConst.isUndefinedValue(tsc.times[0])) {
            Vector<String> pathParts = DSSPathname.parseDssPath(this._dssPathname);
            if (pathParts == null) {
                System.out.println("getTimeSeriesContainer:WARNING null path parts during parsing of " + this._dssPathname);
                return null;
            }
            timeInterval = HecTimeSeriesBase.getIntervalFromEPart(pathParts.get(4));
            if (this._startTime == null) {
                System.out.println("getTimeSeriesContainer:WARNING null start time for " + this._dssPathname);
                return null;
            }
            int numberValues = this._startTime.computeNumberIntervals(this._endTime, timeInterval) + 1;
            if (numberValues < 0) {
                System.out.println("getTimeSeriesContainer:WARNING invalid number of values" + numberValues + " for " + this._dssPathname);
                return null;
            }
            tsc.times = new int[numberValues];
            if (this._endTime == null) {
                System.out.println("getTimeSeriesContainer:WARNING null end time for " + this._dssPathname);
                return null;
            }
            int endTimeValue = this._endTime.value();
            int icount = 0;
            HecTime htime = new HecTime(this._startTime);
            for (int i = 0; i < numberValues; ++i) {
                tsc.times[i] = htime.value();
                htime.increment(1, timeInterval);
                ++icount;
            }
        } else if (tsc.times != null) {
            ePart = HecTimeSeriesBase.getAppropriateEPart(tsc.times);
        }
        DSSPathname dssPath = new DSSPathname();
        dssPath.setPathname(this._dssPathname);
        if (ePart != null && !ePart.isEmpty()) {
            dssPath.setEPart(ePart);
            tsc.interval = timeInterval = HecTimeSeriesBase.getIntervalFromEPart(ePart);
            tsc.fullName = dssPath.getPathname();
        } else {
            tsc.fullName = this._dssPathname;
        }
        tsc.fileName = this._dssFilename;
        tsc.watershed = dssPath.aPart();
        tsc.location = dssPath.bPart();
        tsc.parameter = dssPath.cPart();
        tsc.version = dssPath.fPart();
        if (this._units != null) {
            tsc.units = this._units;
        }
        if (this._unitsType != null) {
            tsc.type = this._unitsType;
        }
        tsc.numberValues = tsc.values != null ? tsc.values.length : 0;
        if (this.hasVerticalDatum()) {
            try {
                TimeSeriesContainerVertDatum tscvd = new TimeSeriesContainerVertDatum(tsc, this._vdc);
                tscvd.forceVerticalDatum(this._vdc.getCurrentVerticalDatum());
                return tscvd;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tsc;
    }

    @Override
    @Scriptable
    public double max(int step, int period) {
        if (!this.fillTSContainer(step, period)) {
            return -3.4028234663852886E38;
        }
        try {
            return TimeSeriesFunctions.max(this._tsContainer);
        }
        catch (ComputationException ce) {
            return -3.4028234663852886E38;
        }
    }

    @Override
    @Scriptable
    public double min(int step, int period) {
        if (!this.fillTSContainer(step, period)) {
            return -3.4028234663852886E38;
        }
        if (this._tsContainer.values.length == 0 || this._tsContainer.values == null) {
            return -3.4028234663852886E38;
        }
        try {
            return TimeSeriesFunctions.min(this._tsContainer);
        }
        catch (ComputationException ce) {
            return -3.4028234663852886E38;
        }
    }

    @Override
    @Scriptable
    public double average(int step, int period) {
        if (!this.fillTSContainer(step, period)) {
            return -3.4028234663852886E38;
        }
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < this._tsContainer.values.length; ++i) {
            if (this._tsContainer.values[i] == -3.4028234663852886E38) continue;
            sum += this._tsContainer.values[i];
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    @Scriptable
    public double sum(int step, int period) {
        if (!this.fillTSContainer(step, period)) {
            return -3.4028234663852886E38;
        }
        try {
            return TimeSeriesFunctions.sum(this._tsContainer);
        }
        catch (ComputationException ce) {
            return -3.4028234663852886E38;
        }
    }

    @Override
    public double standardDeviation(int step, int period) {
        if (!this.fillTSContainer(step, period)) {
            return -3.4028234663852886E38;
        }
        try {
            return TimeSeriesFunctions.standardDeviation(this._tsContainer);
        }
        catch (ComputationException ce) {
            return -3.4028234663852886E38;
        }
    }

    private boolean fillTSContainer(int step, int period) {
        int[] time;
        double[] data;
        if (this._tsContainer == null || this._dataArray == null || this._dataArray.array == null) {
            if (this.hasVerticalDatum()) {
                this._tsContainer = new TimeSeriesContainerVertDatum();
                try {
                    ((TimeSeriesContainerVertDatum)this._tsContainer).setVerticalDatumInfo(this._dssArray.getVerticalDatumInfo());
                }
                catch (Exception exception) {}
            } else {
                this._tsContainer = new TimeSeriesContainer();
            }
        }
        if (step < 0 || step >= this._dataArray.length) {
            return false;
        }
        int timeSteps = Math.abs(period);
        int size = timeSteps + 1;
        int pos = step + period;
        if (pos >= this._dataArray.length) {
            size = this._dataArray.length - step;
        } else if (pos < 0) {
            size = step + 1;
        }
        if (this._tsContainer.times != null && this._tsContainer.times.length == size) {
            data = this._tsContainer.values;
            time = this._tsContainer.times;
        } else {
            data = new double[size];
            time = new int[size];
        }
        for (int i = 0; i < size; ++i) {
            if (period > 0) {
                if (step + i >= this._dataArray.array.length) continue;
                data[i] = this._dataArray.array[step + i];
                time[i] = this._timeArray.array[step + i];
                continue;
            }
            data[size - i - 1] = this._dataArray.array[step - i];
            time[size - i - 1] = this._timeArray.array[step - i];
        }
        this._tsContainer.startTime = step;
        if (time.length < 0) {
            this._tsContainer.endTime = time[time.length - 1];
        }
        this._tsContainer.interval = this._timeStepMin;
        this._tsContainer.times = time;
        this._tsContainer.values = data;
        this._tsContainer.type = this._unitsType;
        this._tsContainer.units = this._units;
        this._tsContainer.parameter = this._paramName;
        DSSPathname dssPath = new DSSPathname();
        dssPath.setPathname(this._dssPathname);
        this._tsContainer.watershed = dssPath.aPart();
        this._tsContainer.location = dssPath.bPart();
        this._tsContainer.version = dssPath.fPart();
        this._tsContainer.fullName = this._dssPathname;
        this._tsContainer.fileName = this._dssFilename;
        this._tsContainer.numberValues = this._tsContainer.values != null ? this._tsContainer.values.length : 0;
        return true;
    }

    @Override
    @Scriptable
    public TimeSeriesContainer getTimeSeriesContainerFor(int step, int period) {
        if (!this.fillTSContainer(step, period)) {
            return null;
        }
        return this._tsContainer;
    }

    public boolean hasVerticalDatum() {
        if (this._vdc == null) {
            if (this._dssArray == null || this._dssArray.getVerticalDatumInfo() == null) {
                return false;
            }
            this._vdc = new VerticalDatumContainer();
            try {
                this._vdc.setVerticalDatumInfo(this._dssArray.getVerticalDatumInfo());
            }
            catch (Exception e) {
                Logger.getLogger(AbstractTSRecord.class.getName()).log(Level.WARNING, "Error setting Vertical Datum:", e);
            }
            return true;
        }
        return true;
    }

    public VerticalDatumContainer getVerticalDatumContainer() {
        if (this._vdc == null && this.hasVerticalDatum()) {
            this._vdc = new VerticalDatumContainer();
            try {
                this._vdc.setVerticalDatumInfo(this._dssArray.getVerticalDatumInfo());
            }
            catch (Exception e) {
                Logger.getLogger(AbstractTSRecord.class.getName()).log(Level.WARNING, "Error setting VerticalDatumInfo:", e);
            }
        }
        return this._vdc;
    }

    public void setVerticalDatumContainer(VerticalDatumContainer vdc) {
        this._vdc = vdc;
    }

    public String getNativeVerticalDatum() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().getNativeVerticalDatum();
    }

    public String getCurrentVerticalDatum() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().getCurrentVerticalDatum();
    }

    public boolean isCurrentVerticalDatumEstimated() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().isCurrentVerticalDatumEstimated();
    }

    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        double offset = this._vdc.getCurrentOffset(this._units);
        boolean change = this._vdc.toNativeVerticalDatum();
        if (change && this._dataArray != null && this._dataArray.array != null) {
            for (int i = 0; i < this._dataArray.array.length; ++i) {
                if (this._dataArray.array[i] == -3.4028234663852886E38) continue;
                int n = i;
                this._dataArray.array[n] = this._dataArray.array[n] - offset;
            }
        }
        return change;
    }

    public boolean toNGVD29() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        double offset = this._vdc.getNGVD29Offset(this._units);
        boolean change = this._vdc.toNGVD29();
        if (change && this._dataArray != null && this._dataArray.array != null) {
            for (int i = 0; i < this._dataArray.array.length; ++i) {
                if (this._dataArray.array[i] == -3.4028234663852886E38) continue;
                int n = i;
                this._dataArray.array[n] = this._dataArray.array[n] + offset;
            }
        }
        return change;
    }

    public boolean toNAVD88() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        double offset = this._vdc.getNAVD88Offset(this._units);
        boolean change = this._vdc.toNAVD88();
        if (change && this._dataArray != null && this._dataArray.array != null) {
            for (int i = 0; i < this._dataArray.array.length; ++i) {
                if (this._dataArray.array[i] == -3.4028234663852886E38) continue;
                int n = i;
                this._dataArray.array[n] = this._dataArray.array[n] + offset;
            }
        }
        return change;
    }

    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        if (datum == null) {
            throw new VerticalDatumException("Null datum specified");
        }
        double offset1 = this._vdc.getCurrentOffset();
        boolean change = this._vdc.toVerticalDatum(datum);
        if (change) {
            double offset2 = this._vdc.getCurrentOffset();
            for (int i = 0; i < this._dataArray.array.length; ++i) {
                if (this._dataArray.array[i] == -3.4028234663852886E38) continue;
                int n = i;
                this._dataArray.array[n] = this._dataArray.array[n] + (offset2 - offset1);
            }
        }
        return change;
    }

    public boolean forceVerticalDatum(String datum) throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        if (datum == null) {
            throw new VerticalDatumException("Null datum specified");
        }
        return this._vdc.forceVerticalDatum(datum);
    }

    public double getCurrentOffset() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().getCurrentOffset();
    }

    public double getCurrentOffset(String unit) throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().getCurrentOffset(unit);
    }

    public double getNGVD29Offset() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().getNGVD29Offset();
    }

    public double getNGVD29Offset(String unit) throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().getNGVD29Offset(unit);
    }

    public double getNAVD88Offset() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().getNAVD88Offset();
    }

    public double getNAVD88Offset(String unit) throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().getNAVD88Offset(unit);
    }

    public boolean isNGVD29OffsetEstimated() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().isNGVD29OffsetEstimated();
    }

    public boolean isNAVD88OffsetEstimated() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().isNAVD88OffsetEstimated();
    }

    public String getVerticalDatumInfo() throws VerticalDatumException {
        if (!this.hasVerticalDatum()) {
            throw new VerticalDatumException("Embedded data does not have vertical datum information");
        }
        return this.getVerticalDatumContainer().getVerticalDatumInfo();
    }

    public void setVerticalDatumInfo(String xmlStr) throws VerticalDatumException {
        if (this._dssArray == null) {
            this._dssArray = new DSSArrayContainer();
        }
        this._dssArray.setVerticalDatumInfo(xmlStr);
        this.getVerticalDatumContainer();
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            if (fobj instanceof String && ((String)fobj).length() < 1) {
                return true;
            }
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    @Override
    public void setCompressData(boolean comp) {
        this._compressData = comp;
    }

    static {
        System.loadLibrary("javaHeclib");
    }
}

