/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import com.google.common.flogger.FluentLogger;
import hec.heclib.util.HecTime;
import hec.lang.DSSPathString;
import hec.model.MessagePrinter;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.model.TSRecordCreator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import rma.util.RMAIO;

public class BaseTSDataSet {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    long _lastModifiedTime = Long.MAX_VALUE;
    String _name = "";
    String _description = "";
    public static final int INST = 0;
    public static final int PER_AVG = 1;
    public static final int PER_CUM = 2;
    public static final String SUMMARY_DELIM = "|";
    int _type = 0;
    String _parentPath;
    String _parentClassName;
    MessagePrinter _messagePrinter = null;
    Vector<TSRecord> _tsRecordVector = new Vector();
    TSRecordCreator _tsRecordCreator = null;
    private transient String _altName;

    public void setAltName(String name) {
        this._altName = name;
    }

    public String getAltName() {
        return this._altName;
    }

    public void setTSRecordCreator(TSRecordCreator cls) {
        this._tsRecordCreator = cls;
    }

    public List<TSRecord> getTSRecordList() {
        return this._tsRecordVector;
    }

    public long getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setMessagePrinter(MessagePrinter printer) {
        this._messagePrinter = printer;
    }

    public int getTSRecordCount() {
        return this._tsRecordVector == null ? 0 : this._tsRecordVector.size();
    }

    public Hashtable getTSRecordSummaryTable(String typestr) {
        Hashtable<CallSite, double[]> table = new Hashtable<CallSite, double[]>();
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            TSRecord rec = this._tsRecordVector.get(i);
            double[] summaryArray = rec.getSummaryArray();
            if (summaryArray == null) continue;
            table.put((CallSite)((Object)(typestr + SUMMARY_DELIM + rec.getName() + SUMMARY_DELIM + rec.getParamName())), summaryArray);
        }
        return table;
    }

    public void setParentPath(String path, String classname) {
        this._parentPath = path;
        this._parentClassName = classname;
    }

    public String getParentPath() {
        return this._parentPath;
    }

    public String getParentClassName() {
        return this._parentClassName;
    }

    public int getType() {
        return this._type;
    }

    public boolean setType(int t) {
        if (t < 0 || t > 2) {
            return false;
        }
        this._type = t;
        return true;
    }

    public boolean appendTSRecords(BaseTSDataSet tsdataset) {
        for (int i = 0; i < tsdataset._tsRecordVector.size(); ++i) {
            TSRecord rec = tsdataset._tsRecordVector.get(i);
            TSRecord tempRec = this.getTSRecord(rec.getName(), rec.getParamName());
            if (tempRec != null && tempRec.getDSSPathname().equalsIgnoreCase(rec.getDSSPathname())) continue;
            this._tsRecordVector.add(rec);
        }
        return true;
    }

    public void init() {
    }

    public Vector<TSRecord> getTSRecords() {
        return this._tsRecordVector;
    }

    public TSRecord getTSRecord(String name, int varid) {
        if (name == null || name.length() == 0) {
            return null;
        }
        TSRecord tsrec = null;
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            tsrec = this._tsRecordVector.get(i);
            if (tsrec == null || name.compareTo(tsrec.getName()) != 0 || varid != tsrec.getVariableId()) continue;
            return tsrec;
        }
        return null;
    }

    public TSRecord getTSRecord(String name, String param) {
        if (name == null || name.length() == 0 || param == null || param.length() == 0) {
            return null;
        }
        TSRecord tsrec = null;
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            tsrec = this._tsRecordVector.get(i);
            if (tsrec == null || name.compareTo(tsrec.getName()) != 0 || !param.equalsIgnoreCase(tsrec.getParamName())) continue;
            return tsrec;
        }
        return null;
    }

    public TSRecord getTSRecordByPathParts(String bPart, String cPart) {
        if (bPart == null || bPart.length() == 0 || cPart == null || cPart.length() == 0) {
            return null;
        }
        TSRecord tsrec = null;
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            tsrec = this._tsRecordVector.get(i);
            if (tsrec == null || tsrec.getDSSPathname() == null || tsrec.getDSSPathname().trim().length() < 1) continue;
            String[] parts = DSSPathString.parsePathname(tsrec.getDSSPathname());
            if (parts == null) {
                return null;
            }
            if (!bPart.equalsIgnoreCase(parts[1]) || !cPart.equalsIgnoreCase(parts[2])) continue;
            return tsrec;
        }
        return null;
    }

    public void reset() {
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            TSRecord rec = this._tsRecordVector.get(i);
            if (rec == null) continue;
            rec.reset();
        }
    }

    public boolean initialize(int beginDate, int beginTime, int timeStepMin, int numSteps, String timeWindow) {
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            TSRecord rec = this._tsRecordVector.get(i);
            if (rec == null || rec.initialize(beginDate, beginTime, timeStepMin, numSteps, timeWindow)) continue;
            return false;
        }
        return true;
    }

    public boolean initialize(RunTimeWindow rtw) {
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            TSRecord rec = this._tsRecordVector.get(i);
            if (rec == null || rec.initialize(rtw)) continue;
            if (this._messagePrinter != null) {
                this._messagePrinter.printErrorMessage("ERROR: failed to initialize time-series record " + rec.getName());
            }
            return false;
        }
        return true;
    }

    public boolean reinitialize(RunTimeWindow rtw) {
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            TSRecord rec = this._tsRecordVector.get(i);
            if (rec == null || rec.reinitialize(rtw)) continue;
            if (this._messagePrinter != null) {
                this._messagePrinter.printErrorMessage("ERROR: failed to initialize time-series record " + rec.getName());
            }
            return false;
        }
        return true;
    }

    public boolean reLoadFile(BufferedReader reader) {
        this._tsRecordVector.clear();
        return this.readFile(reader);
    }

    public boolean readFile(BufferedReader input) {
        if (input == null) {
            return false;
        }
        this._tsRecordVector.clear();
        int maxTSRecord = -1;
        try {
            String line = input.readLine();
            while (line != null) {
                int idx;
                if (line.length() == 0) {
                    line = input.readLine();
                    continue;
                }
                String type = RMAIO.getType(line, "=");
                String param = RMAIO.getParam(line, "=");
                if (type.compareTo("TSDataSet Name") == 0) {
                    this.setName(param);
                } else if (type.compareTo("Description") == 0) {
                    String desc = param.replace('|', '\n');
                    this.setDescription(desc);
                } else if (type.compareTo("_type") == 0) {
                    this._type = RMAIO.parseInt(param);
                } else if (type.compareTo("ParentPath") == 0) {
                    this._parentPath = param;
                } else if (type.compareTo("ParentClass") == 0) {
                    this._parentClassName = param;
                } else if (type.compareTo("ModifiedTime") == 0) {
                    this._lastModifiedTime = RMAIO.parseLong(param, Long.MAX_VALUE);
                } else if (type.compareTo("TSRecord") == 0 && (idx = RMAIO.parseInt(param)) != Integer.MIN_VALUE) {
                    int size = this._tsRecordVector.size();
                    if (idx + 1 > size) {
                        this._tsRecordVector.setSize(idx + 50);
                    }
                    if (this._tsRecordVector.get(idx) != null) {
                        if (this._messagePrinter != null) {
                            this._messagePrinter.printErrorMessage("Warning! Duplicate Time Series " + idx + " ignored.");
                        }
                    } else {
                        TSRecord tsRecord = this._tsRecordCreator.createTSRecord();
                        tsRecord.setIndex(idx);
                        if (tsRecord.readData(input)) {
                            this._tsRecordVector.set(idx, tsRecord);
                            if (idx > maxTSRecord) {
                                maxTSRecord = idx;
                            }
                        } else if (this._messagePrinter != null) {
                            this._messagePrinter.printErrorMessage("Error reading data for TSRecord " + idx);
                        }
                    }
                }
                line = input.readLine();
            }
            input.close();
        }
        catch (IOException e) {
            if (this._messagePrinter != null) {
                this._messagePrinter.printErrorMessage("Failed to open file ");
            }
            return false;
        }
        this._tsRecordVector.setSize(++maxTSRecord);
        this._tsRecordVector.trimToSize();
        if (this._messagePrinter != null) {
            this._messagePrinter.printLogMessage("TSDataSet Dimensions:\n" + maxTSRecord + " TSRecords");
        }
        return true;
    }

    public boolean writeDataToRas(BufferedWriter out) {
        if (out == null) {
            return false;
        }
        String strout = new String();
        try {
            for (int i = 0; i < this._tsRecordVector.size(); ++i) {
                TSRecord rec = this._tsRecordVector.elementAt(i);
                if (rec == null) continue;
                int idx = rec.getIndex() + 1;
                out.write("TSRecord=" + Integer.toString(idx));
                out.newLine();
                rec.writeDataToRas(out);
                out.newLine();
            }
            out.newLine();
        }
        catch (IOException e) {
            if (this._messagePrinter != null) {
                this._messagePrinter.printErrorMessage("Failed in output to BufferedWriter in TSDataSet.writeData() ");
            }
            return false;
        }
        return true;
    }

    public boolean readDataFromRas(BufferedReader input) {
        int maxTSRecord = -1;
        int corr = -1;
        if (input == null) {
            return false;
        }
        try {
            String line = input.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = input.readLine();
                    continue;
                }
                String type = RMAIO.getType(line, "=");
                String param = RMAIO.getParam(line, "=");
                if (type.compareTo("TSDataSet Name") == 0) {
                    this.setName(param);
                    corr = 0;
                } else if (type.compareTo("Description") == 0) {
                    String desc = param.replace('|', '\n');
                    this.setDescription(desc);
                } else if (type.compareTo("TSRecord") == 0) {
                    int idx = RMAIO.parseInt(param);
                    if ((idx += corr) != Integer.MIN_VALUE) {
                        int size = this._tsRecordVector.size();
                        if (idx + 1 > size) {
                            this._tsRecordVector.setSize(idx + 50);
                        }
                        if (this._tsRecordVector.elementAt(idx) != null) {
                            if (this._messagePrinter != null) {
                                this._messagePrinter.printErrorMessage("Warning! Duplicate Controller " + idx + " ignored.");
                            }
                        } else {
                            TSRecord tsRecord = this._tsRecordCreator.createTSRecord();
                            tsRecord.setIndex(idx);
                            if (tsRecord.readDataFromRas(input)) {
                                this._tsRecordVector.setElementAt(tsRecord, idx);
                                if (idx > maxTSRecord) {
                                    maxTSRecord = idx;
                                }
                            } else if (this._messagePrinter != null) {
                                this._messagePrinter.printErrorMessage("Error reading data for TSRecord " + idx);
                            }
                        }
                    }
                }
                line = input.readLine();
            }
        }
        catch (IOException e) {
            if (this._messagePrinter != null) {
                this._messagePrinter.printErrorMessage("Failed in read of BufferedRead in TSDataSet.readData() ");
            }
            return false;
        }
        this._tsRecordVector.setSize(++maxTSRecord);
        this._tsRecordVector.trimToSize();
        if (this._messagePrinter != null) {
            this._messagePrinter.printLogMessage("TSDataSet Dimensions:\n" + maxTSRecord + " TSRecords");
        }
        return true;
    }

    public boolean readData(BufferedReader input) {
        int maxTSRecord = -1;
        if (input == null) {
            return false;
        }
        try {
            String line = input.readLine();
            while (line != null) {
                int idx;
                if (line.length() == 0) {
                    line = input.readLine();
                    continue;
                }
                String type = RMAIO.getType(line, "=");
                String param = RMAIO.getParam(line, "=");
                if (type.compareTo("TSDataSet Name") == 0) {
                    this.setName(param);
                } else if (type.compareTo("Description") == 0) {
                    String desc = param.replace('|', '\n');
                    this.setDescription(desc);
                } else if (type.compareTo("ParentPath") == 0) {
                    this._parentPath = param.trim();
                } else if (type.compareTo("ParentClass") == 0) {
                    this._parentClassName = param.trim();
                } else if (type.compareTo("TSRecord") == 0 && (idx = RMAIO.parseInt(param)) != Integer.MIN_VALUE) {
                    int size = this._tsRecordVector.size();
                    if (idx + 1 > size) {
                        this._tsRecordVector.setSize(idx + 50);
                    }
                    if (this._tsRecordVector.get(idx) != null) {
                        if (this._messagePrinter != null) {
                            this._messagePrinter.printErrorMessage("Warning! Duplicate Time Series " + idx + " ignored.");
                        }
                    } else {
                        TSRecord tsRecord = this._tsRecordCreator.createTSRecord();
                        tsRecord.setIndex(idx);
                        if (tsRecord.readData(input)) {
                            this._tsRecordVector.set(idx, tsRecord);
                            if (idx > maxTSRecord) {
                                maxTSRecord = idx;
                            }
                        } else if (this._messagePrinter != null) {
                            this._messagePrinter.printErrorMessage("Error reading data for TSRecord " + idx);
                        }
                    }
                }
                line = input.readLine();
            }
        }
        catch (IOException e) {
            if (this._messagePrinter != null) {
                this._messagePrinter.printErrorMessage("Failed in read of BufferedRead in TSDataSet.readData() ");
            }
            return false;
        }
        this._tsRecordVector.setSize(++maxTSRecord);
        this._tsRecordVector.trimToSize();
        if (this._messagePrinter != null) {
            this._messagePrinter.printLogMessage("TSDataSet Dimensions:\n" + maxTSRecord + " TSRecords");
        }
        return true;
    }

    public boolean writeData(BufferedWriter out) {
        if (out == null) {
            return false;
        }
        String strout = new String();
        try {
            out.write("TSDataSet Name=" + this.getName());
            out.newLine();
            out.write("Description=" + this.getDescription());
            out.newLine();
            out.write("ParentPath=" + this._parentPath);
            out.newLine();
            out.write("ParentClass=" + this._parentClassName);
            out.newLine();
            out.newLine();
            for (int i = 0; i < this._tsRecordVector.size(); ++i) {
                TSRecord rec = this._tsRecordVector.elementAt(i);
                if (rec == null) continue;
                out.write("TSRecord=" + Integer.toString(rec.getIndex()));
                out.newLine();
                rec.writeData(out);
                out.newLine();
            }
            out.newLine();
        }
        catch (IOException e) {
            if (this._messagePrinter != null) {
                this._messagePrinter.printErrorMessage("Failed in output to BufferedWriter in TSDataSet.writeData() ");
            }
            return false;
        }
        return true;
    }

    public boolean writeFile(BufferedWriter out) {
        String strout = new String();
        try {
            if (out == null) {
                return false;
            }
            out.write("TSDataSet Name=" + this.getName());
            out.newLine();
            out.write("Description=" + this.getDescription());
            out.newLine();
            out.newLine();
            out.write("_type=" + this._type);
            out.newLine();
            out.write("ParentPath=" + this._parentPath);
            out.newLine();
            out.write("ParentClass=" + this._parentClassName);
            out.newLine();
            for (int i = 0; i < this._tsRecordVector.size(); ++i) {
                TSRecord rec = this._tsRecordVector.elementAt(i);
                if (rec == null) continue;
                out.write("TSRecord=" + Integer.toString(rec.getIndex()));
                out.newLine();
                rec.writeData(out);
                out.newLine();
            }
            out.newLine();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            if (this._messagePrinter != null) {
                this._messagePrinter.printErrorMessage("Failed to open file");
            }
            return false;
        }
        return true;
    }

    public void setCompressData(boolean comp) {
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            TSRecord rec = this._tsRecordVector.elementAt(i);
            if (rec == null) continue;
            rec.setCompressData(comp);
        }
    }

    public boolean writeTSRecords() {
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            TSRecord rec = this._tsRecordVector.elementAt(i);
            if (rec == null || !this.isValidToWrite(rec) || rec.writeTSData()) continue;
            System.out.println("TSDataSet.writeTSRecords(): writeTSData failed getting new DSSFileManager and retry");
        }
        return true;
    }

    public boolean isValidToWrite(TSRecord rec) {
        if (rec.getDSSPathname() == null || rec.getDSSPathname().isEmpty()) {
            ((FluentLogger.Api)LOGGER.atFine()).log("TSRecord " + rec + " missing its DSS Pathname");
            return false;
        }
        if (rec.getDSSFilename() == null || rec.getDSSFilename().isEmpty()) {
            ((FluentLogger.Api)LOGGER.atFine()).log("TSRecord " + rec + " missing its DSS Filename");
            return false;
        }
        return true;
    }

    public boolean loadTSRecords() {
        return this.loadTSRecords(this._tsRecordVector);
    }

    public boolean loadTSRecords(Vector tsrecVec) {
        for (int i = 0; i < tsrecVec.size(); ++i) {
            TSRecord rec = (TSRecord)tsrecVec.elementAt(i);
            if (rec == null || rec.loadTSData()) continue;
            if (this._messagePrinter != null) {
                this._messagePrinter.printErrorMessage("TSDataSet ERROR: failed to load record " + rec.getName());
                this._messagePrinter.printErrorMessage("dssfile " + rec.getDSSFilename());
                this._messagePrinter.printErrorMessage("dsspath " + rec.getDSSPathname());
                this._messagePrinter.printErrorMessage("param " + rec.getParamName());
                this._messagePrinter.printErrorMessage("timewindow " + rec.getTimeWindowString());
            }
            return false;
        }
        return true;
    }

    public TSRecord loadTSRecord(String name, int varId, String timewinstr) {
        TSRecord rec = this.getTSRecord(name, varId);
        if (rec != null) {
            rec.loadTSData();
        }
        return rec;
    }

    public TSRecord loadTSRecord(String name, String param, String timewinstr) {
        TSRecord rec = this.getTSRecord(name, param);
        if (rec != null) {
            rec.loadTSData();
        }
        return rec;
    }

    public boolean checkTSRecords(Vector tsrecVec) {
        boolean problem = false;
        for (int i = 0; i < tsrecVec.size(); ++i) {
            TSRecord rec = (TSRecord)tsrecVec.elementAt(i);
            if (rec == null || rec.checkTSData()) continue;
            if (this._messagePrinter != null) {
                this._messagePrinter.printErrorMessage("TSDataSet ERROR: failed to load record " + rec.getName());
                this._messagePrinter.printErrorMessage("dssfile " + rec.getDSSFilename());
                this._messagePrinter.printErrorMessage("dsspath " + rec.getDSSPathname());
                this._messagePrinter.printErrorMessage("param " + rec.getParamName());
                this._messagePrinter.printErrorMessage("timewindow " + rec.getTimeWindowString());
                this._messagePrinter.printMessage(" ");
            }
            problem = true;
        }
        return !problem;
    }

    public void clearTSRecordList() {
        this._tsRecordVector.removeAllElements();
    }

    public TSRecord createTSRecord(String name, String param) {
        TSRecord rec = this.getTSRecord(name, param);
        if (rec == null) {
            int idx = this._tsRecordVector.size();
            rec = this._tsRecordCreator.createTSRecord();
            rec.setIndex(idx);
            rec.setName(name);
            rec.setParamName(param);
            this._tsRecordVector.addElement(rec);
        }
        return rec;
    }

    public TSRecord createTSRecord(String name, int varid, String param) {
        TSRecord rec = this.getTSRecord(name, varid);
        if (rec == null) {
            int idx = this._tsRecordVector.size();
            rec = this._tsRecordCreator.createTSRecord();
            rec.setIndex(idx);
            rec.setName(name);
            rec.setVariableId(varid);
            rec.setParamName(param);
            this._tsRecordVector.addElement(rec);
        }
        return rec;
    }

    public void unloadTSRecord() {
        this._tsRecordVector.clear();
    }

    public void shiftDataSet(HecTime newStartTime) {
        if (newStartTime == null) {
            return;
        }
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            TSRecord tsrecord = this._tsRecordVector.get(i);
            if (tsrecord == null) continue;
            tsrecord.shiftLeft(newStartTime);
        }
    }

    public void shiftDataSet(RunTimeWindow rtw) {
        if (rtw == null) {
            return;
        }
        for (int i = 0; i < this._tsRecordVector.size(); ++i) {
            TSRecord tsrecord = this._tsRecordVector.get(i);
            if (tsrecord == null) continue;
            tsrecord.shiftLeft(rtw);
        }
    }
}

