/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.model.AbstractConditionalBlockRef;
import hec.model.AndOperator;
import hec.model.Block;
import hec.model.ConditionalBlock;
import hec.model.ConditionalItem;
import hec.model.ConditionalValue;
import hec.model.Expression;
import hec.model.LogicNode;
import hec.model.LogicalOperator;
import hec.model.Operator;
import hec.model.OrOperator;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Conditional
extends NamedType
implements AsciiSerializable {
    public static final int IF_CONDITIONAL = 0;
    public static final int ELSE_IF_CONDITIONAL = 1;
    public static final int ELSE_CONDITIONAL = 2;
    private static final int FIRST_CONDITIONAL = 0;
    private static final int LAST_CONDITIONAL = 2;
    private static final String[] CONDITIONAL_NAMES = new String[]{"IF ", "ELSE IF ", "ELSE "};
    protected List _rulesList = new ArrayList();
    protected List<ConditionalItem> _conditionalList = new ArrayList<ConditionalItem>();
    protected ConditionalBlock _conditionalBlock = null;
    private int _type;
    private transient Iterator m_logicIterator;
    private transient LogicNode _rootNode;
    private transient boolean _errorDuringInit;
    private boolean _treeNodeExpanded = true;

    public Conditional() {
    }

    public Conditional(int conditionalType) {
        if (conditionalType < 0 || conditionalType > 2) {
            throw new IllegalArgumentException("Illegal Conditional type " + conditionalType);
        }
        this._type = conditionalType;
    }

    public void decreaseConditionalObjectPriority(Object obj) {
        int idx = this._rulesList.indexOf(obj);
        if (idx == -1 || idx == this._rulesList.size() - 1) {
            return;
        }
        this._rulesList.remove(obj);
        if (++idx == this._rulesList.size()) {
            this._rulesList.add(obj);
        } else {
            this._rulesList.add(idx, obj);
        }
    }

    public void increaseConditionalObjectPriority(Object obj) {
        int idx = this._rulesList.indexOf(obj);
        if (idx == -1 || idx == 0) {
            return;
        }
        this._rulesList.remove(obj);
        this._rulesList.add(--idx, obj);
    }

    public void moveToBottomPriority(Object obj) {
        if (obj == null) {
            return;
        }
        int idx = this._rulesList.indexOf(obj);
        if (idx == -1) {
            return;
        }
        this._rulesList.remove(obj);
        this._rulesList.add(obj);
    }

    public void moveToTopPriority(Object obj) {
        if (obj == null) {
            return;
        }
        int idx = this._rulesList.indexOf(obj);
        if (idx == -1) {
            return;
        }
        this._rulesList.remove(obj);
        if (this._rulesList.size() == 0) {
            this._rulesList.add(obj);
        } else {
            this._rulesList.add(0, obj);
        }
    }

    public void updateParentData() {
        ConditionalItem obj;
        int i;
        for (i = 0; i < this._conditionalList.size(); ++i) {
            obj = this._conditionalList.get(i);
            if (!(obj instanceof ConditionalItem)) continue;
            obj.updateParentData(this);
        }
        for (i = 0; i < this._rulesList.size(); ++i) {
            obj = this._rulesList.get(i);
            if (obj instanceof ConditionalBlock) {
                ((ConditionalBlock)((Object)obj)).setParent(this);
                continue;
            }
            if (!(obj instanceof AbstractConditionalBlockRef)) continue;
            ConditionalBlock cb = ((AbstractConditionalBlockRef)((Object)obj)).getConditionalBlock();
            if (cb == null) {
                System.out.println("Conditional.updateParentData: ConditionalBlock is null in AbstractConditionalBlockRef");
                continue;
            }
            cb.setParent(this);
        }
    }

    public void setParent(ConditionalBlock cb) {
        this._conditionalBlock = cb;
    }

    public ConditionalBlock getParent() {
        return this._conditionalBlock;
    }

    public NamedType getParentElement() {
        return null;
    }

    public boolean removeCondtionalObject(Object obj) {
        if (obj == null) {
            return false;
        }
        boolean success = false;
        List<ConditionalBlock> conditionalBlocks = this.getContitionalBlocks();
        for (int i = 0; i < conditionalBlocks.size(); ++i) {
            ConditionalBlock cb = conditionalBlocks.get(i);
            List<Conditional> conditionals = cb.getConditionals();
            for (int j = 0; j < conditionals.size(); ++j) {
                Conditional cond = conditionals.get(j);
                success |= cond.removeCondtionalObject(obj);
            }
        }
        if (obj instanceof ConditionalBlock) {
            Iterator iter = this._rulesList.iterator();
            while (iter.hasNext()) {
                AbstractConditionalBlockRef ref;
                Object listItem = iter.next();
                if (!(listItem instanceof AbstractConditionalBlockRef) || (ref = (AbstractConditionalBlockRef)listItem).getConditionalBlock() != obj) continue;
                iter.remove();
                success = true;
                break;
            }
        } else {
            success |= this._rulesList.remove(obj);
        }
        return success;
    }

    @Override
    public Conditional clone() {
        int i;
        Conditional c2;
        try {
            c2 = (Conditional)super.clone();
        }
        catch (Exception ex) {
            return null;
        }
        c2._type = this._type;
        c2._conditionalList = new ArrayList<ConditionalItem>();
        Object newObj = null;
        for (i = 0; i < this._conditionalList.size(); ++i) {
            ConditionalItem obj = this._conditionalList.get(i);
            if (obj instanceof ConditionalItem) {
                newObj = obj.clone();
            }
            if (newObj instanceof ConditionalItem) {
                c2._conditionalList.add((ConditionalItem)newObj);
            }
            newObj = null;
        }
        c2._rulesList = new ArrayList(this._rulesList.size());
        newObj = null;
        for (i = 0; i < this._rulesList.size(); ++i) {
            Object rule = this._rulesList.get(i);
            if (rule instanceof NamedType) {
                try {
                    newObj = ((NamedType)rule).clone();
                }
                catch (CloneNotSupportedException e) {
                    System.out.println("Conditional.clone:" + e);
                }
            }
            if (newObj != null) {
                c2._rulesList.add(newObj);
            }
            newObj = null;
        }
        return c2;
    }

    public int getConditionalType() {
        return this._type;
    }

    public String getConditionalTypeString() {
        if (this._type < 0 || this._type >= CONDITIONAL_NAMES.length) {
            return "undefined";
        }
        return CONDITIONAL_NAMES[this._type];
    }

    public String conditionalTreeToString() {
        LogicNode lNode;
        this.m_logicIterator = this.getConditionalItems().iterator();
        System.setProperty("DEBUG_EXPRESSION_TREE", "true");
        String str = "";
        Block node = (Block)this.buildTree();
        if (node != null && (lNode = node.getChildNode()) != null) {
            str = lNode.toString();
        }
        System.setProperty("DEBUG_EXPRESSION_TREE", "false");
        return str;
    }

    @Override
    public String toString() {
        if (this._type < 0 || this._type >= CONDITIONAL_NAMES.length) {
            return "undefined" + this.getName();
        }
        return CONDITIONAL_NAMES[this._type] + "(" + this.getName() + ")";
    }

    public List getConditionalObjects(boolean evaluateSubBlocks) {
        return this.getConditionalObjects(null, false, null, evaluateSubBlocks);
    }

    public List getConditionalObjects(List objectList, boolean recurse, RunTimeStep rts, boolean evaluateSubBlocks) {
        if (objectList == null) {
            objectList = new ArrayList();
        }
        int size = this._rulesList.size();
        for (int i = 0; i < size; ++i) {
            Object obj = this._rulesList.get(i);
            if (obj instanceof AbstractConditionalBlockRef) {
                obj = ((AbstractConditionalBlockRef)obj).getConditionalBlock();
            }
            if (obj instanceof ConditionalBlock && recurse) {
                if (evaluateSubBlocks) {
                    ((ConditionalBlock)obj).getEvaluatedItems(rts, objectList);
                    continue;
                }
                ((ConditionalBlock)obj).getUnEvaluatedItems(objectList);
                continue;
            }
            objectList.add(obj);
        }
        return objectList;
    }

    public boolean initializeCompute(RunTimeWindow rtw) {
        this.m_logicIterator = null;
        this._errorDuringInit = false;
        int size = this._rulesList != null ? this._rulesList.size() : 0;
        for (int i = 0; i < size; ++i) {
            Object obj = this._rulesList.get(i);
            if (obj instanceof AbstractConditionalBlockRef) {
                obj = ((AbstractConditionalBlockRef)obj).getConditionalBlock();
            }
            if (!(obj instanceof ConditionalBlock) || ((ConditionalBlock)obj).initializeCompute(rtw)) continue;
            System.out.println("initializeCompute:ConditionalBlock " + obj + " failed to initialize");
            return false;
        }
        this._rootNode = this.buildTree();
        return !this._errorDuringInit;
    }

    public boolean evaluate(RunTimeStep rts) {
        if (this._type == 2) {
            return true;
        }
        return this._rootNode.evaluate(rts);
    }

    private LogicNode buildTree() {
        if (this.m_logicIterator == null) {
            this.m_logicIterator = this.getConditionalItems().iterator();
        }
        Block rootNode = new Block();
        if (!this.m_logicIterator.hasNext()) {
            return rootNode;
        }
        int row = 1;
        String name = this.getName();
        if (name == null || name.trim().length() == 0) {
            name = "unnamed";
        }
        NamedType parentElement = this.getParentElement();
        String parentName = "unknown";
        if (parentElement != null) {
            parentName = parentElement.getName();
        }
        while (this.m_logicIterator.hasNext()) {
            ConditionalItem ci = (ConditionalItem)this.m_logicIterator.next();
            ConditionalValue cv = ci.getConditionalValue(0);
            Operator operatorNode = null;
            if (ci.getLogicalOperator() != null) {
                operatorNode = this.createLogicalNodeOperator(ci.getLogicalOperator());
            }
            if (cv.getType() == 4) {
                LogicNode subTreeNode = this.buildTree();
                if (operatorNode == null) {
                    rootNode.setChildNode(subTreeNode);
                    continue;
                }
                operatorNode.setLeftChild(rootNode.getChildNode());
                operatorNode.setRightChild(subTreeNode);
                rootNode.setChildNode(operatorNode);
                continue;
            }
            if (cv.getType() == 5) {
                if (Boolean.getBoolean("DEBUG_EXPRESSION_TREE")) {
                    return rootNode;
                }
                return rootNode.getChildNode();
            }
            if (this._rulesList.size() > 0) {
                ConditionalValue cv2;
                if (ci.getConditionalOperator() == null) {
                    this.printErrorMessage("Missing Operator on Conditional Item for '" + this.getName() + "' at row " + row + " in block '" + this._conditionalBlock + "' for Element " + parentName);
                    this._errorDuringInit = true;
                }
                if (cv.getValue() == null && cv.getType() != 2) {
                    this.printErrorMessage("Missing left Conditional Value for '" + this.getName() + "' at row " + row + " in block '" + this._conditionalBlock + "' for Element " + parentName);
                    this._errorDuringInit = true;
                }
                if ((cv2 = ci.getConditionalValue(1)).getValue() == null && cv2.getType() != 2) {
                    this.printErrorMessage("Missing right Conditional Value for '" + this.getName() + "' at row " + row + " in block '" + this._conditionalBlock + "' for Element " + parentName);
                    this._errorDuringInit = true;
                }
            }
            if (operatorNode != null) {
                operatorNode.setLeftChild(rootNode.getChildNode());
                operatorNode.setRightChild(new Expression(ci));
                rootNode.setChildNode(operatorNode);
            } else {
                rootNode.setChildNode(new Expression(ci));
            }
            ++row;
        }
        if (Boolean.getBoolean("DEBUG_EXPRESSION_TREE")) {
            return rootNode;
        }
        return rootNode.getChildNode();
    }

    protected void printErrorMessage(String msg) {
        System.out.println("ERROR:" + msg);
    }

    private Operator createLogicalNodeOperator(LogicalOperator lop) {
        switch (lop.getOperator()) {
            case 1: {
                return new AndOperator();
            }
            case 2: {
                return new OrOperator();
            }
        }
        return null;
    }

    public void clearConditionalItems() {
        this._conditionalList.clear();
    }

    public void addConditionalItem(ConditionalItem ci) {
        if (ci == null) {
            return;
        }
        this._conditionalList.add(ci);
        this.setModified(true);
    }

    public void addConditionalBlock(ConditionalBlock cb) {
        if (cb == null) {
            return;
        }
        cb.setParent(this);
        this._rulesList.add(cb);
        this.setModified(true);
    }

    public List<ConditionalBlock> getContitionalBlocks() {
        ArrayList<ConditionalBlock> conditionalBlocks = new ArrayList<ConditionalBlock>();
        for (int i = 0; i < this._rulesList.size(); ++i) {
            Object obj = this._rulesList.get(i);
            if (obj instanceof AbstractConditionalBlockRef) {
                obj = ((AbstractConditionalBlockRef)obj).getConditionalBlock();
            }
            if (!(obj instanceof ConditionalBlock)) continue;
            conditionalBlocks.add((ConditionalBlock)obj);
        }
        return conditionalBlocks;
    }

    public List getConditionalChildren() {
        return this._rulesList;
    }

    public ConditionalBlock deleteConditionalBlock(int cbBlockIndex) {
        for (int i = 0; i < this._rulesList.size(); ++i) {
            Object obj = this._rulesList.get(i);
            if (!(obj instanceof ConditionalBlock)) continue;
            if (((ConditionalBlock)obj).getIndex() == cbBlockIndex) {
                this._conditionalList.remove(obj);
                return (ConditionalBlock)obj;
            }
            ((ConditionalBlock)obj).deleteConditionalBlock(cbBlockIndex);
        }
        return null;
    }

    public int getChildCount() {
        return this._conditionalList.size();
    }

    public List getConditionalItems() {
        ArrayList<ConditionalItem> conditionalItems = new ArrayList<ConditionalItem>();
        for (int i = 0; i < this._conditionalList.size(); ++i) {
            ConditionalItem obj = this._conditionalList.get(i);
            if (!(obj instanceof ConditionalItem)) continue;
            conditionalItems.add(obj);
        }
        return conditionalItems;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public boolean shouldTreeNodeExpand() {
        return this._treeNodeExpanded;
    }

    public void setTreeNodeExpanded(boolean expanded) {
        this._treeNodeExpanded = expanded;
    }
}

