/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.model.Conditional;
import hec.model.ConditionalItem;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ConditionalBlock
extends NamedType
implements AsciiSerializable {
    protected List<Conditional> _conditionals = new ArrayList<Conditional>();
    private float _priority;
    Object _parent = null;
    private boolean _treeNodeExpanded = true;

    public ConditionalBlock() {
    }

    public ConditionalBlock(String name) {
        super(name);
    }

    public void setParent(Object obj) {
        this._parent = obj;
        for (int i = 0; i < this._conditionals.size(); ++i) {
            Conditional conditional = this._conditionals.get(i);
            conditional.updateParentData();
        }
    }

    public boolean initializeCompute(RunTimeWindow rtw) {
        int imax = this._conditionals.size();
        for (int i = 0; i < imax; ++i) {
            Conditional conditional = this._conditionals.get(i);
            if (conditional.initializeCompute(rtw)) continue;
            return false;
        }
        return true;
    }

    public void deleteConditionalBlock(int cbBlockIndex) {
        for (int i = 0; i < this._conditionals.size(); ++i) {
            Conditional conditional = this._conditionals.get(i);
            conditional.deleteConditionalBlock(cbBlockIndex);
        }
    }

    public Object getParent() {
        return this._parent;
    }

    public void remove(Conditional cond) {
        if (cond == null) {
            return;
        }
        if (this._conditionals.remove(cond)) {
            return;
        }
        for (int i = 0; i < this._conditionals.size(); ++i) {
            Conditional conditional = this._conditionals.get(i);
            if (conditional.getIndex() != cond.getIndex()) continue;
            this._conditionals.remove(i);
            return;
        }
    }

    @Override
    public ConditionalBlock clone() {
        ConditionalBlock cb;
        try {
            cb = (ConditionalBlock)super.clone();
        }
        catch (Exception ex) {
            return null;
        }
        cb._priority = this._priority;
        cb._conditionals = new ArrayList<Conditional>();
        for (int i = 0; i < this._conditionals.size(); ++i) {
            Conditional cond = this._conditionals.get(i);
            Conditional newCond = cond.clone();
            newCond.setParent(cb);
            cb._conditionals.add(newCond);
        }
        return cb;
    }

    public List getEvaluatedItems(RunTimeStep rts, List objList) {
        return this.getItems(rts, objList, true);
    }

    public List getUnEvaluatedItems(List objList) {
        return this.getItems(null, objList, false);
    }

    private List getItems(RunTimeStep rts, List objList, boolean evaluate) {
        if (objList == null) {
            objList = new Vector();
        }
        for (int i = 0; i < this._conditionals.size(); ++i) {
            Conditional cond = this._conditionals.get(i);
            if (evaluate && !cond.evaluate(rts)) continue;
            cond.getConditionalObjects(objList, true, rts, evaluate);
            if (!evaluate) continue;
            return objList;
        }
        return objList;
    }

    public List<Conditional> getConditionals() {
        return this._conditionals;
    }

    public void clearConditionals() {
        this._conditionals.clear();
    }

    public void setPriority(float priority) {
        this._priority = priority;
    }

    public float getPriority() {
        return this._priority;
    }

    public void addConditional(int index, Conditional c2) {
        if (c2 == null) {
            return;
        }
        c2.setParent(this);
        int type = c2.getConditionalType();
        if (type == 0) {
            if (this._conditionals.size() > 0) {
                if (this._conditionals.get(0).getConditionalType() == 0) {
                    this._conditionals.remove(0);
                }
            }
            this._conditionals.add(0, c2);
            this.setModified(true);
        } else if (type == 1) {
            int realIndex;
            int offset = 0;
            if (index == 0 && this._conditionals.size() > 0 && this._conditionals.get(0).getConditionalType() == 0) {
                offset = 1;
            }
            if (index == this._conditionals.size() && this._conditionals.get(this._conditionals.size() - 1).getConditionalType() == 2) {
                offset = -1;
            }
            if ((realIndex = index + offset) < 0) {
                realIndex = 0;
            }
            this._conditionals.add(realIndex, c2);
            this.setModified(true);
        } else if (type == 2) {
            if (this._conditionals.size() > 0) {
                if (this._conditionals.get(this._conditionals.size() - 1).getConditionalType() == 2) {
                    this._conditionals.remove(this._conditionals.size() - 1);
                }
            }
            this._conditionals.add(c2);
            this.setModified(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addConditional(Conditional c) {
        block9: {
            block10: {
                block8: {
                    if (c == null) {
                        return;
                    }
                    c.setParent(this);
                    type = c.getConditionalType();
                    if (type != 0) break block8;
                    if (this._conditionals.size() > 0) {
                        if (this._conditionals.get(0).getConditionalType() == 0) {
                            this._conditionals.remove(0);
                        }
                    }
                    this._conditionals.add(0, c);
                    this.setModified(true);
                    break block9;
                }
                if (type != 1) break block10;
                if (this._conditionals.size() <= 0) ** GOTO lbl-1000
                if (this._conditionals.get(this._conditionals.size() - 1).getConditionalType() == 2) {
                    this._conditionals.add(this._conditionals.size() - 1, c);
                } else lbl-1000:
                // 2 sources

                {
                    this._conditionals.add(c);
                }
                this.setModified(true);
                break block9;
            }
            if (type == 2) {
                if (this._conditionals.size() > 0) {
                    if (this._conditionals.get(this._conditionals.size() - 1).getConditionalType() == 2) {
                        this._conditionals.remove(this._conditionals.size() - 1);
                    }
                }
                this._conditionals.add(c);
                this.setModified(true);
            }
        }
    }

    public boolean hasElse() {
        int size = this._conditionals.size();
        for (int i = size - 1; i >= 0; --i) {
            Conditional conditional = this._conditionals.get(i);
            if (conditional.getConditionalType() != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public void duplicateConditionals(ConditionalBlock copyIntoBlock) {
        if (copyIntoBlock == null) {
            return;
        }
        copyIntoBlock._priority = this._priority;
        for (int i = 0; i < this._conditionals.size(); ++i) {
            Conditional obj = this._conditionals.get(i);
            Conditional obj2 = obj.clone();
            obj2._conditionalList = new ArrayList<ConditionalItem>();
            for (int c2 = 0; c2 < obj._conditionalList.size(); ++c2) {
                ConditionalItem ci = obj._conditionalList.get(c2);
                ConditionalItem ci2 = (ConditionalItem)ci.clone();
                obj2.addConditionalItem(ci2);
            }
            obj2._conditionalBlock = obj._conditionalBlock.clone();
            obj2._rulesList.clear();
            obj2._rulesList.addAll(obj._rulesList);
            copyIntoBlock.addConditional(obj2);
        }
    }

    public boolean shouldTreeNodeExpand() {
        return this._treeNodeExpanded;
    }

    public void setTreeNodeExpanded(boolean expanded) {
        this._treeNodeExpanded = expanded;
    }
}

