/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.io.AsciiSerializable;
import hec.model.Conditional;
import hec.model.ConditionalOperator;
import hec.model.ConditionalValue;
import hec.model.LogicalOperator;
import hec.model.RunTimeStep;
import java.lang.reflect.Field;

public class ConditionalItem
implements AsciiSerializable,
Cloneable {
    public static final int FIRST_CONDITIONAL_VALUE = 0;
    public static final int SECOND_CONDITIONAL_VALUE = 1;
    private LogicalOperator _logicalOperator;
    protected ConditionalValue _value1 = new ConditionalValue();
    protected ConditionalValue _value2 = new ConditionalValue();
    private ConditionalOperator _conditionalOperator;

    public Object clone() {
        ConditionalItem newItem = null;
        try {
            newItem = (ConditionalItem)super.clone();
        }
        catch (Exception ex) {
            return null;
        }
        newItem._logicalOperator = this._logicalOperator != null ? (LogicalOperator)this._logicalOperator.clone() : null;
        newItem._conditionalOperator = this._conditionalOperator != null ? (ConditionalOperator)this._conditionalOperator.clone() : null;
        newItem._value1 = this._value1 != null ? (ConditionalValue)this._value1.clone() : null;
        newItem._value2 = this._value2 != null ? (ConditionalValue)this._value2.clone() : null;
        return newItem;
    }

    public void updateParentData(Conditional cond) {
        this._value1.updateParentData(cond);
        this._value2.updateParentData(cond);
    }

    public boolean evaluate(RunTimeStep rts) {
        return this._conditionalOperator.compare(this._value1, this._value2, rts);
    }

    public ConditionalValue getConditionalValue(int num) {
        if (num == 0) {
            return this._value1;
        }
        if (num == 1) {
            return this._value2;
        }
        return null;
    }

    public void setConditionalValue(int num, ConditionalValue conditionalValue) {
        if (num == 0) {
            this._value1 = conditionalValue;
            if (this._value1 != null && (this._value1.getType() == 4 || this._value1.getType() == 5)) {
                this._value2 = new ConditionalValue();
                this._conditionalOperator = null;
            }
        } else if (num == 1) {
            this._value2 = conditionalValue;
        }
    }

    public LogicalOperator getLogicalOperator() {
        return this._logicalOperator;
    }

    public void setLogicalOperator(LogicalOperator logicalOperator) {
        this._logicalOperator = logicalOperator;
    }

    public ConditionalOperator getConditionalOperator() {
        return this._conditionalOperator;
    }

    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this._conditionalOperator = conditionalOperator;
    }

    public String expressionString() {
        String val1 = this._value1 != null ? this._value1.toString() : "";
        String val2 = this._value2 != null ? this._value2.toString() : "";
        String op = this._conditionalOperator != null ? this._conditionalOperator.toString() : "";
        return val1 + " " + op + " " + val2;
    }

    public String toString() {
        return this.expressionString();
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

