/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import com.google.common.flogger.FluentLogger;
import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.model.ConditionalValue;
import hec.model.RunTimeStep;
import hec.model.TimeSeriesConditionalComparable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import rma.util.RMAIO;

public class ConditionalOperator
implements AsciiSerializable,
Cloneable {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    public static final String[] DAYS = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static HecTime START_OF_YEAR = new HecTime("01JAN1900", "2400");
    private HecTime _time1 = new HecTime();
    private HecTime _time2 = new HecTime();
    public static final int NO_OPERATOR = 0;
    public static final int EQUALS_OPERATOR = 1;
    public static final int NOT_EQUALS_OPERATOR = 2;
    public static final int GREATER_THAN_OPERATOR = 3;
    public static final int GREATER_THAN_EQUALS_OPERATOR = 4;
    public static final int LESS_THAN_OPERATOR = 5;
    public static final int LESS_THAN_EQUALS_OPERATOR = 6;
    private static final int FIRST_OPERATOR = 0;
    private static final int LAST_OPERATOR = 6;
    public static final String[] TOSTRING_VALUES = new String[]{" ", "=", "!=", ">", ">=", "<", "<="};
    private int _operator;

    private static SimpleDateFormat date_format() {
        SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("ddMMMyyyy, HH:mm");
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        return DATE_FORMAT;
    }

    public ConditionalOperator() {
    }

    public boolean equals(Object parm1) {
        if (!(parm1 instanceof ConditionalOperator)) {
            return false;
        }
        return ((ConditionalOperator)parm1)._operator == this._operator;
    }

    public Object clone() {
        ConditionalOperator operator = null;
        try {
            operator = (ConditionalOperator)super.clone();
        }
        catch (Exception ex) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("Exception cloning ConditionalOperator: %s" + ex.getMessage());
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).withCause((Throwable)ex)).log();
            return null;
        }
        operator._operator = this._operator;
        return operator;
    }

    public ConditionalOperator(int operator) {
        this();
        if (operator < 0 || operator > 6) {
            throw new IllegalArgumentException("Illegal Operator " + operator);
        }
        this._operator = operator;
    }

    public String toString() {
        if (this._operator < 0 || this._operator > 6) {
            return "undefined";
        }
        return TOSTRING_VALUES[this._operator];
    }

    public static HecTime getStartOfYear() {
        return START_OF_YEAR;
    }

    public static void setStartOfYear(HecTime hTime) {
        START_OF_YEAR = hTime;
    }

    public boolean compare(ConditionalValue value1, ConditionalValue value2, RunTimeStep rts) {
        int compareValue;
        block52: {
            compareValue = 0;
            int val1Type = value1.getType();
            int val2Type = value2.getType();
            Object value1Val = value1.getValue();
            Object value2Val = value2.getValue();
            try {
                SimpleDateFormat date_format = ConditionalOperator.date_format();
                if (val1Type == 0 && val2Type == 0) {
                    if (value1Val != null && value2Val != null) {
                        compareValue = new Double(value1Val.toString()).compareTo(new Double(value2Val.toString()));
                    } else {
                        ((FluentLogger.Api)LOGGER.atWarning()).log("compare:Warning missing info on Constant.compareTo(Constant). value1=%s(%s) value2=%s(%s)", (Object)value1, value1Val, (Object)value2, value2Val);
                    }
                    break block52;
                }
                if (val1Type == 1 && val2Type == 1) {
                    if (value1Val != null && value2Val != null) {
                        compareValue = date_format.parse(value1Val.toString()).compareTo(date_format.parse(value2Val.toString()));
                        break block52;
                    }
                    ((FluentLogger.Api)LOGGER.atWarning()).log("compare:Warning missing info on DateTime.compareTo(DateTime). value1=%s(%s) value2=%s(%s)", (Object)value1, value1Val, (Object)value2, value2Val);
                    return false;
                }
                if (val1Type == 2 && val2Type == 1) {
                    if (value2Val != null) {
                        long value2MiliTime;
                        long value1MiliTime = rts.rtw.getLookbackTime().getTimeInMillis();
                        compareValue = (value1MiliTime += (long)rts.getTimeStepSeconds() * 1000L * (long)rts.step) < (value2MiliTime = date_format.parse(value2Val.toString()).getTime()) ? -1 : (value1MiliTime > value2MiliTime ? 1 : 0);
                        break block52;
                    }
                    ((FluentLogger.Api)LOGGER.atWarning()).log("compare:Warning missing info on Current.compareTo(DateTime). value=%s(%s)", (Object)value2, value2Val);
                    return false;
                }
                if (val1Type == 2 && val2Type == 7) {
                    if (value2Val != null) {
                        long value2MiliTime = rts.rtw.getLookbackTime().getTimeInMillis();
                        this._time1.set(rts.rtw.getLookbackTime());
                        this._time1.addSeconds(rts.getTimeStepSeconds() * rts.step);
                        if ("0000".equals(value2Val.toString())) {
                            this._time1.showTimeAsBeginningOfDay(true);
                        } else if ("2400".equals(value2Val.toString())) {
                            this._time1.showTimeAsBeginningOfDay(false);
                        }
                        String time1Str = RMAIO.removeChar(this._time1.time(), ':');
                        String time2Str = value2Val.toString();
                        int time1 = RMAIO.parseInt(time1Str);
                        int time2 = RMAIO.parseInt(time2Str);
                        compareValue = time1 < time2 ? -1 : (time1 > time2 ? 1 : 0);
                        break block52;
                    }
                    ((FluentLogger.Api)LOGGER.atWarning()).log("compare:Warning missing info on Current.compareTo(DateTime). value=%s (%s)", (Object)value2, value2Val);
                    return false;
                }
                if (val1Type == 2 && val2Type == 8) {
                    if (value2Val != null) {
                        long value1MiliTime = rts.rtw.getLookbackTime().getTimeInMillis();
                        this._time1.set(rts.rtw.getLookbackTime());
                        this._time1.addSeconds(rts.getTimeStepSeconds() * rts.step);
                        int value1DayOfWeek = this._time1.dayOfWeek() - 1;
                        int value2DayOfWeek = (Integer)value2Val;
                        compareValue = value1DayOfWeek < value2DayOfWeek ? -1 : (value1DayOfWeek > value2DayOfWeek ? 1 : 0);
                        break block52;
                    }
                    ((FluentLogger.Api)LOGGER.atWarning()).log("compare:Warning missing info on Current.compareTo(DateTime). value=%s(%s)", (Object)value2, value2Val);
                    return false;
                }
                if (val1Type == 1 && val2Type == 2) {
                    if (value1Val != null) {
                        long value2MiliTime;
                        long value1MiliTime = rts.rtw.getLookbackTime().getTimeInMillis();
                        compareValue = (value1MiliTime += (long)rts.getTimeStepSeconds() * 1000L * (long)rts.step) < (value2MiliTime = date_format.parse(value2Val.toString()).getTime()) ? -1 : (value1MiliTime > value2MiliTime ? 1 : 0);
                        break block52;
                    }
                    ((FluentLogger.Api)LOGGER.atWarning()).log("compare:Warning missing info on DateTime.compareTo(Current). value=%s(%s)", (Object)value1, value1Val);
                    return false;
                }
                if (val1Type == 2 && val2Type == 2) {
                    compareValue = 0;
                    break block52;
                }
                if (val1Type == 3 && val2Type == 0) {
                    if (value1Val != null && value2Val != null) {
                        compareValue = ((TimeSeriesConditionalComparable)value1Val).compare(rts, RMAIO.parseDouble(value2));
                        break block52;
                    }
                    ((FluentLogger.Api)LOGGER.atWarning()).log("compare:Warning missing info on TS.compareTo(Constant). value1=%s(%s) value2=%s(%s)", (Object)value1, value1Val, (Object)value2, value2Val);
                    return false;
                }
                if (val1Type == 0 && val2Type == 3) {
                    if (value1Val != null && value2Val != null) {
                        compareValue = ((TimeSeriesConditionalComparable)value2Val).compare(rts, RMAIO.parseDouble(value1Val));
                        compareValue *= -1;
                        break block52;
                    }
                    ((FluentLogger.Api)LOGGER.atWarning()).log("compare:Warning missing info on Constant.compareTo(TS). value1=%s(%s) value2=%s(%s)", (Object)value1, value1Val, (Object)value2, value2Val);
                    return false;
                }
                if (val1Type == 3 && val2Type == 3) {
                    if (value1Val != null && value2Val != null) {
                        compareValue = ((TimeSeriesConditionalComparable)value1Val).compare(rts, (TimeSeriesConditionalComparable)value2Val);
                        break block52;
                    }
                    ((FluentLogger.Api)LOGGER.atWarning()).log("compare:Warning missing info on TS.compareTo(TS). value1=%s(%s) value2=%s(%s)", (Object)value1, value1Val, (Object)value2, value2Val);
                    return false;
                }
                if (val1Type == 6 && val2Type == 2) {
                    if (value1Val != null) {
                        int timeStepDayOfYear;
                        HecTime currTime = rts.getHecTime();
                        int year = currTime.year();
                        String yrStr = String.valueOf(year);
                        this._time1.set(value1Val + yrStr, "2400");
                        HecTime waterYearStart = this.getStartOfYear();
                        int waterYearStartDayOfYear = waterYearStart.dayOfYear();
                        HecTime timeStepTime = rts.getHecTime();
                        int dayOfYear = this._time1.dayOfYear() - waterYearStartDayOfYear;
                        int days = 365;
                        if (HecTime.isLeap(year)) {
                            days = 366;
                        }
                        if (dayOfYear < 0) {
                            dayOfYear = days - waterYearStartDayOfYear + this._time1.dayOfYear();
                        }
                        if ((timeStepDayOfYear = timeStepTime.dayOfYear() - waterYearStartDayOfYear) < 0) {
                            timeStepDayOfYear = days - waterYearStartDayOfYear + timeStepTime.dayOfYear();
                        }
                        if (dayOfYear == timeStepDayOfYear) {
                            compareValue = 0;
                        } else if (dayOfYear < timeStepDayOfYear) {
                            compareValue = -1;
                        } else if (dayOfYear > timeStepDayOfYear) {
                            compareValue = 1;
                        }
                        break block52;
                    }
                    ((FluentLogger.Api)LOGGER.atWarning()).log("compare:Warning missing info on CURRENT_TIME_STEP.compareTo(DDMMM). value1=%s(%s) value2=%s(%s)", (Object)value1, value1Val, (Object)value2, value2Val);
                    return false;
                }
                if (val1Type == 2 && val2Type == 6) {
                    if (value2Val != null) {
                        int timeStepDayOfYear;
                        HecTime currTime = rts.getHecTime();
                        int year = currTime.year();
                        String yrStr = String.valueOf(year);
                        this._time1.set(value2Val + yrStr, "2400");
                        HecTime timeStepTime = rts.getHecTime();
                        HecTime waterYearStart = this.getStartOfYear();
                        int waterYearStartDayOfYear = waterYearStart.dayOfYear();
                        int dayOfYear = this._time1.dayOfYear() - waterYearStartDayOfYear;
                        int days = 365;
                        if (HecTime.isLeap(year)) {
                            days = 366;
                        }
                        if (dayOfYear < 0) {
                            dayOfYear = days - waterYearStartDayOfYear + this._time1.dayOfYear();
                        }
                        if ((timeStepDayOfYear = timeStepTime.dayOfYear() - waterYearStartDayOfYear) < 0) {
                            timeStepDayOfYear = days - waterYearStartDayOfYear + timeStepTime.dayOfYear();
                        }
                        if (dayOfYear == timeStepDayOfYear) {
                            compareValue = 0;
                        } else if (timeStepDayOfYear < dayOfYear) {
                            compareValue = -1;
                        } else if (timeStepDayOfYear > dayOfYear) {
                            compareValue = 1;
                        }
                        break block52;
                    }
                    ((FluentLogger.Api)LOGGER.atWarning()).log("compare:Warning missing info on CURRENT_TIME_STEP.compareTo(DDMMM). value1=%s(%s) value2=%s(%s)", (Object)value1, value1Val, (Object)value2, value2Val);
                    return false;
                }
                return false;
            }
            catch (Exception e) {
                ((FluentLogger.Api)LOGGER.atWarning()).log("compare: exception: value1=%s value2=%s Error:%s", value1Val, (Object)value2, (Object)e.getMessage());
                return false;
            }
        }
        if (this._operator == 0) {
            return false;
        }
        if (this._operator == 1) {
            return compareValue == 0;
        }
        if (this._operator == 2) {
            return compareValue != 0;
        }
        if (this._operator == 3) {
            return compareValue > 0;
        }
        if (this._operator == 4) {
            return compareValue >= 0;
        }
        if (this._operator == 5) {
            return compareValue < 0;
        }
        if (this._operator == 6) {
            return compareValue <= 0;
        }
        return false;
    }

    protected int compareTimeSeriesValues(Object value1, Object value2, RunTimeStep rts) {
        return 0;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

