/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.io.PairedDataContainer;
import hec.model.OutputVariable;
import hec.model.RunTimeWindow;
import hec.model.ScalarOutputter;
import java.util.List;
import java.util.Map;

public class EADScalarOutputter
implements ScalarOutputter {
    public static final String KEY = "EAD";
    private RunTimeWindow _rtw;

    @Override
    public Map.Entry<String, Double> getScalar(OutputVariable var) {
        List<PairedDataContainer> pdcList = var.getPairedDataList();
        double damage = 0.0;
        if (pdcList != null && !pdcList.isEmpty()) {
            damage = this.computeEAD(pdcList.get(0));
        }
        Map.Entry<String, Double> retval = new Map.Entry<String, Double>(){
            String _key = "EAD";
            Double _value;

            @Override
            public String getKey() {
                return this._key;
            }

            @Override
            public Double getValue() {
                return this._value;
            }

            @Override
            public Double setValue(Double value) {
                Double oldValue = this._value;
                this._value = value;
                return oldValue;
            }
        };
        retval.setValue(damage);
        return retval;
    }

    private double computeEAD(PairedDataContainer damagePdc) {
        int numYears = EADScalarOutputter.getNumYears(this._rtw);
        double damage = 0.0;
        for (int i = 0; i < damagePdc.xOrdinates.length; ++i) {
            double perRealizationDamage = damagePdc.yOrdinates[0][i];
            if (perRealizationDamage == Double.NEGATIVE_INFINITY) continue;
            damage += perRealizationDamage;
        }
        return damage /= (double)(numYears * damagePdc.numberOrdinates);
    }

    private static int getNumYears(RunTimeWindow rtw) {
        int numYears = 0;
        if (rtw != null) {
            int startYear = rtw.getStartTime().year();
            int endYear = rtw.getEndTime().year();
            numYears = endYear - startYear;
            if (numYears < 1) {
                numYears = 1;
            }
        }
        return numYears;
    }

    @Override
    public void setRunTimeWindow(RunTimeWindow rtw) {
        this._rtw = rtw;
    }

    @Override
    public boolean needsTimeWindow() {
        return true;
    }
}

