/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import java.util.Vector;

public class Interpolate {
    Vector _dataVector = new Vector();

    public static int bisearch(int[] xarray, int x, int n) {
        int klo = 0;
        int khi = n + 1;
        int k = -1;
        boolean ascnd = false;
        if (xarray[n - 1] > xarray[0]) {
            while (khi - klo > 1) {
                k = (khi + klo) / 2;
                if (xarray[k - 1] > x) {
                    khi = k;
                    continue;
                }
                klo = k;
            }
        } else {
            while (khi - klo > 1) {
                k = (khi + klo) / 2;
                if (xarray[k - 1] < x) {
                    khi = k;
                    continue;
                }
                klo = k;
            }
        }
        return klo - 1;
    }

    public static int bisearch(double[] xarray, double x, int n) {
        int klo = 0;
        int khi = n + 1;
        int k = -1;
        boolean ascnd = false;
        if (xarray[n - 1] > xarray[0]) {
            while (khi - klo > 1) {
                k = (khi + klo) / 2;
                if (xarray[k - 1] > x) {
                    khi = k;
                    continue;
                }
                klo = k;
            }
        } else {
            while (khi - klo > 1) {
                k = (khi + klo) / 2;
                if (xarray[k - 1] < x) {
                    khi = k;
                    continue;
                }
                klo = k;
            }
        }
        return klo - 1;
    }

    public static double linearInterpolate(double[] xarray, double[] yarray, double x, int n) {
        int k = Interpolate.bisearch(xarray, x, n);
        if (k < 0) {
            return yarray[0];
        }
        if (k >= n - 1) {
            return yarray[n - 1];
        }
        double val = Interpolate.linearInterpolate(xarray, yarray, x, n, k);
        return val;
    }

    public static double linearInterpolate(double[] xarray, double[] yarray, double x, int n, int interval) {
        int k = interval;
        double delx = xarray[k + 1] - xarray[k];
        if (delx == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double y = (x - xarray[k]) * (yarray[k + 1] - yarray[k]) / delx + yarray[k];
        return y;
    }

    public static double linearInterpolate(int[] xarray, double[] yarray, int x, int n) {
        int k = Interpolate.bisearch(xarray, x, n);
        if (k < 0) {
            return yarray[0];
        }
        if (k >= n - 1) {
            return yarray[n - 1];
        }
        double delx = xarray[k + 1] - xarray[k];
        if (delx == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double y = (double)(x - xarray[k]) * (yarray[k + 1] - yarray[k]) / delx + yarray[k];
        return y;
    }

    public static double[] cubicSpline(int[] xarray, double[] yarray, double yp0, double ypn, int n) {
        double un;
        double qn;
        int i;
        double[] y2 = new double[n];
        double[] u = new double[n];
        if (yp0 == Double.NEGATIVE_INFINITY) {
            y2[0] = 0.0;
            u[0] = 0.0;
        } else {
            y2[0] = -0.5;
            u[0] = 3.0 / (double)(xarray[1] - xarray[0]) * ((yarray[1] - yarray[0]) / (double)(xarray[1] - xarray[0]) - yp0);
        }
        for (i = 1; i < n - 1; ++i) {
            double sig = (double)(xarray[i] - xarray[i - 1]) / (double)(xarray[i + 1] - xarray[i - 1]);
            double p = sig * y2[i - 1] + 2.0;
            y2[i] = (sig - 1.0) / p;
            u[i] = (6.0 * ((yarray[i + 1] - yarray[i]) / (double)(xarray[i + 1] - xarray[i]) - (yarray[i] - yarray[i - 1]) / (double)(xarray[i] - xarray[i - 1])) / (double)(xarray[i + 1] - xarray[i - 1]) - sig * u[i - 1]) / p;
        }
        if (ypn == Double.NEGATIVE_INFINITY) {
            qn = 0.0;
            un = 0.0;
        } else {
            qn = 0.5;
            un = 3.0 / (double)(xarray[n - 1] - xarray[n - 2]) * (ypn - (yarray[n - 1] - yarray[n - 2]) / (double)(xarray[n - 1] - xarray[n - 2]));
        }
        y2[n - 1] = (un - qn * u[n - 2]) / (qn * y2[n - 2] + 1.0);
        for (i = n - 2; i > -1; --i) {
            y2[i] = y2[i] * y2[i + 1] + u[i];
        }
        return y2;
    }

    public static double splineInterpolate(int[] xarray, double[] yarray, double[] y2, int x, int n) {
        if (y2 == null || n < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        int k = Interpolate.bisearch(xarray, x, n);
        if (k < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Interpolate.splineInterpolate(xarray, yarray, y2, x, n, k);
    }

    public static double splineInterpolate(int[] xarray, double[] yarray, double[] y2, int x, int n, int interval) {
        int k = interval;
        double h = xarray[k + 1] - xarray[k];
        if (h == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double a = (double)(xarray[k + 1] - x) / h;
        double b = (double)(x - xarray[k]) / h;
        double y = a * yarray[k] + b * yarray[k + 1] + ((a * a * a - a) * y2[k] + (b * b * b - b) * y2[k + 1]) * (h * h) / 6.0;
        return y;
    }

    public static double[] cubicSpline(double[] xarray, double[] yarray, double yp0, double ypn, int n) {
        double un;
        double qn;
        int i;
        double[] y2 = new double[n];
        double[] u = new double[n];
        if (yp0 == Double.NEGATIVE_INFINITY) {
            y2[0] = 0.0;
            u[0] = 0.0;
        } else {
            y2[0] = -0.5;
            u[0] = 3.0 / (xarray[1] - xarray[0]) * ((yarray[1] - yarray[0]) / (xarray[1] - xarray[0]) - yp0);
        }
        for (i = 1; i < n - 1; ++i) {
            double sig = (xarray[i] - xarray[i - 1]) / (xarray[i + 1] - xarray[i - 1]);
            double p = sig * y2[i - 1] + 2.0;
            y2[i] = (sig - 1.0) / p;
            u[i] = (6.0 * ((yarray[i + 1] - yarray[i]) / (xarray[i + 1] - xarray[i]) - (yarray[i] - yarray[i - 1]) / (xarray[i] - xarray[i - 1])) / (xarray[i + 1] - xarray[i - 1]) - sig * u[i - 1]) / p;
        }
        if (ypn == Double.NEGATIVE_INFINITY) {
            qn = 0.0;
            un = 0.0;
        } else {
            qn = 0.5;
            un = 3.0 / (xarray[n - 1] - xarray[n - 2]) * (ypn - (yarray[n - 1] - yarray[n - 2]) / (xarray[n - 1] - xarray[n - 2]));
        }
        y2[n - 1] = (un - qn * u[n - 2]) / (qn * y2[n - 2] + 1.0);
        for (i = n - 2; i > -1; --i) {
            y2[i] = y2[i] * y2[i + 1] + u[i];
        }
        return y2;
    }

    public static double splineInterpolate(double[] xarray, double[] yarray, double[] y2, double x, int n) {
        if (y2 == null || n < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        int k = Interpolate.bisearch(xarray, x, n);
        if (k < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Interpolate.splineInterpolate(xarray, yarray, y2, x, n, k);
    }

    public static double splineInterpolate(double[] xarray, double[] yarray, double[] y2, double x, int n, int interval) {
        int k = interval;
        double h = xarray[k + 1] - xarray[k];
        if (h == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double a = (xarray[k + 1] - x) / h;
        double b = (x - xarray[k]) / h;
        double y = a * yarray[k] + b * yarray[k + 1] + ((a * a * a - a) * y2[k] + (b * b * b - b) * y2[k + 1]) * (h * h) / 6.0;
        return y;
    }
}

