/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.io.AsciiSerializable;
import hec.model.SchedulableJob;
import hec.model.Scheduler;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.TimerTask;
import java.util.Vector;
import rma.lang.Modifiable;

public abstract class JobTask
extends TimerTask
implements Serializable,
AsciiSerializable,
Modifiable {
    public static final String DONE = "Done";
    public static final String SUCCESSFUL = "Successful";
    public static final String CLIENT_NOT_LOGGED_IN = "Client not logged in";
    public static final String IN_PROGRESS = "In Progress";
    public static final String PENDING = "Pending";
    public static final String SCRIPT_FAILED = "Script Failed";
    public static final String ERROR = "Error";
    protected SchedulableJob _job;
    protected boolean _isRunning = false;
    protected String _status = "Pending";
    protected long _lastRunTime = 0L;
    protected boolean _isPaused = false;
    protected boolean _isModified = false;
    protected transient Scheduler _parent = null;
    protected Vector _jobMessages = new Vector();
    private transient Date _currentDate = new Date();
    protected long _nextRunTime = 0L;

    public JobTask() {
    }

    public JobTask(SchedulableJob job) {
        this();
        this._job = job;
    }

    public SchedulableJob getJob() {
        return this._job;
    }

    @Override
    public void run() {
    }

    public String getName() {
        if (this._job != null) {
            return this._job.getName();
        }
        return "";
    }

    public void setIsRunning(boolean b) {
        this._isRunning = b;
        if (this._parent != null && b) {
            this._parent.logMessage(this.getName() + " running at " + new Date());
        }
        this.setModified(true);
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    public void setPaused(boolean b) {
        this._isPaused = b;
        this.setModified(true);
    }

    public boolean isPaused() {
        return this._isPaused;
    }

    public String getStatus() {
        if (this._isRunning) {
            return IN_PROGRESS;
        }
        return this._status;
    }

    public void setJobStatus(String msg, String status) {
        this._currentDate.setTime(System.currentTimeMillis());
        this._status = status;
        this._jobMessages.addElement(this._currentDate.toString() + ":" + status + ":" + msg);
        if (this._parent != null) {
            this._parent.logMessage(this._job.getName() + ":" + status + ":" + msg);
        }
        this.setModified(true);
    }

    public Vector getJobMessages() {
        return this._jobMessages;
    }

    public void setLastRunTime() {
        this._lastRunTime = System.currentTimeMillis();
        this.setModified(true);
    }

    public long getLastRunTime() {
        return this._lastRunTime;
    }

    public Scheduler getParent() {
        return this._parent;
    }

    public void setParent(Scheduler parent) {
        this._parent = parent;
    }

    @Override
    public void setModified(boolean b) {
        if (b && this._parent != null) {
            this._parent.setModified(b);
        }
        this._isModified = b;
    }

    @Override
    public boolean isModified() {
        return this._isModified;
    }

    public void setNextRunTime(long nextRunTime) {
        this._nextRunTime = nextRunTime;
    }

    public long getNextRunTime() {
        return this._nextRunTime;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void printInfo() {
        this._job.printInfo();
        System.out.println("*********JobTask info************");
        System.out.println("isRunning=" + this._isRunning + " status=" + this._status + " _lastRunTime=" + this._lastRunTime);
        System.out.println("isPaused=" + this._isPaused + " isModified=" + this._isModified + " nextRunTime=" + this._nextRunTime);
        System.out.println("Job Messages:");
        for (int i = 0; i < this._jobMessages.size(); ++i) {
            System.out.println(this._jobMessages.elementAt(i).toString());
        }
    }

    protected String getStackTraceString(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

