/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.io.AsciiSerializable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import rma.util.RMAIO;

public class ModelVariable
implements Comparable,
Cloneable,
AsciiSerializable {
    public static final String MODEL_VARIABLE_BEGIN = "ModelVariable Begin";
    private String _objectType;
    private String _name;
    private String _nameQualifier;
    private int _type;
    private int _paramId;
    private int _dataSetId;
    private boolean _required = true;
    private int _viewPortIndex = -1;
    private int _scaleIndex = -1;
    private double _priority = 1.0;
    private String _unitStr = null;
    private String _unitTypeStr = null;

    public ModelVariable() {
    }

    public ModelVariable(String objectType, String name, int type, int paramId) {
        this._objectType = objectType;
        this._name = name;
        this._type = type;
        this._paramId = paramId;
    }

    public ModelVariable(int type, String objectType, String name, String nqual, int paramId, int dataId) {
        this._objectType = objectType;
        this._name = name;
        this._type = type;
        this._nameQualifier = nqual;
        this._paramId = paramId;
        this._dataSetId = dataId;
        this._required = true;
    }

    public ModelVariable(int type, String objectType, String name, String nqual, int paramId, int dataId, boolean required) {
        this._objectType = objectType;
        this._name = name;
        this._type = type;
        this._nameQualifier = nqual;
        this._paramId = paramId;
        this._dataSetId = dataId;
        this._required = required;
    }

    public ModelVariable(int type, String objectType, String name, String nqual, int paramId, int dataId, boolean required, String unitStr, String unitTypeStr) {
        this._objectType = objectType;
        this._name = name;
        this._type = type;
        this._nameQualifier = nqual;
        this._paramId = paramId;
        this._dataSetId = dataId;
        this._required = required;
        this._unitStr = unitStr;
        this._unitTypeStr = unitTypeStr;
    }

    public boolean equals(ModelVariable mv) {
        if (mv == null) {
            return false;
        }
        if (this._name != null && !this._name.equals(mv._name)) {
            return false;
        }
        if (this._objectType != null && !this._objectType.equals(mv._objectType)) {
            return false;
        }
        if (this._type != mv._type) {
            return false;
        }
        return this._paramId == mv._paramId;
    }

    public boolean isRequired() {
        return this._required;
    }

    public String getNameQualifier() {
        return this._nameQualifier;
    }

    public int getDataSetId() {
        return this._dataSetId;
    }

    public String getName() {
        return this._name;
    }

    public int getType() {
        return this._type;
    }

    public String getObjectType() {
        return this._objectType;
    }

    public int getParamId() {
        return this._paramId;
    }

    public String toString() {
        return this._name;
    }

    public int getViewportIndex() {
        return this._viewPortIndex;
    }

    public void setViewportIndex(int idx) {
        this._viewPortIndex = idx;
    }

    public int getScaleIndex() {
        return this._scaleIndex;
    }

    public void setScaleIndex(int idx) {
        this._scaleIndex = idx;
    }

    public String getUnitString() {
        return this._unitStr;
    }

    public void setUnitString(String s) {
        this._unitStr = s;
    }

    public String getUnitTypeString() {
        return this._unitTypeStr;
    }

    public void setUnitTypeString(String s) {
        this._unitTypeStr = s;
    }

    public boolean write(BufferedWriter writer) throws IOException {
        if (writer == null) {
            return false;
        }
        writer.write(MODEL_VARIABLE_BEGIN);
        writer.newLine();
        writer.write("Name=" + this._name);
        writer.newLine();
        writer.write("ObjectType=" + this._objectType);
        writer.newLine();
        writer.write("Type=" + this._type);
        writer.newLine();
        writer.write("ParamId=" + this._paramId);
        writer.newLine();
        writer.write("Viewport=" + this._viewPortIndex);
        writer.newLine();
        writer.write("Scale=" + this._scaleIndex);
        writer.newLine();
        writer.write("DataSet=" + this._dataSetId);
        writer.newLine();
        if (this._nameQualifier != null) {
            writer.write("NameQualifier=" + this._nameQualifier);
            writer.newLine();
        }
        if (this._unitStr != null) {
            writer.write("UnitStr=" + this._unitStr);
            writer.newLine();
        }
        if (this._unitTypeStr != null) {
            writer.write("UnitTypeStr=" + this._unitTypeStr);
            writer.newLine();
        }
        writer.write("ModelVariable End");
        writer.newLine();
        return true;
    }

    public boolean read(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return false;
        }
        while ((line = reader.readLine()) != null && !line.startsWith("ModelVariable End")) {
            String type = RMAIO.getType(line, "=");
            String param = RMAIO.getParam(line, "=");
            if (type.equals("Name")) {
                this._name = param;
                continue;
            }
            if (type.equals("ObjectType")) {
                this._objectType = param;
                continue;
            }
            if (type.equals("Type")) {
                this._type = RMAIO.parseInt(param);
                continue;
            }
            if (type.equals("ParamId")) {
                this._paramId = RMAIO.parseInt(param);
                continue;
            }
            if (type.equals("Viewport")) {
                this._viewPortIndex = RMAIO.parseInt(param);
                continue;
            }
            if (type.equals("DataSet")) {
                this._dataSetId = RMAIO.parseInt(param);
                continue;
            }
            if (type.equals("Scale")) {
                this._scaleIndex = RMAIO.parseInt(param);
                continue;
            }
            if (type.equals("NameQualifier")) {
                this._nameQualifier = param;
                continue;
            }
            if (type.equals("UnitStr")) {
                this._unitStr = param;
                continue;
            }
            if (!type.equals("UnitTypeStr")) continue;
            this._unitTypeStr = param;
        }
        return true;
    }

    public void setPriority(double priority) {
        this._priority = priority;
    }

    public double getPriority() {
        return this._priority;
    }

    public int compareTo(Object o) {
        ModelVariable that = (ModelVariable)o;
        if (this._priority == that._priority) {
            return 0;
        }
        if (this._priority < that._priority) {
            return -1;
        }
        return 1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("ModelVariable.clone: Exception in clone() " + e);
            return null;
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

