/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.heclib.util.doubleArrayContainer;
import hec.lang.NamedType;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.model.ITSDataSet;
import hec.model.StreamElement;
import hec.model.StreamReferenceHolder;
import hec.model.TSLocation;
import hec.model.TSLocation2;
import hec.model.TSRecord;
import hec.model.TsRecordContainer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import java.util.Vector;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

public class Node
extends NamedType
implements TSLocation,
TSLocation2,
StreamReferenceHolder {
    public static final int OUTFLOW = 0;
    public static final int INFLOW = 1;
    protected TsRecordContainer _manager;
    protected Vector _tsrecordVector = new Vector();
    protected WorldPt _location = new WorldPt();
    protected int _streamIndex = -1;
    protected transient StreamElement _stream = null;
    protected String _streamName = "";
    protected double _station = Double.NEGATIVE_INFINITY;
    protected double _streamCoord = Double.NEGATIVE_INFINITY;

    public Node() {
    }

    public Node(TsRecordContainer sys, int idx) {
        this._manager = sys;
        this._index = idx;
    }

    public void setManager(TsRecordContainer sys) {
        this._manager = sys;
    }

    public void setStream(StreamElement s) {
        this._stream = s;
        if (s != null) {
            this._streamIndex = s.getIndex();
            this._streamName = s.getName();
        } else {
            this._streamIndex = Integer.MIN_VALUE;
        }
    }

    @Override
    public int getStreamIndex() {
        return this._streamIndex;
    }

    @Override
    public void setStreamIndex(int idx) {
        this._streamIndex = idx;
    }

    @Override
    public String getStreamName() {
        return this._streamName;
    }

    @Override
    public void setStreamName(String s) {
        this._streamName = s;
    }

    public void setStreamCoord(double coord) {
        this._streamCoord = coord;
    }

    public double getStreamCoord() {
        return this._streamCoord;
    }

    public void setStreamStation(double coord) {
        this._station = coord;
    }

    public double getStreamStation() {
        return this._station;
    }

    public void setLocation(WorldPt pt) {
        if (pt == null) {
            return;
        }
        this._location = pt;
    }

    public WorldPt getLocation() {
        return this._location;
    }

    public boolean isWithinExtents(WorldRect extents) {
        if (!this._location.isValid()) {
            return false;
        }
        boolean within = extents.contains(this._location);
        return within;
    }

    public void initialize() {
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecord rec = (TSRecord)this._tsrecordVector.elementAt(i);
            if (rec == null) continue;
            rec.reset();
        }
    }

    public Vector getTSRecordProxies() {
        return this._tsrecordVector;
    }

    public TSRecord getTSRecordProxyByName(String name) {
        TSRecord rec = null;
        for (int i = 0; !(i >= this._tsrecordVector.size() || (rec = (TSRecord)this._tsrecordVector.elementAt(i)) != null && name.equalsIgnoreCase(rec.getName())); ++i) {
        }
        return rec;
    }

    public double[] getTSArray(int vid) {
        int imax = this._tsrecordVector.size();
        for (int i = 0; i < imax; ++i) {
            TSRecord rec = (TSRecord)this._tsrecordVector.elementAt(i);
            if (rec == null || rec.getVariableId() != vid) continue;
            return rec.getTSArray();
        }
        return null;
    }

    public doubleArrayContainer getTSContainer(int vid) {
        int imax = this._tsrecordVector.size();
        for (int i = 0; i < imax; ++i) {
            TSRecord rec = (TSRecord)this._tsrecordVector.elementAt(i);
            if (rec == null || rec.getVariableId() != vid) continue;
            return rec.getTSContainer();
        }
        return null;
    }

    @Deprecated
    public TSRecord getTSRecordProxy(String param) {
        TSRecord rec = null;
        for (int i = 0; !(i >= this._tsrecordVector.size() || (rec = (TSRecord)this._tsrecordVector.elementAt(i)) != null && param.equalsIgnoreCase(rec.getParamName())); ++i) {
        }
        return rec;
    }

    public TSRecord getTSRecordProxy(String param, boolean isInput) {
        TSRecord rec = null;
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            rec = (TSRecord)this._tsrecordVector.elementAt(i);
            if (rec == null || !param.equalsIgnoreCase(rec.getParamName()) || rec.isInput() != isInput) continue;
            return rec;
        }
        return null;
    }

    public TSRecord getTSRecordProxy(String name, String param, boolean isInput) {
        TSRecord rec = null;
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            rec = (TSRecord)this._tsrecordVector.elementAt(i);
            if (rec == null || !name.equalsIgnoreCase(rec.getName()) || !param.equalsIgnoreCase(rec.getParamName()) || rec.isInput() != isInput) continue;
            return rec;
        }
        return null;
    }

    @Override
    public ITSDataSet getITSDataSet(boolean isInput) {
        return this.getTSDataSet(isInput);
    }

    @Override
    public ITSDataSet getTSDataSet(boolean isInput) {
        if (isInput) {
            return this._manager.getInputITSDataSet();
        }
        return this._manager.getOutputITSDataSet();
    }

    public double getTSFactor(String param) {
        double tsfac = 1.0;
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecord rec = (TSRecord)this._tsrecordVector.elementAt(i);
            if (rec == null || !param.equalsIgnoreCase(rec.getParamName())) continue;
            tsfac = rec.getFactor();
            if (!rec.isInput()) break;
        }
        return tsfac;
    }

    public double[] getTSArray(String param) {
        double[] tsarray = null;
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecord rec = (TSRecord)this._tsrecordVector.elementAt(i);
            if (rec == null || !param.equalsIgnoreCase(rec.getParamName())) continue;
            tsarray = rec.getTSArray();
            if (!rec.isInput()) break;
        }
        return tsarray;
    }

    public double[] getTSArray(String name, String param) {
        double[] tsarray = null;
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecord rec = (TSRecord)this._tsrecordVector.elementAt(i);
            if (rec == null || !name.equalsIgnoreCase(rec.getName()) || !param.equalsIgnoreCase(rec.getParamName())) continue;
            tsarray = rec.getTSArray();
            if (!rec.isInput()) break;
        }
        return tsarray;
    }

    public double[] getTSArray(String param, boolean isinput) {
        double[] tsarray = null;
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecord rec = (TSRecord)this._tsrecordVector.elementAt(i);
            if (rec == null || rec.isInput() != isinput || !param.equalsIgnoreCase(rec.getParamName())) continue;
            tsarray = rec.getTSArray();
            break;
        }
        return tsarray;
    }

    public boolean addTSRecord(String name, String param, boolean isinput) {
        if (name == null || param == null) {
            return false;
        }
        TSRecord proxy = this._manager.newTSRecordProxy(this);
        proxy.setName(name);
        proxy.setParamName(param);
        proxy.setInput(isinput);
        this._tsrecordVector.addElement(proxy);
        return true;
    }

    public void removeTSRecord(String name, String param, boolean isinput) {
        if (name == null || param == null) {
            return;
        }
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            TSRecord rec = (TSRecord)this._tsrecordVector.elementAt(i);
            if (rec == null || rec.isInput() != isinput || !param.equalsIgnoreCase(rec.getParamName())) continue;
            this._tsrecordVector.removeElementAt(i);
            break;
        }
    }

    public boolean readData(BufferedReader input) {
        try {
            String line = input.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = input.readLine();
                    continue;
                }
                if (line.indexOf("Node") >= 0) {
                    String type = RMAIO.getType(line, "=");
                    String param = RMAIO.getParam(line, "=").trim();
                    if (type.compareTo("Node End") != 0) {
                        this.assignParameter(type, param);
                        line = input.readLine();
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected void assignParameter(String type, String param) {
        if (type.compareTo("Node Name") == 0) {
            this.setName(param);
        } else if (type.compareTo("Node Description") == 0) {
            this.setDescription(param);
        } else if (type.compareTo("Node Location") == 0) {
            this._location.parseString(param);
        } else if (type.compareTo("Node TSRecord") == 0) {
            TSRecord proxy = this._manager.newTSRecordProxy(this);
            rmaTokenizer token = new rmaTokenizer(param, ",");
            try {
                proxy.setName(token.nextToken().trim());
                proxy.setParamName(token.nextToken().trim());
                String valstr = token.nextToken();
                if (valstr.indexOf("Input") >= 0) {
                    proxy.setInput(true);
                } else {
                    proxy.setInput(false);
                }
                this._tsrecordVector.addElement(proxy);
            }
            catch (NoSuchElementException noSuchElementException) {}
        } else if (type.equals("Node _streamIndex")) {
            this._streamIndex = RMAIO.parseInt(param);
        } else if (type.equals("Node Station")) {
            this._station = RMAIO.parseDouble(param);
        } else if (type.equals("Node StreamCoord")) {
            this._streamCoord = RMAIO.parseDouble(param);
        }
    }

    public boolean writeData(BufferedWriter out) {
        try {
            out.write("Node Name=" + this.getName());
            out.newLine();
            out.write("Node Description=" + this.getDescription());
            out.newLine();
            out.write("Node Location=" + this._location.toString());
            out.newLine();
            for (int i = 0; i < this._tsrecordVector.size(); ++i) {
                TSRecord proxy = (TSRecord)this._tsrecordVector.elementAt(i);
                if (proxy == null) continue;
                out.write("Node TSRecord=" + proxy.getName() + "," + proxy.getParamName());
                if (proxy.isInput()) {
                    out.write(", Input");
                } else {
                    out.write(", Output");
                }
                out.newLine();
            }
            out.write("Node _streamIndex=" + this._streamIndex);
            out.newLine();
            out.write("Node Station=" + RMAIO.toString(this._station));
            out.newLine();
            out.write("Node StreamCoord=" + RMAIO.toString(this._streamCoord));
            out.newLine();
            out.write("Node End=");
            out.newLine();
            return true;
        }
        catch (Exception e) {
            System.out.println("Error writing node data");
            return false;
        }
    }

    @Override
    public void setName(String name) {
        if (this._tsrecordVector == null) {
            super.setName(name);
            return;
        }
        String curname = this.getName();
        for (int i = 0; i < this._tsrecordVector.size(); ++i) {
            String proxyname;
            int idx;
            TSRecord p = (TSRecord)this._tsrecordVector.elementAt(i);
            if (p == null || (idx = (proxyname = p.getName()).indexOf(curname)) < 0) continue;
            String newname = name + proxyname.substring(idx + curname.length());
            p.setName(newname);
        }
        super.setName(name);
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

