/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.data.DataSetIllegalArgumentException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import hec.io.AsciiSerializable;
import hec.io.DSSIdentifier;
import hec.io.PairedDataContainer;
import hec.lang.annotation.Scriptable;
import hec.model.Interpolate;
import hec.model.ValuePair;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import rma.util.RMAIO;
import rma.util.rmaTokenizer;

@Scriptable
public class PairedValues
implements AsciiSerializable,
Cloneable {
    Vector _dataVector = new Vector();
    public static final String INTERP_LINEAR = "Linear";
    public static final String INTERP_CUBIC = "Cubic";
    public static final String INTERP_STEP = "Step";
    public static final int INTERP_LINEAR_ID = 0;
    public static final int INTERP_CUBIC_ID = 1;
    public static final int INTERP_STEP_ID = 2;
    public static final String[] INTERP_STRINGS = new String[]{"Linear", "Cubic", "Step"};
    transient boolean _arraysValid = false;
    transient boolean _canInterpX = false;
    transient boolean _canInterpY = false;
    transient double[] _xarray = null;
    transient double[] _yarray = null;
    transient double[] _y2array = null;
    transient double[] _x2array = null;
    transient int _interpInterval = -2;
    int _interpolationType = 0;
    int _unitSystemId = 0;
    int _paramXId = Integer.MIN_VALUE;
    int _paramYId = Integer.MIN_VALUE;
    transient double _datum = -3.4028234663852886E38;
    transient double _shift = -3.4028234663852886E38;
    transient double _offset = -3.4028234663852886E38;
    transient String[] _curveLabels = new String[1];
    DSSIdentifier _dssId = null;

    @Scriptable
    public double getMinY() {
        if (!this._arraysValid) {
            this.init();
        }
        int imax = this._yarray.length;
        double min = Double.MAX_VALUE;
        for (int i = 0; i < imax; ++i) {
            if (!(this._yarray[i] < min)) continue;
            min = this._yarray[i];
        }
        return min;
    }

    @Scriptable
    public double getMaxY() {
        if (!this._arraysValid) {
            this.init();
        }
        int imax = this._yarray.length;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < imax; ++i) {
            if (!(this._yarray[i] > max)) continue;
            max = this._yarray[i];
        }
        return max;
    }

    @Scriptable
    public int getUnitSystem() {
        return this._unitSystemId;
    }

    @Scriptable
    public String getDssPathName() {
        if (this._dssId == null) {
            return null;
        }
        return this._dssId.getDSSPath();
    }

    @Scriptable
    public String getDssFileName() {
        if (this._dssId == null) {
            return null;
        }
        return this._dssId.getFileName();
    }

    @Scriptable
    public void setDssPathName(String pathName) {
        if (this._dssId == null) {
            this._dssId = new DSSIdentifier();
        }
        this._dssId.setDSSPath(pathName);
    }

    @Scriptable
    public DSSIdentifier getDssIdentifer() {
        return this._dssId;
    }

    @Scriptable
    public void setDssIdentifer(DSSIdentifier dssId) {
        this._dssId = dssId;
    }

    @Scriptable
    public String getParamXUnitsString() {
        return Parameter.getUnitsStringForSystem(this._paramXId, this.getUnitSystem());
    }

    @Scriptable
    public String getParamYUnitsString() {
        return Parameter.getUnitsStringForSystem(this._paramYId, this.getUnitSystem());
    }

    @Scriptable
    public String getParamXString() {
        return Parameter.getParamString(this._paramXId);
    }

    @Scriptable
    public String getParamYString() {
        return Parameter.getParamString(this._paramYId);
    }

    @Scriptable
    public int[] getParametersIds() {
        return new int[]{this._paramXId, this._paramYId};
    }

    @Scriptable
    public void setUnitSystem(int us) {
        if (!Units.isValidUnitsSystem(us)) {
            throw new IllegalArgumentException("ERROR <PairedValues.setUnitSystem()> : Invalid Unit System Id " + us);
        }
        this._unitSystemId = us;
    }

    @Scriptable
    public void setParamXId(int paramId) {
        this._paramXId = paramId;
    }

    @Scriptable
    public void setParamYId(int paramId) {
        this._paramYId = paramId;
    }

    @Scriptable
    public int getParamXId() {
        return this._paramXId;
    }

    @Scriptable
    public int getParamYId() {
        return this._paramYId;
    }

    @Scriptable
    public void getXValue(int i, ParamDouble pd) {
        pd.setValue(this.getXValue(i));
        pd.setParameterId(this._paramXId);
        pd.setUnitSystem(this._unitSystemId);
    }

    @Scriptable
    public void getYValue(int i, ParamDouble pd) {
        pd.setValue(this.getYValue(i));
        pd.setParameterId(this._paramYId);
        pd.setUnitSystem(this._unitSystemId);
    }

    @Scriptable
    public double getXValue(int i) {
        if (!this._arraysValid) {
            this.init();
        }
        if (i < 0 || i >= this._xarray.length) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._xarray[i];
    }

    @Scriptable
    public double getYValue(int i) {
        if (!this._arraysValid) {
            this.init();
        }
        if (i < 0 || i >= this._xarray.length) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._yarray[i];
    }

    @Scriptable
    public double getXValue(double yval) {
        return this.interpolateY(yval);
    }

    @Scriptable
    public double getYValue(double xval) {
        return this.interpolate(xval);
    }

    @Scriptable
    public double interpolate(double xval) {
        if (!this._arraysValid) {
            this.init();
        }
        switch (this._interpolationType) {
            case 0: {
                return this.interpolateValue(xval);
            }
            case 1: {
                return this.interpolateValueCubicSpline(xval);
            }
            case 2: {
                return this.interpolateStepValue(xval);
            }
        }
        return this.interpolateValue(xval);
    }

    @Scriptable
    public double interpolateY(double yval) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray == null || this._yarray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._yarray.length < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._yarray.length == 1) {
            return this._xarray[0];
        }
        if (!this._canInterpY) {
            return Double.NEGATIVE_INFINITY;
        }
        double val = Double.NEGATIVE_INFINITY;
        int imax = this._yarray.length - 1;
        int k = this.findInterval(this._yarray, yval);
        if (k < 0) {
            return this._xarray[0];
        }
        if (k >= imax) {
            return this._xarray[imax];
        }
        switch (this._interpolationType) {
            case 0: {
                val = Interpolate.linearInterpolate(this._yarray, this._xarray, yval, this._yarray.length, k);
                break;
            }
            case 1: {
                double yp0 = Double.NEGATIVE_INFINITY;
                double ypn = Double.NEGATIVE_INFINITY;
                if (this._x2array == null) {
                    this._x2array = Interpolate.cubicSpline(this._yarray, this._xarray, yp0, ypn, this._yarray.length);
                }
                val = Interpolate.splineInterpolate(this._yarray, this._xarray, this._x2array, yval, this._yarray.length, k);
                break;
            }
            case 2: {
                return this.interpolateStepValue(yval);
            }
            default: {
                val = Interpolate.linearInterpolate(this._yarray, this._xarray, yval, this._yarray.length, k);
            }
        }
        return val;
    }

    @Scriptable
    public double interpolateValue(double xval) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray == null || this._yarray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length == 1) {
            return this._yarray[0];
        }
        if (!this._canInterpX) {
            return Double.NEGATIVE_INFINITY;
        }
        int imax = this._xarray.length - 1;
        int k = this.findInterval(xval);
        if (k < 0) {
            return this._yarray[0];
        }
        if (k >= imax) {
            return this._yarray[imax];
        }
        double val = Interpolate.linearInterpolate(this._xarray, this._yarray, xval, this._xarray.length, k);
        return val;
    }

    @Scriptable
    public double interpolateStepValue(double xval) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray == null || this._yarray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length == 1) {
            return this._yarray[0];
        }
        if (!this._canInterpX) {
            return Double.NEGATIVE_INFINITY;
        }
        int imax = this._xarray.length - 1;
        int k = this.findInterval(xval);
        if (k < 0) {
            return this._yarray[0];
        }
        if (k >= imax) {
            return this._yarray[imax];
        }
        if (k + 1 <= imax && this._xarray[k + 1] == xval) {
            return this._yarray[k + 1];
        }
        double value = this._yarray[k];
        return value;
    }

    @Scriptable
    public double interpolateValueCubicSpline(double xval) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray == null || this._yarray == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length == 1) {
            return this._yarray[0];
        }
        if (!this._canInterpX) {
            return Double.NEGATIVE_INFINITY;
        }
        int imax = this._xarray.length - 1;
        int k = this.findInterval(xval);
        if (k < 0) {
            return this._yarray[0];
        }
        if (k >= imax) {
            return this._yarray[imax];
        }
        double yp0 = Double.NEGATIVE_INFINITY;
        double ypn = Double.NEGATIVE_INFINITY;
        if (this._y2array == null) {
            this._y2array = Interpolate.cubicSpline(this._xarray, this._yarray, yp0, ypn, this._xarray.length);
        }
        double value = Interpolate.splineInterpolate(this._xarray, this._yarray, this._y2array, xval, this._xarray.length, k);
        return value;
    }

    @Scriptable
    public boolean isXValueOutOfRange(double xval) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray.length < 2) {
            return true;
        }
        return xval < this._xarray[0] || xval > this._xarray[this._xarray.length - 1];
    }

    @Scriptable
    public boolean isYValueOutOfRange(double yval) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._yarray.length < 2) {
            return true;
        }
        return yval < this._yarray[0] || yval > this._yarray[this._yarray.length - 1];
    }

    public int findInterval(double xval) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray.length < 2) {
            return -1;
        }
        int imax = this._xarray.length - 1;
        if (this._interpInterval == imax && xval >= this._xarray[imax]) {
            return imax;
        }
        if (this._interpInterval < 0 || this._interpInterval >= imax || xval < this._xarray[this._interpInterval] || xval > this._xarray[this._interpInterval + 1]) {
            if (this._interpInterval > 1 && this._interpInterval < imax - 2) {
                if (this._xarray[this._interpInterval + 1] < xval && xval < this._xarray[this._interpInterval + 2]) {
                    ++this._interpInterval;
                    return this._interpInterval;
                }
                if (this._xarray[this._interpInterval - 1] < xval && xval < this._xarray[this._interpInterval]) {
                    --this._interpInterval;
                    return this._interpInterval;
                }
            }
            this._interpInterval = Interpolate.bisearch(this._xarray, xval, this._xarray.length);
        }
        return this._interpInterval;
    }

    public int findInterval(double[] array, double val) {
        if (!this._arraysValid) {
            this.init();
        }
        if (array.length < 2) {
            return -1;
        }
        int imax = array.length - 1;
        if (this._interpInterval == imax && val >= array[imax]) {
            return imax;
        }
        if (this._interpInterval < 0 || this._interpInterval >= imax || val < array[this._interpInterval] || val > array[this._interpInterval + 1]) {
            if (this._interpInterval > 1 && this._interpInterval < imax - 2) {
                if (array[this._interpInterval + 1] < val && val < array[this._interpInterval + 2]) {
                    ++this._interpInterval;
                    return this._interpInterval;
                }
                if (array[this._interpInterval - 1] < val && val < array[this._interpInterval]) {
                    --this._interpInterval;
                    return this._interpInterval;
                }
            }
            this._interpInterval = Interpolate.bisearch(array, val, array.length);
        }
        return this._interpInterval;
    }

    public int parseString(String param) {
        rmaTokenizer token = new rmaTokenizer(param, ",");
        int icnt = 0;
        ValuePair valpair = null;
        try {
            while (true) {
                String valstr = token.nextToken().trim();
                if (icnt % 2 == 0) {
                    valpair = new ValuePair();
                    valpair.xval = RMAIO.parseDouble(valstr);
                    if (valpair.xval == Double.NEGATIVE_INFINITY) {
                        break;
                    }
                } else {
                    if (valpair == null) continue;
                    valpair.yval = RMAIO.parseDouble(valstr);
                    if (valpair.yval != Double.NEGATIVE_INFINITY) {
                        this._dataVector.addElement(valpair);
                        this._arraysValid = false;
                    }
                    valpair = null;
                }
                ++icnt;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return icnt / 2;
    }

    @Scriptable
    public void setInterpolationType(int type) {
        if (type >= 0 && type <= 2) {
            this._interpolationType = type;
        }
    }

    @Scriptable
    public int getInterpolationType() {
        return this._interpolationType;
    }

    @Scriptable
    public int size() {
        return this._dataVector.size();
    }

    @Scriptable
    public void clearValues() {
        this._dataVector.removeAllElements();
        this._xarray = null;
        this._yarray = null;
        this._y2array = null;
        this._x2array = null;
        this._arraysValid = false;
    }

    @Scriptable
    public int getPairCount() {
        if (this._dataVector == null) {
            return -1;
        }
        return this._dataVector.size();
    }

    @Scriptable
    public ValuePair getValuePair(int i) {
        if (this._dataVector == null || this._dataVector.size() <= 0) {
            return null;
        }
        if (i < 0 || i >= this._dataVector.size()) {
            return null;
        }
        return (ValuePair)this._dataVector.elementAt(i);
    }

    @Scriptable
    public ValuePair getLastValuePair() {
        if (this._dataVector == null || this._dataVector.size() <= 0) {
            return null;
        }
        return (ValuePair)this._dataVector.lastElement();
    }

    @Scriptable
    public void removePair(int i) {
        if (i < 0 || i >= this._dataVector.size()) {
            return;
        }
        this._dataVector.removeElementAt(i);
        this._arraysValid = false;
    }

    public String toString() {
        Object unParsed = new String();
        for (int i = 0; i < this._dataVector.size(); ++i) {
            ValuePair vp = (ValuePair)this._dataVector.elementAt(i);
            unParsed = (String)unParsed + vp.xval + ", " + vp.yval + ", ";
        }
        if (((String)unParsed).length() >= 2) {
            unParsed = ((String)unParsed).substring(0, ((String)unParsed).length() - 2);
        }
        return unParsed;
    }

    @Scriptable
    public String toTableForm(int precision) {
        StringBuffer buffer = new StringBuffer();
        String sep = System.getProperty("line.separator");
        for (int i = 0; i < this._dataVector.size(); ++i) {
            ValuePair vp = (ValuePair)this._dataVector.elementAt(i);
            String s = RMAIO.setPrecision2(vp.xval, precision);
            buffer.append(RMAIO.leftJustify(12, s));
            s = RMAIO.setPrecision2(vp.yval, precision);
            buffer.append(RMAIO.leftJustify(12, s));
            buffer.append(sep);
        }
        return buffer.toString();
    }

    @Scriptable
    public void addPair(double xval, double yval) {
        ValuePair vp = new ValuePair();
        vp.xval = xval;
        vp.yval = yval;
        this._dataVector.addElement(vp);
        this._arraysValid = false;
    }

    @Scriptable
    public Vector getDataVector() {
        return (Vector)this._dataVector.clone();
    }

    public synchronized Object clone() {
        try {
            PairedValues pv = (PairedValues)super.clone();
            pv._dataVector = new Vector();
            for (int i = 0; i < this._dataVector.size(); ++i) {
                ValuePair vp = (ValuePair)this._dataVector.elementAt(i);
                pv.addPair(vp.xval, vp.yval);
            }
            return pv;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public List init() {
        String s;
        int i;
        ArrayList<CallSite> initializationMessages = null;
        double undef = Double.NEGATIVE_INFINITY;
        int icnt = 0;
        for (int i2 = 0; i2 < this._dataVector.size(); ++i2) {
            ValuePair vp = (ValuePair)this._dataVector.elementAt(i2);
            if (vp.xval == undef || vp.yval == undef) continue;
            ++icnt;
        }
        int npts = icnt;
        this._xarray = new double[npts];
        this._yarray = new double[npts];
        icnt = 0;
        for (i = 0; i < this._dataVector.size(); ++i) {
            ValuePair vp = (ValuePair)this._dataVector.elementAt(i);
            if (vp.xval == undef || vp.yval == undef) continue;
            this._xarray[icnt] = vp.xval;
            this._yarray[icnt] = vp.yval;
            ++icnt;
        }
        this._y2array = null;
        this._x2array = null;
        this._arraysValid = true;
        this._canInterpX = false;
        this._canInterpY = false;
        if (this._xarray.length == 1) {
            String s2 = "Paired Values error, only 1 x value for " + this.getDssFileName() + ":" + this.getDssPathName() + ".";
            if (initializationMessages == null) {
                initializationMessages = new ArrayList<CallSite>();
            }
            initializationMessages.add((CallSite)((Object)s2));
            return initializationMessages;
        }
        if (this._xarray.length < 1) {
            String s3 = "Paired Values error, no x values for " + this.getDssFileName() + ":" + this.getDssPathName() + ".";
            if (initializationMessages == null) {
                initializationMessages = new ArrayList();
            }
            initializationMessages.add((CallSite)((Object)s3));
            return initializationMessages;
        }
        this._canInterpY = true;
        for (i = 0; i < this._yarray.length - 1; ++i) {
            if (!(this._yarray[i + 1] <= this._yarray[i])) continue;
            this._canInterpY = false;
            s = "Paired Values error, y values do not uniformly increase for " + this.getDssFileName() + ":" + this.getDssPathName() + ".";
            if (initializationMessages == null) {
                initializationMessages = new ArrayList();
            }
            initializationMessages.add((CallSite)((Object)s));
            break;
        }
        this._canInterpX = true;
        for (i = 0; i < this._xarray.length - 1; ++i) {
            if (!(this._xarray[i + 1] <= this._xarray[i])) continue;
            this._canInterpX = false;
            if (initializationMessages == null) {
                initializationMessages = new ArrayList();
            }
            s = "Paired Values error, x values do not uniformly increase for " + this.getDssFileName() + ":" + this.getDssPathName() + ".";
            initializationMessages.add((CallSite)((Object)s));
            break;
        }
        return initializationMessages;
    }

    @Scriptable
    public double[] getXArray() {
        if (!this._arraysValid || this._xarray == null) {
            this.init();
        }
        return this._xarray;
    }

    @Scriptable
    public double[] getYArray() {
        if (!this._arraysValid || this._yarray == null) {
            this.init();
        }
        return this._yarray;
    }

    @Scriptable
    public boolean canInterpX() {
        if (!this._arraysValid) {
            this.init();
        }
        return this._canInterpX;
    }

    @Scriptable
    public boolean canInterpY() {
        if (!this._arraysValid) {
            this.init();
        }
        return this._canInterpY;
    }

    @Scriptable
    public boolean setData(PairedDataContainer pdc) {
        int xprec = pdc.xprecision;
        int yprec = pdc.yprecision;
        if (xprec == 0 || xprec == -1) {
            for (int z = 0; z < pdc.numberOrdinates; ++z) {
                this.addPair(pdc.xOrdinates[z], pdc.yOrdinates[0][z]);
            }
        } else {
            for (int z = 0; z < pdc.numberOrdinates; ++z) {
                this.addPair(RMAIO.round(pdc.xOrdinates[z], xprec), RMAIO.round(pdc.yOrdinates[0][z], yprec));
            }
        }
        try {
            this.setParamXId(new Parameter(pdc.xparameter).getParameterId());
            this.setParamYId(new Parameter(pdc.yparameter).getParameterId());
            this.setUnitSystem(Units.getUnitSystemForUnits(pdc.yunits));
        }
        catch (DataSetIllegalArgumentException z) {
        }
        catch (IllegalArgumentException e) {
            System.out.println("\n\n*****  WARNING!  *****");
            System.out.println("UNDEFINED UNITS in - " + pdc.fullName + " from file - " + pdc.fileName);
            System.out.println("\n");
            return false;
        }
        if (pdc.labelsUsed && pdc.labels != null) {
            this.setCurveLabel(pdc.labels[0]);
        }
        return true;
    }

    @Scriptable
    public void setCurveLabel(String curveLabel) {
        this._curveLabels[0] = curveLabel;
    }

    @Scriptable
    public String getCurveLabel() {
        if (this._curveLabels == null) {
            return "";
        }
        return this._curveLabels[0];
    }

    @Scriptable
    public boolean hasCurveLabel() {
        return this._curveLabels != null && this._curveLabels.length > 0 && this._curveLabels[0] != null && this._curveLabels[0].length() > 0;
    }

    @Scriptable
    public void setDatum(double datum) {
        this._datum = datum;
    }

    @Scriptable
    public double getDatum() {
        return this._datum;
    }

    @Scriptable
    public void getDatum(ParamDouble pd) {
        pd.setValue(this._datum);
        pd.setUnitSystem(this.getUnitSystem());
        pd.setParameterId(this.getParamXId());
    }

    @Scriptable
    public void setDatum(ParamDouble pd) {
        this._datum = pd.getValue();
    }

    @Scriptable
    public void setShift(double shift) {
        this._shift = shift;
    }

    @Scriptable
    public double getShift() {
        return this._shift;
    }

    @Scriptable
    public void setOffset(double offset) {
        this._offset = offset;
    }

    @Scriptable
    public double getOffset() {
        return this._offset;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Scriptable
    public String getData() {
        Object unParsed = new String();
        for (int i = 0; i < this._dataVector.size(); ++i) {
            ValuePair vp = (ValuePair)this._dataVector.elementAt(i);
            unParsed = (String)unParsed + vp.xval + ", " + vp.yval + "; ";
        }
        unParsed = ((String)unParsed).substring(0, ((String)unParsed).length() - 2);
        return unParsed;
    }

    @Scriptable
    public int setData(String values) {
        int cnt = 0;
        if (values == null || values.length() < 1) {
            return cnt;
        }
        StringTokenizer tokenizer = new StringTokenizer(values, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.indexOf(44);
            if (idx <= 0) continue;
            String xStr = token.substring(0, idx);
            String yStr = token.substring(idx + 1);
            try {
                this.addPair(Double.valueOf(xStr.trim()), Double.valueOf(yStr.trim()));
                ++cnt;
            }
            catch (NumberFormatException nfe) {
                System.out.println("PairedValues:setData(): bad data [" + xStr + "," + yStr + "]");
            }
        }
        this._arraysValid = false;
        return cnt;
    }

    @Scriptable
    public PairedDataContainer getPairedDataContainer() {
        if (!this._arraysValid) {
            this.init();
        }
        PairedDataContainer pdc = new PairedDataContainer();
        pdc.xOrdinates = this.getXArray();
        pdc.yOrdinates = new double[1][this._yarray.length];
        System.arraycopy(this._yarray, 0, pdc.yOrdinates[0], 0, this._yarray.length);
        pdc.numberCurves = 1;
        pdc.numberOrdinates = this.size();
        if (pdc.xOrdinates == null) {
            pdc.numberOrdinates = 0;
        } else if (pdc.xOrdinates.length < pdc.numberOrdinates) {
            pdc.numberOrdinates = pdc.xOrdinates.length;
        }
        pdc.xparameter = this.getParamXString();
        pdc.yparameter = this.getParamYString();
        pdc.xunits = this.getParamXUnitsString();
        pdc.yunits = this.getParamYUnitsString();
        pdc.xtype = this.getParamXString();
        pdc.ytype = this.getParamYString();
        if (this._curveLabels != null) {
            pdc.labels = this._curveLabels;
            pdc.labelsUsed = true;
        }
        return pdc;
    }
}

