/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.data.DataSetIllegalArgumentException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import hec.io.AsciiSerializable;
import hec.io.DSSIdentifier;
import hec.io.PairedDataContainer;
import hec.lang.annotation.Scriptable;
import hec.model.Interpolate;
import hec.model.PairedValues;
import hec.model.ValueSet;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import rma.util.RMAIO;

public class PairedValuesExt
implements AsciiSerializable,
Cloneable {
    Vector<ValueSet> _dataVector = new Vector();
    public static final String INTERP_LINEAR = "Linear";
    public static final String INTERP_CUBIC = "Cubic";
    public static final String INTERP_STEP = "Step";
    public static final int INTERP_LINEAR_ID = 0;
    public static final int INTERP_CUBIC_ID = 1;
    public static final int INTERP_STEP_ID = 2;
    public static final String[] INTERP_STRINGS = new String[]{"Linear", "Cubic", "Step"};
    transient boolean _arraysValid = false;
    transient boolean _canInterpX = false;
    transient boolean _canInterpY = false;
    transient double[] _xarray = null;
    transient double[][] _yarray = null;
    transient double[] _curveLabelValues = null;
    transient double[][] _y2array = null;
    transient double[] _x2array = null;
    transient int _interpInterval = -2;
    int _interpolationType = 0;
    int _unitSystemId = 0;
    int _paramXId = Integer.MIN_VALUE;
    int _paramYId = Integer.MIN_VALUE;
    int _numY = 1;
    String[] _curveLabels;
    int _zInterpolationType = 0;
    int _paramZId = Integer.MIN_VALUE;
    DSSIdentifier _dssId = null;

    @Scriptable
    public PairedValuesExt() {
    }

    @Scriptable
    public int getNumY() {
        if (this._yarray == null) {
            this.init();
        }
        if (this._yarray == null) {
            return 0;
        }
        return this._yarray.length;
    }

    public void setNumY(int n) {
    }

    public DSSIdentifier getDssIdentifier() {
        return this._dssId;
    }

    public void setDssIdentifier(DSSIdentifier dssId) {
        this._dssId = dssId;
    }

    @Scriptable
    public int getUnitSystem() {
        return this._unitSystemId;
    }

    @Scriptable
    public int getParametersId(int icol) {
        if (icol == 0) {
            return this._paramXId;
        }
        return this._paramYId;
    }

    @Scriptable
    public String getParamXUnitsString() {
        return Parameter.getUnitsStringForSystem(this._paramXId, this.getUnitSystem());
    }

    @Scriptable
    public String getParamYUnitsString() {
        return Parameter.getUnitsStringForSystem(this._paramYId, this.getUnitSystem());
    }

    @Scriptable
    public String getParamXString() {
        return Parameter.getParamString(this._paramXId);
    }

    @Scriptable
    public String getParamYString() {
        return Parameter.getParamString(this._paramYId);
    }

    @Scriptable
    public int[] getParametersIds() {
        return new int[]{this._paramXId, this._paramYId};
    }

    @Scriptable
    public void setUnitSystem(int us) {
        if (!Units.isValidUnitsSystem(us)) {
            throw new IllegalArgumentException("ERROR <PairedValues.setUnitSystem()> : Invalid Unit System Id " + us);
        }
        this._unitSystemId = us;
    }

    @Scriptable
    public void setParamXId(int paramId) {
        this._paramXId = paramId;
    }

    @Scriptable
    public void setParamYId(int paramId) {
        this._paramYId = paramId;
    }

    @Scriptable
    public int getParamXId() {
        return this._paramXId;
    }

    @Scriptable
    public int getParamYId() {
        return this._paramYId;
    }

    @Scriptable
    public int getParamZId() {
        return this._paramZId;
    }

    @Scriptable
    public void setParamZId(int paramId) {
        this._paramZId = paramId;
    }

    @Scriptable
    public String getParamZString() {
        return Parameter.getParamString(this._paramZId);
    }

    public int getNumberCurves() {
        if (this.size() == 0) {
            return 0;
        }
        ValueSet vp = this._dataVector.elementAt(0);
        if (vp.yval == null) {
            return 0;
        }
        return vp.yval.length;
    }

    @Scriptable
    public String getParamZUnitsString() {
        return Parameter.getUnitsStringForSystem(this._paramZId, this.getUnitSystem());
    }

    @Scriptable
    public void removeCurve(int index) {
        for (int i = 0; i < this._dataVector.size(); ++i) {
            ValueSet vp = this._dataVector.elementAt(i);
            vp.removeValue(index);
        }
        this._arraysValid = false;
    }

    @Scriptable
    public void insertCurve(int index, double value) {
        for (int i = 0; i < this._dataVector.size(); ++i) {
            ValueSet vp = this._dataVector.elementAt(i);
            vp.insertValue(index, value);
        }
        this._arraysValid = false;
    }

    @Scriptable
    public PairedValues getCurve(int icurve) {
        if (icurve >= this.getNumberCurves()) {
            return null;
        }
        if (!this._arraysValid) {
            this.init();
        }
        PairedValues pv = new PairedValues();
        double[] yarr = this.getYArray(icurve);
        for (int i = 0; i < this._xarray.length; ++i) {
            pv.addPair(this._xarray[i], yarr[i]);
        }
        pv.setParamXId(this._paramXId);
        pv.setParamYId(this._paramYId);
        pv.setUnitSystem(this._unitSystemId);
        String[] curveLabels = this.getCurveLabels();
        if (curveLabels != null && curveLabels.length > icurve) {
            pv.setCurveLabel(curveLabels[icurve]);
        }
        return pv;
    }

    @Scriptable
    public void getXValue(int i, ParamDouble pd) {
        pd.setValue(this.getXValue(i));
        pd.setParameterId(this._paramXId);
        pd.setUnitSystem(this._unitSystemId);
    }

    @Scriptable
    public void getYValue(int i, ParamDouble pd) {
        this.getYValue(i, 0, pd);
    }

    @Scriptable
    public void getYValue(int i, int iset, ParamDouble pd) {
        pd.setValue(this.getYValue(i, iset));
        pd.setParameterId(this._paramYId);
        pd.setUnitSystem(this._unitSystemId);
    }

    @Scriptable
    public double getXValue(int i) {
        if (!this._arraysValid) {
            this.init();
        }
        if (i < 0 || this._xarray == null || i >= this._xarray.length) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._xarray[i];
    }

    @Scriptable
    public double getYValue(int i) {
        return this.getYValue(i, 0);
    }

    @Scriptable
    public double getYValue(int i, int iset) {
        if (!this._arraysValid) {
            this.init();
        }
        if (i < 0 || this._xarray == null || i >= this._xarray.length) {
            return Double.NEGATIVE_INFINITY;
        }
        if (iset < 0 || iset >= this._yarray.length) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._yarray[iset][i];
    }

    @Scriptable
    public double getXValue(double yval) {
        if (!this._arraysValid) {
            this.init();
        }
        return this.interpolateY(yval);
    }

    @Scriptable
    public double getYValue(double xval) {
        if (!this._arraysValid) {
            this.init();
        }
        return this.interpolate(xval);
    }

    @Scriptable
    public double getYValue(double xval, int iset) {
        if (!this._arraysValid) {
            this.init();
        }
        return this.interpolate(xval, iset);
    }

    public boolean isXValueOutOfRange(double xval) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray.length < 2) {
            return true;
        }
        return xval < this._xarray[0] || xval > this._xarray[this._xarray.length - 1];
    }

    public boolean isZValueOutOfRange(double zval) {
        if (this._curveLabelValues == null) {
            this._curveLabelValues = this.getCurveLabelValues();
        }
        if (this._curveLabelValues.length < 2) {
            return true;
        }
        return zval < this._curveLabelValues[0] || zval > this._curveLabelValues[this._curveLabelValues.length - 1];
    }

    @Scriptable
    public double interpolate(double xval) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray != null && this._xarray.length == 1) {
            return this._yarray[0][0];
        }
        if (!this._canInterpX) {
            return Double.NEGATIVE_INFINITY;
        }
        switch (this._interpolationType) {
            case 0: {
                return this.interpolateValue(xval);
            }
            case 1: {
                return this.interpolateValueCubicSpline(xval);
            }
            case 2: {
                return this.interpolateStepValue(xval);
            }
        }
        return this.interpolateValue(xval);
    }

    @Scriptable
    public double interpolate(double xval, int iset) {
        if (!this._arraysValid) {
            this.init();
        }
        switch (this._interpolationType) {
            case 0: {
                return this.interpolateValue(xval, iset);
            }
            case 1: {
                return this.interpolateValueCubicSpline(xval, iset);
            }
            case 2: {
                return this.interpolateStepValue(xval, iset);
            }
        }
        return this.interpolateValue(xval, iset);
    }

    @Scriptable
    public double interpolate(double xvalue, double zvalue) {
        if (this._curveLabelValues == null) {
            this._curveLabelValues = this.getCurveLabelValues();
        }
        int nsize = this._curveLabelValues.length;
        double yvalue = Double.NEGATIVE_INFINITY;
        if (zvalue < this._curveLabelValues[0]) {
            double interpValue0;
            boolean icurve = false;
            yvalue = interpValue0 = this.interpolate(xvalue, 0);
        } else if (zvalue > this._curveLabelValues[nsize - 1]) {
            double interpValue0;
            int icurve = nsize - 1;
            yvalue = interpValue0 = this.interpolate(xvalue, icurve);
        } else {
            int icurve = 0;
            for (int i = 1; i < nsize; ++i) {
                if (!(zvalue < this._curveLabelValues[i])) continue;
                icurve = i - 1;
                break;
            }
            if (zvalue == this._curveLabelValues[nsize - 1]) {
                double interpValue0;
                icurve = nsize - 1;
                yvalue = interpValue0 = this.interpolate(xvalue, icurve);
                return yvalue;
            }
            double interpValue0 = this.interpolate(xvalue, icurve);
            if (this._zInterpolationType == 2) {
                yvalue = interpValue0;
            } else {
                if (this._interpolationType == 0) {
                    double interpValue1 = this.interpolate(xvalue, icurve + 1);
                    double fact = (zvalue - this._curveLabelValues[icurve]) / (this._curveLabelValues[icurve + 1] - this._curveLabelValues[icurve]);
                    yvalue = fact * (interpValue1 - interpValue0) + interpValue0;
                    return yvalue;
                }
                if (this._interpolationType == 1) {
                    double yp0 = 0.0;
                    double ypn = 0.0;
                    double[] curveValuesArray = new double[nsize];
                    for (int icrve = 0; icrve < nsize - 1; ++icrve) {
                        curveValuesArray[icrve] = this.interpolate(xvalue, icrve);
                    }
                    double[] _z2data = Interpolate.cubicSpline(this._curveLabelValues, curveValuesArray, yp0, ypn, nsize);
                    yvalue = Interpolate.splineInterpolate(this._curveLabelValues, curveValuesArray, _z2data, zvalue, nsize);
                }
            }
        }
        return yvalue;
    }

    @Scriptable
    public double interpolateY(double yval) {
        return this.interpolateY(yval, 0);
    }

    @Scriptable
    public double interpolateY(double yval, int iset) {
        if (!this._arraysValid) {
            this.init();
        }
        if (!this._canInterpY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._yarray.length < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._yarray[iset].length < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._yarray[iset].length == 1) {
            return this._xarray[0];
        }
        double val = Double.NEGATIVE_INFINITY;
        int imax = this._yarray[iset].length - 1;
        int k = this.findInterval(this._yarray[iset], yval);
        if (k < 0) {
            return this._xarray[0];
        }
        if (k >= imax) {
            return this._xarray[imax];
        }
        switch (this._interpolationType) {
            case 0: {
                val = Interpolate.linearInterpolate(this._yarray[iset], this._xarray, yval, this._yarray[iset].length, k);
                break;
            }
            case 1: {
                double yp0 = Double.NEGATIVE_INFINITY;
                double ypn = Double.NEGATIVE_INFINITY;
                if (this._x2array == null) {
                    this._x2array = Interpolate.cubicSpline(this._yarray[iset], this._xarray, yp0, ypn, this._yarray[iset].length);
                }
                val = Interpolate.splineInterpolate(this._yarray[iset], this._xarray, this._x2array, yval, this._yarray[iset].length, k);
                break;
            }
            case 2: {
                return this.interpolateStepValue(yval);
            }
            default: {
                val = Interpolate.linearInterpolate(this._yarray[iset], this._xarray, yval, this._yarray[iset].length, k);
            }
        }
        return val;
    }

    @Scriptable
    public double interpolateY(double yvalue, double zvalue) {
        if (this._curveLabelValues == null) {
            this._curveLabelValues = this.getCurveLabelValues();
        }
        int nsize = this._curveLabelValues.length;
        double xvalue = Double.NEGATIVE_INFINITY;
        if (zvalue < this._curveLabelValues[0]) {
            double interpValue0;
            boolean icurve = false;
            xvalue = interpValue0 = this.interpolateY(yvalue, 0);
        } else if (zvalue > this._curveLabelValues[nsize - 1]) {
            double interpValue0;
            int icurve = nsize - 1;
            xvalue = interpValue0 = this.interpolateY(yvalue, icurve);
        } else {
            int icurve = 0;
            for (int i = 1; i < nsize; ++i) {
                if (!(zvalue < this._curveLabelValues[i])) continue;
                icurve = i - 1;
                break;
            }
            if (zvalue == this._curveLabelValues[nsize - 1]) {
                icurve = nsize - 1;
                return this.interpolateY(yvalue, icurve);
            }
            double interpValue0 = this.interpolateY(yvalue, icurve);
            if (this._zInterpolationType == 2) {
                xvalue = interpValue0;
            } else if (this._interpolationType == 0) {
                double interpValue1 = this.interpolateY(yvalue, icurve + 1);
                double fact = (zvalue - this._curveLabelValues[icurve]) / (this._curveLabelValues[icurve + 1] - this._curveLabelValues[icurve]);
                xvalue = fact * (interpValue1 - interpValue0) + interpValue0;
            } else if (this._interpolationType == 1) {
                double yp0 = 0.0;
                double ypn = 0.0;
                double[] curveValuesArray = new double[nsize];
                for (int icrve = 0; icrve < nsize - 1; ++icrve) {
                    curveValuesArray[icrve] = this.interpolateY(yvalue, icrve);
                }
                double[] _z2data = Interpolate.cubicSpline(this._curveLabelValues, curveValuesArray, yp0, ypn, nsize);
                xvalue = Interpolate.splineInterpolate(this._curveLabelValues, curveValuesArray, _z2data, zvalue, nsize);
            }
        }
        return xvalue;
    }

    @Scriptable
    public double interpolateValue(double xval) {
        return this.interpolateValue(xval, 0);
    }

    public double interpolateValue(double xval, int iset) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray == null || this._yarray == null || this._yarray.length < iset) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length == 1) {
            return this._yarray[iset][0];
        }
        if (!this._canInterpX) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        int imax = this._xarray.length - 1;
        int k = this.findInterval(xval);
        if (k < 0) {
            return this._yarray[iset][0];
        }
        if (k >= imax) {
            return this._yarray[iset][imax];
        }
        double val = Interpolate.linearInterpolate(this._xarray, this._yarray[iset], xval, this._xarray.length, k);
        return val;
    }

    @Scriptable
    public double interpolateStepValue(double xval) {
        return this.interpolateStepValue(xval, 0);
    }

    @Scriptable
    public double interpolateStepValue(double xval, int iset) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray == null || this._yarray == null || this._yarray.length < iset) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length == 1) {
            return this._yarray[iset][0];
        }
        if (!this._canInterpX) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        int imax = this._xarray.length - 1;
        int k = this.findInterval(xval);
        if (k < 0) {
            return this._yarray[iset][0];
        }
        if (k >= imax) {
            return this._yarray[iset][imax];
        }
        if (k + 1 <= imax && this._xarray[k + 1] == xval) {
            return this._yarray[iset][k + 1];
        }
        double value = this._yarray[iset][k];
        return value;
    }

    @Scriptable
    public double interpolateValueCubicSpline(double xval) {
        return this.interpolateValueCubicSpline(xval, 0);
    }

    @Scriptable
    public double interpolateValueCubicSpline(double xval, int iset) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray == null || this._yarray == null || this._yarray.length < iset) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length == 1) {
            return this._yarray[iset][0];
        }
        if (!this._canInterpX) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._xarray.length < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        int imax = this._xarray.length - 1;
        int k = this.findInterval(xval);
        if (k < 0) {
            return this._yarray[iset][0];
        }
        if (k >= imax) {
            return this._yarray[iset][imax];
        }
        double yp0 = Double.NEGATIVE_INFINITY;
        double ypn = Double.NEGATIVE_INFINITY;
        if (this._y2array == null || this._y2array[iset] == null) {
            if (this._y2array == null) {
                this._y2array = new double[this._yarray.length][];
            }
            this._y2array[iset] = Interpolate.cubicSpline(this._xarray, this._yarray[iset], yp0, ypn, this._xarray.length);
        }
        double value = Interpolate.splineInterpolate(this._xarray, this._yarray[iset], this._y2array[iset], xval, this._xarray.length, k);
        return value;
    }

    public int findInterval(double xval) {
        if (!this._arraysValid) {
            this.init();
        }
        if (this._xarray.length < 2) {
            return -1;
        }
        int imax = this._xarray.length - 1;
        if (this._interpInterval == imax && xval >= this._xarray[imax]) {
            return imax;
        }
        if (this._interpInterval < 0 || this._interpInterval >= imax || xval < this._xarray[this._interpInterval] || xval > this._xarray[this._interpInterval + 1]) {
            if (this._interpInterval > 1 && this._interpInterval < imax - 2) {
                if (this._xarray[this._interpInterval + 1] < xval && xval < this._xarray[this._interpInterval + 2]) {
                    ++this._interpInterval;
                    return this._interpInterval;
                }
                if (this._xarray[this._interpInterval - 1] < xval && xval < this._xarray[this._interpInterval]) {
                    --this._interpInterval;
                    return this._interpInterval;
                }
            }
            this._interpInterval = Interpolate.bisearch(this._xarray, xval, this._xarray.length);
        }
        return this._interpInterval;
    }

    public int findInterval(double[] array, double val) {
        if (!this._arraysValid) {
            this.init();
        }
        if (array.length < 2) {
            return -1;
        }
        int imax = array.length - 1;
        if (this._interpInterval == imax && val >= array[imax]) {
            return imax;
        }
        if (this._interpInterval < 0 || this._interpInterval >= imax || val < array[this._interpInterval] || val > array[this._interpInterval + 1]) {
            if (this._interpInterval > 1 && this._interpInterval < imax - 2) {
                if (array[this._interpInterval + 1] < val && val < array[this._interpInterval + 2]) {
                    ++this._interpInterval;
                    return this._interpInterval;
                }
                if (array[this._interpInterval - 1] < val && val < array[this._interpInterval]) {
                    --this._interpInterval;
                    return this._interpInterval;
                }
            }
            this._interpInterval = Interpolate.bisearch(array, val, array.length);
        }
        return this._interpInterval;
    }

    @Scriptable
    public void setInterpolationType(int type) {
        if (type >= 0 && type <= 2) {
            this._interpolationType = type;
        }
    }

    @Scriptable
    public int getInterpolationType() {
        return this._interpolationType;
    }

    @Scriptable
    public int size() {
        return this._dataVector.size();
    }

    @Scriptable
    public void clearValues() {
        this._dataVector.clear();
        this._xarray = null;
        this._yarray = null;
        this._y2array = null;
        this._x2array = null;
        this._arraysValid = false;
    }

    @Scriptable
    public void removePair(int i) {
        if (i < 0 || i >= this._dataVector.size()) {
            return;
        }
        this._dataVector.removeElementAt(i);
        this._arraysValid = false;
    }

    public String toString() {
        StringBuilder asString = new StringBuilder();
        for (int i = 0; i < this._dataVector.size(); ++i) {
            ValueSet vp = this._dataVector.elementAt(i);
            asString.append(vp.xval).append(", ").append(Arrays.toString(vp.yval)).append("; ");
        }
        return asString.toString().trim();
    }

    public String toTableForm(int precision) {
        StringBuffer buffer = new StringBuffer();
        String sep = System.getProperty("line.separator");
        for (int i = 0; i < this._dataVector.size(); ++i) {
            ValueSet vs = this._dataVector.elementAt(i);
            String s = RMAIO.setPrecision2(vs.xval, precision);
            buffer.append(RMAIO.leftJustify(12, s));
            for (int y = 0; y < vs.yval.length; ++y) {
                s = RMAIO.setPrecision2(vs.yval[y], precision);
                buffer.append(RMAIO.leftJustify(12, s));
            }
            buffer.append(sep);
        }
        return buffer.toString();
    }

    public String debugString() {
        String sep = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("X Parameter:");
        builder.append(this.getParamXString());
        builder.append(sep);
        builder.append("Y Parameter: ");
        builder.append(this.getParamYString());
        builder.append(sep);
        builder.append("Z Parameter: ");
        builder.append(this.getParamZString());
        builder.append(sep);
        builder.append("Number of Curves:");
        builder.append(this.getNumberCurves());
        builder.append(sep);
        if (this.hasCurveLabels()) {
            int i;
            String[] labels = this.getCurveLabels();
            builder.append("            ");
            for (i = 0; i < labels.length; ++i) {
                builder.append(RMAIO.leftJustify(12, labels[i]));
            }
            builder.append(sep);
            builder.append("------------");
            for (i = 0; i < labels.length; ++i) {
                builder.append("------------");
            }
            builder.append(sep);
        }
        builder.append(this.toTableForm(3));
        return builder.toString();
    }

    @Scriptable
    public void addPair(double xval, double yval) {
        ValueSet vp = new ValueSet(xval, yval);
        this._dataVector.addElement(vp);
        this._arraysValid = false;
    }

    @Scriptable
    public void addPair(double xval, double[] yval) {
        ValueSet vp = new ValueSet(xval, yval);
        this._dataVector.addElement(vp);
        this._arraysValid = false;
    }

    @Scriptable
    public void setArrays(double[] xarray, double[] yarray) {
        if (xarray == null || yarray == null || xarray.length == 0 || yarray.length == 0 || xarray.length != yarray.length) {
            return;
        }
        this.clearValues();
        for (int i = 0; i < xarray.length; ++i) {
            ValueSet vp = new ValueSet(xarray[i], yarray[i]);
            this._dataVector.add(vp);
        }
        this._arraysValid = false;
    }

    @Scriptable
    public void setArrays(double[][] values) {
        double[] entry;
        int i;
        this.clearValues();
        if (values == null || values.length == 0) {
            return;
        }
        int len = -1;
        for (i = 0; i < values.length; ++i) {
            entry = values[i];
            if (entry == null) continue;
            if (len == -1) {
                len = entry.length;
            }
            if (entry.length == len) continue;
            System.out.println("setArrays:ERROR inconsistent array lengths supplied.");
            return;
        }
        for (i = 0; i < values.length; ++i) {
            entry = values[i];
            if (entry == null) continue;
            if (entry.length == 2) {
                this.addPair(entry[0], entry[1]);
                continue;
            }
            if (entry.length <= 2) continue;
            double[] yarr = new double[entry.length - 1];
            System.arraycopy(entry, 1, yarr, 0, yarr.length);
            this.addPair(entry[0], yarr);
        }
    }

    @Scriptable
    public void setArrays(double[] xarray, double[][] yarray) {
        if (xarray == null || yarray == null || xarray.length == 0 || yarray.length == 0 || xarray.length != yarray.length) {
            return;
        }
        this.clearValues();
        for (int i = 0; i < xarray.length; ++i) {
            ValueSet vp = new ValueSet(xarray[i], yarray[i]);
            this._dataVector.add(vp);
        }
        this._arraysValid = false;
    }

    public Vector<ValueSet> getDataVector() {
        return (Vector)this._dataVector.clone();
    }

    public synchronized PairedValuesExt clone() {
        try {
            PairedValuesExt pv = (PairedValuesExt)super.clone();
            pv._dataVector = new Vector();
            for (int i = 0; i < this._dataVector.size(); ++i) {
                ValueSet vp = this._dataVector.elementAt(i);
                pv.addPair(vp.xval, vp.yval);
            }
            return pv;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void init() {
        int i;
        ValueSet vp;
        double undef = Double.NEGATIVE_INFINITY;
        int icnt = 0;
        for (int i2 = 0; i2 < this._dataVector.size(); ++i2) {
            vp = this._dataVector.elementAt(i2);
            if (vp.xval == undef || vp.yval == null) continue;
            ++icnt;
        }
        int npts = icnt;
        if (icnt < 1) {
            this._xarray = new double[0];
            this._yarray = new double[0][0];
            return;
        }
        vp = this._dataVector.elementAt(0);
        this._xarray = new double[npts];
        this._yarray = new double[vp.yval.length][npts];
        icnt = 0;
        for (i = 0; i < this._dataVector.size(); ++i) {
            vp = this._dataVector.elementAt(i);
            if (vp.xval == undef || vp.yval == null) continue;
            this._xarray[icnt] = vp.xval;
            for (int j = 0; j < vp.yval.length; ++j) {
                this._yarray[j][icnt] = vp.yval[j];
            }
            ++icnt;
        }
        this._y2array = null;
        this._x2array = null;
        this._arraysValid = true;
        this._canInterpX = false;
        this._canInterpY = false;
        if (this._xarray.length <= 1) {
            return;
        }
        this._canInterpY = true;
        block3: for (int j = 0; j < this._yarray.length; ++j) {
            for (int i3 = 0; i3 < this._yarray[j].length - 1; ++i3) {
                if (!(this._yarray[j][i3 + 1] <= this._yarray[j][i3])) continue;
                this._canInterpY = false;
                continue block3;
            }
        }
        this._canInterpX = true;
        for (i = 0; i < this._xarray.length - 1; ++i) {
            if (!(this._xarray[i + 1] <= this._xarray[i])) continue;
            this._canInterpX = false;
            break;
        }
    }

    @Scriptable
    public double[] getXArray() {
        if (!this._arraysValid || this._xarray == null) {
            this.init();
        }
        if (this._xarray == null) {
            return new double[0];
        }
        return this._xarray;
    }

    @Scriptable
    public double[] getYArray() {
        return this.getYArray(0);
    }

    @Scriptable
    public double[] getYArray(int iset) {
        if (!this._arraysValid || this._yarray == null || this._yarray[iset] == null) {
            this.init();
        }
        if (iset >= this._yarray.length) {
            return new double[0];
        }
        return this._yarray[iset];
    }

    public double[][] getYData() {
        if (!this._arraysValid || this._yarray == null) {
            this.init();
        }
        return this._yarray;
    }

    public double getLargestValue() {
        int jmax;
        if (!this._arraysValid || this._yarray == null) {
            this.init();
        }
        if ((jmax = this._yarray.length) <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        int imax = this._yarray[0].length;
        double mult = 0.0;
        for (int j = 0; j < jmax; ++j) {
            for (int i = 0; i < imax; ++i) {
                if (this._yarray[j][i] == Double.NEGATIVE_INFINITY) continue;
                mult = Math.max(mult, this._yarray[j][i]);
            }
        }
        return mult;
    }

    @Scriptable
    public boolean canInterpX() {
        if (!this._arraysValid) {
            this.init();
        }
        return this._canInterpX;
    }

    @Scriptable
    public boolean setData(PairedDataContainer pdc) {
        for (int z = 0; z < pdc.numberOrdinates; ++z) {
            double[] yords = new double[pdc.yOrdinates.length];
            for (int y = 0; y < pdc.yOrdinates.length; ++y) {
                yords[y] = pdc.yOrdinates[y][z];
            }
            this.addPair(pdc.xOrdinates[z], yords);
        }
        try {
            this.setParamXId(new Parameter(pdc.xparameter).getParameterId());
            this.setParamYId(new Parameter(pdc.yparameter).getParameterId());
            this.setUnitSystem(Units.getUnitSystemForUnits(pdc.yunits));
        }
        catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
            // empty catch block
        }
        if (pdc.labelsUsed && pdc.labels != null) {
            this.setCurveLabels(pdc.labels);
        }
        return true;
    }

    @Scriptable
    public PairedDataContainer getPairedDataContainer() {
        PairedDataContainer pdc = new PairedDataContainer();
        pdc.xOrdinates = this.getXArray();
        pdc.yOrdinates = this.getYData();
        pdc.numberCurves = this.getNumberCurves();
        pdc.numberOrdinates = this.size();
        if (pdc.xOrdinates == null) {
            pdc.numberOrdinates = 0;
        } else if (pdc.xOrdinates.length < pdc.numberOrdinates) {
            pdc.numberOrdinates = pdc.xOrdinates.length;
        }
        pdc.xparameter = this.getParamXString();
        pdc.yparameter = this.getParamYString();
        pdc.xunits = this.getParamXUnitsString();
        pdc.yunits = this.getParamYUnitsString();
        pdc.xtype = this.getParamXString();
        pdc.ytype = this.getParamYString();
        if (this.hasCurveLabels()) {
            pdc.labels = this.getCurveLabels();
            pdc.labelsUsed = true;
        }
        return pdc;
    }

    @Scriptable
    public String[] getCurveLabels() {
        return this._curveLabels;
    }

    @Scriptable
    public void setCurveLabels(String[] curveLabels) {
        this._curveLabels = curveLabels;
        this._curveLabelValues = this.getCurveLabelValues();
    }

    @Scriptable
    public boolean hasCurveLabels() {
        if (!this._arraysValid || this._xarray == null) {
            this.init();
        }
        return this._curveLabels != null && this._curveLabels.length == this._yarray.length;
    }

    @Scriptable
    public double[] getCurveLabelValues() {
        if (this._curveLabels == null || this._curveLabels.length == 0) {
            System.out.println("getCurveLabelValues:no curve labels found for " + this._dssId);
            return null;
        }
        int nsize = this._curveLabels.length;
        double[] curveValues = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            curveValues[i] = RMAIO.parseDouble(this._curveLabels[i], Double.NEGATIVE_INFINITY);
        }
        return curveValues;
    }

    public String getData() {
        StringBuilder asString = new StringBuilder();
        for (int i = 0; i < this._dataVector.size(); ++i) {
            ValueSet vp = this._dataVector.elementAt(i);
            asString.append(vp.xval).append(", ").append(Arrays.toString(vp.yval)).append("; ");
        }
        return asString.toString().trim();
    }

    public int setData(String values) {
        int cnt = 0;
        if (values == null || values.length() < 1) {
            return cnt;
        }
        StringTokenizer tokenizer = new StringTokenizer(values, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.indexOf(44);
            if (idx <= 0) continue;
            String xStr = token.substring(0, idx);
            String yStr = token.substring(idx + 1);
            try {
                double[] yVals = this.parseArraysString(yStr.trim());
                this.addPair(Double.parseDouble(xStr.trim()), yVals);
                ++cnt;
            }
            catch (NumberFormatException nfe) {
                System.out.println("PairedValues:setData(): bad data [" + xStr + "," + yStr + "]");
            }
        }
        this._arraysValid = false;
        return cnt;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private String[] fromArraysString(String yVals) {
        String[] result = null;
        if (!"null".equals(yVals)) {
            result = yVals.replace("[", "").replace("]", "").split(", ");
        }
        return result;
    }

    private double[] parseArraysString(String yVals) {
        double[] retval = null;
        String[] vals = this.fromArraysString(yVals);
        if (vals != null) {
            retval = new double[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                retval[i] = Double.parseDouble(vals[i]);
            }
        }
        return retval;
    }
}

