/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.data.ParamDouble;
import hec.model.PairedValuesExt;
import java.util.Vector;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class PairedValuesExtTableModel
extends RmaTableModel
implements RmaTableModelInterface {
    PairedValuesExt _pv;
    private boolean _addBlankRows = true;
    private boolean _saveEmptyYAsUndefined;

    public PairedValuesExtTableModel(String[] colNames, boolean[] editable) {
        super(colNames, new Object[0][0], editable);
    }

    public PairedValuesExtTableModel(String[] colNames, PairedValuesExt pv, boolean[] editable) {
        super(colNames, new Object[0][0], editable);
        this.clearAll();
        this.parsePairedValues(pv);
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object obj = super.getValueAt(row, col);
        if (!(obj instanceof ParamDouble) && this._pv != null) {
            ParamDouble pd = new ParamDouble(RMAIO.parseDouble(obj), this._pv.getParametersId(col));
            pd.setUnitSystem(this._pv.getUnitSystem());
            return pd;
        }
        return obj;
    }

    @Override
    public int getColumnParameter(int col) {
        if (this._pv == null || this._pv.getParametersIds() == null) {
            return -1;
        }
        int len = this._pv.getParametersIds().length;
        if (col < 0 && len >= 2 && col >= len) {
            return this._pv.getParametersIds()[len - 1];
        }
        if (col >= len && len >= 2) {
            return this._pv.getParametersIds()[len - 1];
        }
        if (col >= len) {
            return -1;
        }
        return this._pv.getParametersIds()[col];
    }

    public void setPairedValues(PairedValuesExt pv) {
        if (pv == null) {
            return;
        }
        this.clearAll();
        this.parsePairedValues(pv);
        this.fireTableDataChanged();
    }

    protected void parsePairedValues(PairedValuesExt pv) {
        this._pv = pv;
        double[] xarray = pv.getXArray();
        double[][] yarray = pv.getYData();
        int numYCol = this.getColumnCount() - 1;
        if (yarray != null && yarray.length < numYCol) {
            numYCol = yarray.length;
        }
        ParamDouble pd = null;
        int[] pida = new int[numYCol + 1];
        for (int i = 0; i < numYCol + 1; ++i) {
            pida[i] = pv.getParametersId(i);
        }
        this.setColumnParameters(pida);
        this.setUnitSystem(pv.getUnitSystem());
        if (xarray == null || yarray == null) {
            Vector row1 = new Vector(this.getColumnCount());
            this.addRow(row1);
            for (int i = 1; i < 10; ++i) {
                this.addRow(new Vector(this.getColumnCount()));
            }
            return;
        }
        int nitems = xarray.length;
        for (int irow = 0; irow < nitems; ++irow) {
            Vector<String> row = new Vector<String>(numYCol + 1);
            if (xarray[irow] == Double.NEGATIVE_INFINITY) continue;
            pd = new ParamDouble();
            this._pv.getXValue(irow, pd);
            super.setValueAt(pd, irow, 0);
            for (int j = 0; j < numYCol; ++j) {
                if (yarray[j][irow] != Double.NEGATIVE_INFINITY) {
                    pd = new ParamDouble();
                    this._pv.getYValue(irow, j, pd);
                    super.setValueAt(pd, irow, j + 1);
                    continue;
                }
                row.add("");
            }
            this.addRow(row);
        }
        if (nitems == 0) {
            Vector row1 = new Vector(this.getColumnCount());
            this.addRow(row1);
        }
        if (this._addBlankRows) {
            for (int i = 0; i < 10; ++i) {
                this.addRow(new Vector(this.getColumnCount()));
            }
        }
    }

    @Override
    public RmaTableModel getModel() {
        return this;
    }

    public void storeData(PairedValuesExt pv) {
        Vector rows = this.getDataVector();
        int npts = 0;
        for (int z = 0; z < rows.size(); ++z) {
            Vector row = (Vector)rows.elementAt(z);
            Object cellVal0 = row.elementAt(0);
            Object cellVal1 = row.elementAt(1);
            if (cellVal0 == null || cellVal0.toString().equals("")) continue;
            ++npts;
        }
        pv.clearValues();
        double undef = Double.NEGATIVE_INFINITY;
        int icnt = 0;
        if (rows.size() == 0) {
            if (this._pv != null) {
                pv.setUnitSystem(this._pv.getUnitSystem());
                pv.setParamXId(this._pv.getParametersIds()[0]);
                pv.setParamYId(this._pv.getParametersIds()[1]);
            }
            return;
        }
        Vector row = (Vector)rows.elementAt(0);
        int numcol = row.size() - 1;
        double[] yval = new double[numcol];
        for (int irow = 0; irow < rows.size(); ++irow) {
            row = (Vector)rows.elementAt(irow);
            numcol = row.size() - 1;
            Object xobj = row.elementAt(0);
            if (xobj == null || xobj.toString().equals("")) continue;
            double xval = RMAIO.parseDouble(xobj);
            for (int j = 0; j < numcol; ++j) {
                Object yobj = row.elementAt(j + 1);
                if (yobj == null || yobj.toString().equals("")) {
                    if (!this._saveEmptyYAsUndefined || j >= yval.length) continue;
                    yval[j] = undef;
                    continue;
                }
                yval[j] = RMAIO.parseDouble(yobj);
            }
            if (xval == undef) continue;
            pv.addPair(xval, yval);
            ++icnt;
        }
        if (this._pv != null) {
            pv.setUnitSystem(this._pv.getUnitSystem());
            pv.setParamXId(this._pv.getParametersIds()[0]);
            pv.setParamYId(this._pv.getParametersIds()[1]);
        }
    }

    public void setShouldAddBlankRows(boolean addTheRows) {
        this._addBlankRows = addTheRows;
    }

    public void setSaveEmptyYAsUndefined(boolean saveAsUndefined) {
        this._saveEmptyYAsUndefined = saveAsUndefined;
    }
}

