/*
 * Decompiled with CFR 0.152.
 */
package hec.model;

import hec.data.ParamDouble;
import hec.model.PairedValues;
import java.util.Vector;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;

public class PairedValuesTableModel
extends RmaTableModel
implements RmaTableModelInterface {
    PairedValues _pv;
    private boolean _addBlankRows;

    public PairedValuesTableModel(String[] colNames, boolean[] editable) {
        super(colNames, new Object[0][colNames.length], editable);
    }

    public PairedValuesTableModel(String[] colNames, PairedValues pv, boolean[] editable) {
        super(colNames, new Object[0][colNames.length], editable);
        this.clearAll();
        this.parsePairedValues(pv);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        if (col < 0 || col >= this.getColumnCount()) {
            return null;
        }
        Object obj = super.getValueAt(row, col);
        if (!(obj instanceof ParamDouble) && this._pv != null) {
            ParamDouble pd;
            if (col <= 1) {
                pd = new ParamDouble(RMAIO.parseDouble(obj), this._pv.getParametersIds()[col]);
            } else {
                pd = new ParamDouble();
                pd.setValue(RMAIO.parseDouble(obj));
            }
            pd.setUnitSystem(this._pv.getUnitSystem());
            return pd;
        }
        return obj;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Object nValue = value;
        if (columnIndex < 2 && !(value instanceof ParamDouble) && this._pv != null && this._pv.getParametersIds()[columnIndex] != -1) {
            ParamDouble pd = new ParamDouble();
            pd.setValue(value != null ? value.toString() : "");
            pd.setParameterId(this._pv.getParametersIds()[columnIndex]);
            pd.setUnitSystem(this.getUnitSystem());
            nValue = pd;
        }
        super.setValueAt(nValue, rowIndex, columnIndex);
    }

    @Override
    public int getColumnParameter(int col) {
        if (this._pv == null) {
            return super.getColumnParameter(col);
        }
        if (col < 0 || col >= this._pv.getParametersIds().length) {
            return -1;
        }
        return this._pv.getParametersIds()[col];
    }

    public void setPairedValues(PairedValues pv) {
        if (pv == null) {
            return;
        }
        this.clearAll();
        this.parsePairedValues(pv);
        this.fireTableDataChanged();
    }

    protected void parsePairedValues(PairedValues pv) {
        this._pv = pv;
        double[] xarray = pv.getXArray();
        double[] yarray = pv.getYArray();
        ParamDouble pd = null;
        this.setColumnParameters(pv.getParametersIds());
        this.setUnitSystem(pv.getUnitSystem());
        if (xarray == null || yarray == null) {
            Vector<String> row1 = new Vector<String>(this.getColumnCount());
            row1.addElement("");
            this.addRow(row1);
            for (int i = 1; i < 10; ++i) {
                this.addRow(new Vector(this.getColumnCount()));
            }
            return;
        }
        int nitems = xarray.length;
        for (int irow = 0; irow < nitems; ++irow) {
            Vector<String> row = new Vector<String>(2);
            if (xarray[irow] == Double.NEGATIVE_INFINITY) continue;
            pd = new ParamDouble();
            this._pv.getXValue(irow, pd);
            super.setValueAt(pd, irow, 0);
            if (yarray[irow] != Double.NEGATIVE_INFINITY) {
                pd = new ParamDouble();
                this._pv.getYValue(irow, pd);
                super.setValueAt(pd, irow, 1);
            } else {
                row.add("");
            }
            this.addRow(row);
        }
        if (nitems == 0) {
            Vector<String> row1 = new Vector<String>(this.getColumnCount());
            row1.addElement("");
            this.addRow(row1);
        }
        if (this.shouldAddBlankRows()) {
            for (int i = 0; i < 10; ++i) {
                this.addRow(new Vector(this.getColumnCount()));
            }
        }
    }

    public boolean shouldAddBlankRows() {
        return this._addBlankRows;
    }

    public void setShouldAddBlankRows(boolean addTheRows) {
        this._addBlankRows = addTheRows;
    }

    @Override
    public RmaTableModel getModel() {
        return this;
    }

    public void storeData(PairedValues pv) {
        Vector rows = this.getDataVector();
        int npts = 0;
        for (int z = 0; z < rows.size(); ++z) {
            Vector row = (Vector)rows.elementAt(z);
            Object cellVal0 = null;
            if (row != null && row.size() > 0) {
                cellVal0 = row.elementAt(0);
            }
            if (cellVal0 == null || "".equals(cellVal0)) continue;
            Object cellVal1 = null;
            if (row != null && row.size() > 1) {
                cellVal1 = row.elementAt(1);
            }
            ++npts;
        }
        pv.clearValues();
        double undef = Double.NEGATIVE_INFINITY;
        int icnt = 0;
        for (int irow = 0; irow < rows.size(); ++irow) {
            Vector row = (Vector)rows.elementAt(irow);
            Object xobj = null;
            Object yobj = null;
            if (row != null) {
                int count = row.size();
                if (count > 0) {
                    xobj = row.elementAt(0);
                }
                if (count > 1) {
                    yobj = row.elementAt(1);
                }
            }
            if (xobj == null || "".equals(xobj) || yobj == null || "".equals(yobj)) continue;
            double xval = RMAIO.parseDouble(xobj);
            double yval = RMAIO.parseDouble(yobj);
            if (xval == undef) continue;
            pv.addPair(xval, yval);
            ++icnt;
        }
        if (this._pv != null) {
            pv.setUnitSystem(this._pv.getUnitSystem());
            pv.setParamXId(this._pv.getParametersIds()[0]);
            pv.setParamYId(this._pv.getParametersIds()[1]);
        }
    }
}

